<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Kidzo
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
?>
<div class="single_review_part blog_page_single_item">
    <div class="comment_part">
        <h3 class="kidzo_comment_title">
			<?php
			$kidzo_comment_count = get_comments_number();
			if ( '1' === $kidzo_comment_count ) {
				printf(
					/* translators: 1: title. */
					esc_html__( 'One Comments', 'kidzo' ),
					'<span>' . kidzo_extention_wp_kses( get_the_title() ) . '</span>'
				);
			} else {
				printf( 
					/* translators: 1: comment count number, 2: title. */
					esc_html( _nx( '%1$s', '%1$s Comments', $kidzo_comment_count, 'comments title', 'kidzo' ) ),
					number_format_i18n( $kidzo_comment_count ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					'<span>' . kidzo_extention_wp_kses( get_the_title() ) . '</span>'
				);
			}
			?>
		</h3><!-- .comments-title -->
		<ul class="kidzo_comment_list">
          <?php
            wp_list_comments(
                array(
                    'style'      => 'ul',
                    'short_ping' => true,
                    'walker'        => new Kidzo_Walker_Comment,
                )
            );
            the_comments_navigation();
          ?>
        </ul>
    </div>
</div>
<?php endif; ?>
<div class="review_form blog_page_single_item">
<?php 
	$commenter      = wp_get_current_commenter();
    $req            = get_option( 'require_name_email' );
    $aria_req       = ( $req ? " aria-required='true'" : '' );
    $fields =  array(
        'author'=> '<div class="row"><div class="col-lg-6 form_single_item"><input type="text" name="author"  value="'.esc_attr($commenter['comment_author']).'" placeholder="'.esc_attr__('Full Name *', 'kidzo').'" '.$aria_req.'></div>',
         'email'	=> '<div class="col-lg-6 form_single_item"><input type="email" name="email" id="email" placeholder="'.esc_attr__('Your Email *', 'kidzo').'" '.$aria_req.'></div></div>',
        'cookies' => ''
    );
    
    $comments_args = array(
        'fields'                => apply_filters( 'comment_form_default_fields', $fields ),
        'id_form'               => 'form_single_item',
        'class_form'            => '',
        'class_submit'          => 'pc-button elementor-button button-link cu_btn',
        'label_submit'          => esc_html__( 'Submit Now', 'kidzo' ),
        'title_reply_before'    => '<div class="blog_page_single_item mb-0"><h3 class="blog_title">',
        'title_reply'           => esc_html__( 'Leave a Comment', 'kidzo' ),
        'title_reply_after'     => '</h3></div>',
        'comment_notes_before'  => '',
        'submit_button'         => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s">'. esc_html__( 'Post Comment', 'kidzo' ).'<svg class="pc-dashes inner-dashed-border animated-dashes">
        <rect x="5px" y="5px" rx="25px" ry="25px" width="0" height="0"></rect></svg></button>',
        'comment_field'         => '<div class="form_single_item"><textarea name="comment" placeholder="'. esc_attr__( 'Add comment', 'kidzo' ) .'" required></textarea></div>',
        'comment_notes_after'   => '',
    );
    
    comment_form($comments_args);
?>
</div>
