<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Kidzo
 */

$opt = get_option('kidzo_opt');
$footer_background_images  = isset( $opt['footer_background_images']['url'] ) ? $opt['footer_background_images']['url'] : '';
$footer_animated           = isset( $opt['footer_animated']['url'] ) ? $opt['footer_animated']['url'] : '';
$footer_style              = function_exists( 'get_field' ) ? get_field( 'footer_layout' ) : '';
$copyright_txt             = isset( $opt['copyright_txt'] ) ? $opt['copyright_txt'] : esc_html__( '© 2021 DroitThemes. All rights reserved', 'kidzo' );

$footer_style = !empty( $footer_style ) ? $footer_style : '';
if(! is_404()):
    if( $footer_style ) {
        $footer_style_id = $footer_style;
            $footer_style = new WP_Query(array(
                'post_type' => 'footer',
                'p' => $footer_style_id,
            ));
            if ($footer_style->have_posts()) {
                while ($footer_style->have_posts()) : $footer_style->the_post();
                    the_content();
                endwhile;
            }
    } else { 
        if (is_active_sidebar('footer_widgets')):
        ?>
            <footer class="footer_section home_two_footer position-relative">
                <?php if (is_active_sidebar('footer_widgets')) { ?>
                    <div class="container custom_container">
                        <div class="row justify-content-between">
                            <?php dynamic_sidebar( 'footer_widgets' ); ?> 
                        </div>
                    </div>
                <?php } ?>
                <?php if(!empty($footer_background_images)): ?>
                    <div class="footer_bg">
                        <img src="<?php echo esc_url($footer_background_images); ?>" alt="<?php esc_attr_e( 'Footer Background Images', 'kidzo' ) ?>" class="img-fluid">
                    </div>
                <?php endif; ?>
                <?php
                if(!empty($footer_animated)){ ?>
                    <div class="footer_animation_3">
                        <div data-parallax='{"x": 30, "y": 70, "rotateZ":0}'>
                            <img src="<?php echo esc_url($footer_animated); ?>" alt="<?php esc_attr_e( 'Footer Center Images', 'kidzo' ) ?>">
                        </div>
                    </div>
                    <?php
                } ?>
                <?php if(!empty($copyright_txt)): ?>
                <p class="copy_text"><?php echo kidzo_extention_wp_kses( $copyright_txt ) ?></p>
                <?php endif; ?>
            </footer>
        <?php
        endif;
        }
endif;
    ?>
<?php wp_footer(); ?>
</body>
</html>
