<?php
/**
 * Custom comment walker for this theme.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since 1.0.0
 */

if ( ! class_exists('Rave_Walker_Comment') ) {
    /**
     * CUSTOM COMMENT WALKER
     * A custom walker for comments, based on the walker in Twenty Nineteen.
     */
    class Kidzo_Walker_Comment extends Walker_Comment {

        /**
         * Outputs a comment in the HTML5 format.
         *
         * @see wp_list_comments()
         * @see https://developer.wordpress.org/reference/functions/get_comment_author_url/
         * @see https://developer.wordpress.org/reference/functions/get_comment_author/
         * @see https://developer.wordpress.org/reference/functions/get_avatar/
         * @see https://developer.wordpress.org/reference/functions/get_comment_reply_link/
         * @see https://developer.wordpress.org/reference/functions/get_edit_comment_link/
         *
         * @param WP_Comment $comment Comment to display.
         * @param int        $depth   Depth of the current comment.
         * @param array      $args    An array of arguments.
         */
        protected function html5_comment( $comment, $depth, $args ) {

            ?>
            <li <?php comment_class( $args['has_children'] ? 'post_comment has_children' :'post_comment') ?> id="comment-<?php comment_ID() ?>">
         <div class="media">
            <?php
            if(get_avatar($comment)) {
                echo get_avatar($comment, 60, null, null, array('class'=> 'admin_img'));
            }
            ?>
            <div class="media-body">
                <div class="admin_tittle">
                    <h5><?php comment_author(); ?><span><?php comment_date(get_option('date_format')); ?></span></h5>
                    <div class="comment_rep_btn">
                        <?php comment_reply_link( array_merge( $args, array( 'reply_text' => esc_html__( 'Reply', 'kidzo' ), 'depth' => $depth,  'max_depth' => $args['max_depth'] ) ) ); ?> 
                        <i class="fas fa-long-arrow-alt-right"></i>
                    </div>
                </div>
                <?php comment_text(); ?>
            </div>
        </div>
    </li>
            <?php
        }
    }
}
