<?php

Redux::setSection('kidzo_opt', array(
    'title'     => esc_html__('404 Error Settings', 'kidzo'),
    'id'        => '404_0pt',
    'icon'      => 'dashicons dashicons-info',
    'fields'    => array(

        array(
            'title'     => esc_html__('Heading Text', 'kidzo'),
            'id'        => 'error_heading',
            'type'      => 'text',
            'default'   => esc_html__("404", 'kidzo'),
        ),

        array(
            'title'     => esc_html__('Title', 'kidzo'),
            'id'        => 'error_title',
            'type'      => 'text',
            'default'   => esc_html__('Page not found', 'kidzo'),
        ),

        array(
            'title'     => esc_html__('Subtitle', 'kidzo'),
            'id'        => 'error_subtitle',
            'type'      => 'textarea',
            'default'   => esc_html__('We are sorry, the page you have looked for does not exist in our database! Maybe go to our home page or try to use a search?', 'kidzo'),
        ),

        array(
            'title'     => esc_html__('Home button label', 'kidzo'),
            'id'        => 'error_home_btn_label',
            'type'      => 'text',
            'default'   => esc_html__('Go Back to home Page', 'kidzo'),
            
        ),

        array(
            'id'          => 'btn_font_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Text Color', 'kidzo' ),
            'output'      => array(
                'color' => '.about_btn',
            ),
        ),

        array(
            'id'          => 'btn_font_color_hover',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Text Hover Color', 'kidzo' ),
            'output'      => array(
                'color' => '.about_btn:hover',
            ),
        ),

        array(
            'id'          => 'btn_bg_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Background Color', 'kidzo' ),
            'output'      => array(
                'background' => '.about_btn',
            ),
        ),

        array(
            'id'          => 'btn_bg_color_hover',
            'type'        => 'color',
            'title'       => esc_html__( 'Button Background Hover Color', 'kidzo' ),
            'output'      => array(
                'background' => '.about_btn:hover',
            ),
        )

    )
));
