<?php

// Footer settings
Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Footer Settings', 'kidzo'),
	'id'        => 'kidzo_footer',
	'icon'      => 'el el-arrow-down',
    'fields'           => array(
         array(
            'title'     => esc_html__('Footer Background Images', 'kidzo'),
            'subtitle'  => esc_html__( 'Upload here a image file for your Footer Background Images', 'kidzo' ),
            'id'        => 'footer_background_images',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/footer_bg.png'
            )
        ),
        array(
            'title'     => esc_html__('Footer Animated Images', 'kidzo'),
            'id'        => 'footer_animated',
            'type'      => 'media',
            'compiler'  => true,
            'default'   => array(
                'url'   => KIDZO_DIR_IMG.'/footer_img.png'
            )
        ),
    )
));


// Footer settings
Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Font colors', 'kidzo'),
	'id'        => 'kidzo_footer_font_colors',
	'icon'      => 'dashicons dashicons-editor-textcolor',
	'subsection'=> true,
	'fields'    => array(
        array(
            'title'     => esc_html__('Widget Title Color', 'kidzo'),
            'id'        => 'widget_title_color',
            'type'      => 'color',
            'output'    => array('.home_two_footer .single_footer_widget h4')
        ),
        array(
            'title'     => esc_html__('List Item color', 'kidzo'),
            'id'        => 'footer_list_item_color',
            'type'      => 'color',
            'output'    => array('.home_two_footer .single_footer_widget ul li a')
        ),
        array(
            'title'     => esc_html__('List Item Hover color', 'kidzo'),
            'id'        => 'footer_list_item_hover_color',
            'type'      => 'color',
            'output'    => array('.home_two_footer .single_footer_widget ul li a:hover')
        ),        
	)
));

// Footer background
Redux::setSection('kidzo_opt', array(
	'title'     => esc_html__('Background', 'kidzo'),
	'id'        => 'kidzo_footer_background',
	'icon'      => 'dashicons dashicons-admin-appearance',
	'subsection'=> true,
	'fields'    => array(
        array(
            'title'     => esc_html__('Footer Background Color', 'kidzo'),
            'desc'      => esc_html__('The main footer background Color', 'kidzo'),
            'id'        => 'footer_bg_color',
            'type'      => 'background',
	        'output'    => array( '.home_two_footer' )
        ),
        array(
            'title'     => esc_html__( 'Overlay Color', 'kidzo' ),
            'id'        => 'footer_bg_overlay_color',
            'output'    => '.home_two_footer:before',
            'type'      => 'color_rgba',
            'mode'      => 'background',
        ),
        array(
            'title'     => esc_html__('Footer Background Object', 'kidzo'),
            'id'        => 'footer_obj',
            'type'      => 'switch',
            'on'        => esc_html__('Show', 'kidzo'),
            'off'       => esc_html__('Hide', 'kidzo'),
            'default'   => '1'
        )

	)
));



// Footer Content
Redux::setSection('kidzo_opt', array(
    'title'     => esc_html__('Copyright Text', 'kidzo'),
    'id'        => 'kidzo_footer_copyright',
    'icon'      => 'dashicons dashicons-editor-textcolor',
    'subsection'=> true,
    'fields'    => array(
        array(
            'title'     => esc_html__('Footer Content', 'kidzo'),
            'id'        => 'copyright_txt',
            'type'      => 'editor',
            'default'   => '&copy; 2020 <a href="//droitthemes.com">DroitThemes</a>. All rights reserved',
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => false,
                'textarea_rows' => 10,
                //'tabindex' => 1,
                //'editor_css' => '',
                'teeny'         => false,
                //'tinymce' => array(),
                'quicktags'     => false,
            )
        ),
        array(
            'title'     => esc_html__('Copyright Text Color', 'kidzo'),
            'subtitle'  => esc_html__('Copyright Text font color', 'kidzo'),
            'id'        => 'copyright_font_color',
            'output'    => 'p.copy_text',
            'type'      => 'color',
        ),
  
    )
));
