<?php

// Navbar styling
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Menu Settings', 'kidzo' ),
    'id'               => 'menu_opt',
    'icon'             => 'el el-lines',
    'fields'           => array(
        array(
            'title'     => esc_html__('Menu Background  Shape  Setting', 'kidzo'),
            'subtitle'  => esc_html__('Menu Hover & Active Background Shape Image', 'kidzo'),
            'id'        => 'menu_backgorund_shpa',
            'type'      => 'switch',
            'on'        => esc_html__('Show ', 'kidzo'),
            'off'       => esc_html__('Hidden', 'kidzo'),
            'default'   => '1'
        ),

        array(
            'title'     => esc_html__('Button Hover Animation Setting', 'kidzo'),
            'subtitle'  => esc_html__('Some Button hover animated around', 'kidzo'),
            'id'        => 'button_animation_around',
            'type'      => 'switch',
            'on'        => esc_html__('Show ', 'kidzo'),
            'off'       => esc_html__('Hidden', 'kidzo'),
            'default'   => '1'
        ),
        array(
            'title'     => esc_html__('Menu Bar Backgound Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item font color', 'kidzo'),
            'id'        => 'menu_bar_bg_color',
            'output'    => array(
                'background' => '.header_part',
            ),
            'type'      => 'color',
        ),
        array(
            'title'     => esc_html__('Menu Item Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item font color', 'kidzo'),
            'id'        => 'menu_font_color',
            'output'    => array(
                'color' => '.header_part .dropdown-item, .header_style_3 .dropdown-item',
            ),
            'type'      => 'color',
        ),
        

        // Sticky menu settings section
        array(
            'id' => 'sticky_menu_start',
            'type' => 'section',
            'title' => esc_html__('Sticky menu settings', 'kidzo'),
            'subtitle' => esc_html__('The following settings will only apply on the sticky header mode..', 'kidzo'),
            'indent' => false
        ),
        array(
            'title'     => esc_html__('Menu Bar Backgound Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item font color', 'kidzo'),
            'id'        => 'stick_menu_bar_bg_color',
            'output'    => array(
                'background' => 'header.header.header_part.menu_fixed',
            ),
            'type'      => 'color',
        ),
        array(
            'title'     => esc_html__('Menu Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item font color on sticky menu mode.', 'kidzo'),
            'id'        => 'sticky_menu_font_color',
            'output'    => array(
                'color' => 'header.header.header_part.menu_fixed a.dropdown-toggle.dropdown-item',
            ),
            'type'      => 'color',
        ),
        
        array(
            'title'     => esc_html__('Menu Hover Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item Hover font color on header sticky mode', 'kidzo'),
            'id'        => 'menu_sticky_active_font_color',
            'output'    => array(
                'color'     => '.header_part .menu_fixed .dropdown-item:hover:hover, .header_style_3 .menu_fixed .dropdown-item:hover:hover',
            ),
            'type'      => 'color',
        ),
        array(
            'id'     => 'submenu_end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'title'     => esc_html__('Menu item margin', 'kidzo'),
            'subtitle'  => esc_html__('Margin around menu item.', 'kidzo'),
            'id'        => 'menu_item_margin',
            'type'      => 'spacing',
            'output'    => array( '.header_part .header .navbar .navbar-nav .dropdown-item' ),
            'mode'      => 'margin',
            'units'     => array( 'em', 'px', '%' ),      // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',
        ),


        // Sub menu settings section
        array(
            'id' => 'sub_menu_start',
            'type' => 'section',
            'title' => esc_html__('Sub menu settings', 'kidzo'),
            'subtitle' => esc_html__('The following settings will only apply on the Sub Menu header mode..', 'kidzo'),
            'indent' => false
        ),
        array(
            'title'     => esc_html__('Menu Backgound Color', 'kidzo'),
            'subtitle'  => esc_html__('Sub Menu item font color', 'kidzo'),
            'id'        => 'sub_menu_bar_bg_color',
            'output'    => array(
                'background' => '.header_part .dropdown-menu .dropdown-item:hover',
            ),
            'type'      => 'color',
        ),
        array(
            'title'     => esc_html__('Menu Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item font color on sticky menu mode.', 'kidzo'),
            'id'        => 'sub_menu_font_color',
            'output'    => array(
                'color' => '.header_part .dropdown-menu .dropdown-item:hover',
            ),
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Active Menu Color', 'kidzo'),
            'subtitle'  => esc_html__('Menu item font color on sticky Active menu mode.', 'kidzo'),
            'id'        => 'sub_menu_active_font_color',
            'output'    => array(
                'color' => '.dropdown-menu .current-menu-item>.dropdown-item:Hover',
            ),
            'type'      => 'color',
        ),

    
    )
));