<?php
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Preloader Settings', 'kidzo' ),
    'id'               => 'preloader_opt',
    'icon'             => 'dashicons dashicons-controls-repeat',
    'fields'           => array(

        array(
            'id'      => 'is_preloader',
            'type'    => 'switch',
            'title'   => esc_html__( 'Pre-loader', 'kidzo' ),
            'on'      => esc_html__('Enable', 'kidzo'),
            'off'     => esc_html__('Disable', 'kidzo'),
            'default' => true,
        ),

        array(
            'required' => array('is_preloader', '=', '1'),
            'id'       => 'preloader_style',
            'type'     => 'select',
            'title'    => esc_html__( 'Pre-loader Style', 'kidzo' ),
            'default'   => 'text',
            'options'  => array(
                'text'  => esc_html__( 'Text Preloader', 'kidzo' ),
                'image' => esc_html__( 'Image Preloader', 'kidzo' )
            )
        ),

        /**
         * Text Preloader
         */
        array(
            'required' => array('preloader_style', '=', 'text'),
            'id'       => 'preloader_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Pre-loader Text', 'kidzo' ),
            'default'  => get_bloginfo('name')
        ),

        array(
            'title'     => esc_html__('Color', 'kidzo'),
            'id'        => 'preloader_color',
            'type'      => 'color',
            'output'    => array('.ctn-preloader .animation-preloader .txt-loading .letters-loading:before'),
            'required'  => array('preloader_style', '=', 'text'),
        ),

        array(
            'title'     => esc_html__('Shadow Color', 'kidzo'),
            'id'        => 'preloader_shadow_color',
            'type'      => 'color_rgba',
            'output'    => array('.ctn-preloader .animation-preloader .txt-loading .letters-loading'),
            'required'  => array('preloader_style', '=', 'text'),
        ),
        array(
            'title'         => esc_html__('Typography', 'kidzo'),
            'id'            => 'preloader_typo',
            'type'          => 'typography',
            'text-align'    => false,
            'color'         => false,
            'output'        => '.ctn-preloader .animation-preloader .txt-loading',
            'required'      => array('preloader_style', '=', 'text'),
        ),

        array(
            'id'       => 'loading_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Loading Text', 'kidzo' ),
            'default'  => esc_html__('Loading', 'kidzo'),
            'required' => array('preloader_style', '=', 'text'),
        ),

        array(
            'title'         => esc_html__('Loading Text Typography', 'kidzo'),
            'id'            => 'preloader_small_typo',
            'type'          => 'typography',
            'text-align'    => false,
            'output'        => '.ctn-preloader p',
            'required' => array('preloader_style', '=', 'text'),
        ),

        /**
         * Image Preloader
         */
        array(
            'required' => array('preloader_style', '=', 'image'),
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Pre-loader image', 'kidzo' ),
            'compiler' => true,
            'default'  => array(
                'url' => kidzo_DIR_IMG . '/status.gif'
            )
        ),
    )
));