<?php

Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Typography Settings', 'kidzo' ),
    'id'               => 'kidzo_typo_opt',
    'icon'             => 'dashicons dashicons-editor-textcolor',
    'fields'           => array(

        array(
            'id'        => 'typo_note',
            'type'      => 'info',
            'style'     => 'success',
            'title'     => esc_html__( 'Important Note:', 'kidzo'),
            'icon'      => 'dashicons dashicons-info',
            'desc'      => esc_html__( 'This tab contains general typography options. Additional typography options for specific areas can be found within other tabs. Example: For menu typography options go to the Menu Settings tab.', 'kidzo')
        ),

        array(
            'id'=>'body_typo',
            'type' => 'typography', 
            'title' => __('Body Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all body text.', 'kidzo'),
            'output'        => 'body'
        ),


    )
));


/*** Headers Typography ***/
Redux::setSection('kidzo_opt', array(
    'title'            => esc_html__( 'Headers Typography', 'kidzo' ),
    'id'               => 'headers_typo_opt',
    'icon'             => '',
    'subsection'       => true,
    'fields'           => array(
        array(
            'id'        => 'typo_note_headers',
            'type'      => 'info',
            'style'     => 'success',
            'title'     => esc_html__( 'Important Note:', 'kidzo'),
            'icon'      => 'dashicons dashicons-info',
            'desc'      => esc_html__( 'This tab contains general typography options. Additional typography options for specific areas can be found within other tabs. Example: For menu typography options go to the Menu Settings tab.', 'kidzo')
        ),

        array(
            'id'=>'h1_typo',
            'type' => 'typography', 
            'title' => __('H1 Headers Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all H1 Headers.', 'kidzo'),
            'output'        => 'h1'
        ),

        array(
            'id'=>'h2_typo',
            'type' => 'typography', 
            'title' => __('H2 Headers Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all H2 Headers.', 'kidzo'),
            'output'        => 'h2'
        ),

        array(
            'id'=>'h3_typo',
            'type' => 'typography', 
            'title' => __('H3 Headers Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all H3 Headers.', 'kidzo'),
            'output'        => 'h3'
        ),

        array(
            'id'=>'h4_typo',
            'type' => 'typography', 
            'title' => __('H4 Headers Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all H4 Headers.', 'kidzo'),
            'output'        => 'h4'
        ),

        array(
            'id'=>'h5_typo',
            'type' => 'typography', 
            'title' => __('H5 Headers Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all H5 Headers.', 'kidzo'),
            'output'        => 'h5'
        ),
        
        array(
            'id'=>'h6_typo',
            'type' => 'typography', 
            'title' => __('H6 Headers Typography', 'kidzo'),
            'compiler'=>true,
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            //'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            //'font-size'=>false,
            //'line-height'=>false,
            //'word-spacing'=>true, // Defaults to false
            //'letter-spacing'=>true, // Defaults to false
            //'color'=>false,
            //'preview'=>false, // Disable the previewer
            'units'=>'px',              
            'subtitle'=> __('These settings control the typography for all H6 Headers.', 'kidzo'),
            'output'        => 'h6'
        ),
    )
));