<?php 

// Quick view 

add_action('wp_ajax_kidzo_product_quick_view', 'kidzo_product_quick_view');
add_action('wp_ajax_nopriv_kidzo_product_quick_view','kidzo_product_quick_view');

function kidzo_product_quick_view() {
	if(! isset($_REQUEST['product_id'])) {
		die();
	}

	$product_id = intval($_REQUEST['product_id']);
	wp('p='.$product_id.'&post_type=product');
	ob_start();

	while (have_posts()) : the_post();
	    global $product;
		$sku = $product->get_sku() ? $product->get_sku() : esc_html__( 'N/A', 'kidzo' );
	    if ( post_password_required() ) {
            echo get_the_password_form(); // WPCS: XSS ok.
            return;
        }
        ?>
        <div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
           <div class="row">
               <div class="col-sm-6">
               <div class="flexslider">
                <ul class="slides">
                   <?php woocommerce_show_product_images(); ?>
                </ul>
             </div>

               </div>
               <div class="col-sm-6">
                 <?php do_action( 'woocommerce_single_product_summary'); ?>
               </div>
           </div>  
        </div>  
       
    <?php
  
	endwhile;

	echo ob_get_clean();

	die();
}

// add woocommerce modal  

add_action( 'wp_footer', 'kidzo_quickview' );

function kidzo_quickview() {
    ?>
     <div id="products_quick_view_wrap" class="products_quick_view_wrap">
          <a href="javascript:void(0);">x</a>
         <div class="kidzo-quickview-content">
           <div id="quick_view_product_content" class="clearfix"></div>
         </div>
     </div>
    <?php
} 

// Single page ajaxify 

add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');
add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart');
        
function woocommerce_ajax_add_to_cart() {

            $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
            $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
            $variation_id = absint($_POST['variation_id']);
            $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
            $product_status = get_post_status($product_id);

            if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

                do_action('woocommerce_ajax_added_to_cart', $product_id);

                if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
                    wc_add_to_cart_message(array($product_id => $quantity), true);
                }

                WC_AJAX :: get_refreshed_fragments();
            } else {

                $data = array(
                    'error' => true,
                    'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));

                echo wp_send_json($data);
            }

            wp_die();
        }
