<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Kidzo
 */

get_header();
$blog_column = is_active_sidebar( 'sidebar_widgets' ) ? '8' : '12';
?>
<section class="blog_page section_padding">
    <div class="container custom_container">
        <div class="row">
            <?php  if ( have_posts() ) { ?>
            <div class="col-lg-<?php echo esc_attr($blog_column) ?>">
                <div class="blog_post_list">
                    <?php
                        while ( have_posts() ) : the_post();
                    ?>
                     <?php  get_template_part( 'template-parts/content', 'search' ); ?>
                    <?php 
                     endwhile;
                    ?>
                </div>
                <div class="page_pageination justify-content-start">
                    <?php kidzo_pagination(); ?>
                </div>
            </div>
            <?php }else{ ?>
                <div class="col-lg-<?php echo esc_attr($blog_column) ?>">
                    <div class="blog_post_list">
                    <?php  get_template_part( 'template-parts/content', 'none' ); ?>
                    </div>
                </div>
            <?php } ?>
            <?php get_sidebar(); ?>
        </div>
    </div>
 </section>
<?php
get_footer();