<?php
/**
 *  Template Name: events Information
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package kidzo
 */
get_header();
$opt = get_option('kidzo_opt');
$is_animation     = isset( $opt['is_animation_show']) ? $opt['is_animation_show'] : '';
$is_related_item  = isset( $opt['is_related_item_show']) ? $opt['is_related_item_show'] : '';
$related_title    = isset( $opt['related_title']) ? $opt['related_title'] : '';
$related_item_img = isset( $opt['is_related_item_img_show']) ? $opt['is_related_item_img_show'] : '';
$animation_images = isset( $opt['animation_images']) ? $opt['animation_images'] : '';
$related_animation= isset( $opt['related_animation_images']) ? $opt['related_animation_images'] : '';

$is_enrolment_item = isset( $opt['is_enrollment_program_item_show']) ? $opt['is_enrollment_program_item_show'] : '';
$is_enrollment_program_item_show = isset( $opt['is_enrollment_program_item_show']) ? $opt['is_enrollment_program_item_show'] : '';
$enrollment_title_program    = isset( $opt['enrollment_title_program']) ? $opt['enrollment_title_program'] : '';
$enrollment_subtitle_program = isset( $opt['enrollment_subtitle_program']) ? $opt['enrollment_subtitle_program'] : '';
$enrollment_button_text      = isset( $opt['enrollment_button_text']) ? $opt['enrollment_button_text'] : '';
$enrollment_button_url       = isset( $opt['enrollment_button_url']) ? $opt['enrollment_button_url'] : '';
$enrollment_left_side_imges     = isset( $opt['enrollment_left_side_imges']['url'] ) ? $opt['enrollment_left_side_imges']['url'] : '';
$enrollment_right_side_imges     = isset( $opt['enrollment_right_side_imges']['url'] ) ? $opt['enrollment_right_side_imges']['url'] : '';

$event_date_time    = isset( $opt['event_date_time']['url'] ) ? $opt['event_date_time']['url'] : '';
$event_location_img     = isset( $opt['event_location']['url'] ) ? $opt['event_location']['url'] : '';
$event_contact      = isset( $opt['event_contact']['url'] ) ? $opt['event_contact']['url'] : '';

?>
<!-- event section part here -->
<section class="event_section section_padding event_details">
    <?php 
    while (have_posts()) : the_post();
    $cats = get_the_terms(get_the_ID(), 'events_cat');
    $cat_slug = '';
     $cat_name = '';
    if(is_array($cats)) {
        foreach ($cats as $cat) {
            $cat_slug .= $cat->slug.' ';
            $cat_name .= $cat->name.' ';
        }
    }
    $event_date     = strtotime(get_field('event_date'));
    $event_time     = function_exists( 'get_field' ) ? get_field( 'event_time' ) : '';
    $event_location = function_exists( 'get_field' ) ? get_field( 'event_location' ) : '';
    $contact_number = function_exists( 'get_field' ) ? get_field( 'contact_number' ) : '';
    ?>
    <div class="container custom_container">
        <div class="row justify-content-between align-items-center">
            <div class="col-sm-12 col-sm-12">
                <div class="img_section event_single_images">
                    <?php  if( has_post_thumbnail() ){ ?>
                    <?php the_post_thumbnail('kidzo_1170x500', array('class' => 'img-fluid')) ?>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="row justify-content-between align-items-center">
            <div class="col-sm-12 col-sm-12">
                <h3 class="wow fadeInDown title" data-wow-delay=".4s"><?php the_title(); ?></h3>
                <div class="event_section_content pl-0">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="single_event_section_part">
                    <div class="row justify-content-between">
                        <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".5s">
                            <div class="single_event_part single_orange_bg">
                                <div class="single_event_img">
                                    <img src="<?php echo esc_url($event_location_img); ?>" alt="<?php esc_attr_e( 'Location', 'kidzo' ) ?>" class="img-fluid">   
                                </div>
                                <h4><?php echo esc_html__('event location','kidzo'); ?></h4>
                                <p><?php echo kidzo_extention_wp_kses($event_location); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".2s">
                            <div class="single_event_part">
                                <div class="single_event_img">
                                <img src="<?php echo esc_url($event_date_time); ?>" alt="<?php esc_attr__( 'Date & time', 'kidzo' ) ?>" class="img-fluid">   
                                </div>
                                <h4><?php esc_html_e('event Date & Time','kidzo'); ?></h4>
                                <p><?php echo date(get_option('date_format'), $event_date); ?> <br> <?php echo kidzo_extention_wp_kses($event_time); ?></p>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-sm-6 wow fadeInUp" data-wow-delay=".8s">
                            <div class="single_event_part blue_bg">
                                <div class="single_event_img">
                                    <img src="<?php echo esc_url($event_contact); ?>" alt="<?php esc_attr_e( 'Location', 'kidzo' ) ?>" class="img-fluid">   
                                </div>
                                <h4><?php esc_html_e('Contact Us','kidzo'); ?></h4>
                                <p><?php echo kidzo_extention_wp_kses($contact_number); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    endwhile; 
    if($is_animation == 1): 
        $animation = explode(",", $related_animation);
        $i = 1;
        foreach($animation as $images):
            $imag_ani = wp_get_attachment_image_src($images);
                if($i == 1){ ?>
                    <div class="about_page_animation_1">
                        <div data-parallax='{"x": 2, "y": 70, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php }elseif ($i == 2) { ?>
                    <div class="about_page_animation_2">
                        <div data-parallax='{"x": 10, "y": 80, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php  } elseif ($i == 3) { ?>
                    <div class="about_page_animation_3">
                        <div data-parallax='{"x": 30, "y": 60, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php  } elseif ($i == 4) { ?>
                    <div class="about_page_animation_4">
                        <div data-parallax='{"x": 30, "y": -50, "rotateZ":0}'>
                            <?php echo wp_get_attachment_image($images, 'full') ?>
                        </div>
                    </div>
                <?php }
            $i++;
        endforeach; 
    endif;
    ?>
</section>
<?php if($is_enrolment_item == 1): ?>
 <!-- cta part here -->
 <section class="cta_part section_padding">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-8">
                    <div class="cta_part_iner">
                        <h2><?php echo kidzo_extention_wp_kses($enrollment_title_program); ?></h2>
                        <p><?php echo kidzo_extention_wp_kses($enrollment_subtitle_program); ?></p>
                        <a href="<?php echo esc_url($enrollment_button_url); ?>" class="cu_btn white_bg"><?php echo kidzo_extention_wp_kses($enrollment_button_text); ?></a>

                    </div>
                </div>
            </div>
        </div>
        <?php if(!empty($enrollment_left_side_imges)): ?>
        <div class="breadcrumb_animation_1">
            <div data-parallax='{"x": 30, "y": -20}'>
                <img src="<?php echo esc_url($enrollment_left_side_imges); ?>" alt="#">
            </div>
        </div>
        <?php endif; ?>
        <?php if(!empty($enrollment_right_side_imges)): ?>
        <div class="breadcrumb_animation_2">
            <div data-parallax='{"x": 20, "y": -100}'>
                <img src="<?php echo esc_url($enrollment_right_side_imges); ?>" alt="#">
            </div>
        </div>
        <?php endif; ?>
    </section>
    <!-- cta part end -->
<?php endif; ?>


<!-- event section part end -->
<?php if($is_related_item == 1): ?>
 <!-- event list part here -->
<section class="event_list section_padding section_bg_1">
    <div class="container custom_container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section_tittle_style_02">
                    <h2 class="title wow fadeInDown" data-wow-delay=".5s"> <?php echo kidzo_extention_wp_kses($related_title); ?> </h2>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <?php
             $args = array(
                'post_type' => 'events',
                'post_status' => 'publish',
                'posts_per_page' => 4, 
                'order' => 'DESC', 
            );

            $evemt_list = new WP_Query( $args ); 
            if( $evemt_list->have_posts() ){
                while ( $evemt_list->have_posts() ){
                    $evemt_list->the_post();
                    $event_date     = function_exists( 'get_field' ) ? strtotime(get_field( 'event_date' )) : '';
                    $event_time     = function_exists( 'get_field' ) ? get_field( 'event_time' ) : '';
                    $event_location = function_exists( 'get_field' ) ? get_field( 'event_location' ) : '';
                    $address = substr($event_location, 0, 7);

                    if( has_post_thumbnail() ) {
                        $cats = get_the_terms(get_the_ID(), 'events_cat');
                        $cat_slug = '';
                        $cat_name = '';
                        if(is_array($cats)) {
                            foreach ($cats as $cat) {
                                $cat_slug .= $cat->slug.' ';
                                $cat_name .= $cat->name.' ';
                            }
                        }
                        ?>
                        <div class="col-lg-6 col-md-12 wow fadeInUp" data-wow-delay=".2s">
                            <div class="single_event_list">
                                <div class="event_list_img">
                                <?php
                                    the_post_thumbnail('kidzo_195x235', array('class' => 'img-fluid mobile-none'));
                                    the_post_thumbnail('kidzo_515x300', array('class' => 'img-fluid mobile-image'));
                                ?>
                                </div>
                                <div class="event_list_content">
                                    <h5><?php echo date('d', $event_date); ?> <?php echo date('M', $event_date); ?></h5>
                                    <h3> <a href="<?php the_permalink(); ?>"><?php echo  wp_trim_words( get_the_title(), 2, false ); ?></a></h3>
                                    <p><?php echo  wp_trim_words( get_the_content(), 7, false ); ?></p>
                                    <ul>
                                        <li><i class="fas fa-clock"></i><?php esc_html_e('Time: ','kidzo'); ?><span><?php echo kidzo_extention_wp_kses($event_time); ?></span></li>
                                        <li><i class="fas fa-map-marker-alt"></i><?php esc_html_e('Location: ','kidzo'); ?><span><?php echo kidzo_extention_wp_kses($address); ?></span></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php
                    }
                }
            }
            ?>
        </div>
    </div>
    <?php if($related_item_img == 1):
            $logos = explode(",", $related_animation);
            $i = 1;
            foreach($logos as $image):
                $imag_var = wp_get_attachment_image_src($image);
                ?>
                    <?php if($i == 1){ ?>
                        <div class="event_list_animation_1">
                            <div data-parallax='{"x": 2, "y": 70, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($image, 'full') ?>
                            </div>
                        </div>
                    <?php }elseif ($i == 2) { ?>
                        <div class="event_list_animation_3">
                            <div data-parallax='{"x": 30, "y": 60, "rotateZ":0}'>
                                <?php echo wp_get_attachment_image($image, 'full') ?>
                            </div>
                        </div>
                    <?php  } elseif ($i == 3) { ?>
                        <div class="event_list_animation_4">
                            <div data-parallax='{"x": 30, "y": -50, "rotateZ":0}'>
                             <?php echo wp_get_attachment_image($image, 'full') ?>
                            </div>
                        </div>
                    <?php } ?>
                <?php
            $i++;
            endforeach; 
        endif; ?>
</section>
<!-- event list part end -->
<?php endif; ?>
<?php
get_footer();