<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Kidzo
 */
get_header();
$opt = get_option('kidzo_opt');
$is_social_share  = isset( $opt['is_social_share']) ? $opt['is_social_share'] : '';
$is_post_tag      = isset( $opt['is_post_tag'] ) ? $opt['is_post_tag']: '1';
$is_author_info   = isset( $opt['is_author_info'] ) ? $opt['is_author_info']: '';
$is_related       = isset( $opt['is_related'] ) ? $opt['is_related']: '';
$blog_column = is_active_sidebar( 'sidebar_widgets' ) ? '8' : '12';
?>
 <section class="blog_page section_padding">
    <div class="container custom_container">
        <div class="row">
            <div class="col-lg-<?php echo esc_attr($blog_column) ?>">
                <div class="single_blog_details pr_30">
                    <div class="blog_details_content">
                        <?php
                        if( has_post_thumbnail() ){
                            the_post_thumbnail( 'kidzo_740x40', array( 'class' => 'img-fluid' ) );
                        }
                    	while ( have_posts() ) : the_post(); ?>
                        	<?php 
                        	the_content();
                                wp_link_pages( array(
                                    'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'kidzo' ) . '</span>',
                                    'after'       => '</div>',
                                    'link_before' => '<span>',
                                    'link_after'  => '</span>',
                                    'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'kidzo' ) . ' </span>%',
                                    'separator'   => '<span class="screen-reader-text">, </span>',
                                ));
                        endwhile;
                        ?>
                    </div>
                    <div class="tag_share_list single_blog_meta blog_page_single_item">
                    	<?php
                        if($is_social_share == 1 && function_exists('kidzo_social_links')){
                        ?>
                            <div class="share_icon_list d-flex align-items-center">
                                <h4><?php esc_html_e('Share: ','kidzo'); ?></h4>
                                <?php echo kidzo_social_links(); ?>
                            </div>
                        <?php
                        } 
                        ?>
                        <p class="kd_comment"><i class="far fa-comment"></i><?php kidzo_comment_count( get_the_ID() ); ?></p>
                    </div>
                    <div class="tag_share_list">
                    <?php
                        if($is_post_tag == 1){
                            echo kidzo_post_tags();
                        }
                    ?>
                    </div>
                    <?php
                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) :
                    comments_template();
                    endif;
                    ?>
                </div>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
</section>
<?php
get_footer();