

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wp_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2023-09-01 22:12:52","2023-09-01 22:12:52","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



CREATE TABLE `wp_fusion_form_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` bigint(20) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_fusion_form_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_name` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_label` varchar(256) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_fusion_form_submissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(512) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_fusion_forms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT '0',
  `submissions_count` bigint(20) DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wp_fusion_forms VALUES("1","694","122","0","");
INSERT INTO wp_fusion_forms VALUES("2","717","165","0","");
INSERT INTO wp_fusion_forms VALUES("3","1628","12","0","");



CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=3611 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wp_options VALUES("1","siteurl","https://www.buildingbridgesbehaviortherapy.com","yes");
INSERT INTO wp_options VALUES("2","home","https://www.buildingbridgesbehaviortherapy.com","yes");
INSERT INTO wp_options VALUES("3","blogname","Building Bridges Behavior Therapy - Buildingbridgesbehaviortherapy.com","yes");
INSERT INTO wp_options VALUES("4","blogdescription","","yes");
INSERT INTO wp_options VALUES("5","users_can_register","0","yes");
INSERT INTO wp_options VALUES("6","admin_email","imran@buildingbridgesbehaviortherapy.com","yes");
INSERT INTO wp_options VALUES("7","start_of_week","1","yes");
INSERT INTO wp_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("9","use_smilies","0","yes");
INSERT INTO wp_options VALUES("10","require_name_email","1","yes");
INSERT INTO wp_options VALUES("11","comments_notify","1","yes");
INSERT INTO wp_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("17","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("18","default_category","1","yes");
INSERT INTO wp_options VALUES("19","default_comment_status","open","yes");
INSERT INTO wp_options VALUES("20","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("21","default_pingback_flag","1","yes");
INSERT INTO wp_options VALUES("22","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("24","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("26","comment_moderation","0","yes");
INSERT INTO wp_options VALUES("27","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("28","permalink_structure","/{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}postname{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}/","yes");
INSERT INTO wp_options VALUES("29","rewrite_rules","a:282:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"portfolio-items/?$\";s:35:\"index.php?post_type=avada_portfolio\";s:48:\"portfolio-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:43:\"portfolio-items/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:35:\"portfolio-items/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=avada_portfolio&paged=$matches[1]\";s:12:\"faq-items/?$\";s:29:\"index.php?post_type=avada_faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=avada_faq&paged=$matches[1]\";s:44:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"fusion_tb_layout/([^/]+)/embed/?$\";s:49:\"index.php?fusion_tb_layout=$matches[1]&embed=true\";s:37:\"fusion_tb_layout/([^/]+)/trackback/?$\";s:43:\"index.php?fusion_tb_layout=$matches[1]&tb=1\";s:45:\"fusion_tb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&paged=$matches[2]\";s:52:\"fusion_tb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&cpage=$matches[2]\";s:41:\"fusion_tb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?fusion_tb_layout=$matches[1]&page=$matches[2]\";s:33:\"fusion_tb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"fusion_tb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"fusion_tb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_tb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"fusion_tb_section/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"fusion_tb_section/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"fusion_tb_section/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"fusion_tb_section/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"fusion_tb_section/([^/]+)/embed/?$\";s:50:\"index.php?fusion_tb_section=$matches[1]&embed=true\";s:38:\"fusion_tb_section/([^/]+)/trackback/?$\";s:44:\"index.php?fusion_tb_section=$matches[1]&tb=1\";s:46:\"fusion_tb_section/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&paged=$matches[2]\";s:53:\"fusion_tb_section/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&cpage=$matches[2]\";s:42:\"fusion_tb_section/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?fusion_tb_section=$matches[1]&page=$matches[2]\";s:34:\"fusion_tb_section/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"fusion_tb_section/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"fusion_tb_section/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_tb_section/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"fusion_tb_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:54:\"fusion_tb_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:35:\"fusion_tb_category/([^/]+)/embed/?$\";s:51:\"index.php?fusion_tb_category=$matches[1]&embed=true\";s:47:\"fusion_tb_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?fusion_tb_category=$matches[1]&paged=$matches[2]\";s:29:\"fusion_tb_category/([^/]+)/?$\";s:40:\"index.php?fusion_tb_category=$matches[1]\";s:39:\"fusion_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"fusion_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"fusion_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"fusion_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"fusion_form/([^/]+)/embed/?$\";s:44:\"index.php?fusion_form=$matches[1]&embed=true\";s:32:\"fusion_form/([^/]+)/trackback/?$\";s:38:\"index.php?fusion_form=$matches[1]&tb=1\";s:40:\"fusion_form/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&paged=$matches[2]\";s:47:\"fusion_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&cpage=$matches[2]\";s:36:\"fusion_form/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?fusion_form=$matches[1]&page=$matches[2]\";s:28:\"fusion_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"fusion_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"fusion_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"fusion_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"portfolio-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"portfolio-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"portfolio-items/([^/]+)/embed/?$\";s:48:\"index.php?avada_portfolio=$matches[1]&embed=true\";s:36:\"portfolio-items/([^/]+)/trackback/?$\";s:42:\"index.php?avada_portfolio=$matches[1]&tb=1\";s:56:\"portfolio-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-items/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-items/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"portfolio-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:57:\"portfolio_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:52:\"portfolio_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:33:\"portfolio_skills/([^/]+)/embed/?$\";s:49:\"index.php?portfolio_skills=$matches[1]&embed=true\";s:45:\"portfolio_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\";s:27:\"portfolio_skills/([^/]+)/?$\";s:38:\"index.php?portfolio_skills=$matches[1]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:42:\"index.php?avada_faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:36:\"index.php?avada_faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?avada_faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"slide-page/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:46:\"slide-page/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:27:\"slide-page/([^/]+)/embed/?$\";s:43:\"index.php?slide-page=$matches[1]&embed=true\";s:39:\"slide-page/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?slide-page=$matches[1]&paged=$matches[2]\";s:21:\"slide-page/([^/]+)/?$\";s:32:\"index.php?slide-page=$matches[1]\";s:43:\"fusion_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"fusion_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"fusion_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"fusion_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"fusion_template/([^/]+)/embed/?$\";s:48:\"index.php?fusion_template=$matches[1]&embed=true\";s:36:\"fusion_template/([^/]+)/trackback/?$\";s:42:\"index.php?fusion_template=$matches[1]&tb=1\";s:44:\"fusion_template/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&paged=$matches[2]\";s:51:\"fusion_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_template/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?fusion_template=$matches[1]&page=$matches[2]\";s:32:\"fusion_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"fusion_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"fusion_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"fusion_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"fusion_element/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"fusion_element/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"fusion_element/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"fusion_element/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"fusion_element/([^/]+)/embed/?$\";s:47:\"index.php?fusion_element=$matches[1]&embed=true\";s:35:\"fusion_element/([^/]+)/trackback/?$\";s:41:\"index.php?fusion_element=$matches[1]&tb=1\";s:43:\"fusion_element/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&paged=$matches[2]\";s:50:\"fusion_element/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_element/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?fusion_element=$matches[1]&page=$matches[2]\";s:31:\"fusion_element/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"fusion_element/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"fusion_element/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"fusion_element/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"element_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?element_category=$matches[1]&feed=$matches[2]\";s:52:\"element_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?element_category=$matches[1]&feed=$matches[2]\";s:33:\"element_category/([^/]+)/embed/?$\";s:49:\"index.php?element_category=$matches[1]&embed=true\";s:45:\"element_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?element_category=$matches[1]&paged=$matches[2]\";s:27:\"element_category/([^/]+)/?$\";s:38:\"index.php?element_category=$matches[1]\";s:58:\"template_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?template_category=$matches[1]&feed=$matches[2]\";s:53:\"template_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?template_category=$matches[1]&feed=$matches[2]\";s:34:\"template_category/([^/]+)/embed/?$\";s:50:\"index.php?template_category=$matches[1]&embed=true\";s:46:\"template_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?template_category=$matches[1]&paged=$matches[2]\";s:28:\"template_category/([^/]+)/?$\";s:39:\"index.php?template_category=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=5&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO wp_options VALUES("30","hack_file","0","yes");
INSERT INTO wp_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("32","moderation_keys","","no");
INSERT INTO wp_options VALUES("33","active_plugins","a:4:{i:0;s:33:\"fusion-builder/fusion-builder.php\";i:1;s:27:\"fusion-core/fusion-core.php\";i:2;s:17:\"leadin/leadin.php\";i:3;s:41:\"wp-database-backup/wp-database-backup.php\";}","yes");
INSERT INTO wp_options VALUES("34","category_base","","yes");
INSERT INTO wp_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("36","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("37","gmt_offset","0","yes");
INSERT INTO wp_options VALUES("38","default_email_category","1","yes");
INSERT INTO wp_options VALUES("39","recently_edited","","no");
INSERT INTO wp_options VALUES("40","template","Avada","yes");
INSERT INTO wp_options VALUES("41","stylesheet","Avada","yes");
INSERT INTO wp_options VALUES("42","comment_registration","0","yes");
INSERT INTO wp_options VALUES("43","html_type","text/html","yes");
INSERT INTO wp_options VALUES("44","use_trackback","0","yes");
INSERT INTO wp_options VALUES("45","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("46","db_version","55853","yes");
INSERT INTO wp_options VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("48","upload_path","","yes");
INSERT INTO wp_options VALUES("49","blog_public","1","yes");
INSERT INTO wp_options VALUES("50","default_link_category","2","yes");
INSERT INTO wp_options VALUES("51","show_on_front","page","yes");
INSERT INTO wp_options VALUES("52","tag_base","","yes");
INSERT INTO wp_options VALUES("53","show_avatars","1","yes");
INSERT INTO wp_options VALUES("54","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("55","upload_url_path","","yes");
INSERT INTO wp_options VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("58","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("59","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("60","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("61","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("62","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("63","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("64","image_default_link_type","none","yes");
INSERT INTO wp_options VALUES("65","image_default_size","","yes");
INSERT INTO wp_options VALUES("66","image_default_align","","yes");
INSERT INTO wp_options VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO wp_options VALUES("68","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("69","thread_comments","1","yes");
INSERT INTO wp_options VALUES("70","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("71","page_comments","0","yes");
INSERT INTO wp_options VALUES("72","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("73","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("74","comment_order","asc","yes");
INSERT INTO wp_options VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("76","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("77","widget_text","a:0:{}","yes");
INSERT INTO wp_options VALUES("78","widget_rss","a:0:{}","yes");
INSERT INTO wp_options VALUES("79","uninstall_plugins","a:0:{}","no");
INSERT INTO wp_options VALUES("80","timezone_string","","yes");
INSERT INTO wp_options VALUES("81","page_for_posts","0","yes");
INSERT INTO wp_options VALUES("82","page_on_front","5","yes");
INSERT INTO wp_options VALUES("83","default_post_format","0","yes");
INSERT INTO wp_options VALUES("84","link_manager_enabled","0","yes");
INSERT INTO wp_options VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO wp_options VALUES("86","site_icon","0","yes");
INSERT INTO wp_options VALUES("87","medium_large_size_w","768","yes");
INSERT INTO wp_options VALUES("88","medium_large_size_h","0","yes");
INSERT INTO wp_options VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO wp_options VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO wp_options VALUES("91","admin_email_lifespan","1709158371","yes");
INSERT INTO wp_options VALUES("92","disallowed_keys","","no");
INSERT INTO wp_options VALUES("93","comment_previously_approved","1","yes");
INSERT INTO wp_options VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO wp_options VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO wp_options VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO wp_options VALUES("97","auto_update_core_major","enabled","yes");
INSERT INTO wp_options VALUES("98","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO wp_options VALUES("99","initial_db_version","55853","yes");
INSERT INTO wp_options VALUES("100","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wp_options VALUES("101","fresh_site","0","yes");
INSERT INTO wp_options VALUES("102","user_count","1","no");
INSERT INTO wp_options VALUES("103","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("104","sidebars_widgets","a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:6:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:8:\"search-2\";i:4;s:14:\"recent-posts-2\";i:5;s:17:\"recent-comments-2\";}s:21:\"avada-footer-widget-1\";a:5:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";i:4;s:6:\"meta-2\";}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO wp_options VALUES("105","cron","a:10:{i:1697796772;a:5:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1697796798;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697797176;a:1:{s:21:\"backup_files_cron_new\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"ten_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1697839972;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697839998;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697839999;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697840089;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1697926372;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1698133037;a:1:{s:29:\"astra_get_knowledge_base_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("106","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("107","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("108","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("109","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("110","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("111","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("112","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("113","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("114","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("115","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("116","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("117","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("118","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("119","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("120","_transient_wp_core_block_css_files","a:496:{i:0;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/editor-rtl.css\";i:1;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/editor-rtl.min.css\";i:2;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/editor.css\";i:3;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/editor.min.css\";i:4;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/style-rtl.css\";i:5;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/style-rtl.min.css\";i:6;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/style.css\";i:7;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/archives/style.min.css\";i:8;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/editor-rtl.css\";i:9;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/editor-rtl.min.css\";i:10;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/editor.css\";i:11;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/editor.min.css\";i:12;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/style-rtl.css\";i:13;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/style-rtl.min.css\";i:14;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/style.css\";i:15;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/style.min.css\";i:16;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/theme-rtl.css\";i:17;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/theme-rtl.min.css\";i:18;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/theme.css\";i:19;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/audio/theme.min.css\";i:20;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/editor-rtl.css\";i:21;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/editor-rtl.min.css\";i:22;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/editor.css\";i:23;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/editor.min.css\";i:24;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/style-rtl.css\";i:25;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/style-rtl.min.css\";i:26;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/style.css\";i:27;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/avatar/style.min.css\";i:28;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/block/editor-rtl.css\";i:29;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/block/editor-rtl.min.css\";i:30;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/block/editor.css\";i:31;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/block/editor.min.css\";i:32;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/editor-rtl.css\";i:33;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/editor-rtl.min.css\";i:34;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/editor.css\";i:35;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/editor.min.css\";i:36;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/style-rtl.css\";i:37;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/style-rtl.min.css\";i:38;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/style.css\";i:39;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/button/style.min.css\";i:40;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/editor-rtl.css\";i:41;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/editor-rtl.min.css\";i:42;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/editor.css\";i:43;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/editor.min.css\";i:44;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/style-rtl.css\";i:45;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/style-rtl.min.css\";i:46;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/style.css\";i:47;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/buttons/style.min.css\";i:48;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/calendar/style-rtl.css\";i:49;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/calendar/style-rtl.min.css\";i:50;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/calendar/style.css\";i:51;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/calendar/style.min.css\";i:52;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/editor-rtl.css\";i:53;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/editor-rtl.min.css\";i:54;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/editor.css\";i:55;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/editor.min.css\";i:56;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/style-rtl.css\";i:57;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/style-rtl.min.css\";i:58;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/style.css\";i:59;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/categories/style.min.css\";i:60;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/editor-rtl.css\";i:61;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/editor-rtl.min.css\";i:62;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/editor.css\";i:63;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/editor.min.css\";i:64;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/style-rtl.css\";i:65;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/style-rtl.min.css\";i:66;s:82:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/style.css\";i:67;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/style.min.css\";i:68;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/theme-rtl.css\";i:69;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/theme-rtl.min.css\";i:70;s:82:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/theme.css\";i:71;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/code/theme.min.css\";i:72;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/editor-rtl.css\";i:73;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/editor-rtl.min.css\";i:74;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/editor.css\";i:75;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/editor.min.css\";i:76;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/style-rtl.css\";i:77;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/style-rtl.min.css\";i:78;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/style.css\";i:79;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/columns/style.min.css\";i:80;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-content/style-rtl.css\";i:81;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-content/style-rtl.min.css\";i:82;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-content/style.css\";i:83;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-content/style.min.css\";i:84;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-template/style-rtl.css\";i:85;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-template/style-rtl.min.css\";i:86;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-template/style.css\";i:87;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comment-template/style.min.css\";i:88;s:110:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination-numbers/editor-rtl.css\";i:89;s:114:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination-numbers/editor-rtl.min.css\";i:90;s:106:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination-numbers/editor.css\";i:91;s:110:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination-numbers/editor.min.css\";i:92;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/editor-rtl.css\";i:93;s:106:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/editor-rtl.min.css\";i:94;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/editor.css\";i:95;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/editor.min.css\";i:96;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/style-rtl.css\";i:97;s:105:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/style-rtl.min.css\";i:98;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/style.css\";i:99;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-pagination/style.min.css\";i:100;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-title/editor-rtl.css\";i:101;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-title/editor-rtl.min.css\";i:102;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-title/editor.css\";i:103;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments-title/editor.min.css\";i:104;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/editor-rtl.css\";i:105;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/editor-rtl.min.css\";i:106;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/editor.css\";i:107;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/editor.min.css\";i:108;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/style-rtl.css\";i:109;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/style-rtl.min.css\";i:110;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/style.css\";i:111;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/comments/style.min.css\";i:112;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/editor-rtl.css\";i:113;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/editor-rtl.min.css\";i:114;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/editor.css\";i:115;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/editor.min.css\";i:116;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/style-rtl.css\";i:117;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/style-rtl.min.css\";i:118;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/style.css\";i:119;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/cover/style.min.css\";i:120;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/editor-rtl.css\";i:121;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/editor-rtl.min.css\";i:122;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/editor.css\";i:123;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/editor.min.css\";i:124;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/style-rtl.css\";i:125;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/style-rtl.min.css\";i:126;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/style.css\";i:127;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/details/style.min.css\";i:128;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/editor-rtl.css\";i:129;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/editor-rtl.min.css\";i:130;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/editor.css\";i:131;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/editor.min.css\";i:132;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/style-rtl.css\";i:133;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/style-rtl.min.css\";i:134;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/style.css\";i:135;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/style.min.css\";i:136;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/theme-rtl.css\";i:137;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/theme-rtl.min.css\";i:138;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/theme.css\";i:139;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/embed/theme.min.css\";i:140;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/editor-rtl.css\";i:141;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/editor-rtl.min.css\";i:142;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/editor.css\";i:143;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/editor.min.css\";i:144;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/style-rtl.css\";i:145;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/style-rtl.min.css\";i:146;s:82:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/style.css\";i:147;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/file/style.min.css\";i:148;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/footnotes/style-rtl.css\";i:149;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/footnotes/style-rtl.min.css\";i:150;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/footnotes/style.css\";i:151;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/footnotes/style.min.css\";i:152;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/freeform/editor-rtl.css\";i:153;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/freeform/editor-rtl.min.css\";i:154;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/freeform/editor.css\";i:155;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/freeform/editor.min.css\";i:156;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/editor-rtl.css\";i:157;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/editor-rtl.min.css\";i:158;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/editor.css\";i:159;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/editor.min.css\";i:160;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/style-rtl.css\";i:161;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/style-rtl.min.css\";i:162;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/style.css\";i:163;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/style.min.css\";i:164;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/theme-rtl.css\";i:165;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/theme-rtl.min.css\";i:166;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/theme.css\";i:167;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/gallery/theme.min.css\";i:168;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/editor-rtl.css\";i:169;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/editor-rtl.min.css\";i:170;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/editor.css\";i:171;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/editor.min.css\";i:172;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/style-rtl.css\";i:173;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/style-rtl.min.css\";i:174;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/style.css\";i:175;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/style.min.css\";i:176;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/theme-rtl.css\";i:177;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/theme-rtl.min.css\";i:178;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/theme.css\";i:179;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/group/theme.min.css\";i:180;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/heading/style-rtl.css\";i:181;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/heading/style-rtl.min.css\";i:182;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/heading/style.css\";i:183;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/heading/style.min.css\";i:184;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/html/editor-rtl.css\";i:185;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/html/editor-rtl.min.css\";i:186;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/html/editor.css\";i:187;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/html/editor.min.css\";i:188;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/editor-rtl.css\";i:189;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/editor-rtl.min.css\";i:190;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/editor.css\";i:191;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/editor.min.css\";i:192;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/style-rtl.css\";i:193;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/style-rtl.min.css\";i:194;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/style.css\";i:195;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/style.min.css\";i:196;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/theme-rtl.css\";i:197;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/theme-rtl.min.css\";i:198;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/theme.css\";i:199;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/image/theme.min.css\";i:200;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-comments/style-rtl.css\";i:201;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-comments/style-rtl.min.css\";i:202;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-comments/style.css\";i:203;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-comments/style.min.css\";i:204;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/editor-rtl.css\";i:205;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/editor-rtl.min.css\";i:206;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/editor.css\";i:207;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/editor.min.css\";i:208;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/style-rtl.css\";i:209;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/style-rtl.min.css\";i:210;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/style.css\";i:211;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/latest-posts/style.min.css\";i:212;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/list/style-rtl.css\";i:213;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/list/style-rtl.min.css\";i:214;s:82:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/list/style.css\";i:215;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/list/style.min.css\";i:216;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/editor-rtl.css\";i:217;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/editor-rtl.min.css\";i:218;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/editor.css\";i:219;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/editor.min.css\";i:220;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/style-rtl.css\";i:221;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/style-rtl.min.css\";i:222;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/style.css\";i:223;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/media-text/style.min.css\";i:224;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/more/editor-rtl.css\";i:225;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/more/editor-rtl.min.css\";i:226;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/more/editor.css\";i:227;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/more/editor.min.css\";i:228;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/editor-rtl.css\";i:229;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/editor-rtl.min.css\";i:230;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/editor.css\";i:231;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/editor.min.css\";i:232;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/style-rtl.css\";i:233;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/style-rtl.min.css\";i:234;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/style.css\";i:235;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-link/style.min.css\";i:236;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-submenu/editor-rtl.css\";i:237;s:105:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-submenu/editor-rtl.min.css\";i:238;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-submenu/editor.css\";i:239;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation-submenu/editor.min.css\";i:240;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/editor-rtl.css\";i:241;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/editor-rtl.min.css\";i:242;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/editor.css\";i:243;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/editor.min.css\";i:244;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/style-rtl.css\";i:245;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/style-rtl.min.css\";i:246;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/style.css\";i:247;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/navigation/style.min.css\";i:248;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/nextpage/editor-rtl.css\";i:249;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/nextpage/editor-rtl.min.css\";i:250;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/nextpage/editor.css\";i:251;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/nextpage/editor.min.css\";i:252;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/editor-rtl.css\";i:253;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/editor-rtl.min.css\";i:254;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/editor.css\";i:255;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/editor.min.css\";i:256;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/style-rtl.css\";i:257;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/style-rtl.min.css\";i:258;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/style.css\";i:259;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/page-list/style.min.css\";i:260;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/editor-rtl.css\";i:261;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/editor-rtl.min.css\";i:262;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/editor.css\";i:263;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/editor.min.css\";i:264;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/style-rtl.css\";i:265;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/style-rtl.min.css\";i:266;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/style.css\";i:267;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/paragraph/style.min.css\";i:268;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-author/style-rtl.css\";i:269;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-author/style-rtl.min.css\";i:270;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-author/style.css\";i:271;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-author/style.min.css\";i:272;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/editor-rtl.css\";i:273;s:105:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/editor-rtl.min.css\";i:274;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/editor.css\";i:275;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/editor.min.css\";i:276;s:100:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/style-rtl.css\";i:277;s:104:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/style-rtl.min.css\";i:278;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/style.css\";i:279;s:100:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-comments-form/style.min.css\";i:280;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-date/style-rtl.css\";i:281;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-date/style-rtl.min.css\";i:282;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-date/style.css\";i:283;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-date/style.min.css\";i:284;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/editor-rtl.css\";i:285;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/editor-rtl.min.css\";i:286;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/editor.css\";i:287;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/editor.min.css\";i:288;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/style-rtl.css\";i:289;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/style-rtl.min.css\";i:290;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/style.css\";i:291;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-excerpt/style.min.css\";i:292;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/editor-rtl.css\";i:293;s:106:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/editor-rtl.min.css\";i:294;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/editor.css\";i:295;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/editor.min.css\";i:296;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/style-rtl.css\";i:297;s:105:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/style-rtl.min.css\";i:298;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/style.css\";i:299;s:101:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-featured-image/style.min.css\";i:300;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-navigation-link/style-rtl.css\";i:301;s:106:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-navigation-link/style-rtl.min.css\";i:302;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-navigation-link/style.css\";i:303;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-navigation-link/style.min.css\";i:304;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/editor-rtl.css\";i:305;s:100:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/editor-rtl.min.css\";i:306;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/editor.css\";i:307;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/editor.min.css\";i:308;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/style-rtl.css\";i:309;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/style-rtl.min.css\";i:310;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/style.css\";i:311;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-template/style.min.css\";i:312;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-terms/style-rtl.css\";i:313;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-terms/style-rtl.min.css\";i:314;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-terms/style.css\";i:315;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-terms/style.min.css\";i:316;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-title/style-rtl.css\";i:317;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-title/style-rtl.min.css\";i:318;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-title/style.css\";i:319;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/post-title/style.min.css\";i:320;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/preformatted/style-rtl.css\";i:321;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/preformatted/style-rtl.min.css\";i:322;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/preformatted/style.css\";i:323;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/preformatted/style.min.css\";i:324;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/editor-rtl.css\";i:325;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/editor-rtl.min.css\";i:326;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/editor.css\";i:327;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/editor.min.css\";i:328;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/style-rtl.css\";i:329;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/style-rtl.min.css\";i:330;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/style.css\";i:331;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/style.min.css\";i:332;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/theme-rtl.css\";i:333;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/theme-rtl.min.css\";i:334;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/theme.css\";i:335;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/pullquote/theme.min.css\";i:336;s:107:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination-numbers/editor-rtl.css\";i:337;s:111:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination-numbers/editor-rtl.min.css\";i:338;s:103:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination-numbers/editor.css\";i:339;s:107:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination-numbers/editor.min.css\";i:340;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/editor-rtl.css\";i:341;s:103:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/editor-rtl.min.css\";i:342;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/editor.css\";i:343;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/editor.min.css\";i:344;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/style-rtl.css\";i:345;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/style-rtl.min.css\";i:346;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/style.css\";i:347;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-pagination/style.min.css\";i:348;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-title/style-rtl.css\";i:349;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-title/style-rtl.min.css\";i:350;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-title/style.css\";i:351;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query-title/style.min.css\";i:352;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query/editor-rtl.css\";i:353;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query/editor-rtl.min.css\";i:354;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query/editor.css\";i:355;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/query/editor.min.css\";i:356;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/style-rtl.css\";i:357;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/style-rtl.min.css\";i:358;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/style.css\";i:359;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/style.min.css\";i:360;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/theme-rtl.css\";i:361;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/theme-rtl.min.css\";i:362;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/theme.css\";i:363;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/quote/theme.min.css\";i:364;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/read-more/style-rtl.css\";i:365;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/read-more/style-rtl.min.css\";i:366;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/read-more/style.css\";i:367;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/read-more/style.min.css\";i:368;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/editor-rtl.css\";i:369;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/editor-rtl.min.css\";i:370;s:82:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/editor.css\";i:371;s:86:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/editor.min.css\";i:372;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/style-rtl.css\";i:373;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/style-rtl.min.css\";i:374;s:81:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/style.css\";i:375;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/rss/style.min.css\";i:376;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/editor-rtl.css\";i:377;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/editor-rtl.min.css\";i:378;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/editor.css\";i:379;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/editor.min.css\";i:380;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/style-rtl.css\";i:381;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/style-rtl.min.css\";i:382;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/style.css\";i:383;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/style.min.css\";i:384;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/theme-rtl.css\";i:385;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/theme-rtl.min.css\";i:386;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/theme.css\";i:387;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/search/theme.min.css\";i:388;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/editor-rtl.css\";i:389;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/editor-rtl.min.css\";i:390;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/editor.css\";i:391;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/editor.min.css\";i:392;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/style-rtl.css\";i:393;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/style-rtl.min.css\";i:394;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/style.css\";i:395;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/style.min.css\";i:396;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/theme-rtl.css\";i:397;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/theme-rtl.min.css\";i:398;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/theme.css\";i:399;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/separator/theme.min.css\";i:400;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/shortcode/editor-rtl.css\";i:401;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/shortcode/editor-rtl.min.css\";i:402;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/shortcode/editor.css\";i:403;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/shortcode/editor.min.css\";i:404;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/editor-rtl.css\";i:405;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/editor-rtl.min.css\";i:406;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/editor.css\";i:407;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/editor.min.css\";i:408;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/style-rtl.css\";i:409;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/style-rtl.min.css\";i:410;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/style.css\";i:411;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-logo/style.min.css\";i:412;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-tagline/editor-rtl.css\";i:413;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-tagline/editor-rtl.min.css\";i:414;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-tagline/editor.css\";i:415;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-tagline/editor.min.css\";i:416;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/editor-rtl.css\";i:417;s:97:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/editor-rtl.min.css\";i:418;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/editor.css\";i:419;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/editor.min.css\";i:420;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/style-rtl.css\";i:421;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/style-rtl.min.css\";i:422;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/style.css\";i:423;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/site-title/style.min.css\";i:424;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-link/editor-rtl.css\";i:425;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-link/editor-rtl.min.css\";i:426;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-link/editor.css\";i:427;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-link/editor.min.css\";i:428;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/editor-rtl.css\";i:429;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/editor-rtl.min.css\";i:430;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/editor.css\";i:431;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/editor.min.css\";i:432;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/style-rtl.css\";i:433;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/style-rtl.min.css\";i:434;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/style.css\";i:435;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/social-links/style.min.css\";i:436;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/editor-rtl.css\";i:437;s:93:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/editor-rtl.min.css\";i:438;s:85:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/editor.css\";i:439;s:89:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/editor.min.css\";i:440;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/style-rtl.css\";i:441;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/style-rtl.min.css\";i:442;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/style.css\";i:443;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/spacer/style.min.css\";i:444;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/editor-rtl.css\";i:445;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/editor-rtl.min.css\";i:446;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/editor.css\";i:447;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/editor.min.css\";i:448;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/style-rtl.css\";i:449;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/style-rtl.min.css\";i:450;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/style.css\";i:451;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/style.min.css\";i:452;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/theme-rtl.css\";i:453;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/theme-rtl.min.css\";i:454;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/theme.css\";i:455;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/table/theme.min.css\";i:456;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/tag-cloud/style-rtl.css\";i:457;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/tag-cloud/style-rtl.min.css\";i:458;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/tag-cloud/style.css\";i:459;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/tag-cloud/style.min.css\";i:460;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/editor-rtl.css\";i:461;s:100:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/editor-rtl.min.css\";i:462;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/editor.css\";i:463;s:96:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/editor.min.css\";i:464;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/theme-rtl.css\";i:465;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/theme-rtl.min.css\";i:466;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/theme.css\";i:467;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/template-part/theme.min.css\";i:468;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/term-description/style-rtl.css\";i:469;s:102:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/term-description/style-rtl.min.css\";i:470;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/term-description/style.css\";i:471;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/term-description/style.min.css\";i:472;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/editor-rtl.css\";i:473;s:99:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/editor-rtl.min.css\";i:474;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/editor.css\";i:475;s:95:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/editor.min.css\";i:476;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/style-rtl.css\";i:477;s:98:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/style-rtl.min.css\";i:478;s:90:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/style.css\";i:479;s:94:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/text-columns/style.min.css\";i:480;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/verse/style-rtl.css\";i:481;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/verse/style-rtl.min.css\";i:482;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/verse/style.css\";i:483;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/verse/style.min.css\";i:484;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/editor-rtl.css\";i:485;s:92:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/editor-rtl.min.css\";i:486;s:84:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/editor.css\";i:487;s:88:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/editor.min.css\";i:488;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/style-rtl.css\";i:489;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/style-rtl.min.css\";i:490;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/style.css\";i:491;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/style.min.css\";i:492;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/theme-rtl.css\";i:493;s:91:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/theme-rtl.min.css\";i:494;s:83:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/theme.css\";i:495;s:87:\"/var/www/html/buildingbridgesbehaviortherapy.com/wp-includes/blocks/video/theme.min.css\";}","yes");
INSERT INTO wp_options VALUES("122","recovery_keys","a:0:{}","yes");
INSERT INTO wp_options VALUES("123","theme_mods_twentytwentythree","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1694108586;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","yes");
INSERT INTO wp_options VALUES("124","https_detection_errors","a:0:{}","yes");
INSERT INTO wp_options VALUES("139","can_compress_scripts","0","yes");
INSERT INTO wp_options VALUES("152","finished_updating_comment_type","1","yes");
INSERT INTO wp_options VALUES("183","_transient_health-check-site-status-result","{\"good\":16,\"recommended\":6,\"critical\":1}","yes");
INSERT INTO wp_options VALUES("337","current_theme","Avada","yes");
INSERT INTO wp_options VALUES("338","theme_mods_Avada","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:9;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1694504236;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:21:\"avada-footer-widget-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("339","theme_switched","","yes");
INSERT INTO wp_options VALUES("340","avada_version","7.10.1","yes");
INSERT INTO wp_options VALUES("348","shop_catalog_image_size","a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO wp_options VALUES("349","shop_single_image_size","a:3:{s:5:\"width\";i:700;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO wp_options VALUES("350","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO wp_options VALUES("351","woocommerce_single_image_width","700","yes");
INSERT INTO wp_options VALUES("352","woocommerce_thumbnail_image_width","500","yes");
INSERT INTO wp_options VALUES("353","woocommerce_thumbnail_cropping","uncropped","yes");
INSERT INTO wp_options VALUES("354","fusion_dynamic_css_posts","a:43:{i:1967;b:0;i:1338;b:0;i:5;b:1;s:6:\"global\";b:1;i:1000;b:1;s:9:\"2-archive\";b:1;i:1330;b:1;i:136;b:1;i:143;b:1;i:1336;b:1;i:1142;b:1;i:1565;b:1;i:1323;b:1;i:145;b:1;i:1530;b:1;i:1472;b:1;s:9:\"1-archive\";b:1;i:1;b:1;i:2;b:1;i:231;b:1;i:1406;b:1;s:9:\"0-archive\";b:1;s:9:\"3-archive\";b:1;s:9:\"4-archive\";b:1;s:9:\"5-archive\";b:1;s:9:\"6-archive\";b:1;s:9:\"7-archive\";b:1;s:9:\"8-archive\";b:1;s:9:\"9-archive\";b:1;s:10:\"10-archive\";b:1;s:10:\"11-archive\";b:1;s:10:\"12-archive\";b:1;s:10:\"13-archive\";b:1;s:10:\"14-archive\";b:1;s:10:\"15-archive\";b:1;s:10:\"16-archive\";b:1;s:10:\"17-archive\";b:1;s:10:\"18-archive\";b:1;s:10:\"19-archive\";b:1;s:10:\"20-archive\";b:1;i:1968;b:0;i:1970;b:0;i:1971;b:0;}","yes");
INSERT INTO wp_options VALUES("355","fusion_dynamic_css_ids","a:43:{i:1967;b:0;i:1338;b:0;i:5;s:32:\"795af9caf9ca01031a8d7f8dbacb4e2b\";s:6:\"global\";s:32:\"473164b4e2bccef21c91d8a11b832068\";i:1000;s:32:\"795af9caf9ca01031a8d7f8dbacb4e2b\";s:9:\"2-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";i:1330;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:136;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:143;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:1336;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:1142;s:32:\"61a77570d47dca2533ed541e0be8f30c\";i:1565;s:32:\"bc2a407f8649fa699dd36db31f73da6b\";i:1323;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:145;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:1530;s:32:\"bc2a407f8649fa699dd36db31f73da6b\";i:1472;s:32:\"bc2a407f8649fa699dd36db31f73da6b\";s:9:\"1-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";i:1;s:32:\"2bbd5918c5f6a4b44e20c7ca0bfbaa1a\";i:2;s:32:\"61a77570d47dca2533ed541e0be8f30c\";i:231;s:32:\"72044c2e91031565ebe2e64f16b13205\";i:1406;s:32:\"bc2a407f8649fa699dd36db31f73da6b\";s:9:\"0-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"3-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"4-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"5-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"6-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"7-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"8-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:9:\"9-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"10-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"11-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"12-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"13-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"14-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"15-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"16-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"17-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"18-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"19-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";s:10:\"20-archive\";s:32:\"341ae07ba2bbf68ff4b004ed0c6fd0f3\";i:1968;b:0;i:1970;b:0;i:1971;b:0;}","yes");
INSERT INTO wp_options VALUES("356","avada_disable_builder","1","yes");
INSERT INTO wp_options VALUES("357","avada_disable_encoding","1","yes");
INSERT INTO wp_options VALUES("362","revslider-valid-notice","false","yes");
INSERT INTO wp_options VALUES("379","fusion_registration_data","a:1:{s:5:\"avada\";a:5:{s:5:\"token\";s:0:\"\";s:13:\"purchase_code\";s:36:\"7c764d84-0e4c-4e69-8756-878343a5cff2\";s:8:\"is_valid\";b:1;s:6:\"scopes\";a:0:{}s:6:\"errors\";s:0:\"\";}}","yes");
INSERT INTO wp_options VALUES("818","theme_mods_astra","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1695261228;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("820","astra_docs_data","O:8:\"stdClass\":2:{s:10:\"categories\";O:8:\"stdClass\":10:{s:24:\"installation-and-updates\";O:8:\"stdClass\":2:{s:4:\"name\";s:24:\"Installation and Updates\";s:13:\"subcategories\";a:0:{}}s:28:\"astra-theme-walkthrough-docs\";O:8:\"stdClass\":2:{s:4:\"name\";s:23:\"Astra Theme Walkthrough\";s:13:\"subcategories\";a:0:{}}s:25:\"astra-customizer-settings\";O:8:\"stdClass\":2:{s:4:\"name\";s:19:\"Customizer Settings\";s:13:\"subcategories\";O:8:\"stdClass\":10:{s:17:\"header-and-footer\";O:8:\"stdClass\":2:{s:4:\"name\";s:19:\"Header &amp; Footer\";s:13:\"subcategories\";O:8:\"stdClass\":2:{s:24:\"header-footer-before-3-0\";O:8:\"stdClass\":2:{s:4:\"name\";s:43:\"Old Header &amp; Footer (Before Astra v3.0)\";s:13:\"subcategories\";a:0:{}}s:23:\"header-footer-after-3-0\";O:8:\"stdClass\":2:{s:4:\"name\";s:41:\"Header &amp; Footer Builder (Astra v3.0+)\";s:13:\"subcategories\";a:0:{}}}}s:6:\"global\";O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Global\";s:13:\"subcategories\";a:0:{}}s:10:\"breadcrumb\";O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Breadcrumb\";s:13:\"subcategories\";a:0:{}}s:4:\"blog\";O:8:\"stdClass\":2:{s:4:\"name\";s:4:\"Blog\";s:13:\"subcategories\";a:0:{}}s:7:\"sidebar\";O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Sidebar\";s:13:\"subcategories\";a:0:{}}s:9:\"learndash\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LearnDash\";s:13:\"subcategories\";a:0:{}}s:22:\"easy-digital-downloads\";O:8:\"stdClass\":2:{s:4:\"name\";s:22:\"Easy Digital Downloads\";s:13:\"subcategories\";a:0:{}}s:9:\"lifterlms\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LifterLMS\";s:13:\"subcategories\";a:0:{}}s:16:\"woocommerce-free\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"WooCommerce\";s:13:\"subcategories\";a:0:{}}s:13:\"meta-settings\";O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"Meta Settings\";s:13:\"subcategories\";a:0:{}}}}s:17:\"astra-pro-modules\";O:8:\"stdClass\":2:{s:4:\"name\";s:17:\"Astra Pro Modules\";s:13:\"subcategories\";O:8:\"stdClass\":18:{s:11:\"white-label\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"White Label\";s:13:\"subcategories\";a:0:{}}s:13:\"mobile-header\";O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"Mobile Header\";s:13:\"subcategories\";a:0:{}}s:8:\"nav-menu\";O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Nav Menu\";s:13:\"subcategories\";a:0:{}}s:14:\"typography-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Typography\";s:13:\"subcategories\";a:0:{}}s:21:\"colors-background-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:23:\"Colors &amp; Background\";s:13:\"subcategories\";a:0:{}}s:21:\"custom-layouts-module\";O:8:\"stdClass\":2:{s:4:\"name\";s:21:\"Custom Layouts Module\";s:13:\"subcategories\";a:0:{}}s:11:\"site-layout\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Site Layout\";s:13:\"subcategories\";a:0:{}}s:15:\"header-sections\";O:8:\"stdClass\":2:{s:4:\"name\";s:15:\"Header Sections\";s:13:\"subcategories\";a:0:{}}s:13:\"sticky-header\";O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"Sticky Header\";s:13:\"subcategories\";a:0:{}}s:12:\"page-headers\";O:8:\"stdClass\":2:{s:4:\"name\";s:12:\"Page Headers\";s:13:\"subcategories\";a:0:{}}s:8:\"blog-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Blog Pro\";s:13:\"subcategories\";a:0:{}}s:21:\"footer-widgets-module\";O:8:\"stdClass\":2:{s:4:\"name\";s:21:\"Footer Widgets Module\";s:13:\"subcategories\";a:0:{}}s:7:\"spacing\";O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Spacing\";s:13:\"subcategories\";a:0:{}}s:3:\"woo\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"WooCommerce\";s:13:\"subcategories\";a:0:{}}s:27:\"learndash-astra-pro-modules\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LearnDash\";s:13:\"subcategories\";a:0:{}}s:19:\"lifterlms-astra-pro\";O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"LifterLMS\";s:13:\"subcategories\";a:0:{}}s:29:\"easy-digital-downloads-module\";O:8:\"stdClass\":2:{s:4:\"name\";s:29:\"Easy Digital Downloads Module\";s:13:\"subcategories\";a:0:{}}s:18:\"native-amp-support\";O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Native AMP Support\";s:13:\"subcategories\";a:0:{}}}}s:17:\"starter-templates\";O:8:\"stdClass\":2:{s:4:\"name\";s:17:\"Starter Templates\";s:13:\"subcategories\";a:0:{}}s:15:\"translate-astra\";O:8:\"stdClass\":2:{s:4:\"name\";s:15:\"Translate Astra\";s:13:\"subcategories\";a:0:{}}s:7:\"general\";O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"General\";s:13:\"subcategories\";a:0:{}}s:17:\"account-and-store\";O:8:\"stdClass\":2:{s:4:\"name\";s:17:\"Account and Store\";s:13:\"subcategories\";a:0:{}}s:20:\"custom-code-snippets\";O:8:\"stdClass\":2:{s:4:\"name\";s:20:\"Custom Code Snippets\";s:13:\"subcategories\";O:8:\"stdClass\":5:{s:23:\"astra-theme-pro-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:29:\"Astra Theme &amp; Pro Filters\";s:13:\"subcategories\";a:0:{}}s:27:\"astra-header-footer-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:33:\"Astra Header &amp; Footer Filters\";s:13:\"subcategories\";a:0:{}}s:12:\"blog-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:12:\"Blog Filters\";s:13:\"subcategories\";a:0:{}}s:19:\"woocommerce-filters\";O:8:\"stdClass\":2:{s:4:\"name\";s:19:\"WooCommerce Filters\";s:13:\"subcategories\";a:0:{}}s:10:\"custom-css\";O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Custom CSS\";s:13:\"subcategories\";a:0:{}}}}s:15:\"troubleshooting\";O:8:\"stdClass\":2:{s:4:\"name\";s:15:\"Troubleshooting\";s:13:\"subcategories\";a:0:{}}}s:4:\"docs\";a:458:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Custom Template in Astra\";s:3:\"url\";s:41:\"https://wpastra.com/docs/custom-template/\";s:8:\"category\";a:0:{}}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Customize Button in Gutenberg Editor\";s:3:\"url\";s:69:\"https://wpastra.com/docs/how-to-customize-button-in-gutenberg-editor/\";s:8:\"category\";a:0:{}}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"How to Create a Button with a Link\";s:3:\"url\";s:49:\"https://wpastra.com/docs/create-button-with-link/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Use the Astra Button Presets\";s:3:\"url\";s:46:\"https://wpastra.com/docs/astra-button-presets/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:57:\"Curl Support Missing Error &#8211; for the Administrators\";s:3:\"url\";s:69:\"https://wpastra.com/docs/curl-support-missing-for-the-administrators/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:76:\"Astra Theme Container Layouts: Revamped Options and Improved User Experience\";s:3:\"url\";s:101:\"https://wpastra.com/docs/astra-theme-container-layouts-revamped-options-and-improved-user-experience/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:81:\"Understanding Container Style in Astra Theme: Customizing Your Container’s Look\";s:3:\"url\";s:103:\"https://wpastra.com/docs/understanding-container-style-in-astra-theme-customizing-your-containers-look/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:7;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Astra 4.2.0-beta.1 : Migrations &amp; Backwards Compatibility\";s:3:\"url\";s:79:\"https://wpastra.com/docs/astra-4-2-0-beta-1-migrations-backwards-compatibility/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:8;O:8:\"stdClass\":3:{s:5:\"title\";s:81:\"Understanding Sidebar Style in Astra Theme: Customizing Your Sidebar&#8217;s Look\";s:3:\"url\";s:99:\"https://wpastra.com/docs/understanding-sidebar-style-in-astra-theme-customizing-your-sidebars-look/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:9;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"Astra WooCommerce CSS overriding Global H2 tag font size on product page\";s:3:\"url\";s:98:\"https://wpastra.com/docs/astra-woocommerce-css-overriding-global-h2-tag-font-size-on-product-page/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:10;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"How to Fix the Line Height Unit being converted to “EM”?\";s:3:\"url\";s:79:\"https://wpastra.com/docs/how-to-fix-the-line-height-unit-being-converted-to-em/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:11;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Create Custom CSS using Inspect Element Tool?\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-create-custom-css-using-inspect-element-tool/\";s:8:\"category\";a:0:{}}i:12;O:8:\"stdClass\":3:{s:5:\"title\";s:76:\"XMLReader Support Missing &#8211; Starter Templates (For the Administrators)\";s:3:\"url\";s:92:\"https://wpastra.com/docs/xmlreader-support-missing-starter-templates-for-the-administrators/\";s:8:\"category\";a:0:{}}i:13;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How to Disable or Change the Position of the Featured Image on the Pages?\";s:3:\"url\";s:98:\"https://wpastra.com/docs/how-to-disable-or-change-the-position-of-the-featured-image-on-the-pages/\";s:8:\"category\";a:0:{}}i:14;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Add Images or Icons in the Navigation Menu\";s:3:\"url\";s:75:\"https://wpastra.com/docs/how-to-add-images-or-icons-in-the-navigation-menu/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:15;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Introducing New Filter to Enable/Disable Rank-Math Theme Support\";s:3:\"url\";s:90:\"https://wpastra.com/docs/introducing-new-filter-to-enable-disable-rank-math-theme-support/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:16;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Basic Debugging Steps of WordPress\";s:3:\"url\";s:60:\"https://wpastra.com/docs/basic-debugging-steps-of-wordpress/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:17;O:8:\"stdClass\":3:{s:5:\"title\";s:57:\"Introducing the new Disable Banner Area Meta-Based Option\";s:3:\"url\";s:83:\"https://wpastra.com/docs/introducing-the-new-disable-banner-area-meta-based-option/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:18;O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Introducing New Add to Cart Trigger Actions for Shop and Single Product Pages.\";s:3:\"url\";s:103:\"https://wpastra.com/docs/introducing-new-add-to-cart-trigger-actions-for-shop-and-single-product-pages/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:19;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"How to Change the Typography of the Astra Menu\";s:3:\"url\";s:72:\"https://wpastra.com/docs/how-to-change-the-typography-of-the-astra-menu/\";s:8:\"category\";a:2:{i:0;s:14:\"typography-pro\";i:1;s:25:\"astra-customizer-settings\";}}i:20;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"How to Resolve Update Failed: -1 issue with Starter Templates plugin?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/resolve-update-failed-1-issue/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:21;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Astra 4.0.0 Nav Menu Module\";s:3:\"url\";s:41:\"https://wpastra.com/docs/nav-menu-module/\";s:8:\"category\";a:1:{i:0;s:8:\"nav-menu\";}}i:22;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"We are facing a temporary issue in importing this template\";s:3:\"url\";s:84:\"https://wpastra.com/docs/we-are-facing-a-temporary-issue-in-importing-this-template/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:23;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"How to use dynamic customizer from Astra 4.0.0\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-use-dynamic-customizer-from-astra-4-0/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:24;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"Changing the Post Title&#8217;s Tag of the Related Post Section\";s:3:\"url\";s:82:\"https://wpastra.com/docs/changing-the-post-titles-tag-of-the-related-post-section/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:25;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Narrow Width &#8211; Container Layout\";s:3:\"url\";s:55:\"https://wpastra.com/docs/narrow-width-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:26;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"Quick admin bar navigation to edit custom layout &#038; page header\";s:3:\"url\";s:86:\"https://wpastra.com/docs/quick-admin-bar-navigation-to-edit-custom-layout-page-header/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:27;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Support Mega Menu for all the Header Builder Menu component\";s:3:\"url\";s:65:\"https://wpastra.com/docs/mega-menu-support-for-all-builder-menus/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:28;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Improved Spectra Compatibility\";s:3:\"url\";s:56:\"https://wpastra.com/docs/improved-spectra-compatibility/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:29;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to add a custom cart button in WordPress\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-add-a-custom-cart-button-in-wordpress/\";s:8:\"category\";a:0:{}}i:30;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Show Password eye icon not visible\";s:3:\"url\";s:60:\"https://wpastra.com/docs/show-password-eye-icon-not-visible/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:31;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Revert support for Single Product&#8217;s legacy Gallery layouts\";s:3:\"url\";s:83:\"https://wpastra.com/docs/revert-support-for-single-products-legacy-gallery-layouts/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:32;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Revert support for old Astra cart icon\";s:3:\"url\";s:64:\"https://wpastra.com/docs/revert-support-for-old-astra-cart-icon/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:33;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to Manage WooCommerce Product Image Width\";s:3:\"url\";s:71:\"https://wpastra.com/docs/how-to-manage-woocommerce-product-image-width/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:34;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to enable Product Quantity (Plus-Minus)?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/how-to-enable-product-quantity-plus-minus/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:35;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Sticky Header Background Color\";s:3:\"url\";s:56:\"https://wpastra.com/docs/sticky-header-background-color/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:36;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to remove an Author&#8217;s name from a Single Blog Post?\";s:3:\"url\";s:76:\"https://wpastra.com/docs/how-to-remove-authors-name-from-a-single-blog-post/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:37;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Highlight the active menu item\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-highlight-the-active-menu-item/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:38;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Change &#8220;Add to Cart&#8221; button text?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-change-add-to-cart-button-text/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:39;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to change site background color in Astra\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-change-site-background-color-in-astra/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:40;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Fix Mobile Usability Issues on Astra\";s:3:\"url\";s:62:\"https://wpastra.com/docs/fix-mobile-usability-issues-on-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:41;O:8:\"stdClass\":3:{s:5:\"title\";s:84:\"How to remove horizontal &#038; vertical gallery layouts from a single product page?\";s:3:\"url\";s:102:\"https://wpastra.com/docs/how-to-remove-horizontal-vertical-gallery-layouts-from-a-single-product-page/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:42;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Transparent Header Menu Color not working with Mobile Breakpoint\";s:3:\"url\";s:90:\"https://wpastra.com/docs/transparent-header-menu-color-not-working-with-mobile-breakpoint/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:43;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"cURL error 60: unable to install Astra Pro plugin\";s:3:\"url\";s:74:\"https://wpastra.com/docs/curl-error-60-unable-to-install-astra-pro-plugin/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:44;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"WP_Error-cURL error 7: Failed to connect to websitedemos.net\";s:3:\"url\";s:85:\"https://wpastra.com/docs/wp_error-curl-error-7-failed-to-connect-to-websitedemos-net/\";s:8:\"category\";a:2:{i:0;s:15:\"troubleshooting\";i:1;s:17:\"starter-templates\";}}i:45;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to create a multisite network and use Astra child theme on it.\";s:3:\"url\";s:83:\"https://wpastra.com/docs/how-to-create-a-multisite-network-using-astra-child-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:46;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to ensure text remains visible during web font load Astra\";s:3:\"url\";s:87:\"https://wpastra.com/docs/how-to-ensure-text-remains-visible-during-web-font-load-astra/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:47;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to create a sticky sidebar in Astra\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-create-a-sticky-sidebar-in-astra/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:48;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Change Color of Sale Badge &#8211; WooCommerce\";s:3:\"url\";s:64:\"https://wpastra.com/docs/change-color-of-sale-badge-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:49;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to design Footer Background in Astra\";s:3:\"url\";s:57:\"https://wpastra.com/docs/how-to-design-footer-background/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:50;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"How to disable logo cropping\";s:3:\"url\";s:54:\"https://wpastra.com/docs/how-to-disable-logo-cropping/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:51;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Misc &#8211; WooCommerce\";s:3:\"url\";s:42:\"https://wpastra.com/docs/misc-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:52;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How To add Custom CSS for Specific Pages\";s:3:\"url\";s:66:\"https://wpastra.com/docs/how-to-add-custom-css-for-specific-pages/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:53;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to create a Mobile Menu\";s:3:\"url\";s:53:\"https://wpastra.com/docs/how-to-create-a-mobile-menu/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:54;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"Uploaded file exceeds the upload_max_filesize directive in php.ini\";s:3:\"url\";s:92:\"https://wpastra.com/docs/uploaded-file-exceeds-the-upload_max_filesize-directive-in-php-ini/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:55;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"What are the Best Astra Settings for Elementor?\";s:3:\"url\";s:72:\"https://wpastra.com/docs/what-are-the-best-astra-settings-for-elementor/\";s:8:\"category\";a:1:{i:0;s:13:\"meta-settings\";}}i:56;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Astra theme string translation for WooCommerce\";s:3:\"url\";s:72:\"https://wpastra.com/docs/astra-theme-string-translation-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:57;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How To Fix Not Being Able To Edit Submenu Colors, Above and Below Header?\";s:3:\"url\";s:97:\"https://wpastra.com/docs/how-to-fix-not-being-able-to-edit-submenu-colors-above-and-below-header/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:58;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to Import / Export Astra Customizer Settings\";s:3:\"url\";s:72:\"https://wpastra.com/docs/how-to-import-export-astra-customizer-settings/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:59;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to disable cart fragments on WooCommerce?\";s:3:\"url\";s:70:\"https://wpastra.com/docs/how-to-disable-cart-fragments-on-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:60;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to add custom CSS and JavaScript to Astra theme\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-add-custom-css-and-javascript-to-astra-theme/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:61;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to add custom post type with the Astra theme\";s:3:\"url\";s:74:\"https://wpastra.com/docs/how-to-add-custom-post-type-with-the-astra-theme/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:62;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Change the Menu Color in Astra Theme\";s:3:\"url\";s:69:\"https://wpastra.com/docs/how-to-change-the-menu-color-in-astra-theme/\";s:8:\"category\";a:1:{i:0;s:21:\"colors-background-pro\";}}i:63;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to use the color palette of the Astra theme\";s:3:\"url\";s:73:\"https://wpastra.com/docs/how-to-use-the-color-palette-of-the-astra-theme/\";s:8:\"category\";a:2:{i:0;s:25:\"astra-customizer-settings\";i:1;s:6:\"global\";}}i:64;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to create a correct format svg logo?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-create-a-correct-format-svg-logo/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:65;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to translate the WooCommerce string?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-translate-the-woocommerce-string/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:66;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"SVG Icon\";s:3:\"url\";s:34:\"https://wpastra.com/docs/svg-icon/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:67;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Using Advanced Custom Fields with Astra\";s:3:\"url\";s:65:\"https://wpastra.com/docs/using-advanced-custom-fields-with-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:68;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to add a wishlist button to your WooCommerce Website\";s:3:\"url\";s:82:\"https://wpastra.com/docs/how-to-add-a-wishlist-button-to-your-woocommerce-website/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:3:\"woo\";}}i:69;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"Error 406 while importing Starter Templates on your WordPress website\";s:3:\"url\";s:95:\"https://wpastra.com/docs/error-406-while-importing-starter-templates-on-your-wordpress-website/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:70;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to import Starter Templates with WP CLI Command\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-import-starter-templates-with-wp-cli-command/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:71;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Auto Update Plugin Support\";s:3:\"url\";s:52:\"https://wpastra.com/docs/auto-update-plugin-support/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:72;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"The blank screen in the Customizer area \";s:3:\"url\";s:65:\"https://wpastra.com/docs/the-blank-screen-in-the-customizer-area/\";s:8:\"category\";a:2:{i:0;s:25:\"astra-customizer-settings\";i:1;s:17:\"starter-templates\";}}i:73;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Mixed Content\";s:3:\"url\";s:39:\"https://wpastra.com/docs/mixed-content/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:15:\"troubleshooting\";}}i:74;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to check JavaScript errors/conflicts?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/how-to-check-javascript-errors-conflicts/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:75;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"How Astra is tuned for performance and is the fastest theme?\";s:3:\"url\";s:85:\"https://wpastra.com/docs/how-astra-is-tuned-for-performance-and-is-the-fastest-theme/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:76;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Transparent Header for HFB\";s:3:\"url\";s:52:\"https://wpastra.com/docs/transparent-header-for-hfb/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:77;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How &#8216;Enable Filter Accordion&#8217; Works\";s:3:\"url\";s:59:\"https://wpastra.com/docs/how-enable-filter-accordion-works/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:78;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to improve the CLS score with the Astra theme\";s:3:\"url\";s:75:\"https://wpastra.com/docs/how-to-improve-the-cls-score-with-the-astra-theme/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:79;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"System requirement for Astra Theme\";s:3:\"url\";s:60:\"https://wpastra.com/docs/system-requirement-for-astra-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:80;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"WooCommerce hooks\";s:3:\"url\";s:43:\"https://wpastra.com/docs/woocommerce-hooks/\";s:8:\"category\";a:1:{i:0;s:16:\"woocommerce-free\";}}i:81;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"Set shop page as homepage &#8211; Woocommerce\";s:3:\"url\";s:63:\"https://wpastra.com/docs/set-shop-page-as-homepage-woocommerce/\";s:8:\"category\";a:1:{i:0;s:16:\"woocommerce-free\";}}i:82;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Astra &#8211; Customize the submenu\";s:3:\"url\";s:53:\"https://wpastra.com/docs/astra-customize-the-submenu/\";s:8:\"category\";a:1:{i:0;s:25:\"astra-customizer-settings\";}}i:83;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"Remove default stretched block layout spacing\";s:3:\"url\";s:71:\"https://wpastra.com/docs/remove-default-stretched-block-layout-spacing/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:84;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Improvements on the CheckOut page(Astra 3.9.0)\";s:3:\"url\";s:70:\"https://wpastra.com/docs/improvements-on-the-checkout-pageastra-3-9-0/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:85;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Improvments on the Cart Page(Astra 3.9.0)\";s:3:\"url\";s:54:\"https://wpastra.com/docs/improvments-on-the-cart-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:86;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"Astra WooCommerce update (version 3.9.0) Misc Update\";s:3:\"url\";s:76:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-misc-update/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:87;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Astra WooCommerce update (version 3.9.0) My Account Page\";s:3:\"url\";s:80:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-my-account-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:88;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"Astra WooCommerce update (version 3.9.0) Single Product Page\";s:3:\"url\";s:84:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-single-product-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:89;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Astra WooCommerce update (version 3.9.0) Shop Page\";s:3:\"url\";s:74:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0-shop-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:90;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Astra WooCommerce update (version 3.9.0)\";s:3:\"url\";s:64:\"https://wpastra.com/docs/astra-woocommerce-update-version-3-9-0/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:91;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Improvement: WooCommerce &#8211; Modify the Cart label design\";s:3:\"url\";s:78:\"https://wpastra.com/docs/improvement-woocommerce-modify-the-cart-label-design/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:92;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Improved Block Editor Experience with Astra\";s:3:\"url\";s:58:\"https://wpastra.com/docs/improved-block-editor-experience/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:93;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How to Remove Google Fonts Suggestions in Astra Theme?\";s:3:\"url\";s:72:\"https://wpastra.com/docs/remove-google-fonts-suggestions-in-astra-theme/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:94;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Resolve Repeater Fields Not Working in Widget Block Editor?\";s:3:\"url\";s:86:\"https://wpastra.com/docs/resolving-repeater-fields-not-working-in-widget-block-editor/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:95;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"Enhancement: Applying Content Background to Full-Width Layouts\";s:3:\"url\";s:75:\"https://wpastra.com/docs/applying-content-background-to-full-width-layouts/\";s:8:\"category\";a:1:{i:0;s:21:\"colors-background-pro\";}}i:96;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Move Related Posts Below Comments\";s:3:\"url\";s:59:\"https://wpastra.com/docs/move-related-posts-below-comments/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:97;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Disable Astra Global Colors In Elementor\";s:3:\"url\";s:66:\"https://wpastra.com/docs/disable-astra-global-colors-in-elementor/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:98;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Remove Woocommerce Product Category Archive Title\";s:3:\"url\";s:67:\"https://wpastra.com/docs/remove-woocommerce-category-archive-title/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:99;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Remove Astra Customization for WooCommerce\";s:3:\"url\";s:68:\"https://wpastra.com/docs/remove-astra-customization-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:100;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"How To Change Web Stories Position\";s:3:\"url\";s:53:\"https://wpastra.com/docs/change-web-stories-position/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:101;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Manage Astra Pro With Composer\";s:3:\"url\";s:56:\"https://wpastra.com/docs/manage-astra-pro-with-composer/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:102;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"How to Turn Astra Website Multilingual with TranslatePress?\";s:3:\"url\";s:69:\"https://wpastra.com/docs/turn-astra-multilingual-with-translatepress/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:103;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Starter Templates FAQs\";s:3:\"url\";s:48:\"https://wpastra.com/docs/starter-templates-faqs/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:104;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Building Your Website With Starter Templates\";s:3:\"url\";s:70:\"https://wpastra.com/docs/building-your-website-with-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:105;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Starter Templates Importing\";s:3:\"url\";s:53:\"https://wpastra.com/docs/starter-templates-importing/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:106;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Getting Started With Starter Templates\";s:3:\"url\";s:64:\"https://wpastra.com/docs/getting-started-with-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:107;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Creating Your Header and Footer With Astra or Elementor?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/astra-or-elementor-header-and-footer/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:108;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Gutenberg Editor And Frontend UI Improvements With Astra (3.7.4)\";s:3:\"url\";s:62:\"https://wpastra.com/docs/gutenberg-ui-improvements-with-astra/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:109;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Replace Deprecated Astra Theme and Astra Pro Hooks\";s:3:\"url\";s:48:\"https://wpastra.com/docs/deprecated-astra-hooks/\";s:8:\"category\";a:2:{i:0;s:23:\"astra-theme-pro-filters\";i:1;s:27:\"astra-header-footer-filters\";}}i:110;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Hide the Text by Setting the Font Size to Zero\";s:3:\"url\";s:51:\"https://wpastra.com/docs/setting-font-size-to-zero/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:111;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Translate Categories, Tags, and Astra Strings with Polylang\";s:3:\"url\";s:77:\"https://wpastra.com/docs/translate-categories-tags-and-strings-with-polylang/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:112;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"What To Do When Product Count Is Not Visible on Mini Cart With Astra Pro?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/product-count-color/\";s:8:\"category\";a:2:{i:0;s:3:\"woo\";i:1;s:15:\"troubleshooting\";}}i:113;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to Roll Back to A Previous Version of Astra?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/roll-back-to-previous-astra-version/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:114;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Turn Astra Website Multilingual with Polylang?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/turn-astra-multilingual-with-polylang/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:115;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Starter Templates &#8211; Wireframe Blocks\";s:3:\"url\";s:60:\"https://wpastra.com/docs/starter-templates-wireframe-blocks/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:116;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Enable Debugging in WordPress (Debug Mode)\";s:3:\"url\";s:55:\"https://wpastra.com/docs/enable-debugging-in-wordpress/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:117;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How To Override Astra’s theme.json in Child Theme?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/override-astras-theme-json/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:118;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"How To Hide Quantity Number When the Woocommerce Cart Is Empty?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/hide-quantity-when-cart-is-empty/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:119;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Display the Post Category as a Related Posts Title?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/display-category-as-related-posts-title/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:120;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How To Remove the Astra Header From Entire Site?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/remove-astra-header-from-entire-site/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:121;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"How To Change Navigation Links Text for a Blog Archive?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/replace-blog-archive-navigation-strings/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:122;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Frequently Asked Questions &#8211; VIP Care\";s:3:\"url\";s:39:\"https://wpastra.com/docs/faqs-vip-care/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:123;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"How To Remove Underlined Content Links on Buttons and Specifics Classes?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/remove-underlined-content-links/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:124;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Astra Typography Presets\";s:3:\"url\";s:50:\"https://wpastra.com/docs/astra-typography-presets/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:125;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Astra Global Color Palette\";s:3:\"url\";s:61:\"https://wpastra.com/docs/astra-global-color-palette-settings/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:126;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How To Disable the Block Editor Support for Widgets\";s:3:\"url\";s:61:\"https://wpastra.com/docs/disable-widget-block-editor-support/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:127;O:8:\"stdClass\":3:{s:5:\"title\";s:80:\"How To Enable Design Options for Header and Footer Widgets in Block-Based Editor\";s:3:\"url\";s:60:\"https://wpastra.com/docs/enable-astra-widget-design-options/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:128;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"Restrict Search Results to WooCommerce Products Only\";s:3:\"url\";s:58:\"https://wpastra.com/docs/restrict-search-results-products/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:129;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Fix Swap Sections Not Working on Mobile (Old Astra Header)\";s:3:\"url\";s:55:\"https://wpastra.com/docs/fix-swap-sections-not-working/\";s:8:\"category\";a:1:{i:0;s:20:\"custom-code-snippets\";}}i:130;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Remove Spacing Around Elementor Pro TOC Widget\";s:3:\"url\";s:54:\"https://wpastra.com/docs/remove-spacing-elementor-toc/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:131;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Fix Woocommerce Cart Becoming Transparent With Header Builder\";s:3:\"url\";s:58:\"https://wpastra.com/docs/fix-transparent-woocommerce-cart/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:132;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How To Fix Right Margin for the Footer Widget Element\";s:3:\"url\";s:56:\"https://wpastra.com/docs/fix-footer-widget-right-margin/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:133;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to Add Elementor Template to the Mega Menu?\";s:3:\"url\";s:51:\"https://wpastra.com/docs/add-template-to-mega-menu/\";s:8:\"category\";a:1:{i:0;s:8:\"nav-menu\";}}i:134;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"The Recommended Size for Featured Image Upload\";s:3:\"url\";s:61:\"https://wpastra.com/docs/recommended-size-for-featured-image/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:4:\"blog\";}}i:135;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Why Doesn’t Parallax Scrolling Work on Mobile?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/parallax-not-working-on-mobile/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:136;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"How To Fix Horizontal Scrollbar on Mobile When Using Elementor?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/fix-horizontal-scrollbar-on-mobile/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:137;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How To Apply New Default Button Padding Values?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/apply-default-button-padding/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:138;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Responsive Editing With the Astra Theme\";s:3:\"url\";s:61:\"https://wpastra.com/docs/responsive-editing-with-astra-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:139;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How To Hide Astra Settings for Specific User Roles?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/hide-astra-settings-for-user-roles/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:140;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"How To Create a Header With a Centrally Positioned Logo With Astra?\";s:3:\"url\";s:70:\"https://wpastra.com/docs/create-header-with-centrally-positioned-logo/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:141;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Manage Your Site Identity With Astra&#8217;s Header Builder\";s:3:\"url\";s:55:\"https://wpastra.com/docs/manage-site-identity-and-logo/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:142;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Change the Heading Tag for the Related Posts Title?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/change-tag-for-related-posts-title/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:143;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Host Google Fonts Locally &#8211; Performance Is the Key\";s:3:\"url\";s:48:\"https://wpastra.com/docs/performance-is-the-key/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:144;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How To Improve CLS For the SVG Logo?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/improve-cls-for-svg-logo/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:145;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Fix Font-Weight Not Applying To Widget Titles?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/font-weight-for-widget-titles/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:146;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Self-Host Google Fonts in Astra?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/self-hosted-google-fonts/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:147;O:8:\"stdClass\":3:{s:5:\"title\";s:57:\"Gutenberg Plugin Causing Issues With the Astra Customizer\";s:3:\"url\";s:62:\"https://wpastra.com/docs/astra-customizer-options-unavailable/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:148;O:8:\"stdClass\":3:{s:5:\"title\";s:89:\"Change the &#8220;Shopping Cart&#8221; Text for WooCommerce &#038; EDD Mobile Header Cart\";s:3:\"url\";s:50:\"https://wpastra.com/docs/update-mobile-cart-title/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:149;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"Modify Your PHP Configuration\";s:3:\"url\";s:55:\"https://wpastra.com/docs/modify-your-php-configuration/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:150;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Could not store XML file in /wp-content/ folder?\";s:3:\"url\";s:68:\"https://wpastra.com/docs/could-not-store-files-in-wp-content-folder/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:151;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to Fix 5XX Error While Importing a Starter Template?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/5xx-error-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:152;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"How to Fix Blocked Requests Error While Importing a Starter Template?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/blocked-requests-error-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:153;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"How to Fix Operation Timed Error While Importing a Starter Template?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/operation-timed-error-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:154;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Fix Starter Template Importing Issues\";s:3:\"url\";s:63:\"https://wpastra.com/docs/fix-starter-template-importing-issues/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:155;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How to Remove Border Around the Cart? (Issue After Updating to Astra 3.4)\";s:3:\"url\";s:51:\"https://wpastra.com/docs/remove-border-around-cart/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:156;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Getting the Most Out of Astra Theme\";s:3:\"url\";s:53:\"https://wpastra.com/docs/getting-the-most-with-astra/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:157;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How To Build Quick Sites With Astra?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/build-quick-websites/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:158;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"See Other Customizer Options\";s:3:\"url\";s:50:\"https://wpastra.com/docs/other-customizer-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:159;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Build Your Footer\";s:3:\"url\";s:48:\"https://wpastra.com/docs/footer-builder-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:160;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Add Your Sidebars\";s:3:\"url\";s:45:\"https://wpastra.com/docs/how-to-add-sidebars/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:161;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"Set Up Your Blog\";s:3:\"url\";s:43:\"https://wpastra.com/docs/how-to-setup-blog/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:162;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"Find the Way With Breadcrumbs\";s:3:\"url\";s:43:\"https://wpastra.com/docs/using-breadcrumbs/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:163;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Build Your Header\";s:3:\"url\";s:48:\"https://wpastra.com/docs/header-builder-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:164;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Style Your Website With Global Settings\";s:3:\"url\";s:52:\"https://wpastra.com/docs/style-with-global-settings/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:165;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"This Is Your Customizer\";s:3:\"url\";s:51:\"https://wpastra.com/docs/manage-customizer-options/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:166;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"Astra Theme Walkthrough\";s:3:\"url\";s:49:\"https://wpastra.com/docs/astra-theme-walkthrough/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:167;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Display Related Posts on Single Blog Post\";s:3:\"url\";s:47:\"https://wpastra.com/docs/display-related-posts/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:168;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How do I check my Support Ticket History?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/check-support-ticket-history/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:169;O:8:\"stdClass\":3:{s:5:\"title\";s:69:\"How to Resolve Fatal Error: Call to Undefined function ctype_xdigit()\";s:3:\"url\";s:50:\"https://wpastra.com/docs/fatal-error-ctype-xdigit/\";s:8:\"category\";a:2:{i:0;s:24:\"installation-and-updates\";i:1;s:15:\"troubleshooting\";}}i:170;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Toggle Button for Desktop &#8211; Header Builder Element\";s:3:\"url\";s:51:\"https://wpastra.com/docs/toggle-button-for-desktop/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:171;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Astra’s Default Font Icons Replaced With SVG\";s:3:\"url\";s:47:\"https://wpastra.com/docs/ast-font-icons-to-svg/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:172;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Fix Spacing Issues in Gutenberg Blocks\";s:3:\"url\";s:47:\"https://wpastra.com/docs/fix-spacing-gb-blocks/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:173;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"Optimize Astra HTML and CSS &#8211; For Existing Astra Users (Before v3.3)\";s:3:\"url\";s:54:\"https://wpastra.com/docs/optimize-css-html-before-3-3/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:174;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"FAQs &#8211; Astra Pro 3.2 &#8211; Custom Layout Inside Pages/Posts\";s:3:\"url\";s:44:\"https://wpastra.com/docs/faqs-astra-pro-3-2/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:175;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Inside Page/Post Content Custom Layouts\";s:3:\"url\";s:52:\"https://wpastra.com/docs/custom-layouts-inside-page/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:176;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"How to Remove the White Bars in the Safari Browser on iPhone X and Higher\";s:3:\"url\";s:53:\"https://wpastra.com/docs/remove-white-bars-on-safari/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:177;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Sorry, You Are Not Allowed To Access This Page\";s:3:\"url\";s:52:\"https://wpastra.com/docs/not-allowed-to-access-page/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:178;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Getting Started with Growth Bundle\";s:3:\"url\";s:55:\"https://wpastra.com/docs/getting-started-growth-bundle/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:179;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Getting Started with Essential Bundle\";s:3:\"url\";s:58:\"https://wpastra.com/docs/getting-started-essential-bundle/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:180;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"Can&#8217;t See Newly Added Templates in Starter Templates Library?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/sync-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:181;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"Filter to Remove Starter Templates Button on Post Types\";s:3:\"url\";s:67:\"https://wpastra.com/docs/filter-to-remove-starter-templates-button/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:182;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Using Language Switcher Element with WPML\";s:3:\"url\";s:49:\"https://wpastra.com/docs/using-language-switcher/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:183;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Importing Gutenberg Pages, Patterns, and Wireframes\";s:3:\"url\";s:50:\"https://wpastra.com/docs/import-gb-pages-patterns/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:184;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Revamped Astra&#8217;s Customizer\";s:3:\"url\";s:51:\"https://wpastra.com/docs/revamped-astra-customizer/\";s:8:\"category\";a:2:{i:0;s:23:\"header-footer-after-3-0\";i:1;s:7:\"general\";}}i:185;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Clone and Delete Elements in Header Footer Builder\";s:3:\"url\";s:50:\"https://wpastra.com/docs/clone-delete-hf-elements/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:186;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"How to Clear Astra&#8217;s Cache?\";s:3:\"url\";s:43:\"https://wpastra.com/docs/clear-astra-cache/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:187;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How To Create Mobile Header With Astra Header Builder?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/create-mobile-header-with-header-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:188;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How To Create a Footer With Astra Footer Builder?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/create-footer-with-footer-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:189;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How To Create a Header With Astra Header Builder?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/create-header-with-header-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:190;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Add Multiple Elements in Header Footer Builder\";s:3:\"url\";s:60:\"https://wpastra.com/docs/multiple-elements-in-header-footer/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:191;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"FAQs &#8211; Astra Header/Footer Builder\";s:3:\"url\";s:58:\"https://wpastra.com/docs/faqs-astra-header-footer-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:192;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"Elements in Header/Footer Builder With Astra Theme and Astra Pro\";s:3:\"url\";s:59:\"https://wpastra.com/docs/elements-in-header-footer-builder/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:193;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How to Add Gutenberg Design Compatibility?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/gb-design-compatibility/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:194;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"New Color Controls in Astra theme &#038; Astra Pro Addon\";s:3:\"url\";s:53:\"https://wpastra.com/docs/new-color-controls-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:195;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Astra Pro Shortcodes Reference\";s:3:\"url\";s:56:\"https://wpastra.com/docs/astra-pro-shortcodes-reference/\";s:8:\"category\";a:0:{}}i:196;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"Filter to Add Global Button Settings Support for WooCommerce Buttons\";s:3:\"url\";s:71:\"https://wpastra.com/docs/global-button-support-for-woocommerce-buttons/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:197;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"Blog Featured Image Size Not Working / Error in Image Processing Library\";s:3:\"url\";s:57:\"https://wpastra.com/docs/blog-featured-image-size-issues/\";s:8:\"category\";a:2:{i:0;s:15:\"troubleshooting\";i:1;s:12:\"blog-filters\";}}i:198;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Unable to find &#8220;No Toggle&#8221; Menu Style?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/unable-to-find-no-toggle-menu-style/\";s:8:\"category\";a:1:{i:0;s:13:\"mobile-header\";}}i:199;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"Header Improvements in Astra!\";s:3:\"url\";s:54:\"https://wpastra.com/docs/header-improvements-in-astra/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:200;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Filter to Add Support for Gutenberg Cover and Group blocks\";s:3:\"url\";s:70:\"https://wpastra.com/docs/support-for-gutenberg-cover-and-group-blocks/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:201;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Change Footer Widget Title&#8217;s Heading Tag\";s:3:\"url\";s:64:\"https://wpastra.com/docs/change-footer-widget-title-heading-tag/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:202;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Modify/Change the Quick View text?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/modify-quick-view-text/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:203;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Deprecated Google Fonts Filter\";s:3:\"url\";s:56:\"https://wpastra.com/docs/deprecated-google-fonts-filter/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:204;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Mountain Template With Elementor Theme Style\";s:3:\"url\";s:65:\"https://wpastra.com/docs/mountain-template-elementor-theme-style/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:205;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Plugin Installation Failed &#8211; Multisite\";s:3:\"url\";s:62:\"https://wpastra.com/docs/plugin-installation-failed-multisite/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:206;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Modify Read Time Text on Blog and Single Post Page?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/modify-read-time-text/\";s:8:\"category\";a:0:{}}i:207;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"System Requirements &#8211;  Starter Templates\";s:3:\"url\";s:63:\"https://wpastra.com/docs/system-requirements-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:208;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Custom Layout not Rendering Correctly with Beaver Builder?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/custom-layouts-rendering-issue/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:209;O:8:\"stdClass\":3:{s:5:\"title\";s:83:\"Unable to Upload the Astra Pro ZIP File because it is Unzipped During the Download?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/unable-to-upload-the-astra-pro-zip-file/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:210;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"How to Update Responsive Breakpoints for Tablet+Mobile in Astra?\";s:3:\"url\";s:71:\"https://wpastra.com/docs/set-update-breakpoints-tablet-mobile-in-astra/\";s:8:\"category\";a:2:{i:0;s:23:\"header-footer-after-3-0\";i:1;s:27:\"astra-header-footer-filters\";}}i:211;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Usage Tracking\";s:3:\"url\";s:40:\"https://wpastra.com/docs/usage-tracking/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:212;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to Install Starter Templates (Free) Plugin?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/install-free-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:213;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"How to Update Your Payment Method?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/update-payment-method/\";s:8:\"category\";a:0:{}}i:214;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Setup Custom Adobe Fonts (Typekit) Plugin?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/setup-custom-adobe-fonts-typekit-plugin/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:215;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Can I Import Starter Templates Site on Existing Website?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/import-templates-on-existing-website/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:216;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"Premium Starter Templates &#8211; Install and Activate License\";s:3:\"url\";s:59:\"https://wpastra.com/docs/install-premium-starter-templates/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:217;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Not Valid License &#8211; Starter Templates\";s:3:\"url\";s:43:\"https://wpastra.com/docs/not-valid-license/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:218;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Starter Templates &#8211; Requires plugins missing\";s:3:\"url\";s:52:\"https://wpastra.com/docs/plugin-installation-failed/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:219;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"Filter to Remove Link From Featured Images on Blog Page\";s:3:\"url\";s:65:\"https://wpastra.com/docs/remove-featured-image-link-on-blog-page/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:220;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"Set Parallax Effect on Responsive Devices with Page Header\";s:3:\"url\";s:46:\"https://wpastra.com/docs/parallax-page-header/\";s:8:\"category\";a:1:{i:0;s:12:\"page-headers\";}}i:221;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Starter Templates &#8211; Free Images from Pixabay\";s:3:\"url\";s:58:\"https://wpastra.com/docs/starter-templates-pixabay-images/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:222;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Starter Templates &#8211; Elementor Popup\";s:3:\"url\";s:59:\"https://wpastra.com/docs/starter-templates-elementor-popup/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:223;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Update Required Plugins &#8211; Starter Templates\";s:3:\"url\";s:49:\"https://wpastra.com/docs/update-required-plugins/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:224;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"XMLReader Support Missing &#8211; Starter Templates\";s:3:\"url\";s:43:\"https://wpastra.com/docs/xmlreader-missing/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:225;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Disable Debug Mode &#8211; Starter Templates\";s:3:\"url\";s:44:\"https://wpastra.com/docs/disable-debug-mode/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:226;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Required File Permissions Missing &#8211; Starter Templates\";s:3:\"url\";s:51:\"https://wpastra.com/docs/required-file-permissions/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:227;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"cURL Support Missing &#8211; Starter Templates\";s:3:\"url\";s:46:\"https://wpastra.com/docs/curl-support-missing/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:228;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Starter Templates with Other Themes\";s:3:\"url\";s:61:\"https://wpastra.com/docs/starter-templates-with-other-themes/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:229;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Import A Complete Site With Starter Templates?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/starter-templates-complete-site/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:230;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Starter Templates — Basics and FAQs\";s:3:\"url\";s:55:\"https://wpastra.com/docs/starter-templates-basics-faqs/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:231;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Import Single Page With Starter Templates?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/import-single-template/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:232;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Enable Astra Comment Box on Custom Post Types?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/enable-astra-comment-box-on-cpt/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:233;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"Astra 2.2 for Existing Users\";s:3:\"url\";s:54:\"https://wpastra.com/docs/astra-2-2-for-existing-users/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:234;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"How to Remove Featured Image Link on Archive Page?\";s:3:\"url\";s:68:\"https://wpastra.com/docs/remove-featured-image-link-on-archive-page/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:12:\"blog-filters\";}}i:235;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"Display Settings of Custom Layouts in Astra Pro\";s:3:\"url\";s:48:\"https://wpastra.com/docs/display-rules-in-astra/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:236;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"Get SkillJet Access &#8211; Brainstorm Force Customer\";s:3:\"url\";s:48:\"https://wpastra.com/docs/unlock-skilljet-access/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:237;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"How to Disable Product Quantity (Plus-Minus) Buttons?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/disable-plus-minus-buttons/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:238;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"Change Placeholder for Search Box (Old Astra Header)\";s:3:\"url\";s:51:\"https://wpastra.com/docs/change-search-placeholder/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:239;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Disable Schema Markup Added by Astra?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/disable-schema-markup/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:240;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Change the String &#8220;Search Results For&#8221;\";s:3:\"url\";s:46:\"https://wpastra.com/docs/change-search-string/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:241;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Restrict Search Results to Posts Only\";s:3:\"url\";s:54:\"https://wpastra.com/docs/restrict-search-results-post/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:242;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"How to Remove Page Header Title?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/remove-page-header-title/\";s:8:\"category\";a:1:{i:0;s:12:\"page-headers\";}}i:243;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"Naming Convention for Astra 2.1.0 CSS File(s)\";s:3:\"url\";s:53:\"https://wpastra.com/docs/naming-convention-astra-2-1/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:244;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Get Started with CSS File Generation\";s:3:\"url\";s:52:\"https://wpastra.com/docs/enable-css-file-generation/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:245;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Browser Support by Astra\";s:3:\"url\";s:50:\"https://wpastra.com/docs/browser-support-by-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:246;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Structuring Shop WooCommerce Page\";s:3:\"url\";s:44:\"https://wpastra.com/docs/shop-woocommerce-2/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:247;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Deal with Update Issues in Astra Theme and Astra Pro Addon?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/overcoming-update-issues-in-astra/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:248;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"How to Manage License on Store?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/how-to-manage-license-on-store/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:249;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Update Astra Theme Manually?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/update-theme-manually/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:250;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"How to Change the Heading Tag for the Page/Post Titles?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/change-heading-tag-for-post-title/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:251;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"Astra Compatibility with LearnDash Version 3.0\";s:3:\"url\";s:64:\"https://wpastra.com/docs/astra-compatibility-with-learndash-3-0/\";s:8:\"category\";a:2:{i:0;s:27:\"learndash-astra-pro-modules\";i:1;s:9:\"learndash\";}}i:252;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Modify font-display Property Value\";s:3:\"url\";s:60:\"https://wpastra.com/docs/modify-font-display-property-value/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:253;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"How to Change HTML tag for Site Title and Tagline?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/change-site-title-tagline-html-tag/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:254;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Why font-display property is added to Astra?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/font-display-property-in-astra/\";s:8:\"category\";a:0:{}}i:255;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Disable All Meta Settings of Page/Post by Default\";s:3:\"url\";s:75:\"https://wpastra.com/docs/disable-all-meta-settings-of-page-post-by-default/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:256;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How to Remove Inline CSS from Astra?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/remove-inline-css-from-astra/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:257;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Add RTL CSS via Child Theme?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/rtl-css-via-child-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:258;O:8:\"stdClass\":3:{s:5:\"title\";s:66:\"How to Change Previous and Next Link Text from a Single Blog Post?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/replace-navigation-strings-on-single-post/\";s:8:\"category\";a:1:{i:0;s:12:\"blog-filters\";}}i:259;O:8:\"stdClass\":3:{s:5:\"title\";s:75:\"Add Title attribute to Header Background Image as a Substitute for Alt Text\";s:3:\"url\";s:68:\"https://wpastra.com/docs/title-attribute-in-header-background-image/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:260;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Switch From Existing Breadcrumb to New Trail?\";s:3:\"url\";s:64:\"https://wpastra.com/docs/filter-to-switch-bread-from-old-to-new/\";s:8:\"category\";a:1:{i:0;s:10:\"breadcrumb\";}}i:261;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"How to Display a Breadcrumb Anywhere within a Page or Post with Shortcode?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/display-breadcrumb-with-shortcode/\";s:8:\"category\";a:1:{i:0;s:10:\"breadcrumb\";}}i:262;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How to Add Breadcrumbs in WordPress Website with Astra\";s:3:\"url\";s:52:\"https://wpastra.com/docs/add-breadcrumbs-with-astra/\";s:8:\"category\";a:1:{i:0;s:10:\"breadcrumb\";}}i:263;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Disable Astra’s Native AMP Functionality\";s:3:\"url\";s:51:\"https://wpastra.com/docs/disable-astra-amp-support/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:23:\"astra-theme-pro-filters\";}}i:264;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Astra Options that won&#8217;t work with AMP\";s:3:\"url\";s:63:\"https://wpastra.com/docs/astra-options-that-wont-work-with-amp/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:7:\"general\";}}i:265;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Configure AMP Plugin\";s:3:\"url\";s:46:\"https://wpastra.com/docs/configure-amp-plugin/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:7:\"general\";}}i:266;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"How to Activate the License for Astra Premium Sites Plugin?\";s:3:\"url\";s:73:\"https://wpastra.com/docs/activate-license-for-astra-premium-sites-plugin/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:267;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"White Label Constants to Change Strings Permanently\";s:3:\"url\";s:77:\"https://wpastra.com/docs/white-label-constants-to-change-strings-permanently/\";s:8:\"category\";a:1:{i:0;s:11:\"white-label\";}}i:268;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Manually Install Astra via FTP\";s:3:\"url\";s:56:\"https://wpastra.com/docs/manually-install-astra-via-ftp/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:269;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Change Sidebar Widget Title Heading Tag\";s:3:\"url\";s:65:\"https://wpastra.com/docs/change-sidebar-widget-title-heading-tag/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:270;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"How to Change the Direction for Submenu Opening?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/change-the-direction-for-submenu-opening/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:271;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Display Products from Same Category with Navigation\";s:3:\"url\";s:78:\"https://wpastra.com/docs/products-from-same-directed-category-with-navigation/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:272;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Native AMP Support in Astra\";s:3:\"url\";s:50:\"https://wpastra.com/docs/astra-native-amp-support/\";s:8:\"category\";a:2:{i:0;s:18:\"native-amp-support\";i:1;s:7:\"general\";}}i:273;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Disable the White Label Settings Permanently?\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-disable-the-white-label-settings-permanently/\";s:8:\"category\";a:2:{i:0;s:11:\"white-label\";i:1;s:7:\"general\";}}i:274;O:8:\"stdClass\":3:{s:5:\"title\";s:73:\"Troubleshooting Steps ( with Health Check &#038; Troubleshooting plugin )\";s:3:\"url\";s:47:\"https://wpastra.com/docs/troubleshooting-steps/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:275;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"How to Add Icons to Menu Items?\";s:3:\"url\";s:56:\"https://wpastra.com/docs/how-to-add-icons-to-menu-items/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:276;O:8:\"stdClass\":3:{s:5:\"title\";s:67:\"How Translations can be Manually Exported and Uploaded to the Site?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/manually-upload-translations/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:277;O:8:\"stdClass\":3:{s:5:\"title\";s:77:\"&#8216;The preview could not be loaded&#8217; Pop Up with Astra and Elementor\";s:3:\"url\";s:64:\"https://wpastra.com/docs/the-preview-could-not-be-loaded-pop-up/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:278;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Change Woocommerce Out of Stock Text\";s:3:\"url\";s:62:\"https://wpastra.com/docs/change-woocommerce-out-of-stock-text/\";s:8:\"category\";a:1:{i:0;s:19:\"woocommerce-filters\";}}i:279;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Does White Label Feature Make Changes in the Code?\";s:3:\"url\";s:97:\"https://wpastra.com/docs/does-white-label-feature-in-astra-pro-make-changes-in-the-frontend-code/\";s:8:\"category\";a:1:{i:0;s:11:\"white-label\";}}i:280;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Typography options for EDD\";s:3:\"url\";s:52:\"https://wpastra.com/docs/typography-options-for-edd/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:281;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Colors &#038; Background options for EDD\";s:3:\"url\";s:59:\"https://wpastra.com/docs/colors-background-options-for-edd/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:282;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Checkout Page &#8211; EDD Module Options\";s:3:\"url\";s:58:\"https://wpastra.com/docs/checkout-page-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:283;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"Single Product &#8211; EDD Module Options\";s:3:\"url\";s:59:\"https://wpastra.com/docs/single-product-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:284;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Product Archive &#8211; EDD Module Options\";s:3:\"url\";s:60:\"https://wpastra.com/docs/product-archive-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:285;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"General &#8211; EDD Module Options\";s:3:\"url\";s:52:\"https://wpastra.com/docs/general-edd-module-options/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:286;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"EDD &#8211; Easy Digital Downloads Module Overview\";s:3:\"url\";s:64:\"https://wpastra.com/docs/easy-digital-downloads-module-overview/\";s:8:\"category\";a:1:{i:0;s:29:\"easy-digital-downloads-module\";}}i:287;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"EDD Integration Overview in Free Astra Theme\";s:3:\"url\";s:62:\"https://wpastra.com/docs/edd-integration-overview-astra-theme/\";s:8:\"category\";a:1:{i:0;s:22:\"easy-digital-downloads\";}}i:288;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"How to Display a Mini Cart Anywhere Using Shortcode? (Astra and EDD)\";s:3:\"url\";s:49:\"https://wpastra.com/docs/edd-mini-cart-shortcode/\";s:8:\"category\";a:2:{i:0;s:29:\"easy-digital-downloads-module\";i:1;s:7:\"general\";}}i:289;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"How to Add EDD Cart in Header? (Old Astra Header)\";s:3:\"url\";s:44:\"https://wpastra.com/docs/edd-cart-in-header/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:22:\"easy-digital-downloads\";i:2;s:29:\"easy-digital-downloads-module\";}}i:290;O:8:\"stdClass\":3:{s:5:\"title\";s:72:\"How to Add Download Archive Pages to the Menu When Using Astra with EDD?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/add-download-archive-page-to-menu/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:22:\"easy-digital-downloads\";i:2;s:29:\"easy-digital-downloads-module\";}}i:291;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Disable EDD Inbuilt Styling?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/disable-edd-inbuilt-styling/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:22:\"easy-digital-downloads\";i:2;s:29:\"easy-digital-downloads-module\";}}i:292;O:8:\"stdClass\":3:{s:5:\"title\";s:77:\"How to Apply For Brainstorm Force Affiliate Program? (Become Astra Affiliate)\";s:3:\"url\";s:48:\"https://wpastra.com/docs/become-astra-affiliate/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:293;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"How to Add Custom Fonts in Astra?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/custom-fonts-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:294;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"How to Upgrade to Astra Pro?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/upgrade-to-astra-pro/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:295;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"Typography Improvement for Astra\";s:3:\"url\";s:58:\"https://wpastra.com/docs/typography-improvement-for-astra/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:296;O:8:\"stdClass\":3:{s:5:\"title\";s:46:\"How Does Astra Work with the Gutenberg Editor?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/astra-with-gutenberg-editor/\";s:8:\"category\";a:0:{}}i:297;O:8:\"stdClass\":3:{s:5:\"title\";s:63:\"How to Create Different Headers on Different Pages Using Astra?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/different-headers-on-different-pages/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:298;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Dim Content on Menu Hover\";s:3:\"url\";s:51:\"https://wpastra.com/docs/dim-content-on-menu-hover/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:299;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"Which Zip Should I Install from the Store?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/which-zip-to-install/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:300;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Set Animation To The Sub Menu?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/how-to-set-animation-to-the-sub-menu/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:301;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Display SubMenu Just Below the Header\";s:3:\"url\";s:59:\"https://wpastra.com/docs/display-sub-menu-below-the-header/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:302;O:8:\"stdClass\":3:{s:5:\"title\";s:77:\"How to Duplicate &#8216;Custom Layouts&#8217; and &#8216;Page Headers&#8217;?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/duplicate-custom-layouts-and-page-headers/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:303;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Set up a WordPress Staging Site?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/how-to-set-up-a-staging-site/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:304;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"How to Disable Primary Header?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/how-to-disable-primary-header/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:305;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Nav Menu Module [Create a Mega Menu]\";s:3:\"url\";s:40:\"https://wpastra.com/docs/nav-menu-addon/\";s:8:\"category\";a:1:{i:0;s:8:\"nav-menu\";}}i:306;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How to Switch to Astra from Another Theme?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/how-to-switch-to-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:307;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Google Fonts Not Loading with Astra\";s:3:\"url\";s:61:\"https://wpastra.com/docs/google-fonts-not-loading-with-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:308;O:8:\"stdClass\":3:{s:5:\"title\";s:74:\"Adding Custom Sidebar to the Theme with Lightweight Sidebar Manager plugin\";s:3:\"url\";s:47:\"https://wpastra.com/docs/adding-custom-sidebar/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:309;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"Automatic Beta Updates for Astra\";s:3:\"url\";s:58:\"https://wpastra.com/docs/automatic-beta-updates-for-astra/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:24:\"installation-and-updates\";}}i:310;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Add Font Awesome Icons in Astra?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/add-font-awesome-icons-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:311;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Color for Anchor Tag Inside Heading Tag\";s:3:\"url\";s:55:\"https://wpastra.com/docs/anchor-tag-inside-heading-tag/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:312;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Search Shortcode to Add Search Box in Astra\";s:3:\"url\";s:55:\"https://wpastra.com/docs/search-box-shortcode-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:313;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"LifterLMS Shortcode to Add Profile Link\";s:3:\"url\";s:62:\"https://wpastra.com/docs/lifterlms-shortcode-for-profile-link/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:19:\"lifterlms-astra-pro\";}}i:314;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"LearnDash Shortcode to Add Profile Link\";s:3:\"url\";s:62:\"https://wpastra.com/docs/learndash-shortcode-for-profile-link/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:27:\"learndash-astra-pro-modules\";}}i:315;O:8:\"stdClass\":3:{s:5:\"title\";s:71:\"How to Download Older Version of Astra Theme or Astra Pro Addon plugin?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/download-older-version-of-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:316;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Add Google Tag Manager Code to Astra?\";s:3:\"url\";s:69:\"https://wpastra.com/docs/how-to-add-google-tag-manager-code-to-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:317;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Mobile Header with Above/Below Header (Old Astra Header)\";s:3:\"url\";s:63:\"https://wpastra.com/docs/mobile-header-with-above-below-header/\";s:8:\"category\";a:1:{i:0;s:13:\"mobile-header\";}}i:318;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"How to Stick Footer to Bottom when Page Content is Less?\";s:3:\"url\";s:81:\"https://wpastra.com/docs/how-to-stick-footer-to-bottom-when-page-content-is-less/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:21:\"footer-widgets-module\";}}i:319;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Quick View for WooCommerce Products\";s:3:\"url\";s:61:\"https://wpastra.com/docs/quick-view-for-woocommerce-products/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:320;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Off-Canvas Sidebar for WooCommerce Shop Page\";s:3:\"url\";s:70:\"https://wpastra.com/docs/off-canvas-sidebar-for-woocommerce-shop-page/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:321;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"How to Add WooCommerce Mini Cart in Header? (Old Astra Header)\";s:3:\"url\";s:61:\"https://wpastra.com/docs/add-woocommerce-mini-cart-to-header/\";s:8:\"category\";a:3:{i:0;s:7:\"general\";i:1;s:16:\"woocommerce-free\";i:2;s:3:\"woo\";}}i:322;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Translate Astra Strings with WPML?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/translate-astra-string-wpml/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:323;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Know More about Astra Beta Versions? How to Download and Use?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/about-beta-versions/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:24:\"installation-and-updates\";}}i:324;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to Add Social Media Icons to Header?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/how-to-add-social-media-icons-to-header/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:325;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How to Translate Custom Layouts with WPML?\";s:3:\"url\";s:67:\"https://wpastra.com/docs/how-to-translate-custom-layouts-with-wpml/\";s:8:\"category\";a:2:{i:0;s:15:\"translate-astra\";i:1;s:21:\"custom-layouts-module\";}}i:326;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Why Is My Logo Blurry?\";s:3:\"url\";s:47:\"https://wpastra.com/docs/why-is-my-logo-blurry/\";s:8:\"category\";a:1:{i:0;s:23:\"header-footer-after-3-0\";}}i:327;O:8:\"stdClass\":3:{s:5:\"title\";s:58:\"How to Disable Title on Posts, Pages, or Other Post Types?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/disable-title-on-post-type/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:328;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Disable Featured Image on Posts, Pages, or Other Post Types\";s:3:\"url\";s:61:\"https://wpastra.com/docs/disable-featured-image-on-post-type/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:329;O:8:\"stdClass\":3:{s:5:\"title\";s:81:\"How to Display &#8220;Last Updated&#8221; instead of &#8220;Published&#8221; Date\";s:3:\"url\";s:62:\"https://wpastra.com/docs/show-last-updated-not-published-date/\";s:8:\"category\";a:3:{i:0;s:8:\"blog-pro\";i:1;s:12:\"blog-filters\";i:2;s:4:\"blog\";}}i:330;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How To Reset WordPress Installation?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/how-to-reset-wordpress-installation/\";s:8:\"category\";a:1:{i:0;s:17:\"starter-templates\";}}i:331;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Mobile Header with Astra (Old Astra Header)\";s:3:\"url\";s:50:\"https://wpastra.com/docs/mobile-header-with-astra/\";s:8:\"category\";a:1:{i:0;s:13:\"mobile-header\";}}i:332;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"Disable featured image on all pages\";s:3:\"url\";s:61:\"https://wpastra.com/docs/disable-featured-image-on-all-pages/\";s:8:\"category\";a:0:{}}i:333;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"Elementor Error: The Content Area Was Not Found in Your Page\";s:3:\"url\";s:79:\"https://wpastra.com/docs/elementor-the-content-area-was-not-found-in-your-page/\";s:8:\"category\";a:0:{}}i:334;O:8:\"stdClass\":3:{s:5:\"title\";s:68:\"Sidebar / Container Options in Customizer for Learndash Not Working?\";s:3:\"url\";s:91:\"https://wpastra.com/docs/sidebar-container-options-in-customizer-for-learndash-not-working/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:335;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"About Icons Font That Comes with Astra\";s:3:\"url\";s:57:\"https://wpastra.com/docs/default-font-icon-list-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:336;O:8:\"stdClass\":3:{s:5:\"title\";s:56:\"Default Structured Data and Schema Markup in Astra Theme\";s:3:\"url\";s:68:\"https://wpastra.com/docs/structured-data-and-schema-markup-in-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:337;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Below Header Section\";s:3:\"url\";s:46:\"https://wpastra.com/docs/below-header-section/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:338;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Above Header Section\";s:3:\"url\";s:46:\"https://wpastra.com/docs/above-header-section/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:339;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to Install Astra Theme?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/how-to-install-astra-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:340;O:8:\"stdClass\":3:{s:5:\"title\";s:50:\"Not Receiving Update Notification for Astra Theme?\";s:3:\"url\";s:75:\"https://wpastra.com/docs/not-receiving-update-notification-for-astra-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:341;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"Do Not See License Activation Form for Astra Pro Addon Plugin?\";s:3:\"url\";s:60:\"https://wpastra.com/docs/do-not-see-license-activation-form/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:342;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"How to Refresh / Flush WordPress Permalinks?\";s:3:\"url\";s:61:\"https://wpastra.com/docs/how-to-refresh-wordpress-permalinks/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:343;O:8:\"stdClass\":3:{s:5:\"title\";s:71:\"How to Merge Above/Below Header Menu with a Primary Menu in Responsive?\";s:3:\"url\";s:96:\"https://wpastra.com/docs/how-to-merge-above-below-header-menu-with-a-primary-menu-in-responsive/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:344;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"How to add Google Analytics Code with the Astra Theme?\";s:3:\"url\";s:75:\"https://wpastra.com/docs/how-to-add-google-analytics-code-with-astra-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:345;O:8:\"stdClass\":3:{s:5:\"title\";s:104:\"Getting error &#8211; The package could not be installed. The theme is missing the style.css stylesheet?\";s:3:\"url\";s:120:\"https://wpastra.com/docs/getting-error-the-package-could-not-be-installed-the-theme-is-missing-the-style-css-stylesheet/\";s:8:\"category\";a:2:{i:0;s:24:\"installation-and-updates\";i:1;s:15:\"troubleshooting\";}}i:346;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"Typography Options for WooCommerce\";s:3:\"url\";s:60:\"https://wpastra.com/docs/typography-options-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:347;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Getting Started with Astra Pro Addon Plugin!\";s:3:\"url\";s:56:\"https://wpastra.com/docs/getting-started-with-astra-pro/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:348;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Colors &#038; Background options for WooCommerce\";s:3:\"url\";s:67:\"https://wpastra.com/docs/colors-background-options-for-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:349;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to Activate License Key on WordPress Multisite?\";s:3:\"url\";s:76:\"https://wpastra.com/docs/how-to-activate-license-key-on-wordpress-multisite/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:350;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Edit style.css in Child Theme?\";s:3:\"url\";s:62:\"https://wpastra.com/docs/how-to-edit-style-css-in-child-theme/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:351;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to Display WooCommerce Sidebar on Top for Mobile Devices?\";s:3:\"url\";s:77:\"https://wpastra.com/docs/how-to-display-woocommerce-sidebar-on-top-on-mobile/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:352;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Set Background Image for the Site?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/how-to-set-background-image-for-the-site/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:353;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"How to add Google Analytics code with Custom Layouts Module?\";s:3:\"url\";s:85:\"https://wpastra.com/docs/how-to-add-google-analytics-code-with-custom-layouts-module/\";s:8:\"category\";a:0:{}}i:354;O:8:\"stdClass\":3:{s:5:\"title\";s:124:\"Fix for- cURL error 51: SSL: no alternative certificate subject name matches target host name &#8216;websitedemos.net&#8217;\";s:3:\"url\";s:133:\"https://wpastra.com/docs/fix-for-curl-error-51-ssl-no-alternative-certificate-subject-name-matches-target-host-name-websitedemos-net/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:355;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"How to Remove Previous and Next Link from a Single Blog Post?\";s:3:\"url\";s:84:\"https://wpastra.com/docs/how-to-remove-previous-and-next-link-from-single-blog-post/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:356;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Custom 404 Page\";s:3:\"url\";s:41:\"https://wpastra.com/docs/custom-404-page/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:357;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"Custom Layout &#8211; Hooks\";s:3:\"url\";s:45:\"https://wpastra.com/docs/custom-layout-hooks/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:358;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Custom Footer\";s:3:\"url\";s:39:\"https://wpastra.com/docs/custom-footer/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:359;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Custom Header\";s:3:\"url\";s:39:\"https://wpastra.com/docs/custom-header/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:360;O:8:\"stdClass\":3:{s:5:\"title\";s:61:\"Cannot edit Custom Layouts / Custom Layouts having 404 error?\";s:3:\"url\";s:84:\"https://wpastra.com/docs/cannot-edit-custom-layouts-custom-layouts-having-404-error/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:361;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"Astra Options Page &#8211; All Settings Explained\";s:3:\"url\";s:54:\"https://wpastra.com/docs/new-welcome-screen-for-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:362;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"How to White Label Astra?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/how-to-white-label-astra/\";s:8:\"category\";a:1:{i:0;s:11:\"white-label\";}}i:363;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"How to Install Astra Pro Plugin?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-install-astra-pro-addon-plugin/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:364;O:8:\"stdClass\":3:{s:5:\"title\";s:44:\"Backup Your Website in Less than 10 Minutes!\";s:3:\"url\";s:69:\"https://wpastra.com/docs/backup-your-website-in-less-than-10-minutes/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:365;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"How to use RGBA color picker?\";s:3:\"url\";s:54:\"https://wpastra.com/docs/how-to-use-rgba-color-picker/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:366;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"How to fix Fatal Error / White Screen of Death?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/fixing-fatal-error-white-screen-of-death/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:367;O:8:\"stdClass\":3:{s:5:\"title\";s:65:\"Fix for &#8211;  Parse error: syntax error, unexpected T_FUNCTION\";s:3:\"url\";s:79:\"https://wpastra.com/docs/fixing-parse-error-syntax-error-unexpected-t-function/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:368;O:8:\"stdClass\":3:{s:5:\"title\";s:75:\"How to Disable the Loading of Astra&#8217;s Default Font File? (Astra.woff)\";s:3:\"url\";s:77:\"https://wpastra.com/docs/disable-loading-astras-default-font-file-astra-woff/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:369;O:8:\"stdClass\":3:{s:5:\"title\";s:48:\"Overview of LearnDash Integration in Astra Theme\";s:3:\"url\";s:56:\"https://wpastra.com/docs/learndash-integration-overview/\";s:8:\"category\";a:1:{i:0;s:9:\"learndash\";}}i:370;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"LearnDash Integration in Astra Pro\";s:3:\"url\";s:60:\"https://wpastra.com/docs/learndash-integration-in-astra-pro/\";s:8:\"category\";a:1:{i:0;s:27:\"learndash-astra-pro-modules\";}}i:371;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Checkout Page WooCommerce\";s:3:\"url\";s:51:\"https://wpastra.com/docs/checkout-page-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:372;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Single Product WooCommerce\";s:3:\"url\";s:52:\"https://wpastra.com/docs/single-product-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:373;O:8:\"stdClass\":3:{s:5:\"title\";s:84:\"How to Design a Product Catalog Page or Shop Page Using WooCommerce Module in Astra?\";s:3:\"url\";s:42:\"https://wpastra.com/docs/shop-woocommerce/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:374;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"WooCommerce Module Overview\";s:3:\"url\";s:53:\"https://wpastra.com/docs/woocommerce-module-overview/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:375;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"General WooCommerce\";s:3:\"url\";s:45:\"https://wpastra.com/docs/general-woocommerce/\";s:8:\"category\";a:0:{}}i:376;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Typography Module\";s:3:\"url\";s:43:\"https://wpastra.com/docs/typography-module/\";s:8:\"category\";a:1:{i:0;s:14:\"typography-pro\";}}i:377;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Global Typography &#8211; Astra Theme\";s:3:\"url\";s:41:\"https://wpastra.com/docs/typography-free/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:378;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"Colors &#038; Background Module\";s:3:\"url\";s:50:\"https://wpastra.com/docs/colors-background-module/\";s:8:\"category\";a:1:{i:0;s:21:\"colors-background-pro\";}}i:379;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Global Colors &#8211; Astra Theme\";s:3:\"url\";s:43:\"https://wpastra.com/docs/colors-background/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:380;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"Astra WooCommerce Mini Cart Shortcode\";s:3:\"url\";s:55:\"https://wpastra.com/docs/shortcode-for-astra-mini-cart/\";s:8:\"category\";a:1:{i:0;s:3:\"woo\";}}i:381;O:8:\"stdClass\":3:{s:5:\"title\";s:34:\"LifterLMS Integration in Astra Pro\";s:3:\"url\";s:46:\"https://wpastra.com/docs/lifterlms-module-pro/\";s:8:\"category\";a:1:{i:0;s:19:\"lifterlms-astra-pro\";}}i:382;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"LifterLMS Overview\";s:3:\"url\";s:44:\"https://wpastra.com/docs/lifterlms-overview/\";s:8:\"category\";a:1:{i:0;s:9:\"lifterlms\";}}i:383;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"LifterLMS Integration in Free Astra Theme\";s:3:\"url\";s:40:\"https://wpastra.com/docs/lifterlms-free/\";s:8:\"category\";a:1:{i:0;s:9:\"lifterlms\";}}i:384;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Manage Sidebars in Free Astra Theme?\";s:3:\"url\";s:38:\"https://wpastra.com/docs/sidebar-free/\";s:8:\"category\";a:1:{i:0;s:7:\"sidebar\";}}i:385;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Single post with Blog Pro\";s:3:\"url\";s:46:\"https://wpastra.com/docs/single-post-blog-pro/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:386;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"Blog / Archive with Blog Pro\";s:3:\"url\";s:47:\"https://wpastra.com/docs/blog-archive-blog-pro/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:387;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Blog Pro Overview\";s:3:\"url\";s:43:\"https://wpastra.com/docs/blog-pro-overview/\";s:8:\"category\";a:1:{i:0;s:8:\"blog-pro\";}}i:388;O:8:\"stdClass\":3:{s:5:\"title\";s:11:\"Single Post\";s:3:\"url\";s:37:\"https://wpastra.com/docs/single-post/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:389;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Blog / Archive\";s:3:\"url\";s:38:\"https://wpastra.com/docs/blog-archive/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:390;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Blog Overview\";s:3:\"url\";s:39:\"https://wpastra.com/docs/blog-overview/\";s:8:\"category\";a:1:{i:0;s:4:\"blog\";}}i:391;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"Scroll To Top\";s:3:\"url\";s:43:\"https://wpastra.com/docs/scroll-to-top-pro/\";s:8:\"category\";a:1:{i:0;s:28:\"astra-theme-walkthrough-docs\";}}i:392;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"Custom Layouts Overview\";s:3:\"url\";s:44:\"https://wpastra.com/docs/custom-layouts-pro/\";s:8:\"category\";a:1:{i:0;s:21:\"custom-layouts-module\";}}i:393;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Footer Widgets Module with Astra Pro\";s:3:\"url\";s:50:\"https://wpastra.com/docs/footer-widgets-astra-pro/\";s:8:\"category\";a:1:{i:0;s:21:\"footer-widgets-module\";}}i:394;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"Footer Bar\";s:3:\"url\";s:36:\"https://wpastra.com/docs/footer-bar/\";s:8:\"category\";a:1:{i:0;s:24:\"header-footer-before-3-0\";}}i:395;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"Astra Meta Settings\";s:3:\"url\";s:44:\"https://wpastra.com/docs/page-meta-settings/\";s:8:\"category\";a:1:{i:0;s:13:\"meta-settings\";}}i:396;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to Manage Spacing in Headers Using Astra?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/header-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:397;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"Sidebar Spacing Controls\";s:3:\"url\";s:50:\"https://wpastra.com/docs/sidebar-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:398;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to Manage Spacing on the Blog Page Using Astra?\";s:3:\"url\";s:55:\"https://wpastra.com/docs/blog-archive-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:399;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"Footer Spacing Controls\";s:3:\"url\";s:49:\"https://wpastra.com/docs/footer-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:400;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"Page Headers Overview\";s:3:\"url\";s:47:\"https://wpastra.com/docs/page-headers-overview/\";s:8:\"category\";a:1:{i:0;s:12:\"page-headers\";}}i:401;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Header Sections Overview (Old Astra Header)\";s:3:\"url\";s:45:\"https://wpastra.com/docs/header-sections-pro/\";s:8:\"category\";a:1:{i:0;s:15:\"header-sections\";}}i:402;O:8:\"stdClass\":3:{s:5:\"title\";s:62:\"How to Set the Full-width/Stretched Container Layout in Astra?\";s:3:\"url\";s:63:\"https://wpastra.com/docs/full-width-stretched-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:403;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"Full Width / Contained – Container Layout\";s:3:\"url\";s:63:\"https://wpastra.com/docs/full-width-contained-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:404;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"Content Boxed &#8211; Container Layout\";s:3:\"url\";s:56:\"https://wpastra.com/docs/content-boxed-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:405;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Boxed – Container Layout\";s:3:\"url\";s:48:\"https://wpastra.com/docs/boxed-container-layout/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:406;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"Container Spacing Controls\";s:3:\"url\";s:52:\"https://wpastra.com/docs/container-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:407;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"Site Identity Spacing Controls\";s:3:\"url\";s:56:\"https://wpastra.com/docs/site-identity-spacing-controls/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:408;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Spacing Addon Overview\";s:3:\"url\";s:48:\"https://wpastra.com/docs/spacing-addon-overview/\";s:8:\"category\";a:1:{i:0;s:7:\"spacing\";}}i:409;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"Global Container &#8211; Astra Theme\";s:3:\"url\";s:44:\"https://wpastra.com/docs/container-overview/\";s:8:\"category\";a:1:{i:0;s:6:\"global\";}}i:410;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"How to Add a Sticky Header or On-Scroll Fixed Header with Astra?\";s:3:\"url\";s:43:\"https://wpastra.com/docs/sticky-header-pro/\";s:8:\"category\";a:1:{i:0;s:13:\"sticky-header\";}}i:411;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"Padded Site Layout\";s:3:\"url\";s:44:\"https://wpastra.com/docs/padded-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:412;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Fluid Site Layout\";s:3:\"url\";s:43:\"https://wpastra.com/docs/fluid-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:413;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"Max Width Site Layout\";s:3:\"url\";s:47:\"https://wpastra.com/docs/max-width-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:414;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"Full Width Site Layout\";s:3:\"url\";s:48:\"https://wpastra.com/docs/full-width-site-layout/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:415;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Site Layout Overview\";s:3:\"url\";s:46:\"https://wpastra.com/docs/site-layout-overview/\";s:8:\"category\";a:1:{i:0;s:11:\"site-layout\";}}i:416;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Change the Astra Header Breakpoint Width\";s:3:\"url\";s:62:\"https://wpastra.com/docs/change-astra-header-breakpoint-width/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:417;O:8:\"stdClass\":3:{s:5:\"title\";s:43:\"How to Add Custom Javascript Code in Astra?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/add-custom-javascript-code-astra/\";s:8:\"category\";a:0:{}}i:418;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"What is a Favicon or Site Icon?\";s:3:\"url\";s:43:\"https://wpastra.com/docs/favicon-site-icon/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:419;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"Complete List of WordPress Locale Codes\";s:3:\"url\";s:62:\"https://wpastra.com/docs/complete-list-wordpress-locale-codes/\";s:8:\"category\";a:0:{}}i:420;O:8:\"stdClass\":3:{s:5:\"title\";s:53:\"Fix for &#8211; The PCLZIP_ERR_BAD_FORMAT (-10) Error\";s:3:\"url\";s:60:\"https://wpastra.com/docs/fix-pclzip-err-bad-format-10-error/\";s:8:\"category\";a:1:{i:0;s:15:\"troubleshooting\";}}i:421;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to Add Custom PHP Code?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/add-custom-php-code/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:422;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"WooCommerce Integration Overview in Free Astra Theme\";s:3:\"url\";s:58:\"https://wpastra.com/docs/woocommerce-integration-overview/\";s:8:\"category\";a:1:{i:0;s:16:\"woocommerce-free\";}}i:423;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"How to Replicate the Astra Screenshot?\";s:3:\"url\";s:52:\"https://wpastra.com/docs/replicating-the-screenshot/\";s:8:\"category\";a:0:{}}i:424;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"How to Turn Astra Multilingual with WPML?\";s:3:\"url\";s:59:\"https://wpastra.com/docs/turn-astra-multilingual-with-wpml/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:425;O:8:\"stdClass\":3:{s:5:\"title\";s:81:\"How to Build Advanced Websites Based on Custom Post Types with Toolset and Astra?\";s:3:\"url\";s:57:\"https://wpastra.com/docs/custom-post-types-toolset-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:426;O:8:\"stdClass\":3:{s:5:\"title\";s:36:\"How to Get License Key of Astra Pro?\";s:3:\"url\";s:42:\"https://wpastra.com/docs/get-license-keys/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:427;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to Activate Astra Pro Addon License?\";s:3:\"url\";s:58:\"https://wpastra.com/docs/activate-astra-pro-addon-license/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:428;O:8:\"stdClass\":3:{s:5:\"title\";s:35:\"How to Design Bullets &#038; Lists?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/design-bullets-lists/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:429;O:8:\"stdClass\":3:{s:5:\"title\";s:45:\"How to Disable Comments on WordPress website?\";s:3:\"url\";s:49:\"https://wpastra.com/docs/how-to-disable-comments/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:430;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"How to Highlight a Certain Menu Item?\";s:3:\"url\";s:53:\"https://wpastra.com/docs/highlight-certain-menu-item/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}i:431;O:8:\"stdClass\":3:{s:5:\"title\";s:76:\"How to Bulk Edit Astra Meta Settings on Multiple Pages &#038; Posts at Once?\";s:3:\"url\";s:76:\"https://wpastra.com/docs/bulk-edit-astra-meta-settings-multiple-pages-posts/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:432;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Font Selection\";s:3:\"url\";s:40:\"https://wpastra.com/docs/font-selection/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:433;O:8:\"stdClass\":3:{s:5:\"title\";s:28:\"How to Renew Yearly License?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/renew-yearly-license/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:434;O:8:\"stdClass\":3:{s:5:\"title\";s:52:\"How to Increase PHP Time Limit for a WordPress Site?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/increase-php-time-limit-wordpress-sites/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:435;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Astra Pro WP CLI Commands\";s:3:\"url\";s:41:\"https://wpastra.com/docs/wp-cli-commands/\";s:8:\"category\";a:2:{i:0;s:7:\"general\";i:1;s:23:\"astra-theme-pro-filters\";}}i:436;O:8:\"stdClass\":3:{s:5:\"title\";s:29:\"How Do License Upgrades Work?\";s:3:\"url\";s:51:\"https://wpastra.com/docs/how-license-upgrades-work/\";s:8:\"category\";a:1:{i:0;s:17:\"account-and-store\";}}i:437;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Recommended Settings for Beaver Builder and the Astra Theme\";s:3:\"url\";s:67:\"https://wpastra.com/docs/recommended-settings-beaver-builder-astra/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:438;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"Recommended Settings for Elementor and the Astra Theme\";s:3:\"url\";s:60:\"https://wpastra.com/docs/recommended-settings-for-elementor/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:439;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"How to Force Check Updates?\";s:3:\"url\";s:45:\"https://wpastra.com/docs/force-check-updates/\";s:8:\"category\";a:0:{}}i:440;O:8:\"stdClass\":3:{s:5:\"title\";s:60:\"How to Disable or Change the Position of the Featured Image?\";s:3:\"url\";s:64:\"https://wpastra.com/docs/disable-change-position-featured-image/\";s:8:\"category\";a:0:{}}i:441;O:8:\"stdClass\":3:{s:5:\"title\";s:42:\"How do I manage margin between paragraphs?\";s:3:\"url\";s:50:\"https://wpastra.com/docs/manage-margin-paragraphs/\";s:8:\"category\";a:0:{}}i:442;O:8:\"stdClass\":3:{s:5:\"title\";s:57:\"How to Update the Plugin Manually from WordPress Backend?\";s:3:\"url\";s:66:\"https://wpastra.com/docs/update-plugin-manually-wordpress-backend/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:443;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"How to Adjust the Width of Your Sidebar?\";s:3:\"url\";s:46:\"https://wpastra.com/docs/adjust-width-sidebar/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:444;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"Where Does Astra Primary Color Setting Take Effect?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/astra-primary-color-setting-take-effect/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:445;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"How to Disable Header or Footer for a Landing Page or Post?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/disable-header-footer-landing-page-post/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:446;O:8:\"stdClass\":3:{s:5:\"title\";s:54:\"What Is a Child Theme and How To Install It for Astra?\";s:3:\"url\";s:51:\"https://wpastra.com/docs/install-astra-child-theme/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:447;O:8:\"stdClass\":3:{s:5:\"title\";s:47:\"Increasing the PHP Memory Limit of Your Website\";s:3:\"url\";s:61:\"https://wpastra.com/docs/increasing-php-memory-limit-website/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:448;O:8:\"stdClass\":3:{s:5:\"title\";s:76:\"How to Translate Astra Theme / Plugins in Your Own Language using GlotPress?\";s:3:\"url\";s:42:\"https://wpastra.com/docs/how-to-translate/\";s:8:\"category\";a:1:{i:0;s:15:\"translate-astra\";}}i:449;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Does Astra support Beaver Themer Plugin?\";s:3:\"url\";s:65:\"https://wpastra.com/docs/does-astra-support-beaver-themer-plugin/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:450;O:8:\"stdClass\":3:{s:5:\"title\";s:40:\"Remove Primary Navigation Menu with Hook\";s:3:\"url\";s:63:\"https://wpastra.com/docs/how-to-remove-primary-navigation-menu/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:451;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"Footer Custom Text Helper Strings\";s:3:\"url\";s:59:\"https://wpastra.com/docs/footer-custom-text-helper-strings/\";s:8:\"category\";a:1:{i:0;s:7:\"general\";}}i:452;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"What is Astra Pro Add on?\";s:3:\"url\";s:41:\"https://wpastra.com/docs/astra-pro-addon/\";s:8:\"category\";a:1:{i:0;s:24:\"installation-and-updates\";}}i:453;O:8:\"stdClass\":3:{s:5:\"title\";s:51:\"How to Change the Destination URL for Website Logo?\";s:3:\"url\";s:40:\"https://wpastra.com/docs/astra-logo-url/\";s:8:\"category\";a:1:{i:0;s:27:\"astra-header-footer-filters\";}}i:454;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Using Hooks in Astra\";s:3:\"url\";s:37:\"https://wpastra.com/docs/using-hooks/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:455;O:8:\"stdClass\":3:{s:5:\"title\";s:59:\"Standard server 404 page showing instead of custom 404 page\";s:3:\"url\";s:85:\"https://wpastra.com/docs/standard-server-404-page-showing-instead-of-custom-404-page/\";s:8:\"category\";a:0:{}}i:456;O:8:\"stdClass\":3:{s:5:\"title\";s:39:\"How to Change the Default Astra Strings\";s:3:\"url\";s:47:\"https://wpastra.com/docs/astra-default-strings/\";s:8:\"category\";a:1:{i:0;s:23:\"astra-theme-pro-filters\";}}i:457;O:8:\"stdClass\":3:{s:5:\"title\";s:55:\"How to Add Custom CSS Code Without Editing Theme Files?\";s:3:\"url\";s:48:\"https://wpastra.com/docs/adding-custom-css-code/\";s:8:\"category\";a:1:{i:0;s:10:\"custom-css\";}}}}","yes");
INSERT INTO wp_options VALUES("822","astra-settings","a:2:{s:18:\"theme-auto-version\";s:5:\"4.3.1\";s:22:\"is_theme_queue_running\";b:0;}","yes");
INSERT INTO wp_options VALUES("1373","_site_transient_fusion_wordpress_org_plugins","a:7:{s:3:\"pwa\";a:26:{s:4:\"name\";s:3:\"PWA\";s:4:\"slug\";s:3:\"pwa\";s:7:\"version\";s:5:\"0.7.1\";s:6:\"author\";s:100:\"<a href=\"https://github.com/GoogleChromeLabs/pwa-wp/graphs/contributors\">PWA Plugin Contributors</a>\";s:14:\"author_profile\";s:43:\"https://profiles.wordpress.org/westonruter/\";s:12:\"contributors\";a:5:{s:6:\"google\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/google/\";s:6:\"avatar\";s:82:\"http://2.gravatar.com/avatar/2adafb3bf578fd97d8d2ea1c2ccb3db3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Google\";}s:3:\"xwp\";a:3:{s:7:\"profile\";s:35:\"https://profiles.wordpress.org/xwp/\";s:6:\"avatar\";s:82:\"http://0.gravatar.com/avatar/98d36ee8047719c185f19a00f7184c2c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"XWP\";}s:6:\"rtcamp\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/rtcamp/\";s:6:\"avatar\";s:82:\"http://0.gravatar.com/avatar/c425b1be9dbbb2b45fb026ca564b81da?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"rtCamp\";}s:11:\"westonruter\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/westonruter/\";s:6:\"avatar\";s:82:\"http://2.gravatar.com/avatar/22ed378fbf1d918ef43a45b2a1f34634?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Weston Ruter\";}s:13:\"albertomedina\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/albertomedina/\";s:6:\"avatar\";s:82:\"http://0.gravatar.com/avatar/c61e7d8efedcd6e9bf7a0c6025f80489?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Alberto Medina\";}}s:8:\"requires\";s:3:\"5.5\";s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:3:\"5.6\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:80;s:7:\"ratings\";a:5:{i:5;i:16;i:4;i:0;i:3;i:0;i:2;i:0;i:1;i:5;}s:11:\"num_ratings\";i:21;s:15:\"support_threads\";i:1;s:24:\"support_threads_resolved\";i:1;s:15:\"active_installs\";i:30000;s:12:\"last_updated\";s:21:\"2023-08-07 9:40pm GMT\";s:5:\"added\";s:10:\"2018-07-12\";s:8:\"homepage\";s:42:\"https://github.com/GoogleChromeLabs/pwa-wp\";s:8:\"sections\";a:4:{s:11:\"description\";s:4482:\"<blockquote cite=\"https://developers.google.com/web/progressive-web-apps/\"><p>\nProgressive Web Apps are user experiences that have the reach of the web, and are:</p>\n<ul>\n<li><a href=\"https://developers.google.com/web/progressive-web-apps/#reliable\" rel=\"nofollow ugc\">Reliable</a> &#8211; Load instantly and never show the downasaur, even in uncertain network conditions.</li>\n<li><a href=\"https://developers.google.com/web/progressive-web-apps/#fast\" rel=\"nofollow ugc\">Fast</a> &#8211; Respond quickly to user interactions with silky smooth animations and no janky scrolling.</li>\n<li><a href=\"https://developers.google.com/web/progressive-web-apps/#engaging\" rel=\"nofollow ugc\">Engaging</a> &#8211; Feel like a natural app on the device, with an immersive user experience.</li>\n</ul>\n<p>This new level of quality allows Progressive Web Apps to earn a place on the user&#8217;s home screen.\n</p></blockquote>\n<p>Continue reading more about <a href=\"https://web.dev/progressive-web-apps/\" rel=\"nofollow ugc\">Progressive Web Apps</a> (PWA) from Google.</p>\n<p>In general a PWA depends on the following technologies to be available:</p>\n<ul>\n<li><a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API\" rel=\"nofollow ugc\">Service Workers</a></li>\n<li><a href=\"https://developer.mozilla.org/en-US/docs/Web/Manifest\" rel=\"nofollow ugc\">Web App Manifest</a></li>\n<li><a href=\"https://en.wikipedia.org/wiki/HTTPS\" rel=\"nofollow ugc\">HTTPS</a></li>\n</ul>\n<p>This plugin serves as a place to implement support for these in WordPress with the intention of being proposed for core merge, piece by piece. Case in point, the HTTPS functionality from this plugin has largely been made part of Core: <a href=\"https://make.wordpress.org/core/2021/02/22/improved-https-detection-and-migration-in-wordpress-5-7/\" rel=\"nofollow ugc\">Improved HTTPS detection and migration in WordPress 5.7</a>.</p>\n<p>This feature plugin is <em>not</em> intended to obsolete the other plugins and themes which turn WordPress sites into PWAs. Rather, this plugin is intended to provide the PWA building blocks and coordination mechanism for these themes and plugins to not reinvent the wheel and also to not conflict with each other. For example, a theme that implements the app shell model should be able to extend the core service worker while a plugin that provides push notifications should be able to do the same. Themes and plugins no longer should have to each create a service worker on their own, something which is inherently problematic because only one service worker can be active at a time: only one service worker can win. If you are developing a plugin or theme that includes a service worker, consider relying on this PWA plugin, or at least only use the built-in implementation as a fallback for when the PWA plugin is not available.</p>\n<p>In versions prior to 0.6, no caching strategies were added by default. The only service worker behavior was to serve an offline template when the client&#8217;s connection is down or the site is down, and also to serve an error page when the server returns with 500 Internal Server Error. As of 0.6, there is a new “Offline browsing” toggle on the Reading Settings screen in the admin. It is disabled by default, but when enabled a <a href=\"https://web.dev/offline-cookbook/#network-falling-back-to-cache\" rel=\"nofollow ugc\">network-first</a> caching strategy is registered for navigations so that the offline page won&#8217;t be shown when accessing previously-accessed pages. The network-first strategy is also used for assets from themes, plugins, and WordPress core. In addition, uploaded images get served with a <a href=\"https://web.dev/offline-cookbook/#stale-while-revalidate\" rel=\"nofollow ugc\">stale-while-revalidate</a> strategy. For all the details on these changes, see the <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/pull/338\" rel=\"nofollow ugc\">pull request</a>.</p>\n<p>Documentation for the plugin can be found on the <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/wiki\" rel=\"nofollow ugc\">GitHub project Wiki</a>.</p>\n<p><strong>Development of this plugin is done <a href=\"https://github.com/GoogleChromeLabs/pwa-wp\" rel=\"nofollow ugc\">on GitHub</a>. Pull requests welcome. Please see <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/issues\" rel=\"nofollow ugc\">issues</a> reported there before going to the <a href=\"https://wordpress.org/support/plugin/pwa\" rel=\"ugc\">plugin forum</a>.</strong></p>\n\";s:3:\"faq\";s:466:\"<p>Please see the <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/wiki/FAQ\" rel=\"nofollow ugc\">frequently asked questions</a> on the GitHub project wiki. Don&#8217;t see an answer to your question? Please <a href=\"https://wordpress.org/support/plugin/pwa/\" rel=\"ugc\">search the support forum</a> to see if someone has asked your question. Otherwise, please <a href=\"https://wordpress.org/support/plugin/pwa/#new-post\" rel=\"ugc\">open a new support topic</a>.</p>\n\";s:9:\"changelog\";s:162:\"<p>For the plugin’s changelog, please see <a href=\"https://github.com/GoogleChromeLabs/pwa-wp/releases\" rel=\"nofollow ugc\">the Releases page on GitHub</a>.</p>\n\";s:7:\"reviews\";s:13537:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not working with latest iOS./iPadOS 16.4</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/gypsy-soo/\"><img alt=\'\' src=\'http://1.gravatar.com/avatar/d0158acf33cd9dff9aaf48e19421afe1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://1.gravatar.com/avatar/d0158acf33cd9dff9aaf48e19421afe1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/gypsy-soo/\" class=\"reviewer-name\">Gypsy Soo</a> on <span class=\"review-date\">April 1, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Looks like it is incompatible with the latest iOS/iPadOS 16.4, install the plugin, open the website at iPad Safari, then save to Home Screen, not working at all.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Its nice work</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/baroc/\"><img alt=\'\' src=\'http://1.gravatar.com/avatar/a311a7dd1558ca65113a7b51b1325202?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://1.gravatar.com/avatar/a311a7dd1558ca65113a7b51b1325202?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/baroc/\" class=\"reviewer-name\">baroc</a> on <span class=\"review-date\">March 13, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>easy to work and its wonderful work thx. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Awesome</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/san-lohat/\"><img alt=\'\' src=\'http://2.gravatar.com/avatar/bf334b99a1afebb61da9499965762ec0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://2.gravatar.com/avatar/bf334b99a1afebb61da9499965762ec0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/san-lohat/\" class=\"reviewer-name\">San Lohat</a> on <span class=\"review-date\">September 11, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Thanks for developing this best plugin</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">nothing</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rbavarchi/\"><img alt=\'\' src=\'http://1.gravatar.com/avatar/1d5f5a33fa9addf35cf2d6a08a1a876a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://1.gravatar.com/avatar/1d5f5a33fa9addf35cf2d6a08a1a876a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rbavarchi/\" class=\"reviewer-name\">rbavarchi</a> on <span class=\"review-date\">June 6, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">This app is supposed to be an extension for PWA but when u download it, you cant use it because there is nothing, no panel nothing. No documentation to help neitheir.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">no options</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/beddtimemedia/\"><img alt=\'\' src=\'http://1.gravatar.com/avatar/18a88c0d1eb29b960f7e776411bfa5b8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://1.gravatar.com/avatar/18a88c0d1eb29b960f7e776411bfa5b8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/beddtimemedia/\" class=\"reviewer-name\">beddtimemedia</a> on <span class=\"review-date\">April 15, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">so far this isn\'t worth getting, there aren\'t any options no changes to my site, it didnt change a single thing</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works neatly</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/aurelienpierre/\"><img alt=\'\' src=\'http://2.gravatar.com/avatar/e0fb97531f28593a553b2b2a657de0d7?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://2.gravatar.com/avatar/e0fb97531f28593a553b2b2a657de0d7?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/aurelienpierre/\" class=\"reviewer-name\">aurelienpierre</a> on <span class=\"review-date\">October 2, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Plus nice support</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Nice Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ngbaze/\"><img alt=\'\' src=\'http://1.gravatar.com/avatar/178787c8ff4cc319849d8545fd6e0e57?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://1.gravatar.com/avatar/178787c8ff4cc319849d8545fd6e0e57?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ngbaze/\" class=\"reviewer-name\">NG Baze <small>(ngbaze)</small></a> on <span class=\"review-date\">July 17, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Nice one.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Can&#039;t get it to work</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/crocoart/\"><img alt=\'\' src=\'http://0.gravatar.com/avatar/cdae8b25f64ba65fd615b1af09bc3c3c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://0.gravatar.com/avatar/cdae8b25f64ba65fd615b1af09bc3c3c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/crocoart/\" class=\"reviewer-name\">crocoart</a> on <span class=\"review-date\">July 4, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Can\'t get the Add to home screen to show on ios devices which pretty much makes this useless.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">nice</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/calvin85mathias/\"><img alt=\'\' src=\'http://1.gravatar.com/avatar/a3555307b29e54b42c7cbf760c8c7f11?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://1.gravatar.com/avatar/a3555307b29e54b42c7cbf760c8c7f11?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/calvin85mathias/\" class=\"reviewer-name\">calvin85mathias</a> on <span class=\"review-date\">February 19, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">nice</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works like a charme</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/per4mance/\"><img alt=\'\' src=\'http://0.gravatar.com/avatar/6e6215f8c6a6fad37e40b996fdd4a8f9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'http://0.gravatar.com/avatar/6e6215f8c6a6fad37e40b996fdd4a8f9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/per4mance/\" class=\"reviewer-name\">Thorsten :-) <small>(per4mance)</small></a> on <span class=\"review-date\">February 5, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Hi,\nThank you for this great plugin it works for me on WP/BP. This is an amazing idea, and it works with W3 Total Cache too.\n\nDo you have any suggestions for me, how to implement a feature as \"add website to home\" when a user uses an iPhone or android?\n\nThank you :-)</div>\n</div>\n\";}s:13:\"download_link\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.7.1.zip\";s:11:\"screenshots\";a:0:{}s:4:\"tags\";a:4:{s:20:\"progressive-web-apps\";s:20:\"progressive web apps\";s:3:\"pwa\";s:3:\"pwa\";s:15:\"service-workers\";s:16:\"service-workers.\";s:16:\"web-app-manifest\";s:16:\"web app manifest\";}s:8:\"versions\";a:9:{s:5:\"0.1.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.1.0.zip\";s:5:\"0.2.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.2.0.zip\";s:5:\"0.3.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.3.0.zip\";s:5:\"0.4.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.4.0.zip\";s:5:\"0.5.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.5.0.zip\";s:5:\"0.6.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.6.0.zip\";s:5:\"0.7.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.7.0.zip\";s:5:\"0.7.1\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.7.1.zip\";s:5:\"trunk\";s:46:\"https://downloads.wordpress.org/plugin/pwa.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:58:\"https://ps.w.org/pwa/assets/banner-772x250.png?rev=2272148\";s:4:\"high\";s:59:\"https://ps.w.org/pwa/assets/banner-1544x500.png?rev=2272148\";}}s:11:\"woocommerce\";a:26:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"8.1.1\";s:6:\"author\";s:48:\"<a href=\"https://woocommerce.com\">Automattic</a>\";s:14:\"author_profile\";s:41:\"https://profiles.wordpress.org/woothemes/\";s:12:\"contributors\";a:14:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/687b3bf96c41800814e3b93766444283?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:10:\"mikejolley\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mikejolley/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9b87f99f47e30735e1136c5141531fdf?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Mike Jolley\";}s:11:\"jameskoster\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/jameskoster/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/19a6a101c57df54bc1c40adcfba785d8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"James Koster\";}s:14:\"claudiosanches\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/claudiosanches/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/908480753c07509e76322dc17d305c8b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Claudio Sanches\";}s:13:\"rodrigosprimo\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/rodrigosprimo/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/f2271ae6814a29d8cbf38ae2d0305a72?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Rodrigo Primo\";}s:15:\"peterfabian1000\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/peterfabian1000/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/be249b86dddbf495565a36196625d77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Peter Fabian\";}s:7:\"vedjain\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/vedjain/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7a640eb2847d9a0a0d5e6af385e21881?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Vedanshu Jain\";}s:8:\"jamosova\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/jamosova/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/eb515897a71b0df82ccd2788548588c4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Julia Amosova\";}s:16:\"obliviousharmony\";a:3:{s:7:\"profile\";s:48:\"https://profiles.wordpress.org/obliviousharmony/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/185f31c1e5af65fee78506769ca13276?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"obliviousharmony\";}s:9:\"konamiman\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/konamiman/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b9a819e803dd87615c4aeb33192db976?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"konamiman\";}s:8:\"sadowski\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/sadowski/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/766381c51d7072d1f48ee8878e2ce3af?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"sadowski\";}s:8:\"wpmuguru\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/wpmuguru/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7b8ff059b9a4504dfbaebd4dd190466e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ron Rennick\";}s:5:\"royho\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/royho/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/715b4097a10f874f8681b15608687f83?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"royho\";}s:13:\"barryhughes-1\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/barryhughes-1/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/4d7aea8e7879e3ea257ddb4a99a300f1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:3:\"7.3\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3427;i:4;i:170;i:3;i:92;i:2;i:93;i:1;i:354;}s:11:\"num_ratings\";i:4136;s:15:\"support_threads\";i:1495;s:24:\"support_threads_resolved\";i:1215;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:22:\"2023-09-15 10:03pm GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:11840:\"<p>WooCommerce is <a href=\"https://trends.builtwith.com/shop\" rel=\"nofollow ugc\">the world’s most popular</a> open-source eCommerce solution.</p>\n<p>Our core platform is free, flexible, and amplified by a global community. The freedom of open-source means you retain full ownership of your store’s content and data forever.</p>\n<p>Whether you’re launching a business, taking brick-and-mortar retail online, or developing sites for clients, use WooCommerce for a store that powerfully blends content and commerce.</p>\n<ul>\n<li><strong>Create beautiful, enticing storefronts</strong> with <a href=\"https://woocommerce.com/product-category/themes/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">themes</a> suited to your brand and industry.</li>\n<li><strong>Increase revenue</strong> with an optimized <a href=\"https://woocommerce.com/checkout-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">shopping cart experience</a> that converts.</li>\n<li><strong>Customize product pages in minutes</strong> using modular <a href=\"https://docs.woocommerce.com/document/woocommerce-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">product blocks</a>.</li>\n<li>Showcase physical and digital goods, product variations, custom configurations, instant downloads, and affiliate items.</li>\n<li>Sell <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">subscriptions</a>, <a href=\"https://woocommerce.com/products/woocommerce-bookings/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">bookings</a>, or <a href=\"https://woocommerce.com/products/woocommerce-memberships/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">memberships</a>, with our developer-vetted extensions.</li>\n<li><strong>Rise to the top of search results</strong> by leveraging <a href=\"https://www.searchenginejournal.com/wordpress-best-cms-seo/\" rel=\"nofollow ugc\">WordPress’ SEO advantage</a>.</li>\n<li><strong>Build on a platform that scales.</strong> Get flexible eCommerce for <a href=\"https://woocommerce.com/high-volume-stores/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">high-volume stores</a>. </li>\n</ul>\n<p>Built-in tools and popular integrations help you efficiently manage your business operations. Many services are free to add with a single click via the optional <a href=\"https://docs.woocommerce.com/document/woocommerce-setup-wizard/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Setup Wizard</a>.</p>\n<ul>\n<li><strong>Choose how you want to get paid</strong>. Conveniently manage payments from the comfort of your store with <a href=\"https://woocommerce.com/payments/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooPayments</a> (Available in the U.S., U.K., Ireland, Australia, New Zealand, Canada, Spain, France, Germany, and Italy). Securely accept credit cards, mobile wallets, bank transfers, and cash thanks to <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">100+ payment gateways</a> – including <a href=\"https://woocommerce.com/products/stripe/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Stripe</a>, <a href=\"https://woocommerce.com/products/woocommerce-gateway-paypal-checkout/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">PayPal</a>, and <a href=\"https://woocommerce.com/products/square/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Square</a>.</li>\n<li><strong>Configure your shipping options</strong>. Print USPS labels right from your dashboard and even schedule a pickup with <a href=\"https://woocommerce.com/products/shipping/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Shipping</a> (U.S.-only). Connect with <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">well-known carriers</a> such as UPS and FedEx – plus a wide variety of delivery, inventory, and fulfillment solutions for your locale.</li>\n<li><strong>Simplify sales tax</strong>. Add <a href=\"https://woocommerce.com/products/tax/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Tax</a> or <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/tax?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">similar integrated services</a> to make automated calculations a reality.</li>\n</ul>\n<h4>Grow your business, add features, and monitor your store on the go</h4>\n<p>WooCommerce means business. Keep tabs on the performance metrics most important to you with <a href=\"https://wordpress.org/plugins/woocommerce-admin/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">WooCommerce Admin</a> – a powerful, customizable central dashboard for your store.</p>\n<p>Expand your audience across marketing and social channels with <a href=\"https://woocommerce.com/products/google-ads/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Google Ads</a>, <a href=\"https://woocommerce.com/products/hubspot-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">HubSpot</a>, <a href=\"https://woocommerce.com/products/mailchimp-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Mailchimp</a>, and <a href=\"https://woocommerce.com/products/facebook/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Facebook</a> integrations. You can always check out the in-dashboard <a href=\"https://docs.woocommerce.com/document/marketing-hub/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Marketing Hub</a> for fresh ideas and tips to help you succeed.</p>\n<p>Enhance store functionality with hundreds of free and paid extensions from the <a href=\"https://woocommerce.com/products/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">official WooCommerce Marketplace</a>. Our developers <a href=\"https://docs.woocommerce.com/document/marketplace-overview/#section-6?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">vet each new extension</a> and regularly review existing extensions to maintain Marketplace quality standards. We are actively <a href=\"https://docs.woocommerce.com/document/marketplace-overview/#section-2?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">looking for products that help store builders create successful stores</a>.</p>\n<p>Manage your store from anywhere with the free WooCommerce <a href=\"https://woocommerce.com/mobile/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">mobile app</a> (Android and iOS). Spoiler alert: Keep an ear out for the slightly addictive &#8220;cha-ching&#8221; notification sound each time you make a new sale!</p>\n<h4>Own and control your store data – forever</h4>\n<p>With WooCommerce, your data belongs to you. Always.</p>\n<p>If you opt to share <a href=\"https://woocommerce.com/usage-tracking/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">usage data</a> with us, you can feel confident knowing that it’s anonymized and kept secure. Choose to opt-out at any time without impacting your store.</p>\n<p>Unlike hosted eCommerce solutions, WooCommerce store data is future-proof; you’re free to export all your content and take your site to any platform you choose. No restrictions.</p>\n<h4>Why developers choose (and love) WooCommerce</h4>\n<p>Developers can use WooCommerce to create, customize, and scale a store to meet a client’s exact specifications, making enhancements through extensions or custom solutions.</p>\n<ul>\n<li>Leverage <a href=\"https://docs.woocommerce.com/document/introduction-to-hooks-actions-and-filters/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">hooks and filters</a> to modify or create functionality.</li>\n<li>Integrate virtually any service using a robust <a href=\"https://docs.woocommerce.com/document/woocommerce-rest-api/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">REST API</a> and webhooks.</li>\n<li>Design and build custom content blocks with React.</li>\n<li><a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/extending/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Inspect and modify</a> any aspect of the core plugin code.</li>\n<li>Speed up development with a lightning-fast <a href=\"https://woocommerce.github.io/code-reference/classes/wc-cli-rest-command.html?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">CLI</a>.</li>\n</ul>\n<p>The core platform is tested rigorously and often, supported by a dedicated development team working across time zones. Comprehensive documentation is updated with each release, empowering you to build exactly the store required.</p>\n<h4>Be part of our growing international community</h4>\n<p>WooCommerce has a large, passionate community dedicated to helping merchants succeed – and it’s growing fast.</p>\n<p>There are <a href=\"https://woocommerce.com/meetups/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Meetups</a> in locations around the world that you can attend for free and even get involved in running. These events are a great way to learn from others, share your expertise, and connect with like-minded folks.</p>\n<p>WooCommerce also has a regular presence at WordCamps across the globe – we’d love to meet you.</p>\n<h4>Contribute and translate</h4>\n<p>WooCommerce is developed and supported by Automattic, the creators of WordPress.com and Jetpack. We also have hundreds of independent contributors, and there’s always room for more. Head to the <a href=\"https://github.com/woocommerce/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce GitHub Repository</a> to find out how you can pitch in.</p>\n<p>WooCommerce is translated into multiple languages, including Danish, Ukrainian, and Persian. Help localize WooCommerce even further by adding your locale – visit <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n\";s:12:\"installation\";s:2392:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>PHP 7.3 or greater is required (PHP 8.0 or greater is recommended)</li>\n<li>MySQL 5.6 or greater, OR MariaDB version 10.1 or greater, is required</li>\n</ul>\n<p>Visit the <a href=\"https://docs.woocommerce.com/document/server-requirements/?utm_source=wp{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20org{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20repo{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option &#8212; WordPress will handle the file transfer, and you won’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu, and click “Add New.”</p>\n<p>In the search field type “WooCommerce,” then click “Search Plugins.” Once you’ve found us,  you can view details about it such as the point release, rating, and description. Most importantly of course, you can install it by! Click “Install Now,” and WordPress will take it from there.</p>\n<h4>Manual installation</h4>\n<p>Manual installation method requires downloading the WooCommerce plugin and uploading it to your web server via your favorite FTP application. The WordPress codex contains <a href=\"https://wordpress.org/support/article/managing-plugins/#manual-plugin-installation\" rel=\"ugc\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work smoothly, but we still recommend you back up your site.</p>\n<p>If you encounter issues with the shop/category pages after an update, flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting “Save.” That should return things to normal.</p>\n<h4>Sample data</h4>\n<p>WooCommerce comes with some sample data you can use to see how products look; import sample_products.xml via the <a href=\"https://wordpress.org/plugins/wordpress-importer/\" rel=\"ugc\">WordPress importer</a>. You can also use the core <a href=\"https://docs.woocommerce.com/document/product-csv-importer-exporter/?utm_source=wp{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20org{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20repo{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">CSV importer</a> or our <a href=\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=wp{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20org{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20repo{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">CSV Import Suite extension</a> to import sample_products.csv</p>\n\";s:3:\"faq\";s:7930:\"\n<dt id=\'where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20find{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20woocommerce{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20documentation{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20and{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20user{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20guides{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhere can I find WooCommerce documentation and user guides?\n</h4>\n<p>\n<p>For help setting up and configuring WooCommerce, please refer to <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/getting-started/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Getting Started</a> and the <a href=\"https://woocommerce.com/guides/new-store/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">New WooCommerce Store Owner Guide</a>.</p>\n<p>For extending or theming WooCommerce, see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">codex</a>, as well as the <a href=\"https://docs.woocommerce.com/document/create-a-plugin/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Plugin Developer Handbook</a>.</p>\n</p>\n<dt id=\'where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20get{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20help{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20or{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20talk{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20other{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20users{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20about{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20woocommerce{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20core{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhere can I get help or talk to other users about WooCommerce Core?\n</h4>\n<p>\n<p>If you get stuck, you can ask for help in the <a href=\"https://wordpress.org/support/plugin/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">WooCommerce Support Forum</a> by following <a href=\"https://wordpress.org/support/topic/guide-to-the-woocommerce-forum/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">these guidelines</a>, reach out via the <a href=\"https://woocommerce.com/community-slack/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Community Slack</a>, or post in the <a href=\"https://www.facebook.com/groups/advanced.woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Community group</a> on Facebook.</p>\n</p>\n<dt id=\'where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20get{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20help{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20for{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20extensions{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20have{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20purchased{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20on{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20woocommerce.com{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhere can I get help for extensions I have purchased on WooCommerce.com?\n</h4>\n<p>\n<p>For assistance with paid extensions from the WooCommerce.com Marketplace: first, review our <a href=\"https://docs.woocommerce.com/document/woocommerce-self-service-guide/\" rel=\"nofollow ugc\">self-service troubleshooting guide</a>. If the problem persists, kindly log a support ticket via <a href=\"https://woocommerce.com/my-account/create-a-ticket/\" rel=\"nofollow ugc\">our helpdesk</a>. Our dedicated Happiness Engineers aim to respond within 24 hours.</p>\n</p>\n<dt id=\'i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}E2{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}80{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}99m{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20having{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20trouble{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20logging{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20in{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20woocommerce.com{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}E2{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}80{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}93{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20now{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nI’m having trouble logging in to WooCommerce.com – what now?\n</h4>\n<p>\n<p>First, troubleshoot common login issues using this helpful <a href=\"https://docs.woocommerce.com/document/log-into-woocommerce-com-with-wordpress-com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">step-by-step guide</a>. Still not working? <a href=\"https://woocommerce.com/contact-us/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Get in touch with us</a>.</p>\n</p>\n<dt id=\'will{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20woocommerce{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20work{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20with{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20theme{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWill WooCommerce work with my theme?\n</h4>\n<p>\n<p>Yes! WooCommerce will work with any theme but may require some additional styling. If you’re looking for a theme featuring deep WooCommerce integration, we recommend <a href=\"https://woocommerce.com/storefront/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Storefront</a>.</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20update{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20woocommerce{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow do I update WooCommerce?\n</h4>\n<p>\n<p>We have a detailed guide on <a href=\"https://docs.woocommerce.com/document/how-to-update-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">How To Update WooCommerce</a>.</p>\n</p>\n<dt id=\'my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20site{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20broke{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}E2{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}80{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}93{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nMy site broke – what do I do?\n</h4>\n<p>\n<p>Start by diagnosing the issue using our helpful <a href=\"https://docs.woocommerce.com/documentation/get-help/troubleshooting-get-help/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">troubleshooting guide</a>.</p>\n<p>If you noticed the error after updating a theme or plugin, there might be compatibility issues between it and WooCommerce. If the issue appeared after updating WooCommerce, there could be a conflict between WooCommerce and an outdated theme or plugin.</p>\n<p>In both instances, we recommend running a conflict test using <a href=\"https://docs.woocommerce.com/document/troubleshooting-using-health-check/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Health Check</a> (which allows you to disable themes and plugins without affecting your visitors) or troubleshooting the issue using a <a href=\"https://docs.woocommerce.com/document/how-to-test-for-conflicts/#section-3?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">staging site</a>.</p>\n</p>\n<dt id=\'where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20report{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20bugs{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhere can I report bugs?\n</h4>\n<p>\n<p>Report bugs on the <a href=\"https://github.com/woocommerce/woocommerce/issues?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce GitHub repository</a>. You can also notify us via our support forum – be sure to search the forums to confirm that the error has not already been reported.</p>\n</p>\n<dt id=\'where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20request{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20new{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20features{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}2C{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20themes{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}2C{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20and{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20extensions{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhere can I request new features, themes, and extensions?\n</h4>\n<p>\n<p>Request new features and extensions and vote on existing suggestions on our official <a href=\"https://woocommerce.com/feature-requests/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">feature request board</a>. Our Product teams regularly review requests and consider them valuable for product planning.</p>\n</p>\n<dt id=\'woocommerce{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20is{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20awesome{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}21{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20contribute{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWooCommerce is awesome! Can I contribute?\n</h4>\n<p>\n<p>Yes, you can! Join in on our <a href=\"https://github.com/woocommerce/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">GitHub repository</a> and follow the <a href=\"https://woocommerce.wordpress.com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">development blog</a> to stay up-to-date with everything happening in the project.</p>\n</p>\n<dt id=\'where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20find{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20rest{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20api{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20documentation{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhere can I find REST API documentation?\n</h4>\n<p>\n<p>Extensive <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce REST API Documentation</a> is available on GitHub.</p>\n</p>\n<dt id=\'my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20question{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20is{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20not{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20listed{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20here.{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20find{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20more{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20answers{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nMy question is not listed here. Where can I find more answers?\n</h4>\n<p>\n<p>Check out <a href=\"https://docs.woocommerce.com/document/frequently-asked-questions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Frequently Asked Questions</a> for more.</p>\n</p>\n\n\";s:9:\"changelog\";s:600:\"<h4>8.1.1 2023-09-15</h4>\n<p><strong>WooCommerce</strong></p>\n<ul>\n<li>Fix &#8211; Do not send user meta data back in <code>woocommerce_get_customer_details</code> response. <a href=\"https://github.com/woocommerce/woocommerce/pull/40221\" rel=\"nofollow ugc\">#40221</a></li>\n<li>Fix &#8211; Fix possible metadata duplication when HPOS is enabled. <a href=\"https://github.com/woocommerce/woocommerce/pull/40148\" rel=\"nofollow ugc\">#40148</a></li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/changelog.txt\" rel=\"nofollow ugc\">See changelog for all versions</a>.</p>\n\";s:11:\"screenshots\";s:1035:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:18405:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Top plugin.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/patrickhaond/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/88339f5a2afdf87adbb6c03f532af2fd?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/88339f5a2afdf87adbb6c03f532af2fd?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/patrickhaond/\" class=\"reviewer-name\">Pat <small>(patrickhaond)</small></a> on <span class=\"review-date\">September 19, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">The best WP plugin for ecommerce, no question.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Easy to use plugin with minimum problems</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/pelotekturkey9/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/db87238e21ab41bc7f693432fe9d4d33?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/db87238e21ab41bc7f693432fe9d4d33?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/pelotekturkey9/\" class=\"reviewer-name\">Pelotek Sourcing <small>(pelotekturkey9)</small></a> on <span class=\"review-date\">September 18, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I have been using the WooCommerce plugin for about 8 years. We successfully made around 12,000 sales to around 7,000 clients. Recently, I had a problem, and they solved it in one day by giving me a line of code. I am happy with this plugin, and I am leaving this review as a thank you for providing a free plugin.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Fast reply and detailed solution suggestions, great!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/zhuxiaojie903/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8dd9d77ec148a95f7654f7294c71ea39?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8dd9d77ec148a95f7654f7294c71ea39?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/zhuxiaojie903/\" class=\"reviewer-name\">zhuxiaojie903</a> on <span class=\"review-date\">September 15, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Fast reply and detailed solution suggestions, great!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great customer support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/photografixpl/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/aed67fe860b9b346b051968b774adbd0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/aed67fe860b9b346b051968b774adbd0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/photografixpl/\" class=\"reviewer-name\">photografixpl</a> on <span class=\"review-date\">September 8, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Absolutely fantastic plugin for running an online store or as in my case, creating and selling an online course. I stumbled across a few issues along the way, but all were solved by customer service promptly. Huge thank you and keep up the good work!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">#1 shop solution for WP</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/vyskoczilova/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/469b64229a3914c0f9317ffaf19f6191?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/469b64229a3914c0f9317ffaf19f6191?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/vyskoczilova/\" class=\"reviewer-name\">Karolina Vyskocilova <small>(vyskoczilova)</small></a> on <span class=\"review-date\">September 6, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Industry standard for e-commerce in WP ecosystem, everything is ok but sometimes you find some caveats, but support is pretty OK for a free plugin. Thanks!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Support Lacking... Dead Mans Loop</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/danyi/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a1bc267a08cf9ba12e0a0af56ea6bc53?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a1bc267a08cf9ba12e0a0af56ea6bc53?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/danyi/\" class=\"reviewer-name\">danyi</a> on <span class=\"review-date\">September 4, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Installed and setup Square for WooCommerce ... Square confirmed connection but WooCommerce reports \"CRITICAL Uncaught ArgumentCountError: Too few arguments to function Square\\Models\\CreatePaymentRequest::\" Square payments do NOT process (note: all plugins are up to date yet WooCommerce does NOT process payment instead poping up with a big red box saying \"There has been a critical error on this website.\" Square tech support says its a WooCommerce problem. WooCommerce tech support will not accept support tickets because they block unless they OK the domain name even though their plugin shows the domain name they have in the status report of the pluggin. Its a dead mans loop of unproductive activity !!! </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">After hours of reading search results and documentation not relevant to this error... tried to post a support ticket.<br />Support Tiecket requires the domain name where plugin is installed... so copied the domain as it shows in the WooCommerce Status report to paste into the WooCommerce Support request form BUT IT WOULD NOT ALLOW THE NAME EXACTLY AS THE PLUGIN SHOWS IT,<br />No support possible even though they accepted the domain name (i.e. VancouverCreates.Art) in the email login and it was copied from teir plugin report. Contacted support as Square who quickly ogt back saying it is a WooCommerce problem got talk to WooCommerce. Half a day of my life wasted.... <br /><br />A commerce plugin that won\'t process payments and where support hides behind tons of documents that do not answer issues ... nice user interface but an example of where there is no cure for bad coding. Sad!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\"></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Loved new block</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/anassal/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ec08ab2658f8d97a3e89c2c1dc9e40c0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ec08ab2658f8d97a3e89c2c1dc9e40c0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/anassal/\" class=\"reviewer-name\">anassal</a> on <span class=\"review-date\">August 29, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I posted in support but don\'t know why it got cut, I want to tell that I liked your new block \"Products\" very much which is beta mode, especially the replacements section. One recommendation is that also create a replacement in which you hover on product and add to cart button pops out. Only have one question, Is it safe to use on live website because I love to use it?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Price variations and Site translations</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/marcosmoraleslee/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/dc02f4750277549eb2d7a2038f5f1443?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/dc02f4750277549eb2d7a2038f5f1443?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/marcosmoraleslee/\" class=\"reviewer-name\">marcosmoraleslee</a> on <span class=\"review-date\">August 28, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I like WooCommerce but we´re in 2023 and there are basic functions the plugin still can\'t do. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\"><strong>1 Translations</strong>. The plugin in is not a 100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} translated and so you have a mix of words in English and in the site language. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\"><strong>2 Variation Prices:</strong> When you have product variations, the price display is horrible and unfunctional. It doesn\'t show the variation price and you have to search for another plugin, to load more code on the page, damaging your site\'s performance.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">These 2 things are pretty basic and should have been solved, at least, since 2018. We\'re in 2023 and I just don\'t get it.    </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Kudos to WooCommerce: Superb Support All Year Round! 👏✨</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/gs1623/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a7a58f8c70736b0be282422b356569e8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a7a58f8c70736b0be282422b356569e8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/gs1623/\" class=\"reviewer-name\">Mo <small>(gs1623)</small></a> on <span class=\"review-date\">August 24, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I have interacted with WooCommerce support multiple times over the past year, addressing various types of issues, and I must say I am thoroughly impressed. Each support agent I\'ve encountered has been incredibly helpful, promptly resolving my concerns. Their extensive knowledge and willingness to assist in resolving any reported problems stand out. Moreover, the plugin itself functions flawlessly, which contributes to its widespread popularity. To sum up, this is an excellent plugin supported by one of the most exceptional teams in the field.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Unbelievable amazing support from the team</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/duffy1721/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c4b5fb84723438428955be17b5ab6467?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c4b5fb84723438428955be17b5ab6467?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/duffy1721/\" class=\"reviewer-name\">duffy1721</a> on <span class=\"review-date\">August 23, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">WOW  what amazing support received from the team. The author of the theme basically washed their hands of the issue and told me to contact support.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">Well,  support helped me solve the problem when the issue was in fact an issue on the theme which will affect all their themes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">Thank you so much. You folk are the best</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\"></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">Brian</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:13:\"download_link\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:9:\"ecommerce\";s:9:\"ecommerce\";s:12:\"online-store\";s:12:\"online store\";s:11:\"sell-online\";s:11:\"sell online\";s:4:\"shop\";s:4:\"shop\";s:13:\"shopping-cart\";s:13:\"shopping cart\";}s:8:\"versions\";a:373:{s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:6:\"3.5.10\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.10.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.6.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.7.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.3.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.3.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"3.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.5.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.4.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.4.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.5.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.6.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.4.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.5.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.5.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.7.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.4.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.3.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"4.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.5.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.3.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.3.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.5.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.3.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.4.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.4.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.2.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.2.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:5:\"5.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.1.zip\";s:5:\"5.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"5.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.1.zip\";s:5:\"6.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0.zip\";s:12:\"6.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-beta.1.zip\";s:10:\"6.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-rc.1.zip\";s:5:\"6.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.1.zip\";s:5:\"6.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0.zip\";s:12:\"6.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-beta.1.zip\";s:10:\"6.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.1.zip\";s:10:\"6.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.2.zip\";s:5:\"6.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.1.zip\";s:5:\"6.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.2.zip\";s:5:\"6.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0.zip\";s:12:\"6.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-beta.1.zip\";s:10:\"6.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.1.zip\";s:10:\"6.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.2.zip\";s:5:\"6.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.1.zip\";s:5:\"6.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.2.zip\";s:5:\"6.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0.zip\";s:12:\"6.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-beta.1.zip\";s:10:\"6.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.1.zip\";s:10:\"6.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.2.zip\";s:5:\"6.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.1.zip\";s:5:\"6.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0.zip\";s:12:\"6.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-beta.1.zip\";s:10:\"6.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-rc.1.zip\";s:5:\"6.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.1.zip\";s:5:\"6.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0.zip\";s:12:\"6.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-beta.1.zip\";s:10:\"6.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.1.zip\";s:10:\"6.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.2.zip\";s:5:\"6.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.1.zip\";s:5:\"6.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0.zip\";s:12:\"6.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-beta.1.zip\";s:10:\"6.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.1.zip\";s:10:\"6.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.2.zip\";s:5:\"6.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.1.zip\";s:5:\"6.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0.zip\";s:12:\"6.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.1.zip\";s:12:\"6.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.2.zip\";s:10:\"6.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-rc.1.zip\";s:5:\"6.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0.zip\";s:12:\"6.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.1.zip\";s:12:\"6.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.2.zip\";s:10:\"6.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-rc.1.zip\";s:5:\"6.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.1.zip\";s:5:\"6.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.2.zip\";s:5:\"6.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0.zip\";s:12:\"6.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.1.zip\";s:12:\"6.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.2.zip\";s:10:\"6.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-rc.1.zip\";s:5:\"6.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.1.zip\";s:5:\"6.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.2.zip\";s:5:\"6.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.3.zip\";s:5:\"6.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.4.zip\";s:5:\"7.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0.zip\";s:12:\"7.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.1.zip\";s:12:\"7.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.2.zip\";s:12:\"7.0.0-beta.3\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.3.zip\";s:10:\"7.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.1.zip\";s:10:\"7.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.2.zip\";s:5:\"7.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.1.zip\";s:5:\"7.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0.zip\";s:12:\"7.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.1.zip\";s:12:\"7.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.2.zip\";s:10:\"7.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.1.zip\";s:10:\"7.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.2.zip\";s:5:\"7.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.1.zip\";s:5:\"7.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0.zip\";s:12:\"7.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.1.zip\";s:12:\"7.2.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.2.zip\";s:10:\"7.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.1.zip\";s:10:\"7.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.2.zip\";s:5:\"7.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.1.zip\";s:5:\"7.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.2.zip\";s:5:\"7.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.3.zip\";s:5:\"7.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0.zip\";s:12:\"7.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.1.zip\";s:12:\"7.3.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.2.zip\";s:10:\"7.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.1.zip\";s:10:\"7.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.2.zip\";s:5:\"7.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0.zip\";s:12:\"7.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.1.zip\";s:12:\"7.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.2.zip\";s:10:\"7.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.1.zip\";s:10:\"7.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.2.zip\";s:5:\"7.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.1.zip\";s:5:\"7.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0.zip\";s:12:\"7.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.1.zip\";s:12:\"7.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.2.zip\";s:10:\"7.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-rc.1.zip\";s:5:\"7.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.1.zip\";s:5:\"7.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0.zip\";s:12:\"7.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.1.zip\";s:12:\"7.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.2.zip\";s:10:\"7.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.1.zip\";s:10:\"7.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.2.zip\";s:10:\"7.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.3.zip\";s:5:\"7.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.1.zip\";s:5:\"7.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0.zip\";s:12:\"7.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.1.zip\";s:12:\"7.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.2.zip\";s:10:\"7.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-rc.1.zip\";s:5:\"7.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.1.zip\";s:5:\"7.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.2.zip\";s:5:\"7.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0.zip\";s:12:\"7.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.1.zip\";s:12:\"7.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.2.zip\";s:10:\"7.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.1.zip\";s:10:\"7.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.2.zip\";s:5:\"7.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.1.zip\";s:5:\"7.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.2.zip\";s:5:\"7.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0.zip\";s:12:\"7.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.1.zip\";s:12:\"7.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.2.zip\";s:10:\"7.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.2.zip\";s:10:\"7.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.3.zip\";s:5:\"8.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0.zip\";s:12:\"8.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.1.zip\";s:12:\"8.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.2.zip\";s:10:\"8.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.1.zip\";s:10:\"8.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.2.zip\";s:5:\"8.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.1.zip\";s:5:\"8.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.2.zip\";s:5:\"8.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.3.zip\";s:5:\"8.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0.zip\";s:12:\"8.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-beta.1.zip\";s:10:\"8.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.1.zip\";s:10:\"8.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.2.zip\";s:5:\"8.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=2366418\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=2366418\";}}s:19:\"the-events-calendar\";a:26:{s:4:\"name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:7:\"version\";s:5:\"6.2.2\";s:6:\"author\";s:52:\"<a href=\"https://evnt.is/1x\">The Events Calendar</a>\";s:14:\"author_profile\";s:49:\"https://profiles.wordpress.org/theeventscalendar/\";s:12:\"contributors\";a:14:{s:17:\"theeventscalendar\";a:3:{s:7:\"profile\";s:49:\"https://profiles.wordpress.org/theeventscalendar/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/004d5851721c5bd2b3491b51429f771e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"The Events Calendar\";}s:7:\"borkweb\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/borkweb/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/1e656e49ac69899daa3ff81232b041eb?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:18:\"Matthew Batchelder\";}s:7:\"bordoni\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/bordoni/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c412fa91c51f4e2cff375f74efb663e3?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Gustavo Bordoni\";}s:11:\"brianjessee\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/brianjessee/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/a35212d9e01d2ca4e96ecdd05b110b4a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Brian\";}s:6:\"aguseo\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/aguseo/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/57554805e57d21c1036c8b91f944c8ca?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Andras Guseo\";}s:8:\"camwynsp\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/camwynsp/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/30d0a438b49ba2ab1b325c71349ab3bb?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Stephen Page\";}s:8:\"geoffbel\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/geoffbel/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7d6fd85658178125baa17b6055dd3be1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"GeoffBel\";}s:7:\"jentheo\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/jentheo/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e02959cfbac1b4fab42cd6019c0e70c6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"Jennifer\";}s:11:\"leahkoerper\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/leahkoerper/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9fe5fa3836f54c58936a3979212da076?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"leahkoerper\";}s:8:\"lucatume\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/lucatume/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/d393fcb75e0801c42fe5559ae1e846e6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"lucatume\";}s:11:\"neillmcshea\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/neillmcshea/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/43599a71b1b6506a26d029221f1d61a9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"neillmcshea\";}s:6:\"vicskf\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/vicskf/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/3a2a95b83191dc10b76ba61aba61c618?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Victor Zarranz\";}s:9:\"zbtirrell\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/zbtirrell/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/eeb48b1ae8eca09700c2c2642a1f7dcf?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Zach Tirrell\";}s:7:\"juanfra\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/juanfra/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/bb8f8e3c87dfce235f6bfe5a2d8ece2b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Juan Aldasoro\";}}s:8:\"requires\";s:5:\"6.1.0\";s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:84;s:7:\"ratings\";a:5:{i:5;i:1579;i:4;i:125;i:3;i:79;i:2;i:64;i:1;i:282;}s:11:\"num_ratings\";i:2129;s:15:\"support_threads\";i:175;s:24:\"support_threads_resolved\";i:116;s:15:\"active_installs\";i:700000;s:12:\"last_updated\";s:21:\"2023-09-14 3:18pm GMT\";s:5:\"added\";s:10:\"2010-01-19\";s:8:\"homepage\";s:0:\"\";s:8:\"sections\";a:6:{s:11:\"description\";s:6783:\"<p>Easily create and manage an events calendar on your WordPress site with <a href=\"https://evnt.is/mj\" rel=\"nofollow ugc\">The Events Calendar</a> free plugin. Whether your events are in-person or virtual events, this WordPress calendar plugin boasts professional features backed by our world-class team of developers and designers.</p>\n<p><div class=\"embed-vimeo\" style=\"text-align: center;\"><iframe loading=\"lazy\" src=\"https://player.vimeo.com/video/425323974\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>\n</p>\n<p><a href=\"https://evnt.is/1b4-\" rel=\"nofollow ugc\">See more videos on our YouTube channel</a></p>\n<p>Packed with loads of features, The Events Calendar is ready to go out of the box. It’s also extensible, easy to use, and completely customizable.</p>\n<h4>📅 The #1 Calendar for WordPress</h4>\n<p>See the calendar in action on our <a href=\"https://evnt.is/1ajs\" rel=\"nofollow ugc\">demo experience</a>. Just getting started? Read through the <a href=\"https://evnt.is/2d\" rel=\"nofollow ugc\">New User Primer</a> to get set up.</p>\n<p>Looking for additional features like recurring events, ticket sales, user-submitted events, automatic imports, and more?</p>\n<p><strong>Check out <a href=\"https://evnt.is/mj\" rel=\"nofollow ugc\">Events Calendar Pro</a>, <a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a>, and <a href=\"https://evnt.is/2a\" rel=\"nofollow ugc\">more add-ons</a>.</strong></p>\n<h4>🔌🎨 Plug and Play or Customize</h4>\n<p>The Events Calendar is built to work out of the box. Simply install the plugin, configure your settings, and start creating events in minutes.</p>\n<p>Want to add your personal touch? Use The Events Calendar as the foundation for customization. Personalize to your heart&#8217;s content with the help of a skeleton stylesheet, partial template overrides, template tags, hooks and filters, <a href=\"https://evnt.is/eu\" rel=\"nofollow ugc\">careful documentation</a>, and a <a href=\"https://evnt.is/1a0r\" rel=\"nofollow ugc\">library of free extensions</a>.</p>\n<p>Whether your vision is big or small, you&#8217;re in good company. Hundreds of thousands of small businesses, musicians, venues, restaurants, and non-profits are publishing and promoting their in-person and virtual events with The Events Calendar. Our plugins have also been scaled to work on large networks for Fortune 100 companies, universities, and government institutions.</p>\n<h4>✨ Features</h4>\n<p>Our feature-rich plugin comes with everything you need to create and manage your calendar.</p>\n<p>✔️ Rapidly create events<br />\n✔️ Saved venues &amp; organizers<br />\n✔️ Calendar month view with tooltips<br />\n✔️ Event List view<br />\n✔️ Day view<br />\n✔️ Block Editor support<br />\n✔️ Event search<br />\n✔️ Google maps<br />\n✔️ Widget: Upcoming events list<br />\n✔️ Events Taxonomies (Categories &amp; Tags)<br />\n✔️ Google Calendar and iCal exporting<br />\n✔️ WP REST API endpoints<br />\n✔️ Completely ajaxified for super smooth browsing<br />\n✔️ Completely responsive from mobile to tablet to desktop<br />\n✔️ Tested on the major theme frameworks such as Avada, Divi, Enfold, Genesis, and many more.<br />\n✔️ Increase your SEO with JSON-LD Structured Data<br />\n✔️ Internationalized &amp; translated<br />\n✔️ Multiple stylesheets to improve integration<br />\n✔️ Extensive template tags for customization<br />\n✔️ Hooks &amp; filters galore<br />\n✔️ Caching support<br />\n✔️ Debug mode for developers<br />\n✔️ <a href=\"https://evnt.is/1a0r\" rel=\"nofollow ugc\">Library of extensions</a></p>\n<h3>📃 Documentation</h3>\n<p>All of our documentation can be found in <a href=\"https://evnt.is/eu\" rel=\"nofollow ugc\">our Knowledgebase</a>.</p>\n<p>Additional helpful links:</p>\n<ul>\n<li><a href=\"https://evnt.is/2l\" rel=\"nofollow ugc\">The Events Calendar New User Primer</a></li>\n<li><a href=\"https://evnt.is/2m\" rel=\"nofollow ugc\">The Themer’s Guide to The Events Calendar</a></li>\n</ul>\n<p>If you have any questions about this plugin, you can post a thread in the <a href=\"https://wordpress.org/support/plugin/the-events-calendar\" rel=\"ugc\">WordPress.org forum</a>. Please search existing threads before starting a new one.</p>\n<h3>Add-Ons</h3>\n<p>Take your calendar to the next level by pairing it with our plugins for ticketing, crowdsourcing, email marketing, and more. Learn more about all our products on <a href=\"https://evnt.is/18wn\" rel=\"nofollow ugc\">our website</a>.</p>\n<p>Our Free Plugins:</p>\n<p>🎟️ <a href=\"https://wordpress.org/plugins/event-tickets/\" rel=\"ugc\">Event Tickets</a><br />\n📐 <a href=\"https://wordpress.org/plugins/advanced-post-manager/\" rel=\"ugc\">Advanced Post Manager</a></p>\n<p>Our Premium Plugins and Services:</p>\n<p>⚡ <a href=\"https://evnt.is/18wi\" rel=\"nofollow ugc\">Events Calendar PRO</a><br />\n↪️ <a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a> (service)<br />\n🎟️ <a href=\"https://evnt.is/18wk\" rel=\"nofollow ugc\">Event Tickets Plus</a><br />\n✉️ <a href=\"https://evnt.is/1ajt\" rel=\"nofollow ugc\">Promoter</a><br />\n👥 <a href=\"https://evnt.is/2g\" rel=\"nofollow ugc\">Community Events</a><br />\n🎟️ <a href=\"https://evnt.is/18wl\" rel=\"nofollow ugc\">Community Tickets</a><br />\n✏️ <a href=\"https://evnt.is/fa\" rel=\"nofollow ugc\">Filter Bar</a><br />\n🗓️ <a href=\"https://evnt.is/2e\" rel=\"nofollow ugc\">Eventbrite Tickets</a><br />\n📡 <a href=\"https://evnt.is/1aky\" rel=\"nofollow ugc\">Virtual Events</a></p>\n<h3>Help</h3>\n<p>If you aren’t familiar with The Events Calendar, check out our <a href=\"https://evnt.is/2p\" rel=\"nofollow ugc\">New User Primer</a>. It will have you creating events in no time.</p>\n<p>Ready to dig deeper? Check out these resources:</p>\n<ul>\n<li><a href=\"https://evnt.is/2u\" rel=\"nofollow ugc\">Tutorials</a></li>\n<li><a href=\"https://theeventscalendar.com/release-schedule/\" rel=\"nofollow ugc\">Release Schedule</a></li>\n<li><a href=\"https://theeventscalendar.com/known-issues/\" rel=\"nofollow ugc\">Known Issues</a></li>\n<li><a href=\"https://evnt.is/eu\" rel=\"nofollow ugc\">Documentation</a></li>\n<li><a href=\"https://evnt.is/2t\" rel=\"nofollow ugc\">Help Videos</a></li>\n<li><a href=\"https://evnt.is/2v\" rel=\"nofollow ugc\">Release Notes</a></li>\n</ul>\n<p>We check in on the <a href=\"https://wordpress.org/support/plugin/the-events-calendar/\" rel=\"ugc\">The Events Calendar forum here on WordPress.org</a> about once a week to help users with basic troubleshooting and identifying bugs. If you’re looking for premium, personalized support, consider upgrading to Events Calendar Pro.</p>\n<p>Still have a question? Shoot us an email at support@theeventscalendar.com.</p>\n\";s:12:\"installation\";s:1322:\"<p>Installing the plugin is easy. Just follow one of the following methods:</p>\n<h4>Install The Events Calendar from within WordPress</h4>\n<ol>\n<li>Visit the plugins page within your dashboard and select ‘Add New’</li>\n<li>Search for &#8220;Events Calendar&#8221;</li>\n<li>Activate The Events Calendar from your Plugins page</li>\n<li>You&#8217;re done!</li>\n</ol>\n<h4>Install The Events Calendar Manually</h4>\n<ol>\n<li>From the dashboard of your site, navigate to Plugins &#8211;&gt; Add New.</li>\n<li>Select the Upload option and hit &#8220;Choose File.&#8221;</li>\n<li>When the popup appears select the the-events-calendar-x.x.zip file from your desktop. (The &#8216;x.x&#8217; will change depending on the current version number).</li>\n<li>Follow the on-screen instructions and wait as the upload completes.</li>\n<li>When it&#8217;s finished, activate the plugin via the prompt. A message will show confirming activation was successful. A link to access the calendar directly on the frontend will be presented here as well.</li>\n</ol>\n<p>That&#8217;s it! Just configure your settings as you see fit, and you&#8217;re on your way to creating events in style. Need help getting things started? Check out our <a href=\"https://evnt.is/2l\" rel=\"nofollow ugc\">new user primer</a> for help with settings and features.</p>\n\";s:3:\"faq\";s:9796:\"\n<dt id=\'are{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20there{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20any{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20troubleshooting{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20steps{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20you{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}27d{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20suggest{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20try{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20that{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20might{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20resolve{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20issue{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20before{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20post{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20a{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20new{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20thread{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nAre there any troubleshooting steps you&#8217;d suggest I try that might resolve my issue before I post a new thread?\n</h4>\n<p>\n<p>First, make sure that you&#8217;re running the latest version of The Events Calendar. If you’re running Events Calendar PRO or  any other add-ons, make sure those are current / running the latest code as well.</p>\n<p>The most common issues we see are either plugin or theme conflicts. You can test if a plugin or theme is conflicting by manually deactivating other plugins until just The Events Calendar is running on your site. If the issue persists from there, revert to the default <a href=\"https://wordpress.org/themes/twentytwenty/\" rel=\"ugc\">Twenty Twenty</a> theme. If the issue is resolved after deactivating a specific plugin or your theme, you’ll know that is the source of the conflict.</p>\n<p>Note that we aren’t going to say “tough luck” if you identify a plugin/theme conflict. While we can’t guarantee 100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} integration with any plugin or theme out there, we will do our best (and reach out the plugin/theme author as needed) to figure out a solution that benefits everyone.</p>\n</p>\n<dt id=\'i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}27m{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20still{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20stuck.{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20go{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20file{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20a{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20bug{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20or{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20ask{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20a{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20question{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nI&#8217;m still stuck. Where do I go to file a bug or ask a question?\n</h4>\n<p>\n<p>Users of the free The Events Calendar should post their questions in the plugin&#8217;s <a href=\"https://wordpress.org/support/plugin/the-events-calendar/\" rel=\"ugc\">WordPress.org forum</a>, which we visit about once a week. Please make sure to read <a href=\"https://evnt.is/19oc\" rel=\"nofollow ugc\">our sticky post</a> providing an overview of the support we provide free users BEFORE posting. If you find you&#8217;re not getting support in as timely a fashion as you wish, you might want to consider purchasing a license for Events Calendar Pro.</p>\n<p>If you&#8217;re already an Events Calendar Pro user, you&#8217;re entitled access to our actively-monitored <a href=\"https://evnt.is/1aju\" rel=\"nofollow ugc\">Premium Support</a> on our website. We can provide a deeper level of support here and hit these forums on a daily basis during the work week. Generally, except in times of increased support loads, we reply to all tickets within 24-48 hours during the business week.</p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}27s{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20difference{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20between{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20and{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20pro{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat&#8217;s the difference between The Events Calendar and Events Calendar Pro?\n</h4>\n<p>\n<p>The Events Calendar is our cornerstone plugin, and it’s required in order to run any of our premium calendar add-ons, including Events Calendar Pro, Community Events, Filter Bar, and others.</p>\n<p>In other words, Events Calendar Pro runs alongside The Events Calendar and enhances it with extra features, including recurring events, additional calendar views, calendar shortcodes, advanced widgets, custom event fields and more.</p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20add-ons{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20are{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20available{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20for{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}2C{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20and{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20read{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20more{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20about{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20them{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat add-ons are available for The Events Calendar, and where can I read more about them?\n</h4>\n<p>\n<p>The following add-ons are available for The Events Calendar:</p>\n<ul>\n<li><a href=\"https://evnt.is/18wi\" rel=\"nofollow ugc\">Events Calendar Pro</a>, for adding premium calendar features like recurring events, advanced views, cool widgets, <a href=\"https://evnt.is/1ajw\" rel=\"nofollow ugc\">shortcodes</a>, additional fields, and more!</li>\n<li><a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a>, a service that effortlessly fills your calendar with events from Meetup, Google Calendar, iCalendar, Eventbrite, CSV, and ICS.</li>\n<li><a href=\"https://evnt.is/1aky\" rel=\"nofollow ugc\">Virtual Events</a>, which optimizes your calendar for virtual events including Zoom integration, video and livestream embeds, SEO optimization for online events and more.</li>\n<li><a href=\"https://wordpress.org/plugins/event-tickets/\" rel=\"ugc\">Event Tickets</a> (free), which allows you to sell tickets and collect RSVPs to events. It can run alongside The Events Calendar or as a standalone plugin that adds ticket and RSVP functionality to WordPress posts and pages.</li>\n<li><a href=\"https://evnt.is/18wk\" rel=\"nofollow ugc\">Event Tickets Plus</a>, which allows you to sell tickets for your events using your favorite e-commerce platform.</li>\n<li><a href=\"https://evnt.is/1ajt\" rel=\"nofollow ugc\">Promoter</a>, automated email communication made just for The Events Calendar and Event Tickets. Stay in touch with your attendees every step of the way.</li>\n<li><a href=\"https://evnt.is/2g\" rel=\"nofollow ugc\">Community Events</a>, for allowing frontend event submission from your readers.</li>\n<li><a href=\"https://evnt.is/18wl\" rel=\"nofollow ugc\">Community Tickets</a>, which allows event organizers to sell tickets to the events they submit via Community Events.</li>\n<li><a href=\"https://evnt.is/fa\" rel=\"nofollow ugc\">Filter Bar</a>, for adding advanced frontend filtering capabilities to your events calendar.</li>\n<li><a href=\"https://evnt.is/2e\" rel=\"nofollow ugc\">Eventbrite Tickets</a>, for selling tickets to your event directly through Eventbrite.</li>\n</ul>\n</p>\n<dt id=\'can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20import{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nCan I import events to my calendar?\n</h4>\n<p>\n<p>Yes! The Events Calendar has a built-in CSV import tool. If you want to step it up and automatically import events from Google Calendar, Meetup, Eventbrite and more, check out <a href=\"https://evnt.is/197u\" rel=\"nofollow ugc\">Event Aggregator</a>.</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20sell{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20tickets{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20on{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow do I sell tickets to events on my calendar?\n</h4>\n<p>\n<p>You&#8217;ll want to use our <a href=\"https://wordpress.org/plugins/event-tickets/\" rel=\"ugc\">Event Tickets</a> plugin for that. This free plugin works alongside The Events Calendar and lets you create RSVPs and tickets for events. Event Tickets integrates with PayPal so you can collect payments for tickets, while our premium solution, Event Tickets Plus fully integrates with WooCommerce or Easy Digital Downloads.</p>\n</p>\n<dt id=\'can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20have{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20more{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20than{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20one{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20on{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20site{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nCan I have more than one calendar on my site?\n</h4>\n<p>\n<p>Unfortunately, no. However, you can use <a href=\"https://evnt.is/1bay\" rel=\"nofollow ugc\">event categories</a> or tags to create calendar views that only display certain events. For example, you could create a direct link to a calendar view that only shows events categorized as “Fitness,” <a href=\"https://evnt.is/1ajv\" rel=\"nofollow ugc\">like this example from our demo site</a>.</p>\n<p>With <a href=\"https://evnt.is/18wi\" rel=\"nofollow ugc\">Events Calendar Pro</a>, you can use <a href=\"https://evnt.is/1ajw\" rel=\"nofollow ugc\">shortcodes</a> to embed your calendar on other WordPress pages and posts, then filter that calendar by category.</p>\n</p>\n<dt id=\'can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20allow{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20people{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20submit{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nCan I allow people to submit events to my calendar?\n</h4>\n<p>\n<p>This is available with the <a href=\"https://evnt.is/2g\" rel=\"nofollow ugc\">Community Events</a> add-on to facilitate submissions. Install Community Events alongside The Events Calendar and a page will be added to your WordPress site with a form that visitors can use to submit events. As the calendar owner, you have full control over whether event submissions are published immediately or require moderation first.</p>\n<p>If you want to let users sell tickets for the events they submit, check out <a href=\"https://evnt.is/18wl\" rel=\"nofollow ugc\">Community Tickets</a>. It runs with The Events Calendar, Community Events, and Event Tickets and empowers visitors to create and sell tickets, splitting the profits with you.</p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}E2{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}80{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}99s{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20difference{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20between{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20and{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20events{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20calendar{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20pro\'>\nWhat’s the difference between The Events Calendar and Events Calendar Pro\n</h4>\n<p>\n<p>The Events Calendar is our cornerstone plugin, and it’s required in order to run any of our premium calendar add-ons, including <a href=\"https://evnt.is/18wi\" rel=\"nofollow ugc\">Events Calendar Pro</a>, <a href=\"https://evnt.is/1bax\" rel=\"nofollow ugc\">Community Events</a>, <a href=\"https://evnt.is/fa\" rel=\"nofollow ugc\">Filter Bar</a>, and others.</p>\n<p>In other words, Events Calendar Pro runs alongside The Events Calendar and enhances it with extra features, including recurring events and event Series, additional calendar views, calendar shortcodes, advanced widgets, custom event fields, a duplicate event tool, and more.</p>\n</p>\n<dt id=\'i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20have{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20a{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20feature{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20idea.{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}27s{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20best{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20way{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20tell{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20you{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20about{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20it{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nI have a feature idea. What&#8217;s the best way to tell you about it?\n</h4>\n<p>\n<p>We&#8217;ve got an <a href=\"https://app.loopedin.io/the-events-calendar-suite-roadmap#/ideas\" rel=\"nofollow ugc\">ideas page</a> where we&#8217;re actively watching for feature ideas from the community. Vote up existing feature requests or add your own, and help us shape <a href=\"https://app.loopedin.io/the-events-calendar-suite-roadmap#/roadmap\" rel=\"nofollow ugc\">our roadmap</a>.</p>\n</p>\n<dt id=\'i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}27ve{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20still{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20got{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20questions.{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20where{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20find{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20answers{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nI&#8217;ve still got questions. Where can I find answers?\n</h4>\n<p>\n<p>Check out our extensive <a href=\"https://evnt.is/18wm\" rel=\"nofollow ugc\">knowledgebase</a> for articles on using, tweaking, and troubleshooting our plugins.</p>\n</p>\n\n\";s:9:\"changelog\";s:307239:\"<h4>[6.2.2] 2023-09-13</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.2.2 is only compatible with Event Tickets 5.6.5 and higher</li>\n<li>Fix &#8211; When using the Event Tickets email feature the Organizer email and website will no longer be switched. [ET-1843]</li>\n<li>Fix &#8211; When subscribing to an event, the organizer name will not encode as many characters, especially spaces. [ET-1778]</li>\n<li>Language &#8211; 0 new strings added, 9 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.2.1] 2023-09-05</h4>\n<ul>\n<li>Fix &#8211; WP Rewrite was being incorrectly initialized in some scenarios due to container DI, and causing some 404s. This was affecting classes that extend the <code>Tribe__Rewrite</code>. [TEC-4844]</li>\n<li>Fix &#8211; Fixed a bug where <code>0</code> and <code>1</code> were displayed on the <code>general</code> and <code>display</code> tabs for Network admins on multisite installations. [TEC-4774]</li>\n<li>Fix &#8211; In some cases when multiple Widgets were used on a page, the view results would return the wrong cache, displaying incorrect results. This fixes the inspection of the different view filters being used to determine whether it is cached or not. [ECP-1561]</li>\n<li>Fix &#8211; Correct some accessibility issues in the subscribe dropdowns. Props to @alh0319 for calling these out! [TEC-4185]</li>\n<li>Tweak &#8211; Enhanced venue and organizer labels by updating aria labels with additional placeholders and revised translator comments, improving internationalization and accessibility. [TEC-4874]</li>\n<li>Tweak &#8211; Changed views: <code>blocks/parts/organizer</code>, <code>blocks/parts/subscribe-list</code>, <code>modules/meta/organizer</code>, <code>modules/meta/venue</code>, <code>v2/components/subscribe-links/item</code>, <code>v2/components/subscribe-links/list</code>, <code>v2/components/subscribe-links/single-event-list</code></li>\n<li>Language &#8211; 1 new strings added, 22 updated, 0 fuzzied, and 8 obsoleted</li>\n</ul>\n<h4>[6.2.0.1] 2023-08-16</h4>\n<ul>\n<li>Fix &#8211; Ensure we pass the correct number of params to <code>maybe_get_new_order_from_blocks</code> [TEC-4889]</li>\n</ul>\n<h4>[6.2.0] 2023-08-15</h4>\n<ul>\n<li>Tweak &#8211; Change styling for Venue Blocks to constrain to a card-like style. [ECP-1540]</li>\n<li>Tweak &#8211; Adjust REST endpoints to support multiple venues during event creation and updates. [ECP-1540]</li>\n<li>Tweak &#8211; If multiple venues exist on an event, display them in the classic event editor. [ECP-1540]</li>\n<li>Fix &#8211; Ensure the block editor includes support for user-defined custom CSS classes. [TEC-4724]</li>\n<li>Fix &#8211; Ensure the &#8220;Add Organizer&#8221; button is visible in the classic editor if organizers have been set. [TEC-4729]</li>\n<li>Fix &#8211; Simplify data handling of venues within the block editor. [ECP-1540]</li>\n<li>Fix &#8211; When removing a newly created organizer in the block editor before saving the event will now trash the draft organizer. [TEC-3865]</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_rewrite_dynamic_matchers</code>, <code>tec_events_views_v2_assets_should_enqueue_single_event_block_editor_styles</code>, <code>tec_events_title_taxonomies</code>, <code>tec_events_views_v2_view_header_title_element</code>, <code>tec_events_views_v2_view_{$view_slug}_header_title_element</code>, <code>tec_events_views_v2_view_header_title</code>, <code>tec_events_views_v2_view_{$view_slug}_header_title</code>, <code>tec_events_views_v2_view_content_title</code>, <code>tec_events_views_v2_view_{$view_slug}_content_title</code>, <code>tec_get_venue_ids</code></li>\n<li>Tweak &#8211; Added actions: <code>tec_events_after_venue_map_fields</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-venue.php</code>, <code>blocks/parts/map.php</code>, <code>blocks/parts/venue.php</code>, <code>v2/base.php</code>, <code>v2/components/breadcrumbs/linked-breadcrumbs.php</code>, <code>v2/components/content-title.php</code>, &#8216;v2/components/header-title.php<code>,</code>v2/components/header.php<code>,</code>v2/components/messages.php<code>,</code>v2/day.php<code>,</code>v2/day/event/venue.php<code>,</code>v2/list.php<code>,</code>v2/list/event/venue.php<code>,</code>v2/month.php`</li>\n<li>Language &#8211; 3 new strings added, 72 updated, 1 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[6.1.4] 2023-08-10</h4>\n<ul>\n<li>Version &#8211; The minimum supported version of WordPress is now 6.1.0</li>\n<li>Fix &#8211; In some scenarios our pagination and various view actions would fail due to 403 errors on the REST endpoints, because of failing nonce checks, likely due to cache. Updating the way we handle nonces to avoid some scenarios the wrong nonce could be cached. [TEC-4814]</li>\n<li>Fix &#8211; This issue was regarding our rewrite parsing for the view picker url generation with WPML enabled. It was failing to parse the translated rewrite properly, and leaving unparsed permalinks. [TEC-4758]</li>\n<li>Fix &#8211; Ensure we output valid html around\n<dt> and </p>\n<dd> elements in an accessible way. [TEC-4812]</dd>\n</dt>\n</li>\n<li>Fix &#8211; Ensure the block editor includes support for user-defined custom CSS classes. [TEC-4724]</li>\n<li>Fix &#8211; Our logic to include <code>tribe_events</code> post type on the tag archive page was incorrectly bleeding into other queries happening on the page. This narrows the scope for the <code>WP_Query</code> post type overrides and avoids situations where Divi templates were not loading properly. [TEC-4819]</li>\n<li>Fix &#8211; Correct some PHP 8.1 deprecations that impact loading of views. [TEC-4871]</li>\n<li>Fix &#8211; Prevent TypeError warnings around <code>admin_footer_text_settings</code> filter due to type hinting conflicting with other plugins returning null.</li>\n<li>Tweak &#8211; Deprecated misspelled <code>tribe_get_organiser_object_after</code> filter for one with correct spelling: <code>tribe_get_organizer_object_after</code>. Done as part of [TEC-4812]</li>\n<li>Tweak &#8211; Remove end colons from some translated strings. Done as part of [TEC-4812]</li>\n<li>Tweak &#8211; Fix typo in template displaying stray &#8220;w&#8221;. [TEC-4870]</li>\n<li>Tweak &#8211; Removed code pertaining to Event Tickets CT1. [ETP-874]</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_views_v2_get_rest_nonces</code>, <code>tribe_events_get_organizer_object_after</code></li>\n<li>Tweak &#8211; Deprecated filters: <code>tribe_events_get_organiser_object_after</code></li>\n<li>Tweak &#8211; Deprecated functions: In <code>Tribe\\Views\\V2\\Views\\Traits\\HTML_Cache.php</code> the <code>get_view_nonce_fields()</code>,<code>get_view_nonce_attributes()</code>, <code>get_view_nonce_json_properties()</code>, <code>extract_nonces_before_cache()</code>, <code>extract_nonces_before_cache()</code>, <code>extract_nonces_before_cache()</code>, and <code>maybe_generate_nonce()</code> functions have been deprecated.</li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details.php</code>, <code>blocks/event-category.php</code>, <code>blocks/event-datetime.php</code>, <code>blocks/event-organizer.php</code>, <code>blocks/event-price.php</code>, <code>blocks/event-tags.php</code>, <code>blocks/event-venue.php</code>, <code>blocks/event-website.php</code>, <code>blocks/featured-image.php</code>, <code>blocks/parts/details.php</code>, <code>blocks/parts/organizer.php</code>, <code>blocks/parts/subscribe-list.php</code>, <code>blocks/parts/subscribe-single.php</code>, <code>modules/meta/organizer.php</code>, <code>modules/meta/venue.php</code>, <code>v2/components/events-bar/search.php</code>, <code>v2/day.php</code>, <code>v2/list.php</code>, <code>v2/month.php</code>, <code>v2/widgets/widget-events-list.php</code>.</li>\n<li>Language &#8211; 11 new strings added, 12 updated, 0 fuzzied, and 0 obsoleted.</li>\n</ul>\n<h4>[6.1.3] 2023-07-13</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.1.3 is only compatible with Events Community 4.10.10 and higher</li>\n<li>Fix &#8211; Performance improvements on Month and Day view when a lot of future and past events were found. [TEC-3089]</li>\n<li>Fix &#8211; Ensure we&#8217;re using the correct download link for the <code>Export Outlook .ics</code> file in the single event page. [TEC-4776]</li>\n<li>Fix &#8211; Ensure TEC styles can be easily overridden by themes and page builders. [ECP-1503]</li>\n<li>Fix &#8211; Avoid the issue where TEC blocks would break when either the <code>WP Go Maps</code>, <code>MapPress Google Maps</code> and <code>Leaflet Maps</code> plugins were active on a site. [TEC-4810]</li>\n<li>Fix &#8211; Added some event parsing to ensure only valid events are handled in the iCal file generation. [TEC-4837]</li>\n<li>Fix &#8211; Harden some of our CSS to prevent unintended overrides by Elementor global styles. [TEC-4811]</li>\n<li>Fix &#8211; Log errors throw in the context of the Custom Tables v1 component. [ET-1486]</li>\n<li>Fix &#8211; Adding memoizing into the CT1 models to help reduce trips to fetch the same instance. [ECP-1505]</li>\n<li>Tweak &#8211; Refactored CSS for Tickets Emails to better conform to email client CSS standards. [TEC-4849]</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_ical_protected_content_description</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_log</code></li>\n<li>Tweak &#8211; Changed views: <code>integrations/event-tickets/emails/template-parts/header/head/tec-styles</code></li>\n<li>Security &#8211; Various improvements to event creation.</li>\n<li>Language &#8211; 1 new strings added, 129 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.1.2.2] 2023-06-23</h4>\n<ul>\n<li>Fix &#8211; Ensure there is backwards compatibility with Extensions and Pods.</li>\n</ul>\n<h4>[6.1.2.1] 2023-06-22</h4>\n<ul>\n<li>Fix &#8211; Prevent Telemetry from being initialized and triggering a Fatal when the correct conditionals are not met.</li>\n</ul>\n<h4>[6.1.2] 2023-06-22</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Event Tickets 5.6.1 and higher</li>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Events Filterbar 5.5.0 and higher</li>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Events Community 4.10.8 and higher</li>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Events Community Tickets 4.9.3 and higher</li>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Eventbrite Tickets 4.6.14 and higher</li>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Virtual Events 1.15.1 and higher</li>\n<li>Version &#8211; The Events Calendar 6.1.2 is only compatible with Event Automator 1.3.1 and higher</li>\n<li>Fix &#8211; Lock our container usage(s) to the new Service_Provider contract in tribe-common. This prevents conflicts and potential fatals with other plugins that use a di52 container.</li>\n</ul>\n<h4>[6.1.1] 2023-06-15</h4>\n<ul>\n<li>Feature &#8211; Include Events data into the Tickets Email for compatibility with Event Tickets. [ET-1552] [ET-1553] [ET-1601]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_general_settings_viewing_section</code>, <code>tribe_general_settings_editing_section</code>, <code>tribe_general_settings_maintenance_section</code>, <code>tribe_general_settings_debugging_section</code></li>\n<li>Tweak &#8211; Removed filters: <code>tec_events_integrations_should_load</code>, <code>tec_events_integrations_{$type}_should_load</code>, <code>tec_events_integrations_{$type}_{$slug}_should_load</code>, <code>tribe_events_integrations_should_load_freemius</code></li>\n<li>Tweak &#8211; Added actions: <code>tec_telemetry_modal</code></li>\n<li>Tweak &#8211; Changed views: <code>integrations/event-tickets/emails/template-parts/body/event/date</code>, <code>integrations/event-tickets/emails/template-parts/body/event/image</code>, <code>integrations/event-tickets/emails/template-parts/body/event/links</code>, <code>integrations/event-tickets/emails/template-parts/body/event/links/gcal</code>, <code>integrations/event-tickets/emails/template-parts/body/event/links/ical</code>, <code>integrations/event-tickets/emails/template-parts/body/event/venue</code>, <code>integrations/event-tickets/emails/template-parts/body/event/venue/address</code>, <code>integrations/event-tickets/emails/template-parts/body/event/venue/phone</code>, <code>integrations/event-tickets/emails/template-parts/body/event/venue/website</code>, <code>integrations/event-tickets/emails/template-parts/header/head/tec-styles</code></li>\n<li>Language &#8211; 28 new strings added, 132 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.1.0.1] 2023-06-14</h4>\n<ul>\n<li>Fix &#8211; Prevent fatals when older version of Event Tickets was looking for Freemius code that was removed.</li>\n</ul>\n<h4>[6.1.0] 2023-06-14</h4>\n<ul>\n<li>Feature &#8211; Replace Freemius with Telemetry &#8211; an in-house info system. [TEC-4700]</li>\n<li>Feature &#8211; Add plugin info to Site Health admin page. [TEC-4701]</li>\n<li>Fix &#8211; Elementor and other themes would inadvertently override styles on the tickets button, when the global styles were set. This hardens the common button (rsv/ticket button) styles a bit more. [TEC-4794]</li>\n<li>Fix &#8211; Added option to disable pagination on the Month and Week views to address issue of missing events. [TEC-4615]</li>\n<li>Fix &#8211; Avoid SQL error when filtering by Series in Custom Tables v1 context. [ET-1486]</li>\n<li>Fix &#8211; Fixes database error, caused by the CT1 query parser when attempting rewrite the order by statement. Added logic to reflect on meta query arrays, and not just key/value pairs. [ECP-1495]</li>\n<li>Fix &#8211; In block editor there were unnecessary geocode API calls being triggered for Event Venue blocks. Moved logic within stateful conditions, now it no longer runs fetch if the address has not actually changed. [TEC-4741]</li>\n<li>Fix &#8211; Prevent administration navigation fatal error with <code>TypeError: array_search()</code>. [TEC-4780]</li>\n<li>Fix &#8211; Removing our eager schema updates. This was causing a number of <code>ALTER</code> statements being run redundantly. No longer utilizes cache/transient for the last run check as it is not dependable. [TEC-4797]</li>\n<li>Fix &#8211; This fixes a situation where cache would cause the <code>post</code> reference to switch to the initial <code>post</code> mid-loop on the admin events list page. This likely could have been happening on other pages as well. [TEC-4690]</li>\n<li>Tweak &#8211; Ensure the page titles on the single venue and organizer pages include the respective post titles for improved SEO. [ECP-1173]</li>\n<li>Tweak &#8211; Updates title tags on events pages, to be more unique and search specific, taking on formats like &#8220;Events from February 2, 2017 &#8211; February 3, 2019&#8221;. [TEC-4692]</li>\n<li>Tweak &#8211; Utilize our new container architecture in tribe-common.</li>\n<li>Language &#8211; 1 new strings added, 22 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.13.1] 2023-05-15</h4>\n<ul>\n<li>Fix &#8211; In block editor there were unnecessary geocode API calls being triggered for Event Venue blocks. Moved logic within stateful conditions, now it no longer runs fetch if the address has not actually changed. [TEC-4741]</li>\n<li>Language &#8211; 0 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.13] 2023-05-08</h4>\n<ul>\n<li>Fix &#8211; Correct issue with event subscriptions not passing events past the first 30. [TEC_4584]</li>\n<li>Fix &#8211; Ensure Events are displayed correctly on Elementor&#8217;s <code>Posts</code> widget. [TEC-4685]</li>\n<li>Fix &#8211; Fix a <code>Fatal error: Uncaught TypeError: Illegal offset type in isset or empty in …/wp-content/plugins/sitepress-multilingual-cms/classes/url-handling/converter/class-wpml-url-cached-converter.php:46</code> fatal with our WPML integration when filtering Event permalinks for Event views. [TEC-4770]</li>\n<li>Fix &#8211; Fixed an edge case to not inadvertently trash entire Events Pro recurrences. [ECP-1475]</li>\n<li>Fix &#8211; For CT1 in markers the occurrence would sometimes not be the same one found as the date field, only one was filtering by post_status. We were only using <code>provisional_id</code> for CT1, now we fallback to <code>post_id</code>. Now removing options when no occurrences are found, instead of retaining a stale value. [TEC-4768]</li>\n<li>Fix &#8211; Pass a NOOP callback function to Google Maps scripts to prevent JS warnings. [TEC-4762]</li>\n<li>Fix &#8211; Some button style hardening to prevent some common theme global style bleed, namely from Elementor global styles. [TEC-4677]</li>\n<li>Tweak &#8211; Added filter <code>tec_events_event_cleaner_trash_cron_frequency</code> to allow customizing the frequency of the trash old event cron. [ECP-1475]</li>\n<li>Tweak &#8211; Deprecated some event cleaner functionality. When 6.0 data structure is activated the <code>Permanently delete events older than</code> option is disabled, added an adjusted tooltip on the <code>Move to trash events older than</code> event setting regarding <code>EMPTY_TRASH_DAYS</code>. [TEC-4744]</li>\n<li>Tweak &#8211; Ensure the <code>Subscribe to Calendar</code> dropdown toggles on and off on click for an improved user experience. [TEC-4388]</li>\n<li>Tweak &#8211; Ensure we have the ability to hide the Event Tickets Activation notice using the <code>defined( \'TRIBE_HIDE_UPSELL\' )</code> constant. [TEC-4767]</li>\n<li>Tweak &#8211; Updates to <code>tribe_events_delete_old_events_sql_args</code> and <code>tribe_events_delete_old_events_sql</code> filters to support Events Pro recurrence cleanup. [ECP-1475]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_known_range_stati</code>, <code>tec_events_custom_tables_v1_events_only_modifier_before_get_posts</code>, <code>tec_events_event_cleaner_trash_cron_frequency</code>, <code>tec_events_linked_posts_my_posts_post_status</code>, <code>tec_events_linked_posts_all_posts_post_status</code>, <code>tribe_events_add_canonical_tag</code></li>\n<li>Tweak &#8211; Added actions: <code>tec_events_custom_tables_v1_fully_activated</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-tags</code>, <code>blocks/parts/details</code>, <code>v2/list/event/venue</code></li>\n<li>Language &#8211; 1 new strings added, 32 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.12] 2023-04-10</h4>\n<ul>\n<li>Fix &#8211; Avoid JS error when using the first compact date display format together with WPML. [TEC-4360]</li>\n<li>Fix &#8211; Build secondary Views navigation links correctly when WPML is active. [TEC-4689]</li>\n<li>Fix &#8211; Build the link to the Events page from the Permalinks settings page correctly. [TEC-4689]</li>\n<li>Fix &#8211; Correctly handle the creation or update of Custom Tables v1 in multisite context. (thanks @jiadil). [BTRIA-1734]</li>\n<li>Fix &#8211; Ensure the link to the Event Tags Archive page is correct when using the Block Editor. [TEC-4716]</li>\n<li>Fix &#8211; Ensure the venue country is displayed in the list view when venues are created through the block editor interface. [TEC-4731]</li>\n<li>Fix &#8211; Fix issue with events post type bleeding in on custom tag queries, instead of only on tag archive page. [TEC-4694]</li>\n<li>Fix &#8211; Fixed a situation where an invalid request header in our pagination would cause some strict security settings to block these AJAX requests. [TEC-4723]</li>\n<li>Fix &#8211; Fixes an edge case where running get_posts() twice with a taxonomy query, would result in an extra where statement added limiting results in an unexpected way. [TEC-4695]</li>\n<li>Fix &#8211; Fixes situation in block editor where a default organizer would not persist after being saved. [ECP-1061]</li>\n<li>Fix &#8211; Make improvements to the canonical tags added to event views to improve compatibility with SEO plugins. [TEC-4693]</li>\n<li>Fix &#8211; Resolve the issue of the WP customizer not loading correctly when the Colbri Page Builder plugin is active. [TEC-4735]</li>\n<li>Fix &#8211; Updates the Monolog repository to use TEC namespacing via Strauss, to provide more compatibility with other plugins. [TEC-4730]</li>\n<li>Tweak &#8211; Added filter: <code>tec_events_custom_tables_v1_events_only_modifier_before_get_posts</code> in our 6.0 query modifier, useful to make changes to the query prior to fetching posts for the selected events. [TEC-4695]</li>\n<li>Tweak &#8211; Added Filters: <code>tec_events_linked_posts_my_posts_post_status</code>, <code>tec_events_linked_posts_all_posts_post_status</code> to allow filtering of post status of Linked Posts. [CE-27]</li>\n<li>Tweak &#8211; Ensure we only have a single  element in the single events page for improved accessibility. [TEC-3415]</li>\n<li>Tweak &#8211; Fire the <code>tec_events_custom_tables_v1_fully_activated</code> when the Custom Tables v1 implementation is fully loaded. [ET-1495]</li>\n<li>Tweak &#8211; Replace the use of <code>FILTER_SANITIZE_STRING</code> in favour of <code>tec_sanitize_string</code> to improve PHP 8.1 compatibility. [TEC-4666]</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_custom_tables_v1_events_only_modifier_before_get_posts</code>, <code>tec_events_linked_posts_my_posts_post_status</code>, <code>tec_events_linked_posts_all_posts_post_status</code>, <code>tribe_events_add_canonical_tag</code></li>\n<li>Tweak &#8211; Added actions: <code>tec_events_custom_tables_v1_fully_activated</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-tags</code>, <code>blocks/parts/details</code>, <code>v2/list/event/venue</code></li>\n<li>Language &#8211; 0 new strings added, 82 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.11] 2023-03-20</h4>\n<ul>\n<li>Fix &#8211; Add a default Schema eventStatus value for JSON LD output of events. [TEC-4609]</li>\n<li>Fix &#8211; Avoid fatal error in <code>tribe_events_event_classes</code> when called on events that aren&#8217;t assigned to any category. [TEC-4709]</li>\n<li>Fix &#8211; Avoid PHP errors originating from a missing HTML template when the migration to Custom Tables v1 is not required. [ECP-1472]</li>\n<li>Fix &#8211; Correctly display Recurring Event Venue and Organizer details on the front-end and back-end when using WPML. [ECP-1442, ECP-1455]</li>\n<li>Fix &#8211; Display Venue correctly in List-like views when using WPML. [ECP-1443]</li>\n<li>Fix &#8211; Ensure the date tags for recurring events are displayed correctly in the <code>Events List</code> widget. [ECP-1382]</li>\n<li>Fix &#8211; Ensure the Subscribe to Calendar Dropdown opens and closes consistently across all themes. [TEC-4388]</li>\n<li>Fix &#8211; Failures while saving Events from Blocks Editor while using WPML. [ECP-1429]</li>\n<li>Fix &#8211; Fix an issue that stopped the default venue values from populating when submitting a Community Event. [CE-178]</li>\n<li>Fix &#8211; Fix the pagination styling on the Aggregator import preview data table. [TEC-4698]</li>\n<li>Fix &#8211; Link to the correct Occurrence when using CT1 and WPML. [TEC-4632]</li>\n<li>Fix &#8211; Prevent event save processing from being interrupted in cases of partial WPML activation where a language code is missing. [ECP-1442]</li>\n<li>Fix &#8211; Prevent fatal on PHP 8+ during generation of the activation report when issues exist.</li>\n<li>Fix &#8211; Prevent fatal on PHP 8+ for <code>tribe_get_event_cat_slugs</code> with bad typing around <code>array_filter</code> [TEC-4725]</li>\n<li>Fix &#8211; Prevent PHP 8.0+ fatal around iCal exporting with param not being array [TEC-4726]</li>\n<li>Tweak &#8211; Add empty alt tag to featured images across all views when a user doesn&#8217;t explicitly define one to improve SEO. [ECP-1454]</li>\n<li>Tweak &#8211; Ensure all instances of the <code>tribe_get_events_title</code> filter have matching signatures. [TEC-3929]</li>\n<li>Tweak &#8211; Modified single-event.php to use <code>tribe_get_formatted_cost</code> instead of <code>tribe_get_cost</code> to display the event cost. [TEC-4699]</li>\n<li>Tweak &#8211; Update the datepicker label on list-style views to <code>Upcoming</code> when no events are found. [TEC-3960]</li>\n<li>Tweak &#8211; Removed actions: <code>tribe_log</code></li>\n<li>Tweak &#8211; Changed views: <code>single-event</code>, <code>v2/day/event/featured-image</code>, <code>v2/latest-past/event/featured-image</code>, <code>v2/list/event/featured-image</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/featured-image</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/featured-image</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/featured-image</code>, <code>v2/widgets/widget-events-list/event/date-tag</code></li>\n<li>Language &#8211; 0 new strings added, 24 updated, 2 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.10] 2023-02-22</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.0.10 is only compatible with Events Calendar PRO 6.0.9 and higher</li>\n<li>Tweak &#8211; PHP version compatibility bumped to PHP 7.4</li>\n<li>Tweak &#8211; Version Composer updated to 2</li>\n<li>Tweak &#8211; Version Node updated to 18.13.0</li>\n<li>Tweak &#8211; Version NPM update to 8.19.3</li>\n<li>Tweak &#8211; Reduce JavaScript bundle sizes for Blocks editor</li>\n</ul>\n<h4>[6.0.9] 2023-02-09</h4>\n<ul>\n<li>Feature: Add a notice with install functionality for Event Tickets. [TEC-4663]</li>\n<li>Fix &#8211; Added safeguard against the <code>rewrite_rules_array</code> filter being passed non-array values, more error checking in WPML integration. [TEC-4679]</li>\n<li>Fix &#8211; Updating some button styles to be more compatible with global button styles, such as Elementor global styling. [TEC-4653]</li>\n<li>Fix &#8211; Ensure custom tables data is correctly updated when duplicating an Event using WPML. [TEC-4651]</li>\n<li>Fix &#8211; Ensure the zoom level set under <code>Events → Settings → Display → Google Maps default zoom level</code> is applied to the single events page. [TEC-4634]</li>\n<li>Fix &#8211; Ensure the code will work correctly when the Events&#8217; category taxonomy is unregistered. [TEC-4664]</li>\n<li>Fix &#8211; Change the type of the date-related custom tables date fields to VARCHAR to avoid warnings on stricter SQL modes. [TEC-4536]</li>\n<li>Fix &#8211; Add logic to our template tags to handle non-string returns from <code>get_the_terms_list()</code> [TEC-4664]</li>\n<li>Tweak &#8211; Add support for opt-in direct deletion of EA older records using the <code>tec_event_aggregator_direct_record_deletion</code> filter or setting the <code>TEC_EVENT_AGGREGATOR_RECORDS_PURGE_DIRECT_DELETION</code> constant. [EA-446]</li>\n<li>Tweak &#8211; Ensure all Google Map iframes have a title attribute to improve accessibility. [TEC-4243]</li>\n<li>Tweak &#8211; Allow filtering the redirected nature of a Views v2 request using the <code>tec_events_views_v2_redirected</code> filter. [TEC-4511]</li>\n<li>Tweak &#8211; Added filters: <code>tec_event_aggregator_direct_record_deletion</code>, <code>tec_event_aggregator_direct_record_deletion_batch_size</code>, <code>tec_events_views_v2_redirected</code></li>\n<li>Tweak &#8211; Changed views: <code>modules/map-basic</code></li>\n<li>Language &#8211; 6 new strings added, 125 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.8] 2023-01-26</h4>\n<ul>\n<li>Fix &#8211; Modifications to custom tables registration to ensure all sites get the new 6.0 table schema, preventing 404 and other related issues. [TEC-4631]</li>\n<li>Fix &#8211; Prevent Yoast SEO 19.2 notice due to integration with The Events Calendar [TEC-4662]</li>\n<li>Feature &#8211; Add Event Automator to Add-ons page. [TEC-4660]</li>\n<li>Language &#8211; 5 new strings added, 171 updated, 1 fuzzied, and 8 obsoleted.</li>\n</ul>\n<h4>[6.0.7.1] 2023-01-19</h4>\n<ul>\n<li>Fix &#8211; Prevent fatal when using The Events Calendar with Event Tickets due to Common library not being updated.</li>\n</ul>\n<h4>[6.0.7] 2023-01-18</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.0.7 is only compatible with Events Calendar PRO 6.0.6 and higher</li>\n<li>Fix &#8211; Event repository filters, when passing UTC dates on non-UTC event date fields, when using <code>Condense Event Series</code> showing tomorrow&#8217;s event instead of today&#8217;s. [ECP-1423]</li>\n<li>Fix &#8211; Resolve problem with relative dates on REST endpoint for event creation. Dates would potentially cross timezones that would push to an incorrect day due to using the wrong timezone.</li>\n<li>Fix &#8211; Prevent Update page from display on minor updates, only for major updates and feature updates. [TEC-4589]</li>\n<li>Fix &#8211; Compatibility with Redis Object Cache plugin that would cause Events not be editable in the Blocks Editor. [TEC-4613]</li>\n<li>Fix &#8211; Avoid user locale overriding the site locale during rewrite rules generation. [TEC-3733]</li>\n<li>Fix &#8211; Correct logic for tribe_is_view functions to account for default view. [TEC-4586]</li>\n<li>Fix &#8211; Avoid the issue of events which have venues assigned not being able to be updated successfully on some browsers. [TEC-4596]</li>\n<li>Fix &#8211; Handle the case where rewrite rules map to arrays avoiding fatal errors. [TEC-4567]</li>\n<li>Fix &#8211; Prevent primary cause of MySQL <code>Deadlock</code> errors in 6.0 event migration and added <code>Deadlock</code> error catching in our lock/fetch event queue. [TEC-4548]</li>\n<li>Fix &#8211; Avoid running slow query for adjacent events when possible. [TEC-4633]</li>\n<li>Fix &#8211; Ensure we did not get an error object back when requesting event category. [TEC-4619]</li>\n<li>Fix &#8211; Fix the issue of an invalid property error notice being thrown while visiting the Attendee Registration page as an admin. [TEC-4608]</li>\n<li>Fix &#8211; Resolve compatibility issue between Yoast SEO and FacetWP. [TEC-4628]</li>\n<li>Fix &#8211; Resolve the issue where <code>tribe_is_upcoming()</code> and other conditionals were not working as expected. [TEC-4301]</li>\n<li>Tweak &#8211; Convert all uses of (view)-&gt;get_slug() to (view)::get_view_slug(). [TEC-4586]</li>\n<li>Tweak &#8211; Change some labelling of event settings in the admin. [TEC-4626]</li>\n<li>Tweak &#8211; Reorganize a few Event settings in the admin. [TEC-4627]</li>\n<li>Tweak &#8211; Add canonical tag to the head of all calendar views to prevent Google and other search engines from indexing URLs with custom URL parameters. [TEC-4538]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_views_v2_{$view_slug}_view_html_classes</code>, <code>tribe_events_views_v2_view_{$view_slug}_template_vars</code>, <code>tribe_events_views_v2_view_{$view_slug}_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_prev_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_next_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_link_label_format</code>, <code>tribe_events_views_v2_view_{$view_slug}_title</code>, <code>tribe_events_views_v2_view_{$view_slug}_messages</code>, <code>tribe_events_views_v2_view_{$view_slug}_breadcrumbs</code>, <code>tribe_events_views_v2_view_{$view_slug}_display_events_bar</code>, <code>tribe_events_views_v2_view_{$view_slug}_show_datepicker_submit</code>, <code>tribe_events_views_v2_view_{$view_slug}_public_views</code>, <code>tribe_events_views_v2_{$view_slug}_view_container_data</code>, <code>tribe_events_views_v2_{$view_slug}_show_latest_past_events_view</code>, <code>tribe_events_views_v2_{$view_slug}_events_per_day</code>, <code>tribe_events_views_v2_view_{$view_slug}_breakpoint_pointer</code>, <code>tribe_events_views_v2_view_{$view_slug}_breakpoints</code>, <code>tribe_events_views_v2_view_{$view_slug}_cached_html</code>, <code>tribe_events_views_v2_{$view_slug}_widget_repository_args</code>, <code>tribe_events_views_v2_{$view_slug}_widget_compatibility_classes</code>, <code>tribe_events_views_v2_{$view_slug}_widget_html_classes</code>, <code>tec_events_view_{$view_slug}_today_button_label</code>, <code>tec_is_view</code>, <code>tec_is_{$view_slug}_view</code></li>\n<li>Tweak &#8211; Removed filters: <code>tribe_events_views_v2_{$this-&gt;get_slug()}_view_html_classes</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_template_vars</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_url</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_prev_url</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_next_url</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_link_label_format</code>, <code>tribe_events_views_v2_view_{$slug}_title</code>, <code>tribe_events_views_v2_view_{$slug}_messages</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_breadcrumbs</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_display_events_bar</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_show_datepicker_submit</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_public_views</code>, <code>tribe_events_views_v2_{$this-&gt;get_slug()}_view_container_data</code>, <code>tribe_events_views_v2_{$this-&gt;get_slug()}_show_latest_past_events_view</code>, <code>tec_events_views_v2_{$this-&gt;slug}_view_global_repository_args</code>, <code>tribe_events_views_v2_{$this-&gt;slug}_events_per_day</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_breakpoint_pointer</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_breakpoints</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_cached_html</code>, <code>tribe_events_views_v2_{$this-&gt;get_slug()}_widget_repository_args</code>, <code>tribe_events_views_v2_{$this-&gt;get_slug()}_widget_compatibility_classes</code>, <code>tribe_events_views_v2_{$this-&gt;get_slug()}_widget_html_classes</code>, <code>tec_events_view_{$view_slug}_today_button_title</code></li>\n</ul>\n<h4>[6.0.6.2] 2022-12-16</h4>\n<ul>\n<li>Fix &#8211; Fix layout issues with Avada, Divi, and similar themes. [TEC-4623]</li>\n</ul>\n<h4>[6.0.6.1] 2022-12-14</h4>\n<ul>\n<li>Fix &#8211; Avoid fatal error in the <code>tribe_is_events_front_page</code> when called before global query object is initialized. [BTRIA-1556]</li>\n</ul>\n<h4>[6.0.6] 2022-12-14</h4>\n<ul>\n<li>Fix &#8211; Resolved a migration state problem in the view not being handled properly when preview is unsupported and a migration error happens simultaneously. [TEC-4482]</li>\n<li>Fix &#8211; Prevent a couple scenarios that would cause 404 pages on events. This addresses both an error from UTC offset validation failures and an issue where table renaming improperly created foreign keys that pointed to an invalid constraint target. [TEC-4578]</li>\n<li>Fix &#8211; Avoid query filtering issues where the Event post type would be incorrectly added to queries. [TEC-4588]</li>\n<li>Fix &#8211; Incorrect results when including Events in the main blog loop. [TEC-4474]</li>\n<li>Fix &#8211; Avoid errors when third-party plugins reference or use the <code>Tribe__Events__Query::pre_get_posts</code> method. [TEC-4540]</li>\n<li>Fix &#8211; Prevent Serializable interface deprecated error in PHP 8.1 when migrating events. [ECP-1319]</li>\n<li>Fix &#8211; Ensure the <code>Previous Events</code> button when using the <code>Event View</code> Elementor widget navigates correctly to the previous page. [FBAR-273]</li>\n<li>Fix &#8211; Ensure that when we hit a single-event ical endpoint we get a the correct single event. [TEC-4469]</li>\n<li>Fix &#8211; Avoid PHP fatal error on PHP 8.0+ in some settings&#8217; pages when setting the front page to the Main Events Page. [BTRIA-1545]</li>\n<li>Tweak &#8211; Add aria label to Google Maps iFrame embed to improve accessibility. [TEC-4404]</li>\n<li>Tweak &#8211; Prevent unbound query for previous URL on list based views, improving performance.</li>\n<li>Tweak &#8211; Additional views setup no longer run extra Database Query unnecessarily, improving performance.</li>\n<li>Tweak &#8211; Improve performance on the Settings page when dealing with a big dataset of events.</li>\n<li>Tweak &#8211; Improve performance on the <code>tribe_events()</code> and on the Event Views by removing an unnecessary JOIN for hiding of specific upcoming events.</li>\n<li>Tweak &#8211; Changed views: <code>modules/map-basic</code></li>\n<li>Language &#8211; 1 new strings added, 17 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.5] 2022-11-29</h4>\n<ul>\n<li>Fix &#8211; Fix for scenarios where fatal <code>Call to a member function get() on null in... the-events-calendar/src/Tribe/Query.php(46)</code> would occur when <code>$wp_query</code> global was not set. [TEC-4566]</li>\n<li>Fix &#8211; Add correct text domains to the Organizer block. [TEC-4466]</li>\n<li>Fix &#8211; Fix for stuck migrations when duplicate meta exists. [TEC-4547]</li>\n<li>Tweak &#8211; Added ability to filter v2 repository args on all View queries. [ECP-1372]</li>\n<li>Tweak &#8211; Reorganize the General and Display settings tab content. [TCMN-149]</li>\n<li>Tweak &#8211; New headers for the General and Display settings tabs. [TEC-4573]</li>\n<li>Tweak &#8211; Add view upsells for ECP on the settings display tab. [TEC-4572]</li>\n<li>Tweak &#8211; Add settings info boxes. [TEC-4574]</li>\n<li>Fix &#8211; Avoid issues when trying to import some .ics format files with Event Aggregator. [EA-461]</li>\n<li>Deprecation &#8211; <code>Tribe__Events__Editor__Compatibility::$blocks_editor_hidden_field_key</code>.</li>\n<li>Deprecation &#8211; <code>Tribe__Events__Main::do_addons_api_settings_tab()</code>, <code>Tribe__Events__Main::show_upgrade()</code>,<br />\n                Tribe__Events__Main::do_upgrade_tab(), <code>Tribe__Events__Main::general_settings_tab_fields()</code>,<br />\n                Tribe__Events__Main::display_settings_tab_fields(), <code>Tribe__Events__Main::tribe_settings_url()</code>.</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_custom_tables_v1_query_modifier_applies_to_query</code>, <code>tec_events_display_settings_tab_fields</code>, <code>tribe_general_settings_tab_fields</code></li>\n<li>Language &#8211; 118 new strings added, 287 updated, 10 fuzzied, and 88 obsoleted.</li>\n</ul>\n<h4>[6.0.4] 2022-11-15</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.0.4 is only compatible with Events Calendar PRO 6.0.3 and higher</li>\n<li>Feature &#8211; Include Yoast WordPress SEO OpenGraph integration. [TEC-4558][TEC-4561]</li>\n<li>Fix &#8211; Fix for fatal when adding Featured Venue Events widget on Appearance -&gt; Widgets screen. [ECP-1411]</li>\n<li>Fix &#8211; Fix for fatal error on Series page in PHP 7.3. [TEC-4549]</li>\n<li>Fix &#8211; Prevent error around Free regular expression for JSON-LD on updated views. Props @jonkastonka @saleck @randon [TEC-4570]</li>\n<li>Fix &#8211; Avoid fatal error when using PHP version 8.0 or above and the HyperDB plugin. [ECP-1360]</li>\n<li>Fix &#8211; Ensure view labels are translated appropriately. [TEC-4485]</li>\n<li>Fix &#8211; Errors and warnings in WP.com installations due to empty query results. [TEC-4543]</li>\n<li>Fix &#8211; Translation of Event Occurrences URL when using WPML and the Custom Tables V1 implementation. [ECP-1373]</li>\n<li>Fix &#8211; More robust type checking in Builder methods. [ECP-1402]</li>\n<li>Fix &#8211; Avoid <code>orderby</code> related database error in Custom Tables V1 context. [TEC-4555]</li>\n<li>Fix &#8211; Prevent error when updating Venue in sites using object cache. [TEC-4348]</li>\n<li>Fix &#8211; Prevent date format error when trying to subscribe to calendar in sites using object cache. [TEC-4459]</li>\n<li>Tweak &#8211; Clean up the Event Website block to make it more intuitive for users. [TEC-4352]</li>\n<li>Tweak &#8211; Update the venue website field to type URL. [TEC-4349]</li>\n<li>Tweak &#8211; Do not add date-based ordering to queries when using <code>none</code> or <code>rand</code> order. [TEC-4555]</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_integrations_should_load</code>, <code>tec_events_integrations_{$type}_should_load</code>, <code>tec_events_integrations_{$type}_{$slug}_should_load</code>, <code>tec_events_integrations_{$integration_type}_{$integration_slug}_events_schema_is_needed</code>, <code>tec_events_integrations_{$integration_type}_{$integration_slug}_json_ld_{$type}_data</code>, <code>tec_events_views_v2_view_label</code>, <code>tec_events_views_v2_{$slug}_view_label</code></li>\n<li>Tweak &#8211; Removed filters: <code>tribe_events_views</code>, <code>tribe_events_views_v2_manager_view_label_domain</code>, <code>tribe_events_views_v2_manager_{$slug}_view_label_domain</code>, <code>tribe_events_views_v2_manager_view_label</code>, <code>tribe_events_views_v2_manager_{$slug}_view_label</code></li>\n<li>Language &#8211; 3 new strings added, 144 updated, 0 fuzzied, and 0 obsoleted.</li>\n</ul>\n<h4>[6.0.3.1] 2022-11-03</h4>\n<ul>\n<li>Fix &#8211; Correct issues where early queries can interfere with View template redirects. [TEC-4554]</li>\n<li>Fix &#8211; Serialization and unserialization issues related to caching of post models. [TEC-4379]</li>\n<li>Fix &#8211; Prevent default WordPress occurrence query caching because we cache it ourselves. [TEC-4379]</li>\n<li>Tweak &#8211; Add the <code>tribe_get_venue_object_after</code> and <code>tribe_get_organizer_object_after</code> filters. [TEC-4379]</li>\n</ul>\n<h4>[6.0.3] 2022-10-31</h4>\n<ul>\n<li>Fix &#8211; Handle repository query filters correctly in custom tables context; fix a REST API issue. [ET-1567]</li>\n</ul>\n<h4>[6.0.2] 2022-10-20</h4>\n<ul>\n<li>Feature &#8211; Add initial integration with Restrict Content Pro. This hides any events on the calendar views that the user is not allowed to view. [ [TEC-4457]]</li>\n<li>Feature &#8211; Support the <code>strict_dates</code> REST API argument in the <code>/events</code> endpoint to control the inclusiveness of the date parameters. [TEC-4493]</li>\n<li>Feature &#8211; Support relative date parameters (e.g: <code>starts_before</code>, <code>ends_after</code> as REST API arguments in the <code>/events</code> endpoint to retrieve single day and multi-day events in a single search. [TEC-4493]</li>\n<li>Fix &#8211; Prevent problems with WordPress.com Memcache turning Event Single Pages into 404s after the first visit [TEC-4488]</li>\n<li>Fix &#8211; Add new function to properly escape event titles in URLs so they are better handled by rewrite rules. Props to @shisho585 for the fix! [TEC-4518]</li>\n<li>Fix &#8211; Avoid resetting post data in some Dive theme and plugins. [TEC-4510]</li>\n<li>Fix &#8211; Correct a few misnamed custom prop references. [TEC-4445]</li>\n<li>Fix &#8211; Correct an issue with event venue when saving in our WPML integration. Props to @dgwatkins for the fix! [TEC-4498]</li>\n<li>Fix &#8211; Correctly deprecate the <code>Tribe__Events__Main::get_closest_event</code> method. [ECP-1326]</li>\n<li>Fix &#8211; Correctly set <code>found_posts</code> and <code>max_num_pages</code> when redirecting a query to the custom tables. [TEC-4508]</li>\n<li>Fix &#8211; Do not run wasteful queries on <code>switch_blog</code> in multi-site installations. [TEC-4492]</li>\n<li>Fix &#8211; Do not throw errors during migration when notices or errors come from other plugins. [ECP-1318]</li>\n<li>Fix &#8211; Ensure <code>tribe_is_month</code> and <code>tribe_is_by_date</code> work as expected. [TEC-4509]</li>\n<li>Fix &#8211; Ensure we handle if By_Day_View gets a null $event_obj-&gt;dates. Props to @juliangumenita for the fix! [TEC-4509]</li>\n<li>Fix &#8211; Remove strict type hinting from Custom Tables v1 code that would cause fatals in some environments. [ECP-1343]</li>\n<li>Fix &#8211; Resolve problems with tribe_get_full_address() which was not properly returning venue address.</li>\n<li>Fix &#8211; Restore erroneously removed Events query filters that would result in out-of-order results. [TEC-4470]</li>\n<li>Fix &#8211; Revert the code erroneous removed on legacy views removal around the &#8220;Show events with the site&#8217;s other posts&#8221; setting.</li>\n<li>Fix &#8211; Prevent a potential fatal when WP-CLI isn&#8217;t present. [TEC-4470]</li>\n<li>Tweak &#8211; Move Month View day cell class logic to a standalone function with filters. [TEC-4457]</li>\n<li>Tweak &#8211; Add new method: <code>\\Tribe\\Events\\Views\\V2\\month_day_classes</code> [TEC-4457]</li>\n<li>Tweak &#8211; Added filter <code>tec_events_month_day_classes_comparison_date</code> to filter the date used for class determination comparisons. [TEC-4457]</li>\n<li>Tweak &#8211; Added filter <code>tec_events_month_day_classes</code> to filter the actual class list before it gets passed to the template. [TEC-4457]</li>\n<li>Tweak &#8211; Update the organizer website field to type URL. [TEC-4395]</li>\n<li>Tweak &#8211; Add an event property for if the event is currently happening. [TEC-4454]</li>\n<li>Tweak &#8211; Create a filterable function <code>tec_events_get_today_button_label()</code> for the text on the &#8220;Today&#8221; button on calendar views. [TEC-4458]</li>\n<li>Tweak &#8211; Add a filter for the link title and aria-label so they match the button text more closely. [TEC-4458]</li>\n<li>Tweak &#8211; Added filters: <code>tec_events_today_button_label</code> and <code>tec_events_view_{view_slug}_today_button_label</code> to filter the output of the <code>tec_events_get_today_button_label</code> function<br />\n                         tec_events_today_button_title and <code>tec_events_{view_slug}_view_today_button_title</code> to filter the link title and aria-label. [TEC-4458]</li>\n<li>Tweak &#8211; Speed up the Custom Tables v1 migration process if a browser window is open on the migration UI. [TEC-4517]</li>\n<li>Language &#8211; 11 new strings added, 149 updated, 2 fuzzied, and 2 obsoleted.</li>\n</ul>\n<h4>[6.0.1.1] 2022-09-29</h4>\n<ul>\n<li>Fix &#8211; Prevent Google Calendar duplicated Events from Importing with Aggregator. [TEC-4497]</li>\n</ul>\n<h4>[6.0.1] 2022-09-22</h4>\n<ul>\n<li>Fix &#8211; Prevent network deactivation from overwriting the subsite settings with main site cached settings. [TEC-3738]</li>\n<li>Fix &#8211; Correct some translation domains pointing to the wrong plugin. [TEC-4450]</li>\n<li>Fix &#8211; Ensure the details in the single event page are accurate for Divi users who set any Divi template under Settings → Events template. [TEC-3814]</li>\n<li>Fix &#8211; Add caching to prevent duplicated queries for translated venue/organizer values. props to @dgwatkins for the suggested fix! [TEC-4428]</li>\n<li>Fix &#8211; Check the document for <code>lang</code> and <code>rtl</code> attributes and pass them on to the datepicker so it adapts properly. [TEC-4452]</li>\n<li>Fix &#8211; Corrected an issue where the Organizer Block was showing the &#8220;Add Another Organizer&#8221; button when no organizers were selected. [CE-11]</li>\n<li>Fix &#8211; Corrected an issue where the &#8220;Edit Venue&#8221; and &#8220;Edit Organizer&#8221; links were displaying with no link. [CE-165]</li>\n<li>Fix &#8211; Correct migration error when The Events Calendar PRO is not active. [TEC-4475]</li>\n<li>Fix &#8211; Normalize, reformat and rebuild Event date-related meta to fix a number of migration preview failures [ECP-1304]</li>\n<li>Fix &#8211; Correct a problem with moving tickets when The Events Calendar PRO is not active. [TEC-4471]</li>\n<li>Fix &#8211; Correct an issue with migrating past events that straddle Daylight Savings Time. [ECP-1270]</li>\n<li>Fix &#8211; Fix the Community Events recurrence link. [ECP-1215]</li>\n<li>Tweak &#8211; Add some helpful knowledgebase article links to the CSV import screen. [TEC-4353]</li>\n<li>Tweak &#8211; Ensure the Fast-forward link uses the correct, customizable color as other links. [TEC-3962]</li>\n<li>Tweak &#8211; Include Custom Tables Migration in the Support System Information array. [ECP-1316]</li>\n<li>Tweak &#8211; Add compatibility for new &#8220;Convert to single&#8221; option in The Events Calendar PRO. [ECP-1308]</li>\n<li>Language &#8211; 5 new strings added, 163 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[6.0.0.1] 2022-09-07</h4>\n<ul>\n<li>Fix &#8211; Prevent <code>E_ERROR</code> from showing up when calling <code>tribe_context()-&gt;is( \'is_main_query\' )</code> too early in execution. [TEC-4464]</li>\n</ul>\n<h4>[6.0.0] 2022-09-06</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 6.0.0 is only compatible with Events Calendar PRO 6.0.0 and higher</li>\n<li>Feature &#8211; Custom tables and optimization of Cache Primers to enable reduced and stabilized number of queries on Event views.</li>\n<li>Feature &#8211; Inclusion of Event Occurrences custom table <code>{$prefix}_tec_occurrences</code>.</li>\n<li>Feature &#8211; Inclusion of Events custom table <code>{$prefix}_tec_events</code>.</li>\n<li>Tweak &#8211; Legacy views are now fully deprecated and most of the template files and code was removed, please see other changelog items to see modifications.</li>\n<li>Language &#8211; 123 new strings added, 296 updated, 0 fuzzied, and 161 obsoleted</li>\n<li>Tweak &#8211; Methods marked as deprecated: <code>Tribe__Events__Main::add_new_organizer</code>, <code>Tribe__Events__Main::default_view</code>, <code>Tribe__Events__Main::fullAddress</code>, <code>Tribe__Events__Main::fullAddressString</code>, <code>Tribe__Events__Main::getDateStringShortened</code>, <code>Tribe__Events__Main::getPostTypes</code>, <code>Tribe__Events__Main::googleCalendarLink</code>, <code>Tribe__Events__Main::googleMapLink</code>, <code>Tribe__Events__Main::monthNames</code>, <code>Tribe__Events__Main::nextMonth</code>, <code>Tribe__Events__Main::previousMonth</code>, <code>Tribe__Events__Main::setDisplay</code></li>\n<li>Tweak &#8211; Functions moved to <code>src/functions/template-tags/deprecated</code>: <code>tribe_events_the_header_attributes</code>, <code>tribe_get_next_day_date</code>, <code>tribe_get_previous_day_date</code></li>\n<li>Tweak &#8211; Functions/methods refactored:  <code>tribe_events_is_view_enabled</code>, <code>tribe_is_ajax_view_request</code>, <code>tribe_meta_event_category_name</code></li>\n<li>Tweak &#8211; Functions/Methods Removed:  <code>tribe_get_list_widget_events</code>, <code>Tribe__Events__Main::register_list_widget</code>, <code>Tribe__Events__Main::init_day_view</code>, <code>Tribe__Events__Main::eventQueryVars</code>, <code>Tribe__Events__Main::ecpActive</code>, <code>Tribe__Events__Main::dateHelper</code>, <code>Tribe__Events__Main::dateToTimeStamp</code>, <code>Tribe__Events__Main::defaultValueReplaceEnabled</code>, <code>Tribe__Events__Main::addHelpAdminMenuItem</code>, <code>Tribe__Events__Main::getNotices</code>, <code>Tribe__Events__Main::removeNotice</code>, <code>Tribe__Events__Main::isNotice</code>, <code>Tribe__Events__Main::setNotice</code>, <code>Tribe__Events__Main::renderDebug</code>, <code>Tribe__Events__Main::debug</code>, <code>Tribe__Events__Main::truncate</code>, <code>Tribe__Events__Main::saveAllTabsHidden</code>, <code>Tribe__Events__Main::doNetworkSettingTab</code>, <code>Tribe__Events__Main::addNetworkOptionsPage</code>, <code>Tribe__Events__Main::setNetworkOptions</code>, <code>Tribe__Events__Main::getNetworkOption</code>, <code>Tribe__Events__Main::getNetworkOptions</code>, <code>Tribe__Events__Main::setOption</code>, <code>Tribe__Events__Main::setOptions</code>, <code>Tribe__Events__Main::getOption</code>, <code>Tribe__Events__Main::getOptions</code>, <code>Tribe__Events__Main::getTagRewriteSlug</code>, <code>Tribe__Events__Main::getTaxRewriteSlug</code>, <code>Tribe__Events__Main::doHelpTab</code>, <code>Tribe__Events__Main::doSettingTabs</code>, <code>Tribe__Events__Main::array_insert_before_key</code>, <code>Tribe__Events__Main::array_insert_after_key</code>, <code>Tribe__Events__Main::add_post_type_to_edit_term_link</code>, <code>Tribe__Events__Main::prepare_to_fix_tagcloud_links</code>, <code>Tribe__Events__Main::saved_organizers_dropdown</code>, <code>Tribe__Events__Main::saved_venues_dropdown</code>, <code>Tribe__Events__Main::set_meta_factory_global</code>, <code>Tribe__Events__Main::initOptions</code>, <code>Tribe__Events__Main::loadTextDomain</code>, <code>Tribe__Events__Main::common</code>, <code>Tribe__Events__Main::issue_noindex</code>, <code>Tribe__Events__Main::displayEventOrganizerDropdown</code>, <code>Tribe__Events__Main::displayEventVenueDropdown</code>, <code>Tribe__Events__Main::checkAddOnCompatibility</code>, <code>Tribe__Events__Main::maybe_delay_activation_if_outdated_common</code>, <code>Tribe__Events__Main::is_delayed_activation</code>, <code>Tribe__Events__Main::get_event_link</code>, <code>Tribe__Events__Main::get_closest_event</code>, <code>Tribe__Events__Main::setPostExceptionThrown</code>, <code>Tribe__Events__Main::getPostExceptionThrown</code>, <code>Tribe__Events__Main::manage_preview_metapost</code>, <code>Tribe__Events__Main::setDashicon</code>, <code>Tribe__Events__Main::printLocalizedAdmin</code>, <code>Tribe__Events__Main::localizeAdmin</code>, <code>Tribe__Events__Main::asset_fixes</code>, <code>Tribe__Events__Main::add_admin_assets</code>, <code>Tribe__Events__Main::loadStyle</code>, <code>Tribe__Events__Main::enqueue_wp_admin_menu_style</code>, <code>Tribe__Events__Main::get_closest_event_where</code>, <code>Tribe__Events__Main::setup_listview_in_bar</code>, <code>Tribe__Events__Main::setup_gridview_in_bar</code>, <code>Tribe__Events__Main::setup_dayview_in_bar</code>, <code>Tribe__Events__Main::setup_date_search_in_bar</code>, <code>Tribe__Events__Main::remove_hidden_views</code>, <code>Tribe__Events__Main::setup_keyword_search_in_bar</code>, <code>Tribe__Events__Main::OrganizerMetaBox</code>, <code>Tribe__Events__Main::VenueMetaBox</code>, <code>Tribe__Events__Main::EventsChooserBox</code>, <code>Tribe__Events__Main::normalize_organizer_submission</code>, <code>Tribe__Events__Main::get_i18n_strings_for_domains</code>, <code>Tribe__Events__Main::get_i18n_strings</code>, <code>Tribe__Events__Main::redirect_past_upcoming_view_urls</code>, <code>Tribe__Events__Main::getOrganizerPostTypeArgs</code>, <code>Tribe__Events__Main::getVenuePostTypeArgs</code>, <code>Tribe__Events__Main::disable_pro</code>, <code>Tribe__Events__Main::template_redirect</code>, <code>Tribe__Events__Main::handle_submit_bar_redirect</code>, <code>Tribe__Events__Main::print_noindex_meta</code>, <code>Tribe__Events__Query::init</code>, <code>Tribe__Events__Query::parse_query</code>, <code>Tribe__Events__Query::pre_get_posts</code>, <code>Tribe__Events__Query::default_page_on_front</code>, <code>Tribe__Events__Query::multi_type_posts_fields</code>, <code>Tribe__Events__Query::posts_join</code>, <code>Tribe__Events__Query::posts_fields</code>, <code>Tribe__Events__Query::posts_results</code>, <code>Tribe__Events__Query::posts_where</code>, <code>Tribe__Events__Query::posts_orderby_venue_organizer</code>, <code>Tribe__Events__Query::posts_join_venue_organizer</code>, <code>Tribe__Events__Query::posts_distinct</code>, <code>Tribe__Events__Query::posts_orderby</code>, <code>Tribe__Events__Query::set_orderby</code>, <code>Tribe__Events__Query::set_order</code>, <code>Tribe__Events__Query::getHideFromUpcomingEvents</code>, <code>Tribe__Events__Query::getEventCounts</code>, <code>Tribe__Events__Query::last_found_events</code>, <code>Tribe__Events__Query::postmeta_table</code>, <code>Tribe__Events__Query::can_inject_date_field</code>, <code>Tribe__Events__Query::should_remove_date_filters</code>, <code>Tribe\\Events\\Views\\V2\\Widgets\\Service_Provider::unregister_list_widget</code>, <code>tribe_include_view_list</code>, <code>tribe_events_month_has_events_filtered</code>, <code>tribe_events_the_month_single_event_classes</code>, <code>tribe_events_the_month_day_classes</code>, <code>tribe_events_get_current_month_day</code>, <code>tribe_events_get_current_week</code>, <code>tribe_events_the_month_day</code>, <code>tribe_events_have_month_days</code>, <code>tribe_show_month</code>, <code>tribe_get_dropdown_link_prefix</code>, <code>tribe_events_get_filters</code>, <code>tribe_events_get_views</code>, <code>Tribe__Events__Template__Single_Event::setup_meta</code>, <code>Tribe__Events__Template_Factory::asset_package</code>, <code>Tribe__Events__Template_Factory::get_asset_factory_instance</code>, <code>Tribe__Events__Template_Factory::handle_asset_package_request</code>, <code>Tribe__Events__Template_Factory::setup_meta</code>, <code>tribe_initialize_view</code>, <code>Tribe__Events__Templates::init</code>, <code>Tribe__Events__Templates::instantiate_template_class</code>, <code>Tribe__Events__Templates::load_ecp_comments_page_template</code>, <code>Tribe__Events__Templates::load_ecp_into_page_template</code>, <code>Tribe__Events__Templates::maybe_modify_global_post_title</code>, <code>Tribe__Events__Templates::maybeSpoofQuery</code>, <code>Tribe__Events__Templates::modify_global_post_title</code>, <code>Tribe__Events__Templates::restore_global_post_title</code>, <code>Tribe__Events__Templates::setup_ecp_template</code>, <code>Tribe__Events__Templates::showInLoops</code>, <code>Tribe__Events__Templates::spoof_the_post</code>, <code>Tribe__Events__Templates::templateChooser</code>, <code>Tribe__Events__Templates::theme_body_class</code>, <code>Tribe__Events__Templates::add_singular_body_class</code>, <code>Tribe__Events__Templates::get_current_page_template</code>, <code>Tribe__Events__Templates::needs_compatibility_fix</code>, <code>Tribe__Events__Templates::remove_singular_body_class</code>, <code>Tribe__Events__Templates::restoreQuery</code>, <code>Tribe__Events__Templates::spoof_the_post</code>, <code>Tribe__Events__Templates::template_body_class</code>, <code>Tribe__Events__Templates::wpHeadFinished</code>, <code>event_grid_view</code>, <code>get_event_google_map_link</code>, <code>event_google_map_link</code>, <code>tec_get_event_address</code>, <code>tec_event_address</code>, <code>tec_address_exists</code>, <code>get_event_google_map_embed</code>, <code>event_google_map_embed</code>, <code>get_jump_to_date_calendar</code>, <code>the_event_start_date</code>, <code>the_event_end_date</code>, <code>the_event_cost</code>, <code>the_event_venue</code>, <code>the_event_country</code>, <code>the_event_address</code>, <code>the_event_city</code>, <code>the_event_state</code>, <code>the_event_province</code>, <code>the_event_zip</code>, <code>the_event_phone</code>, <code>the_event_region</code>, <code>the_event_all_day</code>, <code>is_new_event_day</code>, <code>get_events</code>, <code>tribe_event_link</code>, <code>events_displaying_past</code>, <code>events_displaying_upcoming</code>, <code>events_displaying_month</code>, <code>events_get_past_link</code>, <code>events_get_upcoming_link</code>, <code>events_get_next_month_link</code>, <code>events_get_previous_month_link</code>, <code>events_get_events_link</code>, <code>events_get_gridview_link</code>, <code>events_get_listview_link</code>, <code>events_get_listview_past_link</code>, <code>events_get_previous_month_text</code>, <code>events_get_current_month_text</code>, <code>events_get_next_month_text</code>, <code>events_get_displayed_month</code>, <code>events_get_this_month_link</code>, <code>sp_get_option</code>, <code>sp_calendar_grid</code>, <code>sp_calendar_mini_grid</code>, <code>sp_sort_by_month</code>, <code>sp_is_event</code>, <code>sp_get_map_link</code>, <code>sp_the_map_link</code>, <code>sp_get_full_address</code>, <code>sp_the_full_address</code>, <code>sp_address_exists</code>, <code>sp_get_embedded_map</code>, <code>sp_the_embedded_map</code>, <code>sp_month_year_dropdowns</code>, <code>sp_get_start_date</code>, <code>sp_get_end_date</code>, <code>sp_get_cost</code>, <code>sp_has_organizer</code>, <code>sp_get_organizer</code>, <code>sp_get_organizer_email</code>, <code>sp_get_organizer_website</code>, <code>sp_get_organizer_link</code>, <code>sp_get_organizer_phone</code>, <code>sp_has_venue</code>, <code>sp_get_venue</code>, <code>sp_get_country</code>, <code>sp_get_address</code>, <code>sp_get_city</code>, <code>sp_get_stateprovince</code>, <code>sp_get_state</code>, <code>sp_get_province</code>, <code>sp_get_zip</code>, <code>sp_get_phone</code>, <code>sp_previous_event_link</code>, <code>sp_next_event_link</code>, <code>sp_post_id_helper</code>, <code>sp_is_new_event_day</code>, <code>sp_get_events</code>, <code>sp_is_past</code>, <code>sp_is_upcoming</code>, <code>sp_is_month</code>, <code>sp_get_past_link</code>, <code>sp_get_upcoming_link</code>, <code>sp_get_next_month_link</code>, <code>sp_get_previous_month_link</code>, <code>sp_get_month_view_date</code>, <code>sp_get_single_ical_link</code>, <code>sp_get_events_link</code>, <code>sp_get_gridview_link</code>, <code>sp_get_listview_link</code>, <code>sp_get_listview_past_link</code>, <code>sp_get_dropdown_link_prefix</code>, <code>sp_get_ical_link</code>, <code>sp_get_previous_month_text</code>, <code>sp_get_current_month_text</code>, <code>sp_get_next_month_text</code>, <code>sp_get_displayed_month</code>, <code>sp_get_this_month_link</code>, <code>sp_get_region</code>, <code>sp_get_all_day</code>, <code>sp_is_multiday</code>, <code>sp_events_title</code>, <code>sp_meta_event_cats</code>, <code>sp_meta_event_category_name</code>, <code>sp_get_add_to_gcal_link</code>, <code>eventsGetOptionValue</code>, <code>events_by_month</code>, <code>is_event</code>, <code>getEventMeta</code>, <code>tribe_events_event_recurring_info_tooltip</code>, <code>tribe_the_map_link</code>, <code>tribe_the_embedded_map</code>, <code>tribe_the_full_address</code>, <code>tribe_get_organizer_website</code>, <code>tribe_get_venue_permalink</code>, <code>tribe_previous_event_link</code>, <code>tribe_next_event_link</code>, <code>display_day_title</code>, <code>display_day</code>, <code>tribe_meta_event_cats</code>, <code>tribe_get_all_day</code>, <code>tribe_is_multiday</code>, <code>tribe_calendar_grid</code>, <code>tribe_calendar_mini_grid</code>, <code>tribe_sort_by_month</code>, <code>tribe_month_year_dropdowns</code>, <code>tribe_get_this_month_link</code>, <code>tribe_get_displayed_month</code>, <code>tribe_get_display_day_title</code>, <code>tribe_the_display_day</code>, <code>tribe_get_display_day</code>, <code>tribe_get_object_property_from_array</code>, <code>tribe_mini_display_day</code>, <code>tribe_event_format_date</code>, <code>tribe_event_beginning_of_day</code>, <code>tribe_event_end_of_day</code>, <code>tribe_events_the_notices</code>, <code>tribe_get_the_day_link_date</code>, <code>tribe_get_the_day_link_label</code>, <code>tribe_the_day_link</code>, <code>tribe_get_linked_day</code>, <code>tribe_events_disabled_views</code>, <code>tribe_events_enabled_views</code>, <code>tribe_events_template_data</code>, <code>tribe_get_ticket_form</code>, <code>tribe_map_cost_array_callback</code>, <code>tribe_events_get_days_of_week</code>, <code>tribe_is_community_my_events_page</code>, <code>tribe_display_current_events_slug</code>, <code>tribe_display_current_single_event_slug</code>, <code>tribe_display_current_ical_link</code>, <code>tribe_is_new_event_day</code></li>\n<li>Tweak &#8211; Added filters: <code>tec_events_custom_tables_v1_upgrade_before</code>, <code>tec_events_custom_tables_v1_upgrade_after</code>, <code>tec_events_custom_tables_v1_should_render_maintenance_modal</code>, <code>tec_events_custom_tables_v1_migration_ajax_ui_renderer</code>, <code>tec_events_custom_tables_v1_migration_strategy</code>, <code>tec_events_custom_tables_v1_delete_meta_keys</code>, <code>tec_events_custom_tables_v1_migration_strategy_text_override_$action</code>, <code>tec_events_custom_tables_v1_migration_event_report_categories</code>, <code>tec_events_custom_tables_v1_migration_get_plugin_state_migration_addendum</code>, <code>tec_events_custom_tables_v1_event_data_from_post</code>, <code>tec_custom_tables_{$this-&gt;table}_model_v1_extensions</code>, <code>tec_events_custom_tables_v1_normalize_occurrence_id</code>, <code>tec_events_custom_tables_v1_occurrences_generator</code>, <code>tec_custom_tables_v1_get_occurrence_match</code>, <code>tec_events_custom_tables_v1_enabled</code>, <code>tec_events_custom_tables_v1_table_schemas</code>, <code>tec_events_custom_tables_v1_field_schemas</code>, <code>tec_events_custom_tables_v1_tables_to_drop</code>, <code>tec_events_custom_tables_v1_fields_to_drop</code>, <code>tec_events_custom_tables_v1_db_transactions_supported</code>, <code>tec_events_custom_tables_v1_should_update_custom_tables</code>, <code>tec_events_custom_tables_v1_commit_post_updates</code>, <code>tec_events_custom_tables_v1_updated_post</code>, <code>tec_events_custom_tables_v1_deleted_post</code>, <code>tec_events_custom_tables_v1_redirect_post_location</code>, <code>tribe_events_known_range_stati</code>, <code>tec_events_custom_tables_v1_request_factory_post_id_keys</code>, <code>tec_events_custom_tables_v1_custom_tables_query_vars</code>, <code>tec_events_custom_tables_v1_occurrence_select_fields</code>, <code>tec_events_custom_tables_v1_custom_tables_query_where</code>, <code>tec_events_custom_tables_v1_meta_key_redirection_map</code>, <code>tec_events_custom_tables_v1_show_series_title</code>, <code>tec_events_custom_tables_v1_series_marker_label_classes</code>, <code>tribe_events_assets_should_enqueue_admin_update_page_assets</code>, <code>tec_events_custom_tables_v1_blocks_editor_event_meta</code>, <code>tribe_events_linked_posts_should_render_meta_box</code>, <code>tec_events_upgrade_tab_has_content</code>, <code>tec_events_prime_cache_post_ids</code>, <code>tec_events_get_current_view</code>, <code>tribe_get_venue_website_link_target</code>, <code>tribe_get_venue_website_link_label</code>, <code>tribe_events_settings_default_fields_initializer</code></li>\n<li>Tweak &#8211; Removed filters: <code>aggregator_should_load_scripts</code>, <code>tribe-events-bar-should-show</code>, <code>widget_title</code>, <code>tribe_events_</code>, <code>tribe_events_widget_jsonld_enabled</code>, <code>tec_events_default_view</code>, <code>tribe_events_get_{$mode}_event_link</code>, <code>tribe_events_get_closest_event</code>, <code>tribe_events_get_event_link</code>, <code>tribe-events-bar-date-search-default-value</code>, <code>tribe_events_bar_date_search_default_value</code>, <code>tribe_bar_datepicker_caption</code>, <code>tribe_tec_addons</code>, <code>tribe_add_on_compatibility_errors</code>, <code>tribe_display_event_venue_dropdown_id</code>, <code>tribe_display_event_organizer_dropdown_id</code>, <code>tribe_events_category_rewrite_slug</code>, <code>tribe_events_tag_rewrite_slug</code>, <code>the_content</code>, <code>tribe_events_suppress_query_filters</code>, <code>tribe_query_can_inject_date_field</code>, <code>tec_events_query_default_view</code>, <code>tribe_events_query_include_start_date_meta</code>, <code>tribe_events_query_include_children</code>, <code>tribe_events_query_posts_fields</code>, <code>tribe_events_query_force_local_tz</code>, <code>tribe_events_query_posts_joins</code>, <code>tribe_events_query_end_date_column</code>, <code>tribe_events_query_posts_orderby</code>, <code>tribe_events_query_posts_join_orderby</code>, <code>tribe_events_query_posts_join_venue_organizer</code>, <code>tribe_events_hide_from_upcoming_ids</code>, <code>tribe_events_month_day_limit</code>, <code>tribe_enable_recurring_event_queries</code>, <code>tribe_events_day_view_title</code>, <code>tribe_events_day_timeslot_format</code>, <code>tribe_events_ajax_response</code>, <code>tribe_upcoming_events_title</code>, <code>tribe_past_events_title</code>, <code>tribe_events_listview_ajax_get_event_args</code>, <code>tribe_events_listview_ajax_event_display</code>, <code>tribe_events_month_view_transient_expiration</code>, <code>tribe_month_grid_view_title</code>, <code>tribe_events_this_month_title</code>, <code>tribe_events_month_get_events_in_month</code>, <code>tribe_events_month_daily_events</code>, <code>tribe_events_month_daily_events_query_args</code>, <code>tribe_themes_compatibility_fixes</code>, <code>tribe_set_global_post_title</code>, <code>tribe_events_current_template_class</code>, <code>tribe_event_meta_event_date</code>, <code>tribe_event_meta_event_category</code>, <code>tribe_event_meta_event_tag</code>, <code>tribe_event_meta_event_website</code>, <code>tribe_events_display_event_origin</code>, <code>tribe_event_meta_event_origin</code>, <code>tribe_event_meta_organizer_name</code>, <code>tribe_event_meta_organizer_email</code>, <code>tribe_event_meta_venue_name</code>, <code>tribe_event_meta_venue_address_gmap</code>, <code>tribe_event_meta_venue_address</code>, <code>tribe_event_meta_venue_map</code>, <code>tribe_events_kill_responsive</code>, <code>tribe_events_stylesheet_url</code>, <code>tribe_importer_url</code>, <code>tribe_events_hide_legacy_imports</code>, <code>tribe_events_import_type_titles_map</code>, <code>tribe_events_import_options_rows</code>, <code>tribe_events_import_options_default_selected</code>, <code>tribe-import-tabs</code>, <code>tribe_import_tabs</code>, <code>tribe_events_csv_batch_size</code>, <code>tribe-import-available-options</code>, <code>tribe_import_available_options</code>, <code>tribe-import-setting-</code>, <code>tribe_import_setting_</code>, <code>tribe_import_default_post_status_non_saved</code>, <code>tribe_import_default_post_status</code>, <code>tribe_import_possible_stati</code>, <code>tribe_import_default_encode_status_non_saved</code>, <code>tribe_import_default_encode_status</code>, <code>tribe_import_encoding_status</code>, <code>tribe_meta_factory_check_exists</code>, <code>tribe_meta_factory_get_args</code>, <code>tribe_meta_factory_template</code>, <code>tribe_get_linked_day</code>, <code>tribe_the_day_link</code>, <code>tribe_event_link</code>, <code>tribe_get_organizer_website</code>, <code>tribe_previous_event_link</code>, <code>tribe_next_event_link</code>, <code>tribe_meta_event_cats</code>, <code>tribe_get_all_day</code>, <code>tribe_is_multiday</code>, <code>tribe_get_ticket_form</code>, <code>tribe-events-bar-filters</code>, <code>tribe_is_new_event_day</code>, <code>tribe_events_get_current_month_day</code>, <code>tribe_events_the_month_day_class</code>, <code>tribe_events_the_month_single_event_classes</code>, <code>tribe_events_month_has_events_filtered</code>, <code>tribe_get_dropdown_link_prefix</code>, <code>tribe_get_list_widget_events</code>, <code>tribe_events_views_v2_is_enabled</code>, <code>tribe_events_views_v2_should_smart_activate</code>, <code>tribe_events_views_v2_use_period_repository</code>, <code>tribe_events_widgets_v2_is_enabled</code>, <code>tribe_events_single_view_v2_is_enabled</code>, <code>tec_events_views_v1_should_display_deprecated_notice</code>, <code>tribe_events_day_view_event_type</code>, <code>tribe_default_events_template_classes</code>, <code>tribe_events_list_view_event_type</code>, <code>tribe_events_list_widget_thumbnail_size</code>, <code>tribe_events_list_widget_featured_image_link</code></li>\n<li>Tweak &#8211; Added actions: <code>tec_events_custom_tables_v1_error</code>, <code>tribe_log</code>, <code>tec_events_custom_tables_v1_migration_maintenance_mode</code>, <code>tec_events_custom_tables_v1_before_migration_applied</code>, <code>tec_events_custom_tables_v1_migration_before_cancel</code>, <code>tec_events_custom_tables_v1_migration_after_cancel</code>, <code>tec_events_custom_tables_v1_migration_completed</code>, <code>tec_events_custom_tables_v1_after_insert_occurrences</code>, <code>tec_events_custom_tables_v1_after_save_occurrences</code>, <code>tec_events_custom_tables_v1_after_update_occurrences</code>, <code>tec_events_custom_tables_v1_pre_drop_tables</code>, <code>tec_events_custom_tables_v1_post_drop_tables</code>, <code>tec_events_custom_tables_v1_pre_drop_fields</code>, <code>tec_events_custom_tables_v1_post_drop_fields</code>, <code>tec_events_custom_tables_v1_request_after_insert_event</code>, <code>tec_events_custom_tables_v1_request_after_update_event</code>, <code>tec_events_custom_tables_v1_update_post_before</code>, <code>tec_events_custom_tables_v1_update_post_after</code>, <code>tec_events_custom_tables_v1_delete_post</code>, <code>tec_events_custom_tables_v1_after_insert_event</code>, <code>tec_events_custom_tables_v1_after_update_event</code>, <code>tec_events_custom_tables_v1_redirect_classic_editor_event_post</code>, <code>tec_events_custom_tables_v1_redirect_rest_event_post</code>, <code>tec_events_custom_tables_v1_custom_tables_query_pre_get_posts</code>, <code>tec_events_custom_tables_v1_custom_tables_query_results</code>, <code>tec_events_custom_tables_v1_{$modifier_class}_done</code>, <code>tec_events_views_v2_after_get_events</code>, <code>tribe_events_single_meta_details_section_after_datetime</code></li>\n<li>Tweak &#8211; Removed actions: <code>tribe-events-bar-enqueue-scripts</code>, <code>tribe_events_widget_render</code>, <code>tribe_events_before_list_widget</code>, <code>tribe_events_list_widget_before_the_title</code>, <code>tribe_events_list_widget_after_the_title</code>, <code>tribe_events_after_list_widget</code>, <code>tribe_events_pre_get_posts</code>, <code>tribe_events_set_month_view_events_from_cache</code>, <code>tribe_events_calendar_loop_end</code>, <code>tribe_tec_template_chooser</code>, <code>tribe_events_filter_the_page_title</code>, <code>tribe-import-render-tab-</code>, <code>tribe_import_render_tab_</code>, <code>tribe_events_csv_import_complete</code>, <code>tribe_import_options_updated</code>, <code>tribe_meta_factory_register</code>, <code>tribe_pre_initialize_view</code>, <code>tribe_events_before_event_template_data_date_display</code>, <code>tribe_events_after_event_template_data_date_display</code>, <code>tribe_events_before_show_month</code>, <code>tribe_events_after_show_month</code>, <code>tribe_events_before_template</code>, <code>tribe_events_after_template</code>, <code>tribe_events_before_header</code>, <code>tribe_events_before_header_nav</code>, <code>tribe_events_after_header_nav</code>, <code>tribe_events_after_header</code>, <code>tribe_events_before_loop</code>, <code>tribe_events_after_loop</code>, <code>tribe_events_before_footer</code>, <code>tribe_events_before_footer_nav</code>, <code>tribe_events_after_footer_nav</code>, <code>tribe_events_after_footer</code>, <code>tribe_events_inside_before_loop</code>, <code>tribe_events_inside_after_loop</code>, <code>tribe_events_before_the_event_title</code>, <code>tribe_events_after_the_event_title</code>, <code>tribe_events_before_the_meta</code>, <code>tribe_events_inside_cost</code>, <code>tribe_events_after_the_meta</code>, <code>tribe_events_before_the_content</code>, <code>tribe_events_after_the_content</code>, <code>tribe_events_before_the_title</code>, <code>tribe_events_after_the_title</code>, <code>tribe_default_events_template_after_header</code>, <code>tribe_default_events_template_before_footer</code>, <code>tribe_events_list_before_the_content</code>, <code>tribe_events_bar_before_template</code>, <code>tribe_events_bar_after_template</code>, <code>tribe_events_before_the_grid</code>, <code>tribe_events_after_the_grid</code>, <code>tribe_events_before_nav</code>, <code>tribe_events_after_nav</code>, <code>tribe_events_list_widget_before_the_event_image</code>, <code>tribe_events_list_widget_after_the_event_image</code>, <code>tribe_events_list_widget_before_the_event_title</code>, <code>tribe_events_list_widget_after_the_event_title</code>, <code>tribe_events_list_widget_before_the_meta</code>, <code>tribe_events_list_widget_after_the_meta</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-links</code>, <code>blocks/event-website</code>, <code>blocks/parts/details</code>, <code>day</code>, <code>day/content</code>, <code>day/loop</code>, <code>day/nav</code>, <code>day/single-event</code>, <code>day/single-featured</code>, <code>day/title-bar</code>, <code>default-template</code>, <code>list</code>, <code>list/content</code>, <code>list/loop</code>, <code>list/nav</code>, <code>list/single-event</code>, <code>list/single-featured</code>, <code>list/title-bar</code>, <code>modules/address</code>, <code>modules/bar</code>, <code>modules/meta/details</code>, <code>month</code>, <code>month/content</code>, <code>month/loop-grid</code>, <code>month/mobile</code>, <code>month/nav</code>, <code>month/single-day</code>, <code>month/single-event</code>, <code>month/title-bar</code>, <code>month/tooltip</code>, <code>v2/month/calendar-body/day</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/title</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/title</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/title</code>, <code>widgets/calendar-widget</code>, <code>widgets/list-widget</code></li>\n</ul>\n<h4>[5.16.4] 2022-08-09</h4>\n<ul>\n<li>Fix &#8211; Ensure date formats are escaped properly when they contain slashes. [ECP-1136]</li>\n<li>Tweak &#8211; Update the calendar print design. [TEC-4425]</li>\n<li>Tweak &#8211; Add support for <code>ticketed</code> parameter for Event archive REST API calls. [TEC-4439]</li>\n<li>Tweak &#8211; Add new methods <code>filter_url_date_conflicts</code> and <code>filter_date_escaping</code> to filter and properly escape the date formats for some views. [ECP-1136]</li>\n<li>Language &#8211; 0 new strings added, 403 updated, 0 fuzzied, and 124 obsoleted.</li>\n</ul>\n<h4>[5.16.3.1] 2022-07-21</h4>\n<ul>\n<li>Fix &#8211; Update Freemius to avoid PHP 8 fatals. [TEC-4330]</li>\n</ul>\n<h4>[5.16.3] 2022-07-20</h4>\n<ul>\n<li>Fix &#8211; Add a theme based CSS class to the HTML body tag when the <code>Default Page Template</code> setting is enabled under Events &gt; Settings &gt; Display. [TEC-4391]</li>\n<li>Fix &#8211; Avoid some conflicts between the import notice and third-party plugins using jQuery datepicker in the admin. [TEC-4429]</li>\n<li>Tweak &#8211; Add edit links to single venue and organizer pages to improve user experience. [ECP-1181]</li>\n<li>Tweak &#8211; Add a CSS class i.e. <code>tribe-events-calendar-month__day--other-month</code> to past and future month dates in the month view to allow easy targeting similar to what we had in v1. [TEC-4034]</li>\n<li>Tweak &#8211; Changed views: <code>v2/month/calendar-body/day</code></li>\n</ul>\n<h4>[5.16.2.1] 2022-07-08</h4>\n<ul>\n<li>Fix &#8211; Don&#8217;t load Aggregator scripts on post edit pages to prevent datepicker conflicts [TEC-4427]</li>\n<li>Tweak &#8211; Added filter: <code>aggregator_should_load_scripts</code></li>\n</ul>\n<h4>[5.16.2] 2022-07-06</h4>\n<ul>\n<li>Fix &#8211; Ensure the <code>Next</code> arrow in <code>List</code> and <code>Summary</code> views navigates to the correct page when the <code>Main Events Page</code> is set as the homepage. [TEC-4247]</li>\n<li>Fix &#8211; Ensure the <code>Next</code> button when using the <code>Event View</code> Elementor widget navigates to the next page on the first click. [FBAR-263]</li>\n<li>Fix &#8211; Add a height to the subscribe to calendar export SVG icon on the single events page when using the <code>Skeleton Styles</code> to prevent it from taking over a huge portion of the page. [TEC-4399]</li>\n<li>Fix &#8211; Remove link to Updates page from TEC Settings page. [TEC-4373]</li>\n<li>Fix &#8211; Ensure Aggregator CSV imports continue to run when on an admin page. [TEC-4070]</li>\n<li>Fix &#8211; Correct hardcoded admin urls used for Event Settings page(s). [ECP-1175]</li>\n<li>Fix &#8211; Ensure event widgets don&#8217;t carry the global search param into their queries. [TEC-4048]</li>\n<li>Fix &#8211; Allow sub-site admins to use the updated calendar designs when their plugin access is restricted. [TEC-4382]</li>\n<li>Fix &#8211; Remove deprecated usage of <code>jQuery.attr( \'checked\' )</code></li>\n<li>Tweak &#8211; Add a unique CSS class i.e. <code>tribe-events-calendar-month__day--past-month</code> to past month dates in the month view to allow easy targeting. [TEC-3447]</li>\n<li>Tweak &#8211; Add a unique CSS class i.e. <code>tribe-events-calendar-month__day--next-month</code> to future month dates in the month view to allow easy targeting. [TEC-3819]</li>\n<li>Tweak &#8211; Changed views: <code>v2/month/calendar-body/day</code></li>\n<li>Language &#8211; 1 new strings added, 113 updated, 0 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[5.16.1.1] 2022-06-15</h4>\n<ul>\n<li>Fix &#8211; correct issues with template paths when using FSE. [TEC-4401]</li>\n</ul>\n<h4>[5.16.1] 2022-06-09</h4>\n<ul>\n<li>Fix &#8211; Add rel=&#8221;noindex&#8221; to links that point to empty Month and Day Views so as to not dilute SEO with empty results. [TEC-4354]</li>\n<li>Fix &#8211; Clean up some borked CSS in some sections of the Elementor <code>Event</code> widget. [ECP-1105]</li>\n<li>Fix &#8211; Fix admin links to work with the new admin page structure. [TEC-4380]</li>\n<li>Tweak &#8211; Removed filters: <code>tribe_settings_admin_slug</code>, <code>tribe_settings_url</code>, <code>tribe_events_enable_month_view_cache</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-links</code>, <code>blocks/parts/subscribe-list</code>, <code>blocks/parts/subscribe-single</code>,<br />\n                         v2/components/subscribe-links/item, <code>v2/components/subscribe-links/single</code>, <code>v2/day/nav/next</code>,<br />\n                         v2/day/nav/prev, <code>v2/day/top-bar/nav/next</code>, <code>v2/day/top-bar/nav/prev</code>, <code>v2/month/mobile-events/nav/next</code>,<br />\n                         v2/month/mobile-events/nav/prev, <code>v2/month/top-bar/nav/next</code>, <code>v2/month/top-bar/nav/prev</code></li>\n</ul>\n<h4>[5.16.0] 2022-05-31</h4>\n<ul>\n<li>Feature &#8211; Add subscribe links for Outlook 365 and Outlook Live to the event views. [TEC-4168]</li>\n<li>Feature &#8211; Add export links for Outlook 365 and Outlook Live to single events. [TEC-4168]</li>\n<li>Feature &#8211; Update single event export to use a dropdown template to support more links. [TEC-4176]</li>\n<li>Feature &#8211; Add Outlook ics as an option for Subscribe to Calendar that removes the X-WR-CALNAME from the file. Props to Andy Fragen @afragen [TEC-4188]</li>\n<li>Fix &#8211; Prevent Redis Cache Pro fatals around date utilization and calculations on Views [TEC-4351]</li>\n<li>Fix &#8211; Ensure all expected subscribe links show when using the default page template. [TEC-4313]</li>\n<li>Fix &#8211; Put back the event website label for Classic editor. [TEC-4334]</li>\n<li>Fix &#8211; Ensure that subscription links include events up to the limit, no matter the view settings. [TEC-4264]</li>\n<li>Fix &#8211; On Event tag archives only show events with the tag, change the single event tag links to use the event tag archive, and add a link to event tag archive in the admin tag list. [TEC-4314]</li>\n<li>Fix &#8211; Default event category in Global Import Settings to apply on new imports in Event Aggregator. [EA-426]</li>\n<li>Fix &#8211; Add rel noindex and nofollow to the legacy iCal export button. [TEC-4354]</li>\n<li>Language &#8211; 6 new strings added, 53 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.15.0.1] 2022-05-23</h4>\n<ul>\n<li>Fix &#8211; Prevent fatal when using Yoast due to missing function <code>tribe_is_month()</code> [TEC-4376]</li>\n<li>Fix &#8211; Check if function exists for <code>get_current_screen</code> to avoid a fatal if not.</li>\n</ul>\n<h4>[5.15.0] 2022-05-19</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.15.0 is only compatible with Event Tickets 5.4.0 and higher</li>\n<li>Version &#8211; The Events Calendar 5.15.0 is only compatible with Events Calendar PRO 5.14.0 and higher</li>\n<li>Version &#8211; The Events Calendar 5.15.0 is only compatible with Events Filterbar    5.3.0 and higher</li>\n<li>Version &#8211; The Events Calendar 5.15.0 is only compatible with Events Virtual 1.10.0 and higher</li>\n<li>Version &#8211; The Events Calendar 5.15.0 is only compatible with Events Community 4.9.0 and higher</li>\n<li>Version &#8211; The Events Calendar 5.15.0 is only compatible with Eventbrite Tickets 4.6.11 and higher</li>\n<li>Feature &#8211; Update Events menu to work with the new admin pages structure. [ET-1335]</li>\n<li>Language &#8211; 1 new strings added, 395 updated, 2 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[5.14.2.1] 2022-04-28</h4>\n<ul>\n<li>Fix &#8211; Correct an issue with linked common release.</li>\n</ul>\n<h4>[5.14.2] 2022-04-28</h4>\n<ul>\n<li>Feature &#8211; Add support to CSV import for the ISO Currency Code field. [TEC-4341]</li>\n<li>Feature &#8211; First iteration of changes for Full Site Editor compatibility. [TEC-4262]</li>\n<li>Tweak &#8211; Added filters <code>tribe_merge_identical_organizers_enabled</code>, <code>tribe_merge_identical_venues_enabled</code>, <code>tribe_merge_identical_organizers_fields</code>, <code>tribe_merge_identical_venues_fields</code>, <code>tribe_amalgamate_venues_keep_venue</code>, <code>tribe_amalgamate_organizers_keep_organizer</code> for better control of the merge duplicate venues and organizers functionality. [TEC-4225]</li>\n<li>Tweak &#8211; Added filter <code>tribe_events_views_v2_ff_link_next_event</code> to allow better control of the fast-forward link target. [ECP-957]</li>\n<li>Tweak &#8211; Allow filtering of the &#8220;next event&#8221; query in the fast-forward link. [ECP-957]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_merge_identical_organizers_enabled</code>, <code>tribe_merge_identical_venues_enabled</code>, <code>tribe_merge_identical_organizers_fields</code>, <code>tribe_merge_identical_venues_fields</code>, <code>tribe_amalgamate_venues_keep_venue</code>, <code>tribe_amalgamate_organizers_keep_organizer</code>, <code>tribe_events_views_v2_ff_link_next_event</code>.</li>\n<li>Tweak &#8211; Changed views: <code>blocks/archive-events</code>.</li>\n<li>Fix &#8211; Correctly calculate Event duration when the Event crosses the daylight saving date and time. [TEC-4336]</li>\n<li>Fix &#8211; Don&#8217;t try to validate &#8220;raw&#8221; as a date. [TEC-4254]</li>\n<li>Fix &#8211; Ensure the Views don&#8217;t try to do math with strings. [TEC-4322]</li>\n<li>Fix &#8211; Enable more than 5 csv entries to be imported when using 8.0.15 to 8.0.17 or 8.1.2 to 8.1.4. [TEC-4312]</li>\n<li>Fix &#8211; Ensure Google Calendar links include the event description if it exists. [TEC-4315]</li>\n<li>Language &#8211; 3 new strings added, 232 updated, 0 fuzzied, and 0 obsoleted.</li>\n</ul>\n<h4>[5.14.1] 2022-03-17</h4>\n<ul>\n<li>Tweak &#8211; Update the backend block editor UI for a single event to look similar to its frontend version in order to create a true WYSIWYG experience when using the block editor. [TEC-4250]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_views_v2_month_ics_start_today</code></li>\n<li>Fix &#8211; Correct a regex typo that was breaking proper JSON-LD data around event cost. [TEC-4263]</li>\n<li>Fix &#8211; Correct Month View ics export so it begins on the current day rather than the 1st. [TEC-4223]</li>\n<li>Fix &#8211; Add ISO Currency Code field to admin to set code sent via JSON-LD. TEC was incorrectly sending symbol. [TEC-4212]</li>\n<li>Fix &#8211; Ensure that the full styles custom properties require the skeleton style custom properties. [TEC-4308]</li>\n<li>Fix &#8211; Ensure that the State/Province field saves for non-US venues. [TEC-4309]</li>\n<li>Fix &#8211; Correct duplicated text in wpadminbar Events Menu. [TEC-4310]</li>\n<li>Fix &#8211; Load the assets required by the <code>Event View</code> Elementor widget in preview mode. [ECP-1065]</li>\n<li>Language &#8211; 4 new strings added, 144 updated, 0 fuzzied, and 0 obsoleted.</li>\n</ul>\n<h4>[5.14.0.4] 2022-03-01</h4>\n<ul>\n<li>Tweak &#8211; Update version of Freemius to 2.4.3.</li>\n</ul>\n<h4>[5.14.0.3] 2022-02-25</h4>\n<ul>\n<li>Fix &#8211; Ensure the Venue and Organizer metaboxes load when creating a new post of that type. [TEC-4303]</li>\n</ul>\n<h4>[5.14.0.2] 2022-02-22</h4>\n<ul>\n<li>Fix &#8211; Correct conditional in Filter Bar upsell banner. [TEC-4284]</li>\n<li>Fix &#8211; Un-deprecate <code>tribe_initialize_view()</code> as it is used in some new views.</li>\n</ul>\n<h4>[5.14.0.1] 2022-02-15</h4>\n<ul>\n<li>Fix &#8211; Prevent parse error due to trailing comma on a method call, PHP 7.1 compatibility required. Props @kzeni</li>\n</ul>\n<h4>[5.14.0] 2022-02-15</h4>\n<ul>\n<li>Feature &#8211; Add a Filter Bar upsell banner to the Filters tab that displays when the Filter Bar plugin isn&#8217;t active. [TEC-4238]</li>\n<li>Tweak &#8211; Correct documentation around the subscribe link filters. Add link slug as array keys for <code>tec_views_v2_single_subscribe_links</code> filter. [TEC-4215]</li>\n<li>Tweak &#8211; Move and deprecate some methods specific to the Google Calendar link from Main to the new Google_Calendar class. [TEC-4235]</li>\n<li>Tweak &#8211; Prevent scripts from loading on all Admin pages, only load on pages needed.</li>\n<li>Tweak &#8211; Performance improvements around Block Asset loading and redundancy.</li>\n<li>Tweak &#8211; Internal caching of values to reduce <code>get_option()</code> call count.</li>\n<li>Tweak &#8211; Switch from <code>sanitize_title_with_dashes</code> to <code>sanitize_key</code> in a couple instances for performance gains.</li>\n<li>Tweak &#8211; Remove the <code>wp.editor.InnerBlocks</code> gutenberg component in favor of <code>wp.blockEditor.InnerBlocks</code> which was deprecated since version 5.3. [TEC-4178]</li>\n<li>Tweak &#8211; Prevent asset loading from repeating calls to plugin URL and path, resulting in some minor performance gains.</li>\n<li>Fix &#8211; Update the way we handle Classic Editor compatibility. Specifically around user choice. [TEC-4016]</li>\n<li>Fix &#8211; Remove incorrect reference for moment.min.js.map [TEC-4148]</li>\n<li>Fix &#8211; Fixed troubleshooting page styles for standalone Event Tickets setup [ET-1382]</li>\n<li>Fix &#8211; Remove singleton created from a deprecated class.</li>\n<li>Fix &#8211; Ensure that the tec_views_v2_use_subscribe_links filter applies to the single event view. [TEC-4219]</li>\n<li>Fix &#8211; Hide the &#8220;Export to .ics file&#8221; link by default, allow showing it via a filter. Also ensure the link is correct. [TEC-4214]</li>\n<li>Fix &#8211; Serve a single event import url for Google Calendar on the single event view. [TEC-4235]</li>\n<li>Fix &#8211; Improve theme CSS compatibility on View container by making sure our views take 100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} of the width available (props @askwpgirl) [TEC-4257]</li>\n<li>Language &#8211; 9 new strings added, 277 updated, 1 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.13.0] 2022-01-31</h4>\n<ul>\n<li>Deprecation &#8211; All files from Legacy Views will throw deprecated notices, refer to <code>https://evnt.is/v1-removal</code> for extra information.</li>\n<li>Deprecation &#8211; Template functions <code>tribe_initialize_view</code>, <code>tribe_get_view</code> and <code>tribe_show_month</code> were deprecated, refer to <code>https://evnt.is/v1-removal</code> for extra information.</li>\n</ul>\n<h4>[5.12.4] 2022-01-19</h4>\n<ul>\n<li>Tweak &#8211; Minor CSS tweaks to align with the new shortcode based blocks in ECP. [ECP-1016]</li>\n<li>Tweak &#8211; Add hook to CSV importer to enable add-on plugins to support their fields during import. [VE-387]</li>\n<li>Tweak &#8211; Included new filter <code>tec_system_information</code> allowing better control over the Troubleshooting Help page.</li>\n<li>Tweak &#8211; Included a Views V2 Status on the Troubleshooting page system info section to help with clarity for support.</li>\n<li>Tweak &#8211; Add notice for Themes using Full Site Editor incompatibility with Widgets. [TEC-4233]</li>\n<li>Fix &#8211; Prevent Onboarding assets from loading on the admin when not needed.</li>\n<li>Fix &#8211; Remove CSS attributes targeting <code>aria-labels</code> to prevent inconsistent styling for different languages. [TEC-4227]</li>\n<li>Fix &#8211; Resolve sorting problems when using orderby with the Event repository when no other orderby values are specified. [TEC-4232]</li>\n<li>Fix &#8211; Prevent unwanted notice on single-event and embed views from legacy views deprecation</li>\n</ul>\n<h4>[5.12.3] 2022-01-10</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.12.3 is only compatible with Events Calendar PRO 5.11.2 and higher</li>\n<li>Fix &#8211; Ensure the modifications made through the <code>tribe_events_views_v2_category_title</code> are respected. [TEC-4110]</li>\n<li>Fix &#8211; Correct issue where mobile default view does not load correctly when homepage set to Events Main. [TEC-3826]</li>\n<li>Tweak &#8211; Boost SEO for category archive pages by fixing the title tag. [TEC-4110]</li>\n<li>Tweak &#8211; Add filter to allow users to choose if the taxonomy should show parent categories [TEC-4110]</li>\n<li>Tweak &#8211; Move handling of mobile view to ECP. Add filter to allow overriding default view. [TEC-3826]</li>\n<li>Language &#8211; 0 new strings added, 71 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.12.2] 2021-12-20</h4>\n<ul>\n<li>Fix &#8211; Remove trailing comma that can cause fatals on older versions of PHP. [FBAR-252]</li>\n<li>Fix &#8211; Prevent infinite loops in the block editor when including the links block. [TEC-4190]</li>\n<li>Fix &#8211; Initial steps to make The Events Calendar compatible with PHP 8.1</li>\n</ul>\n<h4>[5.12.1] 2021-12-14</h4>\n<ul>\n<li>Feature &#8211; Add TEC widget based blocks to the <code>Event Blocks</code> custom block category. [TEC-4151]</li>\n<li>Feature &#8211; Add Event Status filter options when Filter Bar is active. [FBAR-92]</li>\n<li>Fix &#8211; Add a valid rel value to the link tag for TEC REST API support in order to improve HTML 5 and WCAG 2.1 compliance. (props to @gabyrau for the fix!) [TEC-4129]</li>\n<li>Fix &#8211; Ensure the date selected when creating a new event from the Event Manager is applied to the block editor. [ECP-954]</li>\n<li>Fix &#8211; Properly observe the disabling of JSON-LD output on widget blocks in the block editor. [TEC-4077]</li>\n<li>Fix &#8211; Prevent PHP warning in some cases when fetching the date from <code>tribe_get_display_end_date()</code>. (props to @huubl for the fix!) [TEC-4161]</li>\n<li>Fix &#8211; Close a div in the new subscribe dropdown that was left open. Props to @whoisuncle for bringing this to our attention! [TEC-4166]</li>\n<li>Tweak &#8211; Ensure the <code>Disable the Event Search Bar</code> setting doesn&#8217;t get applied on the Event Manager page. [ECP-948]</li>\n<li>Tweak &#8211; Ensure the <code>related events title</code> and <code>event titles</code> within the single event page for the block editor make use the customizer font settings. [TEC-4125]</li>\n<li>Tweak &#8211; Update the description text for the &#8220;Merge Duplicates&#8221; action. Add filters for data sets usd for comparison. [TEC-3018]</li>\n<li>Tweak &#8211; Adjust the Subscribe to Calendar dropdown styling to better accommodate themes with sidebars. [TEC-4166]</li>\n<li>Tweak &#8211; Add the Event List and Mini-Calendar widgets to the Event Blocks category. [TEC-4151]</li>\n<li>Tweak &#8211; Correct some incorrect template paths in docblocks. [TEC-4111]</li>\n<li>Language &#8211; 4 new strings added, 159 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.12.0] 2021-12-02</h4>\n<ul>\n<li>Feature &#8211; Add new subscribe options to the &#8220;Export Events&#8221; link at the bottom of calendar views and single Event view [TEC-4131]</li>\n<li>Fix &#8211; Bypass caching of the event when dealing with the admin event list table. [TEC-4156]</li>\n<li>Fix &#8211; Event List Widget will not print the H3 tag related to the title when that is empty. [TEC-4160]</li>\n<li>Tweak &#8211; Allow bypassing of the Aggregator logging function by using the <code>tec_aggregator_records_should_log_error</code> filter. [TEC-4159]</li>\n<li>Tweak &#8211; Removed the <code>tribe_events_force_filtered_ical_link</code> filter and the associated js function that recreates the subscribe link on v1 and Single Event views. [TEC-4131]</li>\n<li>Language &#8211; 4 new strings added, 52 updated, 0 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[5.11.0] 2021-11-17</h4>\n<ul>\n<li>Feature &#8211; Add an <code>Events List</code> block that is based on the <code>Events List</code> widget to the block editor which users can drag around to any position they want it to appear. [ECP-989]</li>\n<li>Feature &#8211; Add event status options of scheduled, canceled, and postponed with the ability to add and display a reason for the latter two. [TEC-3465]</li>\n<li>Feature &#8211; Add live preview to the TEC customizer screens. [TEC-4055]</li>\n<li>Fix &#8211; When accessing comments there could be situations where an undefined array key was accessed, and in PHP 8 it is a promoted Warning error for undefined array access. [TEC-4093]</li>\n<li>Fix &#8211; Resolved <code>Warning: reset(): Argument #1 ($array) must be passed by reference...</code> error that was displayed on the Events, Organizers and Venue REST endpoints in PHP v8. [TEC-4097]</li>\n<li>Fix &#8211; Ensure that the proper spacing is applied for the venue address in list view. [TEC-4089]</li>\n<li>Tweak &#8211; Change some of the block tests to adapt to the new Editor compatibility in common. [TEC-4016]</li>\n<li>Tweak &#8211; Update the google calendar export button to open in a new tab on the event single page for both the classic and block editors. [TEC-4084]</li>\n<li>Tweak &#8211; Add supplied organizer url to JSON-LD for the event-&gt;organizer. Props @cmenon12 for the notification and code! [TEC-4095]</li>\n<li>Tweak &#8211; Add a link to the Customizer in the admin menu and in Events-&gt;Settings-&gt;Display for folks running a FSE theme. [TEC-4126]</li>\n<li>Language &#8211; 10 new strings added, 55 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.10.1] 2021-11-04</h4>\n<ul>\n<li>Feature &#8211; Added Black Friday promo to the General Settings panel. [TCMN-127]</li>\n<li>Tweak &#8211; Update Black Friday banner. [TCMN-126]</li>\n</ul>\n<h4>[5.10.0] 2021-10-19</h4>\n<ul>\n<li>Tweak &#8211; Improve the look and feel of the single events page when using the block editor. These changes can be bypassed by defining the following constant to your wp-config.php file: <code>define( \'TRIBE_EVENTS_SINGLE_VIEW_V2_DISABLED\', true );</code> [TEC-3979]</li>\n<li>Language &#8211; 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.9.2] 2021-10-12</h4>\n<ul>\n<li>Fix &#8211; Ensure the day view on mobile displays the not found message when no events are present. [TEC-3944]</li>\n<li>Fix &#8211; Ensure a map preview is displayed on the venue block in the admin area when using TEC&#8217;s default Google API Key. [TEC-3042]</li>\n<li>Fix &#8211; Add some missing text domains for string translation. [TEC-3908]</li>\n<li>Fix &#8211; Correct block use checks around the Classic Editor plugin. [TEC-4099]</li>\n<li>Tweak &#8211; Set the appropriate Content-Type for REST responses that return just HTML during view partial requests. [TEC-4087]</li>\n<li>Language &#8211; 0 new strings added, 164 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.9.1] 2021-09-14</h4>\n<ul>\n<li>Feature &#8211; Updated swagger docs generated from swagger 2.0 to openapi 3.0.0</li>\n<li>Fix &#8211; Initialize $local_time_zone to ensure we don&#8217;t have notices displayed in the frontend. [TEC-3791]</li>\n<li>Fix &#8211; Ensure the correct timezone label is being displayed on the Classic and Block editors when site-wide timezone is set. [TEC-3791]</li>\n<li>Fix &#8211; Ensure that venue state or province are displayed next to the city in list view. [TEC-3332]</li>\n<li>Fix &#8211; Ensure the category archive event breadcrumb links to the main events page. [TEC-3330]</li>\n<li>Fix &#8211; Ensure that the page title does not encode (em)dashes before passing it on. [TEC-4049]</li>\n<li>Fix &#8211; Ensure that the page title does not encode apostrophes before passing it on. [TEC-4058]</li>\n<li>Fix &#8211; Ensure that filter_single_event_details_event_website_label() only filters the label for the website field. [ECP-921]</li>\n<li>Tweak &#8211; Remove unused template file to avoid confusion.</li>\n<li>Language &#8211; 0 new strings added, 13 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.9.0] 2021-08-24</h4>\n<ul>\n<li>Fix &#8211; Ensure that $eventDisplay is defined before we use it in the default template. [TEC-4060]</li>\n<li>Feature &#8211; Alter Customizer to leverage the new exposed CSS custom properties. [TCMN-104]</li>\n<li>Feature &#8211; Reduce the CSS load of The Events Calendar Customizer style overrides. [TEC-3011]</li>\n<li>Feature &#8211; Allow easier style overrides by users and third-party themes/plugins. [TEC-3011]</li>\n<li>Feature &#8211; Add new Font Sections to Customizer -&gt; The Events Calendar -&gt; Global Events. [TEC-3872]</li>\n<li>Feature &#8211; Add new font family control to allow The Events Calendar styles to inherit theme fonts. [TEC-3895]</li>\n<li>Feature &#8211; Add new font size controls for accessibility and to allow users to more closely match the font sizes of their theme. [TEC-3891]</li>\n<li>Tweak &#8211; Support optionally passing start dates to the Event Edit page so targeted event creation can be triggered by The Events Calendar Pro&#8217;s Event Manager.</li>\n<li>Language &#8211; 16 new strings added, 429 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.8.2] 2021-08-17</h4>\n<ul>\n<li>Feature &#8211; Redesign In-App help and troubleshooting pages. [TEC-3741]</li>\n<li>Fix &#8211; Try to ensure that when we do an event search the query post type remains <code>tribe_events</code>. [TEC-4012]</li>\n<li>Fix &#8211; Ensure the year is displayed in the block editor event single page for events that are occurring in a different year from the current one. [TEC-3740]</li>\n<li>Fix &#8211; Fix the issue of the Event Date Time block Timezone dropdown taking up a lot of space. [TEC-4029]</li>\n<li>Fix &#8211; Ensure WPML translated event posts show up on translated venue and organizer pages. (props @NicoX13) [TEC-4036]</li>\n<li>Fix &#8211; Fix issue of month names not being translatable. This was caused by a missing moment js localization dependency. [ECP-739]</li>\n<li>Fix &#8211; Ensure we test the value of tribe_events_get_current_month_day() before using it. [ECP-912]</li>\n<li>Fix &#8211; Add a new function to add &#8220;Event Blocks&#8221; category to the editor for WP &gt;= 5.8. [TEC-4037]</li>\n<li>Tweak &#8211; Change label of API Settings tab to &#8220;Integrations&#8221; and alter helper text. [TEC-4015]</li>\n<li>Language &#8211; 2 new strings added, 251 updated, 1 fuzzied, and 18 obsoleted</li>\n</ul>\n<h4>[5.8.1] 2021-07-20</h4>\n<ul>\n<li>Fix &#8211; Ensure that the Block Editor saves cost data when submitted. [TEC-3987]</li>\n<li>Fix &#8211; Ensure that when viewing a single event we load the correct template when tribe_context is &#8220;confused&#8221;. [TEC-3975]</li>\n<li>Tweak &#8211; Remove some CSS on the single events page that was causing a random border to appear on avada theme [TEC-3952]</li>\n<li>Tweak &#8211; Add CSS class to the event tags label on the event details section on the single event page. [TEC-3951]</li>\n<li>Tweak &#8211; Correct the messaging and link for the v1 deprecation notice. [TEC-3958]</li>\n<li>Tweak &#8211; Include filter to allow modifications to the Grid query for By Day Views like Month and Week, <code>tribe_events_views_v2_by_day_view_day_repository</code></li>\n<li>Language &#8211; 5 new strings added, 26 updated, 2 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[5.8.0] 2021-07-01</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.8.0 is only compatible with Events Calendar PRO 5.8.0 and higher</li>\n<li>Feature &#8211; Add new Events bar section to the Customizer for control of the Events Bar styles. [TEC-3672]</li>\n<li>Fix &#8211; Correct instance where the date &amp; time symbols (&#8220;@&#8221;) are not changing color along with the text. [TEC-3883]</li>\n<li>Tweak &#8211; Ensure that the Month view date and time default colors match up with the rest [TEC-3709]</li>\n<li>Tweak &#8211; Ensure the Customizer Accent Color defaults to &#8220;royal blue&#8221; (#334aff) [TEC-3884]</li>\n<li>Tweak &#8211; Stop doing all the work here and leverage the new tribe-common Theme_Compatibility. [TCMN-106]</li>\n<li>Tweak &#8211; Add new hooks to the single event templates to allow more third-party control over content without custom templates. [TEC-3948]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_events_views_v2_bootstrap_html</code>, <code>tribe_default_events_template_classes</code>, <code>tribe_events_single_event_title_classes</code>, <code>tribe_events_single_event_title_html_before</code>, <code>tribe_events_single_event_title_html_after</code>, <code>tribe_events_single_event_title_html</code></li>\n<li>Tweak &#8211; Removed filters: <code>tribe_events_views_v2_compatibility_classes</code>, <code>tribe_events_views_v2_theme_compatibility_registered</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_default_events_template_after_header</code>, <code>tribe_default_events_template_before_footer</code></li>\n<li>Tweak &#8211; Changed views: <code>default-template</code>, <code>single-event</code>, <code>v2/default-template</code></li>\n<li>Language &#8211; 13 new strings added, 64 updated, 6 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[5.7.1] 2021-06-23</h4>\n<ul>\n<li>Fix &#8211; Properly recalculate event cost when creating events via the Block Editor. [TEC-3141]</li>\n<li>Fix &#8211; Resolve a compatibility issue with the new single view and the tickets block when using the <code>twentynineteen</code> theme. [TEC-3937]</li>\n<li>Fix &#8211; Ensure that <code>view_data</code> is an array when fetching values from the request. [TEC-3946]</li>\n<li>Fix &#8211; Ensure that the events block editor is disabled when &#8220;Activate Block Editor for Events&#8221; is unchecked. [TEC-3964]</li>\n<li>Tweak &#8211; Make custom post types available from the REST API so they can be compatible with the Navigation block. [TEC-3907]</li>\n<li>Tweak &#8211; Remove aria-labeled attribute from featured icons. [TEC-3396]</li>\n<li>Language &#8211; 0 new strings added, 154 updated, 3 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.7.0] 2021-05-27</h4>\n<ul>\n<li>Feature &#8211; Add new Month View section to the Customizer for v2 views. [TEC-3836]</li>\n<li>Fix &#8211; Apply responsive breakpoints once the page has fully loaded with all JavaScript and Elements on the page [TEC-3797]</li>\n<li>Fix &#8211; Resolve conflicts with Gravity Forms plugin that would prevent correct submission of forms data. [ECP-466]</li>\n<li>Fix &#8211; Correctly handle start and end of day cutoff in Day View when the server timezone is not the same as the site (thanks @therealgilles). [TEC-3877]</li>\n<li>Fix &#8211; Do not remove the <code>archive</code> body class from post tag and category pages when using Page as Event Template. [TEC-3846]</li>\n<li>Fix &#8211; Correctly translate calendar view in WPML language switcher (thanks @dgwatkins). [TEC-3810]</li>\n<li>Fix &#8211; Styles with the default theme <code>twenty twenty one</code> in <code>&lt;buttons&gt;</code> around the calendar. [TEC-3887]</li>\n<li>Fix &#8211; Single event iCalendar export will correctly export only that event information. [TEC-3886]</li>\n<li>Fix &#8211; Use the correct date and time in the Day View time separator when Timezone Mode is set to &#8220;Manual time zones for each event&#8221;. [TEC-3877]</li>\n<li>Fix &#8211; Correctly integrate with the &#8220;Hello Elementor&#8221; theme to avoid issues with The Events Calendar and The Events Calendar PRO Views. [ECP-648]</li>\n<li>Fix &#8211; Correct typo in style output from Customizer.  Thanks @apmatthews for catching and correcting this!</li>\n<li>Fix &#8211; Avoid PHP warnings when linked post types are filtered out (thanks @baden03). [TEC#3533]</li>\n<li>Tweak &#8211; Make sure events from latest past events display the featured image correctly. [TEC-3655]</li>\n<li>Tweak &#8211; Reduced the usage of the word &#8220;onwards&#8221; on list-style view date range headings where simpler headings are better suited. [TEC-3831]</li>\n<li>Tweak &#8211; Move messages below the calendar grid in the mobile version of Month View. [TEC-3793]</li>\n<li>Tweak &#8211; Display a message to let visitors know the selected Month View day has no events in mobile. [TEC-3812]</li>\n<li>Tweak &#8211; Add compatibility for the Full Site Editor navigation block. [TEC-3850]</li>\n<li>Tweak &#8211; Filter the type of files allowed to upload into the EA Client. [TEC-3882]</li>\n<li>Tweak &#8211; Updating lodash to 4.17.21. [TEC-3885]</li>\n<li>Tweak &#8211; Prevent to list changes of hash on URL changes like <code>#content</code> [TEC-3890]</li>\n<li>Tweak &#8211; Update Google Calendar link to use the timezone based on the Timezone Settings from the Calendar [TEC-3143]</li>\n<li>Tweak &#8211; Add the <code>tribe_views_v2_after_setup_loop</code> filter to modify the loop context set up in the View (v2). [ECP-811]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_by_day_view_grid_days</code> to allow pre-filling Month and Week Views (v2) Events. [ECP-529]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_by_day_view_day_results</code> to allow fine-grained control over Month and Week Views (v2) Event data. [ECP-529]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_events_views_v2_view_ical_repository_args</code>, <code>tribe_events_views_v2_view_{$slug}_asset_origin_object</code>, <code>tribe_events_views_v2_by_day_view_grid_days</code>, <code>tribe_events_views_v2_by_day_view_day_results</code>, <code>tribe_events_views_v2_month_mobile_messages</code>, <code>tribe_events_views_v2_view_cached_html</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_cached_html</code>, <code>tribe_ical_template_event_ids</code>, <code>tribe_get_view_permalink</code>, <code>tribe_get_{$slug}_view_permalink</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_views_v2_after_setup_loop</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/parts/details</code>, <code>modules/meta/details</code>, <code>v2/components/breakpoints</code>, <code>v2/components/messages</code>, <code>v2/day/time-separator</code>, <code>v2/month</code>, <code>v2/month/calendar-body/day</code>, <code>v2/month/mobile-events</code>, <code>v2/month/mobile-events/mobile-day</code>, <code>v2/month/mobile-events/mobile-day/day-marker</code></li>\n<li>Language &#8211; 27 new strings added, 133 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.6.0] 2021-04-29</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.6.0 is only compatible with Events Calendar PRO 5.6.0 and higher</li>\n<li>Fix &#8211; Correct implementation of filters in Views/V2/Hooks.php to avoid fatals. [ECP-761]</li>\n<li>Fix &#8211; Ensure when saving on Blocks editor Organizer and Venue IDs don&#8217;t throw notices for failed deletion. [TEC-3844]</li>\n<li>Fix &#8211; Resolve compatibility problem between The Events Calendar and other plugins using Select2. [TEC-3748]</li>\n<li>Fix &#8211; Enqueue full styles for v2 event single only when using full styles. [TEC-3848]</li>\n<li>Fix &#8211; Modify Select2 to clone the <code>jQuery.fn.select2</code> into <code>jQuery.fn.select2TEC</code> to avoid conflicting with third-party usage that didn&#8217;t include the full version of Select2 [TEC-3748]</li>\n<li>Fix &#8211; Add filtering hooks to Cache Listener to allow modifications of which options trigger an occurrence. [ECP-826] [ECP-824]</li>\n<li>Fix &#8211; Improve escaping for messages when no results were found using search (Thanks Steve Pollak)</li>\n<li>Tweak &#8211; Added the ability to filter cached view HTML. Hooks added were: <code>tribe_events_views_v2_view_cached_html</code> and <code>tribe_events_views_v2_view_{$view_slug}_cached_html</code>. [ECP-770]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_customizer_should_print_shortcode_customizer_styles</code>, <code>tribe_events_views_v2_view_ical_repository_args</code>, <code>tribe_events_views_v2_view_cached_html</code>, <code>tribe_events_views_v2_view_{$this-&gt;slug}_cached_html</code>, <code>tribe_ical_template_event_ids</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/parts/details</code>, <code>modules/meta/details</code>, <code>v2/components/messages</code>, <code>v2/month/mobile-events/mobile-day</code>, <code>v2/month/mobile-events/mobile-day/day-marker</code></li>\n<li>Language &#8211; 3 new strings added, 176 updated, 0 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.5.0.1] 2021-04-05</h4>\n<ul>\n<li>Fix &#8211; Reduce overhead of widget setup on every page load by setting up the widgets only as needed. [TEC-3833]</li>\n</ul>\n<h4>[5.5.0] 2021-03-29</h4>\n<ul>\n<li>Feature &#8211; Add <code>has_event</code> and <code>has_no_events</code> to the Venue and Organizer ORM so we can filter requests for both by whether they have events or not.</li>\n<li>Fix &#8211; Invert quotes to protect against issue with MySQL in <code>ANSI_QUOTES</code> mode. [TEC-3785]</li>\n<li>Fix &#8211; correct display order of sticky, featured, and &#8220;normal&#8221; events on Month View. Adds a class for targeting sticky posts for styling. [TEC-3770]</li>\n<li>Fix &#8211; Ensure the Events List widget also shows the Time Zone when displaying it is set in the admin. [TEC-3747]</li>\n<li>Fix &#8211; Saving on Blocks editor without Organizer is working as expected again [TEC-3788]</li>\n<li>Fix &#8211; Fusion Core/Avada Widget implementation of The Events Calendar will no longer throw warnings on the frontend display. [ECP-538]</li>\n<li>Fix &#8211; Usage of <code>tribe_get_events()</code> for non-existent posts will no longer throw warnings on the Blocks Editor, impacted Community Events Shortcode usage [BTPLAN-121]</li>\n<li>Tweak &#8211; Added rel=noreferrer to Google Map links. [TEC-3795]</li>\n<li>Tweak &#8211; Include actions before and after the creation of a view for REST API requests. Hooks added were: <code>tribe_events_views_v2_before_make_view_for_rest</code> and <code>tribe_events_views_v2_after_make_view_for_rest</code></li>\n<li>Tweak &#8211; Allow specific filtering to add other views into the HTML caching for performance using hook <code>tribe_events_views_v2_cached_views</code>.</li>\n<li>Tweak &#8211; Include Legacy views deprecation notice [TEC-4809]</li>\n<li>Language &#8211; 8 new strings added, 181 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.4.0.2] 2021-03-10</h4>\n<ul>\n<li>Fix &#8211; Saving organizers properly work on WordPress 5.7 with Blocks Editor [TEC-3788]</li>\n</ul>\n<h4>[5.4.0.1] 2021-03-04</h4>\n<ul>\n<li>Fix &#8211; Prevent fatals happening with PHP 5.6 due to duplicated class for templates [TEC-3799]</li>\n</ul>\n<h4>[5.4.0] 2021-02-24</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.4.0 is only compatible with Events Calendar PRO 5.3.0 and higher</li>\n<li>Fix &#8211; Compatibility with WordPress 5.7 and jQuery 3.5.X</li>\n<li>Fix &#8211; Updated views JavaScript manager is now deferred to the end of the request, to make sure all dependencies are loaded.</li>\n<li>Fix &#8211; Navigation for the Views will no longer use current browser URL as previous url, preventing problems on shortcodes.</li>\n<li>Fix &#8211; Latest Past view moved to not publicly visible, which was the intended behavior.</li>\n<li>Tweak &#8211; Add compatibility container to widgets &#8211; to allow for a non-body target for compatibility classes.</li>\n<li>Tweak &#8211; Include the <code>tribe_events_views_v2_view_page_reset_ignored_params</code> filter to prevent certain params from interfering with pagination resetting. [FBAR-222]</li>\n<li>Tweak &#8211; Use filterable attributes for the view more link and text. Add customizer styling for the link. [ECP-568]</li>\n<li>Tweak &#8211; Removed <code>tribe_events_views_v2_widget_admin_form_{$field_type}_input</code> from the List Widget admin form in favor of using <code>Tribe__Template::do_entry_point()</code> [ECP-486]</li>\n<li>Tweak &#8211; Moved administration templates for List Widget components to Common. [ECP-486]</li>\n<li>Language &#8211; 1 new strings added, 10 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.3.2.1] 2021-02-02</h4>\n<ul>\n<li>Fix &#8211; Prevent Event Aggregator ASYNC requests from failing to import after 5 Events, Venues, RSVP, Tickets and/or Organizers. [TEC-3769]</li>\n<li>Fix &#8211; Update compatibility with PHP 7.4 for ForceUTF8 vendor module. [TEC-3769]</li>\n</ul>\n<h4>[5.3.2] 2021-01-28</h4>\n<ul>\n<li>Feature &#8211; Add customizer support for custom location pins on single events when Views V2 is active. [TEC-3276]</li>\n<li>Fix &#8211; Use dynamic label for fast-forward link on the month view. [TEC-3452]</li>\n<li>Fix &#8211; Correctly filter <code>locale</code> in the <code>Tribe\\Events\\I18n</code> class to avoid errors.</li>\n<li>Fix &#8211; Prevent heartbeat warning when null data param is passed on Cron and AJAX requests [TEC-3745]</li>\n<li>Fix &#8211; Increase the minimum width of the datetime dropdown when editing an event with the block editor. [TEC-3126]</li>\n<li>Fix &#8211; Ordering with an Array when using <code>Tribe__Repository</code> now properly ignores the global order passed as the default. [ECP-598]</li>\n<li>Fix &#8211; Resolve PHP 8.0 incompatibility with <code>__wakeup</code> and <code>__clone</code> visibility on Extension class.</li>\n<li>Fix &#8211; Prevent <code>tribe_sort_by_priority</code> from throwing warnings on <code>uasort</code> usage for PHP 8+ compatibility.</li>\n<li>Fix &#8211; Update Di52 to include PHP 8+ compatibility.</li>\n<li>Fix &#8211; Modify Freemius <code>class-fs-logger.php</code> file to prevent PHP 8+ warnings.</li>\n<li>Fix &#8211; Correctly handle *nix and Windows server paths that contain falsy values (e.g. <code>0</code> or spaces) when building template paths. [TEC-3712]</li>\n<li>Tweak &#8211; Increase top padding above date stamp in list view. [TEC-3656]</li>\n<li>Tweak &#8211; Reduce bottom margin of the event title in list/day views. [TEC-3656]</li>\n<li>Tweak &#8211; Round featured event line corners. [TEC-3656]</li>\n<li>Tweak &#8211; Add new filter <code>tribe_aggregator_build_url_data</code> to customize the URL delivered to EA server.</li>\n<li>Tweak &#8211; Update V2 Customizer admin styles of TEC sections. [TEC-3696]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_aggregator_build_url_data</code></li>\n<li>Language &#8211; 4 new strings added, 187 updated, 3 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[5.3.1] 2020-12-15</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator &#8211; Filter Events by Aggregator/Import Record. [EA-130]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add background color css overrides. [TEC-3651]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add Event Title color css overrides. [TEC-3334]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add Event Date &amp; Time color css overrides. [TEC-3675]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add controls for Background Color to general and single-event sections. [TEC-3683]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add controls for Event Title Color to general section. [TEC-3684]</li>\n<li>Feature &#8211; V2 Customizer &#8211; Add controls for Event Date &amp; Time Color to general section. [TEC-3685]</li>\n<li>Tweak &#8211; Add opaque backgrounds for selected bordered elements. [TEC-3673]</li>\n<li>Tweak &#8211; Change Title/Date &amp; Time font color defaults on the Event Single page. [TEC-3682]</li>\n<li>Fix &#8211; Fix an issue in csv venue imports where the address would not import.  [TEC-3637]</li>\n<li>Fix &#8211; Compatibility for some theme menus that no longer displayed when an event is password protected. [TEC-2968]</li>\n<li>Language &#8211; 8 new strings added, 63 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.3.0] 2020-12-02</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator &#8211; Search Box for Scheduled Imports. [TEC-3570]</li>\n<li>Feature &#8211; Event Aggregator Batch Pushing for Cron Imports [EA-297]</li>\n<li>Tweak &#8211; Add the filter <code>tribe_aggregator_import_queue_cleaner_time_to_live</code> to customize the time in seconds to consider an EA record alive. [EA-297]</li>\n<li>Tweak &#8211; Add the filter <code>tribe_aggregator_import_queue_cleaner_stall_limit</code> to customize the number of seconds for an EA record to be considered stalled. [EA-297]</li>\n<li>Tweak &#8211; Add the filter <code>tribe_events_aggregator_build_url</code> [EA-297]</li>\n<li>Tweak &#8211; Adjust Event Aggregator Client Progress Bar using the Heart Beat API for polling state instead [TEC-3534]</li>\n<li>Tweak &#8211; Event Aggregator &#8211; Make default limit by number of events instead of by date range. [TEC-3635]</li>\n<li>Tweak &#8211; Event Aggregator/Eventbrite Tickets &#8211; Remove verbiage regarding 50 event limit on Eventbrite imports.</li>\n<li>Tweak &#8211; Add the <code>tribe_get_organizer_object</code> function. [TEC-3645]</li>\n<li>Tweak &#8211; Change the return value of the <code>tribe_get_event( $event_id )-&gt;organizers</code> from a collection of Organizer names to a collection of Organizer post objects. [TEC-3645s]</li>\n<li>Tweak &#8211; Add the <code>tribe_get_event( $event_id )-&gt;organizer_names</code> method to return a collection of the Event Organizer names. [TEC-3645]</li>\n<li>Tweak &#8211; Ensure widgets don&#8217;t get Filter Bar classes on their containers. [FBAR-202]</li>\n<li>Tweak &#8211; Switch the List View previous/next URL methods to use the slug rather than a hard-coded &#8220;list&#8221; so the class is more easily extendable. [TEC-3648]</li>\n<li>Tweak &#8211; Add an option to trash events after 1 month (thanks @StefanSchroeder).</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_datepicker_no_conflict</code> filter (default <code>false</code>) to allow loading the Views v2 datepicker in no-conflict mode, when set to <code>true</code>, and avoid issues with other plugins that are loading the built-in WordPress <code>jquery-ui-datepicker</code> script. [TEC-3581]</li>\n<li>Tweak &#8211; Improve WPML integration and URL localization of Views v2. [TEC-3608]</li>\n<li>Fix &#8211; Event Aggregator &#8211; Fix Eventbrite status filter to not return &#8216;do_not_override&#8217; and handle Eventbrite&#8217;s additional statuses. [TEC-3569]</li>\n<li>Fix &#8211; Ensure ECP shortcode today button handles categories gracefully. [ECP-492]</li>\n<li>Fix &#8211; Prevent creation of duplicate venues for default address while adding or editing events. [ECP-482]</li>\n<li>Fix &#8211; Make sure Month View &#8220;View More&#8221; link to Day View will preserve the current search criteria. [TEC-3230]</li>\n<li>Fix &#8211; Ensure Event Aggregator Cron schedules always have array format and avoid errors on fresh WordPress installations (thanks @mmcachran).</li>\n<li>Fix &#8211; Regular expression to sanitize name of columns on the EA client make sure all invalid characters are removed.</li>\n<li>Fix &#8211; Use more robust code in the <code>tribe_is_past_event</code> template tag to avoid Warnings.</li>\n<li>Fix &#8211; Review and improve the Rewrite component to correctly parse and handle localized URLs and accented characters. [TEC-3608]</li>\n<li>Language &#8211; 25 new strings added, 775 updated, 1 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.2.1] 2020-10-22</h4>\n<ul>\n<li>Tweak &#8211; Change Views v2 AJAX request method from GET to POST to avoid issues with too long URLs. [TEC-3283]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_endpoint_method</code> filter to allow controlling the HTTP method Views should use to fetch their content from the back-end endpoint. [TEC-3283]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_views_v2_endpoint_url</code> filter to allow controlling the URL Views should use to fetch their content from the back-end endpoint. [TEC-3283]</li>\n<li>Fix &#8211; Prevent Event Aggregator 15 minute Cron Schedule from being created when not required (props @jetxpert) [EA-317]</li>\n<li>Fix &#8211; Add filter to toggle off the event templates hijack. [TEC-3521]</li>\n<li>Fix &#8211; Correct url for current month iCal export link. [TEC-3575]</li>\n<li>Fix &#8211; Avoid loading the same CSS file twice on the back-end. [TEC-3623]</li>\n<li>Fix &#8211; Ensure ECP shortcode prev/next urls handle categories gracefully. [ECP-492]</li>\n<li>Language &#8211; 3 new strings added, 200 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.2.0] 2020-09-28</h4>\n<ul>\n<li>Fix &#8211; Fix the order of the List View when the PRO is set to show only the first instance of a Recurring Event. [ECP-467]</li>\n<li>Fix &#8211; Fix a PHP error that would arise when during the translation, by the WPML plugin, of some strings. [TEC-3454, TEC-3578]</li>\n<li>Fix &#8211; Fix a compatibility issue with the WPML plugin that would prevent some options from being translated correctly. [TEC-3454]</li>\n<li>Fix &#8211; Generation and usage of translated strings that would cause issues with the WPML plugin. [TEC-3454]</li>\n<li>Tweak &#8211; Use the <code>border-small</code> class for the today button, add new border button styles to customizer. [FBAR-143]</li>\n<li>Tweak &#8211; Add missing CSS classes to the Event Categories label on the single event page. [TEC-3478]</li>\n<li>Tweak &#8211; Adjust accordion trigger selector to allow multiple space-separated <code>data-js</code> attributes. [FBAR-125]</li>\n<li>Tweak &#8211; Adjust spacing on header to prevent screen overflow. [FBAR-132]</li>\n<li>Tweak &#8211; Adjust aria attributes and add loader text to make ajax loading more accessible. [FBAR-147]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_latest_past_view_display_template</code> filter to allow controlling the display of templates  in the context of the Latest Past Events View. [FBAR-148]</li>\n<li>Tweak &#8211; Allow passing of additional data to the AJAX request by use of container data. [FBAR-162]</li>\n<li>Language &#8211; 2 new strings added, 20 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.1.6] 2020-08-24</h4>\n<ul>\n<li>Tweak &#8211; Move the iCal output coding out of the loop and into its own method.  [VE-150]</li>\n<li>Fix &#8211; Fix SQL errors that would show up when creating custom Event queries in theme builders. [TEC-3530]</li>\n<li>Fix &#8211; Fix SQL errors that would show up when running custom Event queries in plugins . [TEC-3528]</li>\n<li>Fix &#8211; Fix SQL errors that would prevent customers from being able to select tickets assigned to Events in some instances. [TEC-3500]</li>\n<li>Fix &#8211; On re-import of the excerpt and event description field enable changes to the existing values. [TEC-3080]</li>\n<li>Fix &#8211; On re-import enable excerpt and description to be cleared of their values. [TEC-3080]</li>\n<li>Fix &#8211; On re-import only overwrite items that have been mapped. [TEC-2962]</li>\n<li>Tweak &#8211; Add filters for venue and organizer import data. [TEC-2962]</li>\n<li>Tweak &#8211; Add ability to use default values from settings for venue imports via the <code>tribe_events_importer_set_default_venue_import_values</code> filter. [TEC-2962]</li>\n<li>Tweak &#8211; Replace placeholders in template docblocks with appropriate links. [TEC-3399]</li>\n<li>Language &#8211; 32 new strings added, 75 updated, 0 fuzzied, and 28 obsoleted</li>\n</ul>\n<h4>[5.1.5] 2020-07-27</h4>\n<ul>\n<li>Tweak &#8211; Add filters to link generation for events, venues, and organizers. [EXT-151]</li>\n<li>Tweak &#8211; Remove disabled admin notice for Virtual Events and Gutenberg. [TEC-3546]</li>\n<li>Tweak &#8211; Modify parameters on <code>register_rest_route</code> to include <code>permission_callback</code> to prevent notices on WordPress 5.5.</li>\n<li>Fix &#8211; Prevent the wrong dates in mobile month view date marker when on leading UTC timezones. [TEC-3549]</li>\n<li>Fix &#8211; Fix the display order of Events starting on the same date and time to ensure it&#8217;s consistent. [TEC-3548]</li>\n<li>Fix &#8211; Fix the handling of URL fragments translations in Views to ensure fully localized View URLs work. [TEC-3479]</li>\n<li>Fix &#8211; Display promo at the bottom of views when &#8220;Show The Events Calender link&#8221; is checked. [TEC-3321]</li>\n<li>Fix &#8211; Set proper timezone on block editor when creating a new event. [TEC-3543]</li>\n<li>Fix &#8211; Prevent PHP error when using V2, the site home page at <code>Main Events page</code>, including events in the blog loop, and Pro is active.  [ECP-361]</li>\n<li>Fix &#8211; Resolve WordPress REST API authentication errors related to <code>null</code> returns. Props to @ahaurat [TEC-3539]</li>\n<li>Language &#8211; 0 new strings added, 55 updated, 0 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.1.4] 2020-06-24</h4>\n<ul>\n<li>Tweak &#8211; Improve fresh install experience by setting the default template to the Events one [TEC-3453]</li>\n<li>Tweak &#8211; Create a new method to request an update back to EA imports to mark imports as completed on EA server [TEC-3476]</li>\n<li>Tweak &#8211; Add a new filter <code>tribe_aggregator_service_put_pue_licenses</code> to enable external sources the option to add additional PUE attached to the request. [TEC-3476]</li>\n<li>Tweak &#8211; Prevent latest-past from showing in the front end view selector in new installs [TEC-3450]</li>\n<li>Tweak &#8211; On a fresh install set the enabled views to list, month, and day and set the default view to list to stop erroneous error entries [TEC-3451]</li>\n<li>Tweak &#8211; Add a new &#8220;scheduled&#8221; status for the activity reporter of imports from EA [TEC-3475]</li>\n<li>Tweak &#8211; Add admin notice for Virtual Events. [TEC-3620]</li>\n<li>Language &#8211; 3 new strings added, 246 updated, 1 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.1.3] 2020-06-22</h4>\n<ul>\n<li>Tweak &#8211; Add new filter <code>tribe_events_filter_views_v2_plural_events_label</code> to customize the label in V2 views. [VE-9]</li>\n<li>Fix &#8211; Prevent &#8220;too few arguments&#8221; on the settings page when a url contains percentage signs. [VE-111]</li>\n<li>Fix &#8211; Correctly store Event Organizer meta when using the ORM.</li>\n<li>Fix &#8211; Linked posts (Organizers and Venues) correctly check if the item selected is brand new or existing when edit link is empty. [TEC-3481]</li>\n<li>Language &#8211; 1 new strings added, 112 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.1.2.1] 2020-06-09</h4>\n<ul>\n<li>Security &#8211; Remove deprecated usage of escapeMarkup in Select2 (props to miha.jirov for reporting this).</li>\n</ul>\n<h4>[5.1.2] 2020-05-27</h4>\n<ul>\n<li>Tweak &#8211; Prevent undefined errors when using tribe_get_events and forcing a cache refresh.</li>\n<li>Fix &#8211; Prevent <code>E_ERROR</code> for <code>Tribe__Events__Meta__Save</code> construct when dealing with revisions, which some WP Engine customers were seeing.</li>\n<li>Language &#8211; 0 new strings added, 49 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[5.1.1] 2020-05-11</h4>\n<ul>\n<li>Feature &#8211; Move all the featured event icons to templates. [TEC-3441]</li>\n<li>Feature &#8211; Added a helper method <code>Tribe__Plugins::is_active( \'slug\' )</code> to check if a given plugin is active.</li>\n<li>Feature &#8211; Add entry points through filters to be able to add content after the opening html tag or before the closing html tag. [TCMN-65]</li>\n<li>Tweak &#8211; Deprecated the <code>Tribe__Events__Main::get_i18n_strings_for_domains()</code> and <code>Tribe__Events__Main::get_i18n_strings()</code> methods; use the methods with the same name and signature provided by the <code>tribe( \'tec.18n\' )</code> object [TEC-3404]</li>\n<li>Tweak &#8211; Add new filter <code>tribe_aggregator_manage_record_column_source_html</code> to customize the source column content HTML used on the Event Aggregator Import &#8220;History&#8221; tab.</li>\n<li>Tweak &#8211; Modify language variables to improve translations readability on Updated Views navigation previous and next buttons. [props @justlevine]</li>\n<li>Tweak &#8211; Add new filter <code>tribe_aggregator_manage_record_column_source_html</code> to customize the source column content HTML used on the Event Aggregator Import &#8220;History&#8221; tab.</li>\n<li>Fix &#8211; Enqueue Customizer stylesheets properly via <code>tribe_customizer_inline_stylesheets</code> in Common. [TEC-3401]</li>\n<li>Fix &#8211; Not being able to create events because capabilities were not set on activation or update of the plugin. [TEC-3350]</li>\n<li>Fix &#8211; Adjust templates to show time zone in event details when &#8220;Show time zone&#8221; is checked. [TEC-2979]</li>\n<li>Fix &#8211; Correct bad defaults from <code>Template-&gt;attr()</code> and ensure that the timezone info is correctly hydrated in the case of an unchanged block. [TEC-2964]</li>\n<li>Fix &#8211; Show the correct counts on the Event Aggregator Import &#8220;History&#8221; tab for non-Event content types being imported.</li>\n<li>Fix &#8211; Prevent creation of empty venue when removing a Venue inside of the Events using the Classic editor that had a US state selected. [TEC-3416]</li>\n<li>Fix &#8211; Event Aggregator imported events when using default status or categories from the Settings Page will now be imported correctly. [TEC-3445]</li>\n<li>Fix &#8211; A localization support that would mangle Views URLs when WPML plugin is active alongside Views v2 [TEC-3404]</li>\n<li>Fix &#8211; Prevent problems with <code>func_get_args()</code> usage around template inclusion for legacy template files [TEC-3104]</li>\n<li>Tweak &#8211; Extended support for namespaced classes in the Autoloader.</li>\n<li>Tweak &#8211; Make Customizer stylesheet enqueue filterable via <code>tribe_customizer_inline_stylesheets</code>. [TEC-3401]</li>\n<li>Tweak &#8211; Normalize namespaced prefixes with trailing backslash when registering them in the Autoloader. [VE-14]</li>\n<li>Language &#8211; 2 new strings added, 243 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[5.1.0] 2020-04-23</h4>\n<ul>\n<li>Feature &#8211; Add a &#8220;fast forward&#8221; link to Month and Day views when there are no events to show. [TEC-3400]</li>\n<li>Feature &#8211; Add <code>tribe_events_views_v2_use_ff_link</code> and <code>tribe_events_views_v2_{$this-&gt;slug}_use_ff_link</code> filters to allow control of the link. [TEC-3400]</li>\n<li>Feature &#8211; Add Recent Past Events Views. [TEC-3385]</li>\n<li>Tweak &#8211; Improved on meta data handling of for Blocks editor.</li>\n<li>Tweak &#8211; Deprecate Select2 3.5.4 in favor of SelectWoo</li>\n<li>Tweak &#8211; Load plugin text domain on the new <code>tribe_load_text_domains</code> action hook, which fires on <code>init</code> instead of on the <code>plugins_loaded</code> hook. [TEC-3406]</li>\n<li>Tweak &#8211; Add a constant <code>TRIBE_CACHE_VIEWS</code> to turn off views HTML caching.</li>\n<li>Fix &#8211; Theme navigation warning around <code>post_date = \'0\'</code> no longer happens when using Page template for Updated Views [TEC-3434]</li>\n<li>Fix &#8211; Selecting other Page templates from Settings &gt; Display now loads the correct template properly, to display events.</li>\n<li>Fix &#8211; Preventing redirects from updated Views V2 to be too broad and end up catching requests from other Plugins, reported by GravityView team on Gravity Forms bug with imports.</li>\n<li>Fix &#8211; Prevent PHP errors from happening during bulk activation or deactivation of the plugin [TCMN-53]</li>\n<li>Fix &#8211; Correct iCal link on month view for months other than the current one [TEC-3267]</li>\n<li>Fix &#8211; Correct a few incorrect and/or typoed text domains [TEC-3390]</li>\n<li>Fix &#8211; Ensure we pass search keywords when changing views and in the top-bar nav [TEC-3282]</li>\n<li>Fix &#8211; Prevent Blocks editor from throwing browser alert when leaving the page without any changes applied to the edited post.</li>\n<li>Fix &#8211; Several strings have been adjusted for consistency and better translatability [TEC-3417]</li>\n<li>Hook &#8211; Add the <code>tribe_events_blocks_editor_is_on</code> filter; returning a falsy value from this filter will prevent the Blocks Editor to ever be active on Events; else the settings from Events &gt; Settings will apply [TEC-3349]</li>\n<li>Tweak &#8211; Add some filters for better control of link targets, standardize the way we create those links [TEC-3402]</li>\n<li>Language &#8211; 4 new strings added, 286 updated, 1 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[5.0.3.1] 2020-03-23</h4>\n<ul>\n<li>Fix &#8211; Assets class modification to prevent JavaScript and CSS failing to load when <code>SCRIPT_DEBUG=true</code> [TCMN-52]</li>\n</ul>\n<h4>[5.0.3] 2020-03-23</h4>\n<ul>\n<li>Feature &#8211; Allow users to set a custom name for new Event Aggregator Imports. [TEC-3286]</li>\n<li>Tweak &#8211; Add back missing JSON-LD to Single Events. [TEC-3262]</li>\n<li>Tweak &#8211; Minify the Freemius svg assets. [TEC-3215]</li>\n<li>Tweak &#8211; Remove &#8220;(beta)&#8221; label from URL source type of import. [TEC-3289]</li>\n<li>Tweak &#8211; Reword the Filter Activation setting&#8217;s labels for better clarity.  [FBAR-79]</li>\n<li>Fix &#8211; Ensure that any values for <code>liveFilterUpdate</code> that are not <code>automatic</code> or <code>manual</code> get converted. [FBAR-83]</li>\n<li>Fix &#8211; Breakpoint code compatibility with the latest version of jQuery 3.4.1 [TEC-3251]</li>\n<li>Fix &#8211; Remove numbers from listed events in event list widget for Genesis theme. [TEC-2957]</li>\n<li>Fix &#8211; Customizer accent color affects featured line and text. [TEC-3277]</li>\n<li>Fix &#8211; Resolve conflict between datepicker holding consistent size when navigating and flexibility on small screen sizes. [TEC-3322]</li>\n<li>Fix &#8211; Respect EA <code>post_status</code> from settings when an event does not have a defined value. [TEC-3255]</li>\n<li>Fix &#8211; Save the <code>post_status</code> for a scheduled import when using a different value other than <code>publish</code>. [TEC-3296]</li>\n<li>Fix &#8211; Update events, venues, and organizers to use dynamic labels. [TEC-3280]</li>\n<li>Fix &#8211; Resolve an issue in Views v2 that would break URLs when the event single and archive slugs have the same value due to the &#8220;Events URL slug&#8221; and &#8220;Single event URL slug&#8221; settings or due to their translations [TEC-3254]</li>\n<li>Fix &#8211; Restore correct handling of events RSS feeds; events will show in the RSS feed in ascending start date, starting from the current day and the event publish date will be set to the event start date [TEC-3252]</li>\n<li>Hook &#8211; Add filters <code>tribe_events_liveupdate_automatic_label_text</code> and <code>tribe_events_liveupdate_manual_label_text</code> to allow Filter Bar to include itself in those labels. [TEC-3322]</li>\n<li>Hook &#8211; Add the <code>tribe_views_v2_events_query_controller_active</code> filter; returning a falsy value from this filter will prevent Views v2 from altering the WordPress query. This filter allows handling situations where Views v2 might interfere with third party plugins (e.g. custom RSS feed implementations) [TEC-3252]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_option_convert_live_filters</code>, <code>tribe_events_views_v2_messages_need_events_label_keys</code></li>\n<li>Tweak &#8211; Removed filters: <code>tribe_events_ical_export_text</code></li>\n<li>Tweak &#8211; Changed views: <code>v2/components/events-bar/search/keyword</code>, <code>v2/month/calendar-body/day</code></li>\n<li>Language &#8211; 11 new strings added, 81 updated, 0 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[5.0.2.1] 2020-02-25</h4>\n<ul>\n<li>Fix &#8211; Plugin dependency registration with <code>Plugin_Register</code> will not prevent loading of all plugins in list if the last item loaded fails. [TCMN-41]</li>\n</ul>\n<h4>[5.0.2] 2020-02-19</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.0.2 is only compatible with Filter Bar 4.9.2 and higher</li>\n<li>Version &#8211; The Events Calendar 5.0.2 is only compatible with Events Calendar PRO 5.0.2 and higher</li>\n<li>Tweak &#8211; Modify Link Color Customizer option for single event links in description, the venue, the organizer, and the website link in classic editor.  [TEC-3219]</li>\n<li>Tweak &#8211; Move link color option to General tab in Customizer and remove Text tab.  [TEC-3244]</li>\n<li>Tweak &#8211; Freemius Opt-out workflow now present on all occasions [TEC-3171]</li>\n<li>Tweak &#8211; Freemius updated to the latest version 2.3.2 [TEC-3171]</li>\n<li>Tweak &#8211; Remove the &#8220;Default stylesheet &#8211; full&#8221; option from display settings, for the new views. [TEC-3125]</li>\n<li>Tweak &#8211; Change the live refresh option to a radio, adjust conditional checks to accommodate. [TEC-3072]</li>\n<li>Fix &#8211; Freemius activation URL send via email works as expected [TEC-3218]</li>\n<li>Fix &#8211; Improve compatibility from Updated Views V2 with Beaver Builder plugins [TEC-3248]</li>\n<li>Fix &#8211; More robust handling of <code>hide_from_listings</code> in REST API v2, thanks @maxm123</li>\n<li>Fix &#8211; Make sure the new Views (v2) will correctly print JSON-LD schema information [TEC-3241]</li>\n<li>Language &#8211; 4 new strings added, 248 updated, 1 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[5.0.1] 2020-02-12</h4>\n<ul>\n<li>Version &#8211; The Events Calendar 5.0.1 is only compatible with Filter Bar 4.9.1 and higher</li>\n<li>Version &#8211; The Events Calendar 5.0.1 is only compatible with Events Calendar PRO 5.0.1 and higher</li>\n<li>Feature &#8211; Add the &#8220;Accent Color&#8221; option in the customizer, for the new views. [TEC-3067]</li>\n<li>Fix &#8211; Fix venue block title from being indented in Twenty Twenty theme. [TEC-3140]</li>\n<li>Fix &#8211; Fix website block label from disappearing when adding event details classic block. [TEC-2971]</li>\n<li>Fix &#8211; Fix style overrides for new view shortcodes for Enfold theme. [ECP-315]</li>\n<li>Fix &#8211; Fix events bar input class recognition for JS handling in new views. [TEC-3091]</li>\n<li>Fix &#8211; Ensure datepicker does not get cut off in small width screens for new views. [TEC-2983]</li>\n<li>Fix &#8211; Venue and organizer blocks link to venue and organizer pages if Events Calendar Pro is activated. [ECP-14]</li>\n<li>Fix &#8211; Use proper check for map on venue block to apply proper class. [TEC-3020]</li>\n<li>Fix &#8211; Remove font family applied to organizer block to allow theme styles to be applied. [TEC-2974]</li>\n<li>Fix &#8211; Fix numbers breaking into two lines in datepicker in Twenty Twenty theme. [TEC-2999]</li>\n<li>Fix &#8211; Fix tooltips being cut off and hidden in month view. [TEC-3000]</li>\n<li>Fix &#8211; Fix event sharing block cutting off text in block editor admin when editing event. [TEC-2972]</li>\n<li>Fix &#8211; Fix disappearing price description in block editor admin when editing event. [TEC-2992]</li>\n<li>Fix &#8211; Allow venues to be properly removed by clicking the remove venue button in the venue block. [TEC-2965]</li>\n<li>Fix &#8211; Ensure map does not display if enable map setting is disabled. [TEC-3013]</li>\n<li>Fix &#8211; Fix the datepicker width problem in Google Chrome, for the new views. [TEC-2995]</li>\n<li>Fix &#8211; Fix an issue where Venue provinces would be incorrectly populated in iCal exports [TEC-3223]</li>\n<li>Fix &#8211; Deleting events after X feature no longer will delete posts with <code>_EventEndDate</code> meta [TEC-3233]</li>\n<li>Tweak &#8211; Adjust tooltip title styles for Twenty Twenty theme. [TEC-2998]</li>\n<li>Tweak &#8211; Remove find events button and related data when events bar is disabled. [TEC-3074]</li>\n<li>Tweak &#8211; Ensure datepicker always updates view via live refresh. [TEC-3073]</li>\n<li>Tweak &#8211; Adjust customizer labels for sites using the new views [TEC-3066]</li>\n<li>Tweak &#8211; Allow start datetime and end datetime to be the same to hide end datetime in frontend when using block editor. [TEC-3009]</li>\n<li>Tweak &#8211; Move the &#8220;Link Color&#8221; option in the customizer, for the new views. [TEC-3067]</li>\n<li>Language &#8211; 14 new strings added, 256 updated, 0 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[5.0.0.2] 2020-02-06</h4>\n<ul>\n<li>Fix &#8211; Datepicker format now properly defaults to the correct value when Display Settings have not been saved. [TEC-3229]</li>\n<li>Fix &#8211; New views mobile breakpoints interactions with Caching plugins resolved. [TEC-3221]</li>\n</ul>\n<h4>[5.0.0.1] 2020-01-31</h4>\n<ul>\n<li>Fix &#8211; Events with timezones that differ from the site timezone now display on the correct date. [TEC-3208]</li>\n<li>Fix &#8211; Multi-day events now display on all days that they are supposed to. [TEC-3212]</li>\n<li>Fix &#8211; End of day cutoff is now being observed appropriately when creating the day grid stack. [TEC-3210]</li>\n<li>Fix &#8211; Fix number of parameters when doing <code>the_post</code> action, for the single event view in the new views. [TEC-3214]</li>\n<li>Fix &#8211; 404s on permalinks have been resolved by moving the flush permalink action to a later moment of time on activation after all rules have been declared. [TEC-3211]</li>\n</ul>\n<h4>[5.0.0] 2020-01-27</h4>\n<ul>\n<li>Feature &#8211; Created new Month, Day, and List views with all new HTML, CSS, and JavaScript.</li>\n<li>Feature &#8211; Add upgrade path for new Month, Day, and List views making it opt-in for any existing users.</li>\n<li>Feature &#8211; New templating engine to power the new Views. <a href=\"https://evnt.is/1aid\" rel=\"nofollow ugc\">See More</a></li>\n<li>Feature &#8211; Views initialization and instance includes more filters and actions to allow improved extensibility and customization. (See all filters below)</li>\n<li>Feature &#8211; Views manager and bootstrapping classes were created to allow more control over where and when views will be initialized. (See filters related to those below)</li>\n<li>Feature &#8211; Reduced maintenance burden of customizations by leveraging atomic templates for the new views. (See list of files now available below)</li>\n<li>Feature &#8211; CSS uses a Block Element Modifier (BEM) methodology to improve reusability of components. <a href=\"https://evnt.is/1aib\" rel=\"nofollow ugc\">See More</a></li>\n<li>Feature &#8211; New Views share one JavaScript Manager, which contains multiple jQuery actions and customization points.</li>\n<li>Feature &#8211; View navigation relies on the WP Rest API, improving reliability and caching opportunities.</li>\n<li>Feature &#8211; Event permalinks are now more consistent across navigation using <code>WP_Rewrite</code> to map params to their matching URL, which improves SEO.</li>\n<li>Feature &#8211; Event data filtering used across all new views: <code>tribe_get_event_before</code>, <code>tribe_get_event</code>, <code>tribe_get_event_after</code>, <code>tribe_events_organizers_fetch_callback</code>, <code>tribe_events_venues_fetch_callback</code></li>\n<li>Feature &#8211; Venue data filtering used across all new views: <code>tribe_get_venue_object_before</code>, <code>tribe_get_venue_object</code></li>\n<li>Tweak &#8211; Custom Before and After HTML on the Events &gt; Settings page will now prefer event view styling over the Theme&#8217;s CSS.</li>\n<li>Tweak &#8211; Lowered the reliance on the global <code>$wp_query</code> to create more consistent output and faster maintenance. <a href=\"https://evnt.is/1aic\" rel=\"nofollow ugc\">See More</a></li>\n<li>Tweak &#8211; View overrides for the new views will look within a new folder in your theme to avoid conflicting with old The Events Calendar theme customizations <a href=\"https://evnt.is/1aia\" rel=\"nofollow ugc\">See More</a></li>\n<li>Tweak &#8211; Switch to a compact date while on day and month view in mobile [136789]</li>\n<li>Tweak &#8211; Remove <code>tribe_events_getLink</code> in favor of <code>tribe_events_get_link</code> which was a deprecated filter since version 4.3</li>\n<li>Hooks &#8211; View template include and render filters and actions: <code>tribe_template_before_include</code>, <code>tribe_template_before_include:{$template_path}</code>, <code>tribe_template_after_include</code>, <code>tribe_template_after_include:{$template_path}</code>, <code>tribe_template_html</code>, <code>tribe_template_html:{$template_path}</code></li>\n<li>Hooks &#8211; View instance filters and actions: <code>tribe_events_views_v2_view_template</code>, <code>tribe_events_views_v2_{$view_slug}_view_template</code>, <code>tribe_events_views_v2_view_context</code>, <code>tribe_events_views_v2_{$view_slug}_view_context</code>, <code>tribe_events_views_v2_view_repository</code>, <code>tribe_events_views_v2_{$view_slug}_view_repository</code>, <code>tribe_events_views_v2_view_url_query_args</code>, <code>tribe_events_views_v2_{$view_slug}_view_url_query_args</code>, <code>tribe_events_views_v2_view_html_classes</code>, <code>tribe_events_views_v2_{$view_slug}_view_html_classes</code>, <code>tribe_events_views_v2_url_query_args</code>, <code>tribe_events_views_v2_view_template_vars</code>, <code>tribe_events_views_v2_view_{$view_slug}_template_vars</code>, <code>tribe_events_views_v2_view_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_url</code>, <code>tribe_events_views_v2_view_prev_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_prev_url</code>, <code>tribe_events_views_v2_view_next_url</code>, <code>tribe_events_views_v2_view_{$view_slug}_next_url</code>, <code>tribe_events_views_v2_view_repository_args</code>, <code>tribe_events_views_v2_view_link_label_format</code>, <code>tribe_events_views_v2_view_{$view_slug}_link_label_format</code>, <code>tribe_events_views_v2_view_title</code>, <code>tribe_events_views_v2_view_{$view_slug}_title</code>, <code>tribe_events_views_v2_view_messages</code>, <code>tribe_events_views_v2_view_{$view_slug}_messages</code>, <code>tribe_events_views_v2_view_breadcrumbs</code>, <code>tribe_events_views_v2_view_{$view_slug}_breadcrumbs</code>, <code>tribe_events_views_v2_view_display_events_bar</code>, <code>tribe_events_views_v2_view_{$view_slug}_display_events_bar</code>, <code>tribe_events_views_v2_view_ical_data</code>, <code>tribe_events_views_v2_view_{$view_slug}_ical_data</code>, <code>tribe_events_views_v2_view_show_datepicker_submit</code>, <code>tribe_events_views_v2_view_{$view_slug}_show_datepicker_submit</code>, <code>tribe_events_views_v2_view_public_views</code>, <code>tribe_events_views_v2_view_{$view_slug}_public_views</code>, <code>tribe_events_views_v2_view_data</code>, <code>tribe_events_views_v2_{$view_slug}_view_data</code>, <code>tribe_events_views_v2_{$view_slug}_events_per_day</code>, <code>tribe_events_views_v2_month_events_per_day</code>, <code>tribe_events_views_v2_month_nav_skip_empty</code>, <code>tribe_events_views_v2_view_breakpoints</code>, <code>tribe_events_views_v2_view_{$view_slug}_breakpoints</code>, <code>tribe_events_views_v2_before_make_view</code>, <code>tribe_events_views_v2_after_make_view</code>, <code>tribe_events_views_v2_messages_map</code>, <code>tribe_events_views_v2_view_messages_before_render</code></li>\n<li>Hooks &#8211; View REST API HTML request actions and filters: <code>tribe_events_views_v2_request_arguments</code>, <code>tribe_events_views_v2_rest_endpoint_available</code>, <code>tribe_events_views_v2_rest_params</code>, <code>tribe_events_views_v2_{$view_slug}_rest_params</code></li>\n<li>Hooks &#8211; Views Bootstrap filters and actions: <code>tribe_events_views_v2_bootstrap_pre_get_view_html</code>, <code>tribe_events_views_v2_bootstrap_should_display_single</code>, <code>tribe_events_views_v2_bootstrap_view_slug</code>, <code>tribe_events_views_v2_bootstrap_pre_should_load</code>, <code>tribe_events_views_v2_should_hijack_page_template</code></li>\n<li>Hooks &#8211; Views Manager filters and actions: <code>tribe_events_views</code>, <code>tribe_events_views_v2_manager_default_view</code>, <code>tribe_events_views_v2_manager_view_label_domain</code>, <code>tribe_events_views_v2_manager_{$view_slug}_view_label_domain</code>, <code>tribe_events_views_v2_manager_view_label</code>, <code>tribe_events_views_v2_manager_{$view_slug}_view_label</code></li>\n<li>Hooks &#8211; Other views filters and actions: <code>tribe_events_views_v2_is_enabled</code>, <code>tribe_events_views_v2_assets_should_enqueue_frontend</code>, <code>tribe_events_views_v2_assets_should_enqueue_full_styles</code>, <code>tribe_events_v2_view_title</code>, <code>tribe_events_views_v2_should_replace_excerpt_more_link</code>, <code>tribe_events_views_v2_view_before_events_html</code>, <code>tribe_events_views_v2_view_after_events_html</code>, <code>tribe_events_views_v2_month_title</code>, <code>tribe_events_views_v2_day_title</code>, <code>tribe_events_views_v2_category_title</code>, <code>tribe_events_views_v2_theme_compatibility_registered</code>, <code>tribe_events_views_v2_stack_spacer</code>, <code>tribe_events_views_v2_stack_recycle_spaces</code>, <code>tribe_events_views_v2_stack_events</code>, <code>tribe_events_views_v2_stack_filter_event</code>, <code>tribe_events_views_v2_stack_normalize</code></li>\n<li>Templates &#8211; Views refactored template files: <code>v2/base</code>, <code>v2/components/after</code>, <code>v2/components/before</code>, <code>v2/components/breadcrumbs</code>, <code>v2/components/breadcrumbs/breadcrumb</code>, <code>v2/components/breadcrumbs/linked-breadcrumb</code>, <code>v2/components/breakpoints</code>, <code>v2/components/data</code>, <code>v2/components/events-bar</code>, <code>v2/components/events-bar/filters</code>, <code>v2/components/events-bar/search-button</code>, <code>v2/components/events-bar/search-button/icon</code>, <code>v2/components/events-bar/search</code>, <code>v2/components/events-bar/search/keyword</code>, <code>v2/components/events-bar/search/submit</code>, <code>v2/components/events-bar/tabs</code>, <code>v2/components/events-bar/views</code>, <code>v2/components/events-bar/views/list</code>, <code>v2/components/events-bar/views/list/item</code>, <code>v2/components/filter-bar</code>, <code>v2/components/ical-link</code>, <code>v2/components/loader</code>, <code>v2/components/messages</code>, <code>v2/components/read-more</code>, <code>v2/components/top-bar/actions</code>, <code>v2/components/top-bar/actions/content</code>, <code>v2/components/top-bar/datepicker/submit</code>, <code>v2/components/top-bar/nav</code>, <code>v2/components/top-bar/nav/next-disabled</code>, <code>v2/components/top-bar/nav/next</code>, <code>v2/components/top-bar/nav/prev-disabled</code>, <code>v2/components/top-bar/nav/prev</code>, <code>v2/components/top-bar/today</code>, <code>v2/day</code>, <code>v2/day/event</code>, <code>v2/day/event/cost</code>, <code>v2/day/event/date</code>, <code>v2/day/event/date/meta</code>, <code>v2/day/event/description</code>, <code>v2/day/event/featured-image</code>, <code>v2/day/event/title</code>, <code>v2/day/event/venue</code>, <code>v2/day/nav</code>, <code>v2/day/nav/next-disabled</code>, <code>v2/day/nav/next</code>, <code>v2/day/nav/prev-disabled</code>, <code>v2/day/nav/prev</code>, <code>v2/day/time-separator</code>, <code>v2/day/top-bar</code>, <code>v2/day/top-bar/datepicker</code>, <code>v2/day/type-separator</code>, <code>v2/index</code>, <code>v2/list</code>, <code>v2/list/event</code>, <code>v2/list/event/cost</code>, <code>v2/list/event/date-tag</code>, <code>v2/list/event/date</code>, <code>v2/list/event/date/meta</code>, <code>v2/list/event/description</code>, <code>v2/list/event/featured-image</code>, <code>v2/list/event/title</code>, <code>v2/list/event/venue</code>, <code>v2/list/month-separator</code>, <code>v2/list/nav</code>, <code>v2/list/nav/next-disabled</code>, <code>v2/list/nav/next</code>, <code>v2/list/nav/prev-disabled</code>, <code>v2/list/nav/prev</code>, <code>v2/list/nav/today</code>, <code>v2/list/top-bar</code>, <code>v2/list/top-bar/datepicker</code>, <code>v2/month</code>, <code>v2/month/calendar-body</code>, <code>v2/month/calendar-body/day</code>, <code>v2/month/calendar-body/day/calendar-events</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/date</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/date/meta</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/featured-image</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/title</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/cost</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date/meta</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/description</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/featured-image</code>, <code>v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/title</code>, <code>v2/month/calendar-body/day/more-events</code>, <code>v2/month/calendar-body/day/multiday-events</code>, <code>v2/month/calendar-body/day/multiday-events/multiday-event-spacer</code>, <code>v2/month/calendar-body/day/multiday-events/multiday-event</code>, <code>v2/month/calendar-header</code>, <code>v2/month/mobile-events</code>, <code>v2/month/mobile-events/mobile-day</code>, <code>v2/month/mobile-events/mobile-day/day-marker</code>, <code>v2/month/mobile-events/mobile-day/mobile-event</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/cost</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/date</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/date/meta</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/featured-image</code>, <code>v2/month/mobile-events/mobile-day/mobile-event/title</code>, <code>v2/month/mobile-events/mobile-day/more-events</code>, <code>v2/month/mobile-events/nav</code>, <code>v2/month/mobile-events/nav/next-disabled</code>, <code>v2/month/mobile-events/nav/next</code>, <code>v2/month/mobile-events/nav/prev-disabled</code>, <code>v2/month/mobile-events/nav/prev</code>, <code>v2/month/mobile-events/nav/today</code>, <code>v2/month/top-bar</code>, <code>v2/month/top-bar/datepicker</code>, <code>v2/not-found</code></li>\n<li>Language &#8211; 2 new strings added, 169 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.14] 2020-01-15</h4>\n<ul>\n<li>Feature &#8211; Add Repository filter <code>where_meta_related_by_meta</code> for getting a post by the meta value an associated post. [133333]</li>\n<li>Tweak &#8211; Modifications to the Freemius code initialization to allow better data around plugin uninstalls.</li>\n<li>Tweak &#8211; Adjust tooltip title styles for Twenty Twenty theme. [TEC-2998]</li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-venue</code></li>\n<li>Fix &#8211; Cost field description no longer disappears when editing the block. [TEC-2992]</li>\n<li>Fix &#8211; Organizer theme no longer getting overwritten by Blocks editor styles. [TEC-2974]</li>\n<li>Fix &#8211; Venue block properly receives the correct HTML class. [TEC-3020]</li>\n<li>Fix &#8211; Correct missing block when switching from blocks to classic editor. [131493]</li>\n</ul>\n<h4>[4.9.13] 2019-12-10</h4>\n<ul>\n<li>Tweak &#8211; Allow Event Aggregator date refinements for Eventbrite source.</li>\n<li>Language &#8211; 29 new strings added, 201 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.12] 2019-11-20</h4>\n<ul>\n<li>Fix &#8211; Blocks Editor date time saving correctly for WordPress 5.3 compatibility. [137421]</li>\n<li>Tweak &#8211; Add the <code>tribe_get_query_var</code> function [137262]</li>\n<li>Tweak &#8211; Add <code>tribe_get_the_content()</code> and <code>tribe_the_content()</code> for PHP 7.2 compatibility with WordPress 5.2</li>\n<li>Language &#8211; 21 new strings added, 162 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.11] 2019-11-12</h4>\n<ul>\n<li>Feature &#8211; Opt-in to the newly redesigned views</li>\n<li>Fix &#8211; Fixed issue where DD/MM/YYYY style dates were not supported during Event Aggregator imports [117691]</li>\n<li>Fix &#8211; Resolved issue where non YYYY-MM-DD datepicker formats resulted in unpredictable behavior while navigating views [116086, 126472, 117909]</li>\n<li>Fix &#8211; Fixed date issue where the event date was defaulting to current date when editing an event with the block editor [132735]</li>\n<li>Tweak &#8211; Added additional datepicker formats for simpler selection [116086, 126472, 117909]</li>\n<li>Tweak &#8211; Updated the Repository implementation to handle more complex <code>orderby</code> constructs [133303]</li>\n<li>Tweak &#8211; Added the <code>Tribe__Date_Utils::get_week_start_end</code> method [133303]</li>\n<li>Tweak &#8211; added the <code>tribe_events_suppress_query_filters</code> filter to allow suppressing <code>Tribe__Events__Query</code> filters [134827]</li>\n<li>Language &#8211; 5 new strings added, 23 updated, 2 fuzzied, and 13 obsoleted</li>\n</ul>\n<h4>[4.9.10] 2019-10-16</h4>\n<ul>\n<li>Tweak &#8211; added the <code>tribe_sanitize_deep</code> function to sanitize and validate input values [134427]</li>\n<li>Tweak &#8211; use the <code>tribe_sanitize_deep</code> function to sanitize the values returned by the <code>tribe_get_request_var</code> function [134427]</li>\n<li>Tweak &#8211; Rename &#8220;Datepicker Date Format&#8221; to &#8220;Compact Date Format&#8221; [134526]</li>\n<li>Tweak &#8211; Adjust Promoter loading order to increase compatibility with plugins that use authentication early in the process [134862]</li>\n<li>Tweak &#8211; Add support for Authentication using a Header when using Promoter [133922]</li>\n<li>Language &#8211; 2 new strings added, 25 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.9.9] 2019-09-25</h4>\n<ul>\n<li>Fix &#8211; Set the start date with the current day for the &#8220;All&#8221; events page for recurring events. Thanks Andy, leapness and others for flagging this! [130350]</li>\n<li>Tweak &#8211; Updated Freemius integration code [133148]</li>\n<li>Tweak &#8211; Conform iCalendar feed to specifications by not putting quotes around the timezone ID. This fixes some custom parsers [133626]</li>\n<li>Language &#8211; 0 new strings added, 16 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.9.8] 2019-09-04</h4>\n<ul>\n<li>Tweak &#8211; Added the Monolog logging library as alternative logging backend [120785]</li>\n<li>Tweak &#8211; Hook Monolog logger on <code>tribe_log</code> action [120785]</li>\n<li>Tweak &#8211; Add redirection of <code>tribe( \'logger\' )-&gt;log()</code> calls to the Monolog logger using the <code>tribe_log_use_action_logger</code> filter [120785]</li>\n<li>Fix &#8211; Conform iCalendar feed to specifications by not putting quotes around the timezone. This fixes Outlook compatibility [131791]</li>\n<li>Fix &#8211; Additional fields with multiple values using pipes <code>|</code> as separators are working properly on importing again. [131510]</li>\n<li>Fix &#8211; Fix default view redirection loop on mobile devices. Thanks Ricardo, cittaslow and others for flagging this! [125567]</li>\n<li>Fix &#8211; Handling of featured image setting during Event Aggregator CSV imports [127132]</li>\n<li>Language &#8211; 1 new strings added, 10 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.7] 2019-08-19</h4>\n<ul>\n<li>Tweak &#8211; Update Lodash version on Block editor to prevent any possibility of a security issue with the package. From v4.17.11 to v4.17.15 [131421]</li>\n<li>Tweak &#8211; Add filter &#8216;tribe_events_js_config&#8217; to allow filtering the contents of the Javascript configuration [132567]</li>\n<li>Tweak &#8211; Updates to the shortcode Javascript code to allow disabling the URL manipulation behavior [132567]</li>\n<li>Fix &#8211; Prevent mascot image to get blown up out of proportions to a larger size on buggy CSS loading. [131910]</li>\n<li>Language &#8211; 3 new strings added, 191 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.6] 2019-08-07</h4>\n<ul>\n<li>Tweak &#8211; Update Event Aggregator to include compatibility with new Meetup API requirements &#8211; <a href=\"https://evnt.is/1afb\" rel=\"nofollow ugc\">See more</a> [125635]</li>\n<li>Language &#8211; 5 new strings added, 120 updated, 5 fuzzied, and 10 obsoleted</li>\n</ul>\n<h4>[4.9.5] 2019-07-25</h4>\n<ul>\n<li>Tweak &#8211; Update redirection URLs for Freemius actions [130281]</li>\n<li>Fix &#8211; Location filtering for Context class moved out of construct, resolving lots of navigation problems across The Events Calendar [130754]</li>\n<li>Fix &#8211; Featured event AJAX and browser navigation working as expected for all use cases. [127272]</li>\n<li>Fix &#8211; Shortcode properly handling featured param on AJAX requests. [114002]</li>\n<li>Fix &#8211; Remove removing wpautop for gutenberg blocks to fix spacing when content comes from classic editor. [122801]</li>\n<li>Language &#8211; 4 new strings added, 16 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.4] 2019-07-03</h4>\n<ul>\n<li>Tweak &#8211; Add filter <code>tribe_events_event_insert_args</code> the arguments in prior to inserting the event and meta fields. [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_event_update_args</code> the arguments prior the update of an event and meta fields. [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_event_prevent_update</code> to disable the update for an event via the Tribe API [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_archive_get_args</code> to filter the arguments used to get the events on the archive page via REST API. [129517]</li>\n<li>Tweak &#8211; Add filter <code>tribe_events_validator_is_event_id</code> to define if is a valid event_id [129517]</li>\n<li>Tweak &#8211; Add action <code>tribe_rest_before_event_data</code> executed before the Event data is pulled before deliver the Event via REST API. [129517]</li>\n<li>Tweak &#8211; Add <code>Tribe__Events__Query::last_found_events()</code> to access the last results via the <code>Query</code> object [129517]</li>\n<li>Tweak &#8211; Wrap <code>register_rest_route</code> calls with <code>tribe_register_rest_route</code> to enable filtering on REST registration</li>\n<li>Tweak &#8211; Add filter <code>tribe_ical_feed_vtimezone</code> to filter the <code>VTIMEZONE</code> group [89999]</li>\n<li>Tweak &#8211; Include proper documentation of why the plugin has been deactivated and a knowledgebase article about how to downgrade [129726]</li>\n<li>Tweak &#8211; When trying to update The Events Calendar with an incompatible version of an Addon that is expired, it will stop the upgrade [129727]</li>\n<li>Tweak &#8211; Add filter <code>tribe_is_classic_editor_plugin_active</code> to change the output if the classic editor is active or not [121267]</li>\n<li>Tweak &#8211; Create a new key if <code>AUTH_KEY</code> is not defined or is empty and add a new filter <code>tribe_promoter_secret_key</code> to filter the result [127183]</li>\n<li>Tweak &#8211; Divide the <code>tribe-common.js</code> file to prevent that file from being bloated with external dependencies. [129526]</li>\n<li>Tweak &#8211; Make sure <code>UTC-0</code> is converted back to <code>UTC</code> instead of <code>UTC-01</code> [129240]</li>\n<li>Tweak &#8211; Add new function <code>tribe_register_rest_route</code> Wrapper around <code>register_rest_route</code> to filter the arguments when a new REST endpoint is created [129517]</li>\n<li>Tweak &#8211; Add new method <code>Tribe__Cost_Utils::parse_separators</code> to infer decimal and thousands separators from a value that might have been formatted in a local different from the current one [98061]</li>\n<li>Fix &#8211; Save of event meta data when Classic editor plugin and gutenberg blocks for events are enabled [121267]</li>\n<li>Fix &#8211; Moved The Events Calendar specific code from common Context class into The Events Calendar [129241]</li>\n<li>Fix &#8211; Fixed issue where multiday events were not returning correct end date in block editor [128033]</li>\n<li>Fix &#8211; Resolved issue where deactivation feedback was not hooked properly [128341]</li>\n<li>Fix &#8211; Added escaping to the event website URL target attribute [129565]</li>\n<li>Fix &#8211; Fix Timezone definitions for <code>*.ics</code> file on events [89999]</li>\n<li>Fix &#8211; Resolved an issue where non-English decimal and thousands event cost separators could lead to wrong cost values in REST API responses [98061]</li>\n<li>Fix &#8211; Prevent Clipboard Javascript from loading all over the place on <code>/wp-admin/</code> [129526]</li>\n<li>Fix &#8211; PHP 5.6 compatibility for <code>trait Cache_User</code> by using WP action <code>shutdown</code> instead of <code>__destruct</code> on our <code>WP_Rewrite</code> [129860]</li>\n<li>Language &#8211; 14 new strings added, 222 updated, 1 fuzzied, and 6 obsoleted</li>\n</ul>\n<h4>[4.9.3.2] 2019-06-20</h4>\n<ul>\n<li>Fix &#8211; Prevent issue where older versions of the tribe-common libraries could be bootstrapped [129478]</li>\n<li>Fix &#8211; Add Promoter PCSS file so that the proper CSS will be generated on package build [129584]</li>\n</ul>\n<h4>[4.9.3.1] 2019-06-07</h4>\n<ul>\n<li>Fix &#8211; Remove caching of rewrite base slugs which make third-party, Photo and Week work as expected [129035]</li>\n<li>Tweak &#8211; Adjust newsletter signup submission destination [129034]</li>\n</ul>\n<h4>[4.9.3] 2019-06-06</h4>\n<ul>\n<li>Fix &#8211; Fixed issue where the previous events link was not present on initial page load of the List View [127477]</li>\n<li>Language &#8211; 10 new strings added, 18 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.9.2] 2019-05-16</h4>\n<ul>\n<li>Tweak &#8211; In the Event Repository class: filter the event creation meta before checking it for coherency</li>\n<li>Tweak &#8211; Reduced file size by removing .po files and directing anyone creating or editing local translations to translate.wordpress.org</li>\n<li>Fix &#8211; Fix event bar issue where it was required to pick the date in order to search events via keyword or location [126158]</li>\n<li>Fix &#8211; Make back-compatibility handling more robust when dealing with classes non-existing in the older plugin versions [127173]</li>\n</ul>\n<h4>[4.9.1.1] 2019-05-06</h4>\n<ul>\n<li>Fix &#8211; Prevent Composer autoloader from throwing Fatal due to nonexistent <code>setClassMapAuthoritative()</code> method [126590]</li>\n</ul>\n<h4>[4.9.1] 2019-05-02</h4>\n<ul>\n<li>Fix &#8211; Prevent recurring events all page to throw 404 when events are in the past [126790]</li>\n<li>Fix &#8211; Backwards compatibility for <code>eventDisplay</code> usage around <code>list</code> and <code>day</code> only showing upcoming events [126686]</li>\n<li>Fix &#8211; List events Widget will display events until their end date has passed [126837]</li>\n<li>Tweak &#8211; Add values for the JSON-LD object to avoid Google console errors. Fields added: <code>offers.availability</code>, <code>offers.category</code>, <code>offers.priceCurrency</code>, <code>offers.validFrom</code> and <code>performer</code> [120193]</li>\n<li>Tweak &#8211; Add <code>tribe_events_cost_unformatted</code> filter to allow WPML support for WooCommerce Multilingual</li>\n<li>Language &#8211; 0 new strings added, 168 updated, 0 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[4.9.0.3] 2019-04-26</h4>\n<ul>\n<li>Fix &#8211; Prevent Composer autoloader from throwing Fatal due to nonexistent <code>setClassMapAuthoritative()</code> method [126590]</li>\n</ul>\n<h4>[4.9.0.2] 2019-04-25</h4>\n<ul>\n<li>Fix &#8211; Avoid fatals due to Query method not been present by bumping version of Event Tickets required to 4.10.4.2</li>\n</ul>\n<h4>[4.9.0.1] 2019-04-25</h4>\n<ul>\n<li>Fix &#8211; Modifications to <code>tribe_get_events()</code> to resolve problems introduced by latest release <code>4.9.0</code></li>\n<li>Fix &#8211; Backwards compatibility for <code>\'eventDisplay\' =&gt; \'upcoming\'</code> on <code>tribe_get_events()</code>. Thanks @softwebteam, @mrwweb and @karks88 [126124]</li>\n<li>Fix &#8211; Single navigation to next and previous events using the Object Relational Mapping classes [126144]</li>\n<li>Fix &#8211; Events displayed correctly on all views, using End date instead of Start Date. Making sure events that are not over still show on upcoming [126259]</li>\n</ul>\n<h4>[4.9.0] 2019-04-17</h4>\n<ul>\n<li>Feature &#8211; Refactor the Database Connection to start using an Object Relational Mapping tool for a better tested codebase</li>\n<li>Feature &#8211; Add the <code>tribe_events()</code> function as entry-point to the Events ORM and the supporting filter code [116356, 115579]</li>\n<li>Feature &#8211; Add the <code>tribe_venues()</code> function as entry-point to the Venues ORM and the supporting filter code [116356, 115579]</li>\n<li>Feature &#8211; Add the <code>tribe_organizers()</code> function as entry-point to the Organizers ORM and the supporting filter code [116356, 115579]</li>\n<li>Feature &#8211; Add additional caching to The Events Calendar REST API archives and the Post Repository event/venue/organizer responses [117159]</li>\n<li>Feature &#8211; Include Freemius integration on to allow opt-in information collection for 10{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} of new users</li>\n<li>Tweak &#8211; Setting the site of Timezones will trigger queries using UTC to equalize event dates on Views</li>\n<li>Tweak &#8211; Add filter to allow deactivating Freemius <code>tribe_events_integrations_should_load_freemius</code></li>\n<li>Tweak &#8211; Include a way for third-party to handle Known Range rebuilding of events <code>tribe_events_rebuild_known_range</code></li>\n<li>Tweak &#8211; All new granular handling for UTC and Timezone saving on the Classic editor</li>\n<li>Tweak &#8211; Add support for the <code>tribe_suppress_query_filters</code> query variable to prevent the plugin&#8217;s own query filters from applying [116356, 115579]</li>\n<li>Tweak &#8211; Add the <code>tribe_events_has_next_args</code> and <code>tribe_events_has_previous_args</code> filters to allow filtering the arguments that check if next/previous archive pages or events are available [123950]</li>\n<li>Fix &#8211; Include second param for the <code>the_title</code> for Events, Venue and Organizer Rest API endpoints amd prevent warnings. Props to Alex [123317]</li>\n<li>Language &#8211; 5 new strings added, 167 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.8.2] 2019-03-04</h4>\n<ul>\n<li>Fix &#8211; Resolve console warnings around React key usage for Blocks Editor [121198]</li>\n<li>Fix &#8211; Improve our <code>tribe_paged</code> URL parameter sanitization, preventing themes from printing the variable and causing XSS security issues [123616]</li>\n<li>Fix &#8211; Change ordering for Eventbrite Tickets on Event Aggregator, Ascending order by date is now the default [121979]</li>\n<li>Tweak &#8211; Day light savings notice will now reset 4 times per year when using any UTC Timezone [123221]</li>\n<li>Tweak &#8211; Start date for Event Aggregator is now required on Eventbrite Tickets [121979]</li>\n<li>Language &#8211; 3 new strings added, 172 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.8.1] 2019-02-14</h4>\n<ul>\n<li>Feature &#8211; Introduced new &#8220;(do not override)&#8221; default post status for Eventbrite imports in Event Aggregator. This preserves events&#8217; original statuses from Eventbrite.com upon import (e.g., &#8220;draft&#8221; events will not be automatically set to &#8220;publish&#8221; upon import) [112346]</li>\n<li>Fix &#8211; Make sure the setting for &#8220;Default mobile view&#8221; is respected. Thanks to Kathleen, Tim and others for reporting this! [119271]</li>\n<li>Fix &#8211; Apply block closer to price block [120108]</li>\n<li>Tweak &#8211; Added new filter <code>tribe_aggregator_new_event_post_status_before_import</code> to allow for custom handling of an event&#8217;s post status before EA an import is completed [112648]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_admin_js_ajax_url_data</code></li>\n<li>Tweak &#8211; Unload Image Widget Plus version 1.0.2 or older to Prevent it from creating fatals on The Events Calendar</li>\n<li>Language &#8211; 2 new strings added, 150 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.8] 2019-02-04</h4>\n<ul>\n<li>Feature &#8211; Introduced new &#8220;(do not override)&#8221; default post status for Eventbrite imports in Event Aggregator. This preserves events&#8217; original statuses from Eventbrite.com upon import (e.g., &#8220;draft&#8221; events will not be automatically set to &#8220;publish&#8221; upon import) [112346]</li>\n<li>Fix &#8211; Make sure the setting for &#8220;Default mobile view&#8221; is respected. Thanks to Kathleen, Tim and others for reporting this! [119271]</li>\n<li>Fix &#8211; Apply block closer to price block [120108]</li>\n<li>Tweak &#8211; Added new filter <code>tribe_aggregator_new_event_post_status_before_import</code> to allow for custom handling of an event&#8217;s post status before EA an import is completed [112648]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_events_admin_js_ajax_url_data</code></li>\n<li>Tweak &#8211; Unload Image Widget Plus version 1.0.2 or older to Prevent it from creating fatals on The Events Calendar</li>\n<li>Language &#8211; 2 new strings added, 150 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.8.0.1] 2019-02-07</h4>\n<ul>\n<li>Fix &#8211; Modify extension dependency checking with new system to determine if it can load [122368]</li>\n<li>Tweak &#8211; Prevent most extensions from loading if Event Tickets is on an older version to prevent conflicts [122368]</li>\n</ul>\n<h4>[4.8] 2019-02-05</h4>\n<ul>\n<li>Feature &#8211; Add check and enforce PHP 5.6 as the minimum version [116282]</li>\n<li>Feature &#8211; Add system to check plugin versions to inform you to update and prevent site breaking errors [116841]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_not_php_version_names</code></li>\n<li>Deprecated &#8211; Constants MIN_ET_VERSION and MIN_COMMON_VERSION in Tribe__Events__Main, use $min_et_version property and no replacement for MIN_COMMON_VERSION</li>\n<li>Deprecated &#8211; The <code>is_delayed_activation()</code>, <code>maybe_delay_activation_if_outdated_common()</code>, and <code>checkAddOnCompatibility()</code> method has been deprecated in <code>Tribe__Events__Main</code> in favor of new Dependency Checking System</li>\n<li>Language &#8211; 7 new strings added, 139 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.7.4] 2019-01-21</h4>\n<ul>\n<li>Fix &#8211; Display the tags block delimiter in the editor [119393]</li>\n<li>Fix &#8211; Fixed a number of small layout bugs with the new Twenty Nineteen core theme [119689]</li>\n<li>Fix &#8211; Save the &#8220;Event Options&#8221; when using the block editor [120168]</li>\n<li>Fix &#8211; Filter correctly when in Classic Editor page [120137]</li>\n<li>Fix &#8211; Give the ability to switch back from all day events in date time block [120266]</li>\n<li>Fix &#8211; Properly align the search or create results [120460]</li>\n<li>Fix &#8211; iCal export content for events created with the block editor [118679]</li>\n<li>Fix &#8211; Moved the &#8220;Remove venue&#8221; button for a better user experience when removing venues from an event [120267]</li>\n<li>Fix &#8211; Date/time block conflicts when clicking to open the block options [119413]</li>\n<li>Fix &#8211; Layout bugs with the new Twenty Nineteen core theme [119689]</li>\n<li>Fix &#8211; Include UTC dates meta on the event creation from the block editor [120399]</li>\n<li>Tweak &#8211; Ensure we don&#8217;t re-apply <code>wpautop()</code> to content that has had it removed [120562]</li>\n<li>Tweak &#8211; Added <code>tribe_events_admin_js_ajax_url_data</code> filter to make filtering the JS vars of TEC&#8217;s admin JS easier [116973]</li>\n<li>Tweak &#8211; Adjusted content in the admin welcome page that users are brought to upon newly activating The Events Calendar [117795]</li>\n<li>Tweak &#8211; Changed views: <code>blocks/event-tags</code></li>\n<li>Language &#8211; 3 new strings added, 21 updated, 1 fuzzied, and 5 obsoleted</li>\n</ul>\n<h4>[4.7.3] 2018-12-19</h4>\n<ul>\n<li>Tweak &#8211; Tweak the registration of the Event, Venue, and Organizer post types so they use some new post type labels introduced in WordPress 5.0 like <code>item_updated</code>, <code>item_scheduled</code>, etc. [119451]</li>\n<li>Fix &#8211; Password protected events breaking the month view. Thanks to Lindsay, Simon and others for flagging this out! [117385]</li>\n<li>Fix &#8211; Add proper capitalization for Event Price for Blocks Editor [119140]</li>\n<li>Fix &#8211; Make sure Datetime Format for Datepickers are respected on the Blocks Editor [117428]</li>\n<li>Fix &#8211; Correct text domain and remove old <code>events-gutenberg</code> [118656]</li>\n<li>Fix &#8211; Properly display recurrence description on Blocks Editor view [119354]</li>\n<li>Fix &#8211; Point support links to the correct places [117795]</li>\n<li>Language &#8211; 27 new strings added, 106 updated, 0 fuzzied, and 13 obsoleted</li>\n</ul>\n<h4>[4.7.2] 2018-12-13</h4>\n<ul>\n<li>Feature &#8211; Added new action <code>tribe_events_before_event_template_data_date_display</code> and <code>tribe_events_after_event_template_data_date_display</code></li>\n<li>Tweak &#8211; Corrected font on time picker components in Event Date Time block [116907]</li>\n<li>Tweak &#8211; Adjusted padding on the Event Date Time block [118697]</li>\n<li>Tweak &#8211; Set default start time to 8:00am and default end time to 5:00pm in Event Date Time block [118112]</li>\n<li>Fix &#8211; Corrected an issue where feature detection of async-process support would fire too many requests [118876]</li>\n<li>Fix &#8211; Removed tribe_events_template_data()&#8217;s dependency on Events Calendar PRO, which could lead to a fatal error under some conditions [119263]</li>\n<li>Fix &#8211; Made the Event Date Time block respect the timezone settings [118682]</li>\n<li>Fix &#8211; Removed Price block dashboard gap [118683]</li>\n<li>Fix &#8211; Made sure all block editor code for Meta saving is PHP 5.2 compatible</li>\n<li>Fix &#8211; Prevented <code>undefined</code> from been displayed at the Event Date Time separator fields [119337]</li>\n<li>Fix &#8211; Solved 500 error when trying to update an event [118058]s</li>\n</ul>\n<h4>[4.7.1] 2018-12-05</h4>\n<ul>\n<li>Feature &#8211; Added additional caching to TEC REST API archives and the Post Repository event/venue/organizer responses [117159]</li>\n<li>Feature &#8211; Added new <code>tribe_events_set_month_view_events_from_cache</code> action to make it easier to listen for when Month View events are retrieved from the Month View cache [116124]</li>\n<li>Fix &#8211; Importing CSV files with whitespace at the beginning of the rows won&#8217;t remove headers and skip columns on Preview [117236]</li>\n<li>Fix &#8211; Prevent JavaScript error in Month View when the Date filter is removed from the Tribe Bar (thank you to @tyrann0us on GitHub for submitting this fix!) [116995]</li>\n<li>Fix &#8211; Facilitate automated updates for Events Calendar PRO even if it&#8217;s requirements have not been met</li>\n</ul>\n<h4>[4.7.0.1] 2018-11-30</h4>\n<ul>\n<li>Fix &#8211; Update common library to maximize compatibility with earlier PHP versions (our thanks to @megabit81 for highlighting this problem) [119073]</li>\n<li>Fix &#8211; Update common library to ensure better compatibility with addons running inside multisite networks [119044]</li>\n<li>Language &#8211; 0 new strings added, 141 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.7] 2018-11-29</h4>\n<ul>\n<li>Feature &#8211; added new setting to activate the block editor on events for users running the WordPress 5.0 beta.</li>\n<li>Feature &#8211; added an Event Date Time block to add and display the event date and time</li>\n<li>Feature &#8211; added an Event Price block to add and display the event price and optional event description</li>\n<li>Feature &#8211; added an Event Organizer block to add and display an organizer on an event single</li>\n<li>Feature &#8211; added an Event Venue block to add and display the event venue information including optional link or map</li>\n<li>Feature &#8211; added an Event Website block to add and display an external website link as a button with custom label</li>\n<li>Feature &#8211; added an Event Sharing block to display event export options and allow for more customization</li>\n<li>Feature &#8211; added an Event Details Classic block to maintain a combined content display as in the classic editor</li>\n<li>Feature &#8211; added a Featured Image block to display an event’s featured image in the editor content</li>\n<li>Feature &#8211; added a Tags block to display an event’s tags in the editor content</li>\n<li>Feature &#8211; added an Event Categories block to display an event’s categories in the editor content</li>\n<li>Feature &#8211; added a new Events Blocks section to the block inserter</li>\n<li>Tweak &#8211; Added filters: <code>tribe_blocks_editor_update_classic_content_params</code>, <code>tribe_blocks_editor_update_classic_content</code>, <code>tribe_events_editor_default_classic_template</code>, <code>tribe_events_editor_default_template</code>, <code>tribe_events_google_maps_api</code>, <code>tribe_events_editor_assets_should_enqueue_frontend</code>, <code>tribe_events_single_map_zoom_level</code>, <code>tribe_events_single_event_time_formatted</code>, <code>tribe_events_single_event_time_title</code>, <code>tribe_events_event_block_datetime_use_yearless_format</code>, <code>tribe_get_event_website_link_target</code>, <code>tribe_events_single_event_time_formatted</code>, <code>tribe_events_single_event_time_title</code></li>\n<li>Tweak &#8211; Added actions: <code>tribe_blocks_editor_flag_post_classic_editor</code>, <code>tribe_events_editor_register_blocks</code>, <code>tribe_events_single_event_meta_primary_section_start</code>, <code>tribe_events_single_event_meta_primary_section_end</code>, <code>tribe_events_single_event_meta_secondary_section_start</code>, <code>tribe_events_single_event_meta_secondary_section_end</code>, <code>tribe_events_single_meta_details_section_start</code>, <code>tribe_events_single_meta_details_section_end</code>, <code>tribe_events_single_meta_map_section_start</code>, <code>tribe_events_single_meta_map_section_end</code>, <code>tribe_events_single_meta_organizer_section_start</code>, <code>tribe_events_single_meta_organizer_section_end</code>, <code>tribe_events_single_meta_venue_section_start</code>, <code>tribe_events_single_meta_venue_section_end</code></li>\n<li>Tweak &#8211; Changed views: <code>blocks/classic-event-details</code>, <code>blocks/event-category</code>, <code>blocks/event-datetime</code>, <code>blocks/event-links</code>, <code>blocks/event-organizer</code>, <code>blocks/event-price</code>, <code>blocks/event-tags</code>, <code>blocks/event-venue</code>, <code>blocks/event-website</code>, <code>blocks/featured-image</code>, <code>blocks/parts/details</code>, <code>blocks/parts/map</code>, <code>blocks/parts/organizer</code>, <code>blocks/parts/venue</code>, <code>silence</code>, <code>single-event-blocks</code>, <code>single-event</code>, <code>single-event/back-link</code>, <code>single-event/comments</code>, <code>single-event/content</code>, <code>single-event/footer</code>, <code>single-event/notices</code>, <code>single-event/title</code></li>\n<li>Language &#8211; 11 new strings added, 0 updated, 0 fuzzied, and 30 obsoleted</li>\n</ul>\n<h4>[4.6.26.1] 2018-11-21</h4>\n<ul>\n<li>Fix &#8211; Resolved a compatibility issue with WordPress version 4.7.11 and earlier (our thanks to @placer69 and @earthnutvt for flagging this) [118627]</li>\n</ul>\n<h4>[4.6.26] 2018-11-13</h4>\n<ul>\n<li>Fix &#8211; Fixed the setting-up of strings in the Tribe Bar datepicker to ensure they&#8217;re translatable into languages other than English [115286]</li>\n<li>Tweak &#8211; Improved the legibility of text in Featured Events that are in the Event List widget [116702]</li>\n<li>Tweak &#8211; Clarified a number of maps-related settings strings [114865]</li>\n</ul>\n<h4>[4.6.25] 2018-10-22</h4>\n<ul>\n<li>Fix &#8211; List only enabled views on the &#8220;Default View&#8221; option. Thanks to wescole, John Meuse and others for reporting! [114807]</li>\n<li>Fix &#8211; Handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Fix &#8211; Fixed event navigation when the mini calendar widget was on the event page. Props to Matt and wescole for flagging this [114359]</li>\n<li>Fix &#8211; Ensure columns without headers are handled in CSV imports [114199]</li>\n<li>Tweak &#8211; Added notice for the Events Gutenberg extension and eBook download [115543]</li>\n<li>Tweak &#8211; Avoid unnecessary HTTP calls in the Settings screens [114013]</li>\n<li>Tweak &#8211; Show only applicable refinements for the Eventbrite source types in Event Aggregator imports [107009]</li>\n<li>Tweak &#8211; Added <code>tribe_aggregator_resolve_geolocation</code> filter to allow for disabling of Geocoding using the EA service [114171]</li>\n<li>Tweak &#8211; Added <code>tribe_aggregator_clean_unsupported</code> filter to specify whether unsupported origin records should be removed or not</li>\n</ul>\n<h4>[4.6.24.1] 2018-10-08</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]</li>\n<li>Fix &#8211; Handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_import_setting_origins</code> filter to the origins available for default import settings [115704]</li>\n</ul>\n<h4>[4.6.24] 2018-10-03</h4>\n<ul>\n<li>Fix &#8211; Prevent broken and low-resolution Google Maps if user has not provided a Google Maps API key of their own by providing our own fallback API key [114442]</li>\n<li>Fix &#8211; Only load widget assets when widget is active on the page [113141]</li>\n<li>Fix &#8211; Ensure that venue, organizer, and meta information doesn&#8217;t show on password-protected events [102643]</li>\n<li>Fix &#8211; Correct the Google Maps API link in the Settings help text to point to the correct API page [112322]</li>\n<li>Fix &#8211; Restores the event categories and tags creation summary in CSV imports [105888]</li>\n<li>Fix &#8211; Updated the Events Gutenberg extension install check to show only when the extension is not active [114577]</li>\n<li>Fix &#8211; Stop potential fatal errors from debug logging when running EA import actions from command line [114555]</li>\n<li>Fix &#8211; Fixed a bug where it was often not possible to un-check the &#8220;Enable JSON-LD&#8221; option in the Events List Widget (thanks to @myrunningresource and @craigwilcox for reporting this!) [113541]</li>\n<li>Fix &#8211; Ensure that the <code>tribe-events-bar-should-show</code> filter functions as aspected; if <code>__return_false</code> is passed, the Tribe Bar will be totally hidden (thanks @debranettles for reporting this!) [112260]</li>\n<li>Fix &#8211; Added checks to prevent JS Type Error in mobile view. Thanks szenenight, agrilife and others for flagging this! [113524]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_month_daily_events</code> filter to the Month view [114041]</li>\n<li>Tweak &#8211; Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]</li>\n<li>Tweak &#8211; Accept 0 as an argument in tribe_get_events() so that <code>\'post_parent\' =&gt; 0</code> works, thanks Cy for the detailed report [111518]</li>\n<li>Fix &#8211; handle left-over Facebook scheduled imports and notices [114831]</li>\n<li>Tweak &#8211; Added new filters for customizing the fallback Google Maps embeds: <code>tribe_is_using_basic_gmaps_api</code>, <code>tribe_get_basic_gmap_embed_url</code>, and <code>tribe_get_basic_gmap_embed_url_args</code> [114442]</li>\n<li>Tweak &#8211; Fixed the handling of the global $post variable in some Month View templates to make it easier for themers to customize those templates [113283]</li>\n<li>Tweak &#8211; Ensure linked posts are listed alphabetically in metabox dropdowns, as they are in all other admin locations [108120]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_month_daily_events</code> filter to the Month view [114041]</li>\n<li>Tweak &#8211; Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]</li>\n<li>Tweak &#8211; Accept 0 as an argument in tribe_get_events() so that <code>\'post_parent\' =&gt; 0</code> works, thanks Cy for the detailed report [111518]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_record_by_origin</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_service_post_import_args</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_import_validate_meta_by_origin</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_refine_keyword_exclusions</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_refine_location_exclusions</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_venue_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_event_translate_service_data_organizer_field_map</code> filter to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_status_third_party</code> action to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_aggregator_import_form</code> action to allow new EA origins [114652]</li>\n<li>Tweak &#8211; Added <code>$origin_show_map_options</code> parameter to the <code>tribe_aggregator_fields</code> filter to allow new EA origins to make use of them [114652]</li>\n<li>Fix &#8211; Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]</li>\n</ul>\n<h4>[4.6.23] 2018-09-12</h4>\n<ul>\n<li>Fix &#8211; Fixed the &#8220;Full Styles&#8221; mobile view. Thanks Matthew, Laura and others for flagging this! [112301]</li>\n<li>Fix &#8211; Modify resource url function to work in mu-plugin directory, thanks to Doug for reporting it  [86104]</li>\n<li>Fix &#8211; Remove references to and settings for Facebook importing in Event Aggregator [112432]</li>\n<li>Fix &#8211; Ensure Event Aggregator allows for importing events from Eventbrite sites other than eventbrite.com, including but not limited to eventbrite.ca, .co.uk, and .co.nz [107821]</li>\n<li>Fix &#8211; Allow venue location fields to be intentionally empty on Venue Singular REST API calls [108834]</li>\n<li>Tweak &#8211; Add the WordPress Custom Fields Metabox show|hide settings from the Events Calendar Pro [109815]</li>\n<li>Tweak &#8211; Allow changing Event Aggregator import process system between the asynchronous and the cron-based one; previously only available as a filter [113418, 113475]</li>\n<li>Tweak &#8211; Allow stopping and clearing asynchronous queue processes from the admin UI [113418, 113475]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Aggregator__Record__Facebook</code></li>\n</ul>\n<h4>[4.6.22.1] 2018-08-27</h4>\n<ul>\n<li>Fix &#8211; Allow user to choose venues not created by them. Props to @integrity, @nomadadmin, and many others for reporting this! [113147]</li>\n</ul>\n<h4>[4.6.22] 2018-08-22</h4>\n<ul>\n<li>Add &#8211; Allow filtering events, in REST API requests, by their post ID with <code>include</code> [94326]</li>\n<li>Add &#8211; Enable future event display to get all events in the future that have not started [70769]</li>\n<li>Add &#8211; Allow filtering events, in REST API requests, by their post ID with <code>include</code> [94326]</li>\n<li>Add &#8211; Enable future event display to get all events in the future that have not started [70769]</li>\n<li>Fix &#8211; Prevent subsequent CSV imports from duplicating events in some instances [102745]</li>\n<li>Fix &#8211; The &#8220;Import events but preserve local changes to event fields&#8221; Event Aggregator change authority setting will now behave as expected [87443]</li>\n<li>Fix &#8211; Multiple fixes regarding linked post types (e.g. Organizers and custom post types) &#8211; props to @natureslens and others for reporting these [105116]:\n<ul>\n<li>Now correctly saves in their drag-and-drop order</li>\n<li>Deprecated the functions added in version 4.6.13 that previously attempted to fix ordering logic but was not done in a backwards-compatible way: <code>get_order_meta_key()</code> and <code>tribe_sanitize_organizers()</code></li>\n<li>We no longer rely on a separate postmeta value dedicated to ordering linked posts (e.g. <code>_EventOrganizerID_Order</code>), and you may want to remove all such values from your database after re-saving any events that have linked posts and their ordering is important</li>\n<li><code>tribe_get_linked_posts_by_post_type()</code> now works as expected, no longer returning zero results in error, nor returning all of the post type&#8217;s posts if there are none linked. The <code>tribe_events_return_all_linked_posts_if_none</code> filter was added, as it is necessary for this fix.</li>\n<li>Editing an existing event no longer loses the linked posts just because they were not part of the submission. Example of the bug in prior versions: If organizers are editable in the wp-admin event edit screen but not on the Community Events &#8220;event edit&#8221; form (via template override or other custom code), all pre-existing organizers were removed in error.</li>\n</ul>\n</li>\n<li>Fix &#8211; Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]</li>\n<li>Fix &#8211; Only show admin notice when it is a top-level page with the event slug, thanks to MikeNGarrett for the code fix! [111186]</li>\n<li>Fix &#8211; Change template_redirect to an action for some legacy view redirects, thanks barryceelen! [110463]</li>\n<li>Fix &#8211; Correctly import and set Organizers for iCal and ICS files Event Aggregator imports [96059]</li>\n<li>Fix &#8211; Retain category title in month view and month view shortcode, thanks corthoover for the first report [108258]</li>\n<li>Fix &#8211; The &#8220;Import events but preserve local changes to event fields&#8221; Event Aggregator change authority setting will now behave as expected [87443]</li>\n<li>Fix &#8211; Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]</li>\n<li>Fix &#8211; Prevent subsequent CSV imports from duplicating events in some instances [102745]</li>\n<li>Fix &#8211; Fix the classic header option not working. Thanks @hanemac, David Luyendyk and others for flagging this! [111672]</li>\n<li>Tweak &#8211; Namespace javascript debug function to prevent conflicts causing a function found, thanks to Tom-Mulvey for the fix [110462]</li>\n<li>Tweak &#8211; Add venue name to address string for iCal and gCal export, thanks for the coding from sylviavanos [110464]</li>\n<li>Tweak &#8211;  Drop the order from the query WPML linked query as it is set later in the method, thanks to dgwatkins for the PR [110459]</li>\n<li>Tweak &#8211; Display JS debug messages only if setting is set or through the <code>tribe_events_js_debug</code> filter. Thanks to Rob, @aand and others for flagging this! [82781]</li>\n</ul>\n<h4>[4.6.21] 2018-08-01</h4>\n<ul>\n<li>Add &#8211; Make global $post obj available to tribe_events_get_the_excerpt() with setup_postdata($post) [108043]</li>\n<li>Add &#8211; Added WPML metadata improvements for Organizers and Venue. Thanks to David Garcia Watkins and the entire WPML team for their contribution [106798]</li>\n<li>Fix &#8211; Ensure no console errors are being displayed if there&#8217;s no Google Maps API key present. Thanks Greg for flagging this [95312]</li>\n<li>Fix &#8211; Fixed an issue where saving Event Aggregator scheduled imports with an empty preview would generate PHP notices [110311]</li>\n<li>Fix &#8211; Escape each closing html element in month view tooltip to prevent PHP parser from exposing html, thanks to Karen for a solution [64834]</li>\n<li>Fix &#8211; Sending empty &#8216;categories&#8217; and &#8216;tags&#8217; for the REST API event endpoints when inserting and updating events [109627]</li>\n<li>Fix &#8211; Prevent selection of past dates when setting up Scheduled Other URL Imports in Event Aggregator [111227]</li>\n<li>Tweak &#8211; Manage plugin assets via <code>tribe_assets()</code> [40267]</li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Abstract_Asset in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Abstract_Events_Css in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin_Menu in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin_Ui in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Admin in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_Calendar in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_Dayview in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ajax_List in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Bootstrap_Datepicker in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Calendar_Script in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Chosen in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Datepicker in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Dialog in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Dynamic in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Ecp_Plugins in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Default in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Full in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css_Skeleton in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Events_Css in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Factory in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Jquery_Placeholder in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Jquery_Resize in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__PHP_Date_Formatter in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Settings in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Smoothness in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Tribe_Events_Bar in favor of using <code>tribe_asset</code></li>\n<li>Deprecated &#8211; Tribe__Events__Asset__Tribe_Select2 in favor of using <code>tribe_asset</code></li>\n</ul>\n<h4>[4.6.20.1] 2018-07-10</h4>\n<ul>\n<li>Fix &#8211; Fix an issue where Event Aggregator imports might get blocked at 1{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} progress [110258]</li>\n<li>Fix &#8211; Fix the error displayed when navigating the month view via shortcode. Thanks Lam, @ltcalendar, Disk and others for flagging this! [109589]</li>\n</ul>\n<h4>[4.6.20] 2018-07-09</h4>\n<ul>\n<li>Feature &#8211; Add featured event column support for CLI imports [108027]</li>\n<li>Fix &#8211; Display the exact search term in the &#8220;no results&#8221; notice on the events page [106991]</li>\n<li>Fix &#8211; Allow venue and organizer fields to be intentionally empty on Event Singular REST API calls [109482]</li>\n<li>Fix &#8211; Added basic checks to prevent saving obviously-invalid event meta values, such as sending <code>EventStartMinute</code> of <code>60</code> (since it should be 0-59) to <code>tribe_create_event()</code>. This prevents falling back to &#8220;zero&#8221; values (e.g. Unix Epoch) when another value was intended. Thanks to @compton-bob for flagging this via our Help Desk. [109722]</li>\n<li>Fix &#8211; Add Privacy Policy guide for The Events Calendar [108454]</li>\n<li>Tweak &#8211; Added event ID parameter to <code>tribe_events_event_classes</code> filter to make it more useful [64807]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_record_finalized</code> action to allow developers to act before Event Aggregator imports start [109938]</li>\n</ul>\n<h4>[4.6.19] 2018-06-20</h4>\n<ul>\n<li>Feature &#8211; CSV importer now supports a featured event column [72376]</li>\n<li>Add &#8211; Add Eventbrite Icon to Third Party Accounts on the help page [105388]</li>\n<li>Add &#8211; Accessibility repair: new title-bar template for loop views included above the filter bar and content containing the page title in a <code>h1</code> tag.</li>\n<li>Fix &#8211; Accessibility repair: adjust main content container element from <code>div</code> to <code>main</code>.</li>\n<li>Fix &#8211; More robust handling of errors and exceptions during Event Aggregator imports [107929]</li>\n<li>Fix &#8211; Ensure that the &#8220;Export Events&#8221; button is properly displayed in month view when paginating. Thanks to @linpleva, Steven, Will and others for flagging this! [104751]</li>\n<li>Fix &#8211; Month view pagination for datepicker formats: YYYY.MM.DD, MM.DD.YYYY, and DD.MM.YYYY. Thanks @netzwerk, @wdburgdorf, @oliverwick and others for notifying us! [105443]</li>\n<li>Fix &#8211; Resolved customizer inconsistencies with month/week views and full styles [69758]</li>\n<li>Fix &#8211; Check the Events Aggregator license each time the page is accessed [67864]</li>\n<li>Fix &#8211; Improve Event Import message responses from Event Aggregator for certain cases where &#8220;Unknown service message&#8221; would be returned [107606]</li>\n<li>Fix &#8211; Make the date picker respect the &#8220;Start of the week&#8221; Setting. Thanks to @websource, @dsb and others for flagging this! [76320]</li>\n<li>Fix &#8211; Correct the &#8220;View All&#8221; link when using the events month view and plain permalinks. props to Kay and Robert for notifying us [72544]</li>\n<li>Fix &#8211; Keep filter bar date when changing from month to list view, with all datepicker formats. Thanks to Caio for reporting this! [83018]</li>\n<li>Fix &#8211; Correct the pagination in list view when a keyword is being searched. Thanks to @versi, @akr and Mary for reporting this! [94613]</li>\n<li>Fix &#8211; Split linked posts (Organizers and Venues) by ownership, for all users [71349]</li>\n<li>Fix &#8211; The connected status for Eventbrite under Third Party Accounts on the Help page [106868]</li>\n<li>Fix &#8211; Fixed two PHP 5.2 errors on the Events &gt; Help page [108338]</li>\n<li>Fix &#8211; Display the correct Import Settings when Eventbrite Tickets is enabled [106947]</li>\n<li>Tweak &#8211; Modify the default values for the CSV settings if there&#8217;s no EA license [94426]</li>\n<li>Tweak &#8211; Added classes to meta output in Single Event meta templates to facilitate customization [62704]</li>\n<li>Tweak &#8211; Add the <code>tribe_aggregator_async_insert_event</code> filter to allow overriding the Event Aggregator asynchronous event insertion [107929]</li>\n<li>Tweak &#8211; Add the <code>\'tribe_aggregator_async_import_event_task</code> filter to allow overriding the Event Aggregator asynchronous import task [107929]</li>\n<li>Tweak &#8211; Added venue google map link to events in Day view [91610]</li>\n<li>Tweak &#8211; Renamed the Time zone mode option &#8220;Use the local time zones for each event&#8221; to &#8220;Use manual timezones for each event&#8221; (thanks @hikeitbaby for the suggestion) [67148]</li>\n<li>Tweak &#8211; Accessibility repair: heading hierarchy improvements throughout.</li>\n<li>Tweak &#8211; Accessibility repair: make sure all elements have unique <code>id</code> attributes.</li>\n<li>Tweak &#8211; Accessibility repair: remove redundant tab stops on feature image links.</li>\n<li>Tweak &#8211; Accessibility repair: filter bar view selector adjustments.</li>\n<li>Tweak &#8211; Accessibility repair: provide meaningful aria labels for filter bar inputs.</li>\n<li>Tweak &#8211; Accessibility repair: hide Google Map embeds from screen readers.</li>\n<li>Tweak &#8211; Enable only url imports for Eventbrite when that plugin is not active [107415]</li>\n<li>Tweak &#8211; The EB 4.5 migration process to better detect events for migration and insure all fields are migrated [106623]</li>\n<li>Tweak &#8211; Add <code>tribe_events_month_has_events_filtered</code> function and filter to see if there are events on a certain month, with filters (categories, search) [67607]</li>\n<li>Language &#8211; 68 new strings added, 406 updated, 3 fuzzied, and 37 obsoleted</li>\n</ul>\n<h4>[4.6.18] 2018-06-04</h4>\n<ul>\n<li>Add &#8211; Eventbrite to Event Aggregator import origins [61172]</li>\n<li>Add &#8211; Priority attribute to Import Setting fields to be able to customize order of fields [61173]</li>\n<li>Add &#8211; Default category and change authority for Eventbrite Imports [61173]</li>\n<li>Add &#8211; Ability to schedule Eventbrite imports through Event Aggregator [35454]</li>\n<li>Add &#8211; Preview for Eventbrite events in the import screen ordered from farthest future event to closest [70130]</li>\n<li>Add &#8211; Import Eventbrite events using the Other URL import origin [81825]</li>\n<li>Add &#8211; Ability to preview and import multiple Eventbrite events using the Organizer URL [94284]</li>\n<li>Add &#8211; Import from Eventbrite Location Search URL, i.e. https://www.eventbrite.com/d/or&#8211;portland/events/ [94588]</li>\n<li>Tweak &#8211; Move Eventbrite settings from Legacy Import to Settings Import Tab [94388]</li>\n<li>Tweak &#8211; Add Eventbrite imports to the Import History Tab [81826]</li>\n<li>Tweak &#8211; Remove Legacy Imports UI [81829]</li>\n</ul>\n<h4>[4.6.17] 2018-05-29</h4>\n<ul>\n<li>Tweak &#8211; Add tribe_redirected parameter to enable a visitor to select another view after default mobile redirect, thanks to Marcella for notifying us [102743]</li>\n<li>Fix &#8211; Hide any errors generated by servers that don&#8217;t support <code>set_time_limit()</code> (props to @jsww for flagging this!) [64183]</li>\n<li>Fix &#8211; Add a warning when the site Timezone is set to UTC [105217]</li>\n<li>Fix &#8211; An issue with organizers and venues not being attached to events on Eventbrite import  [106869]</li>\n<li>Language &#8211; 4 new strings added, 170 updated, 1 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.16] 2018-05-16</h4>\n<ul>\n<li>Tweak &#8211; Replaced the Aggregator queue processing system to run independently of WP Cron (not for CSV) [105650]</li>\n<li>Fix &#8211; Prevents notices for Events Community when handling State and Province fields [106415]</li>\n</ul>\n<h4>[4.6.15] 2018-05-09</h4>\n<ul>\n<li>Feature &#8211; Added wp-cli command to import events from a source with Event Aggregator. See <code>wp event-aggregator import-from --help</code> to know more [104426]</li>\n<li>Feature &#8211; Added wp-cli command to run scheduled imports with Event Aggregator. See <code>wp event-aggregator run-import --help</code> to know more [104426]</li>\n<li>Fix &#8211; Ensure that organizers can be deleted when an event has multiple organizers [103715]</li>\n<li>Fix &#8211; Fixed a bug where the <code>[tribe_events]</code> Month View pagination would fail when no Tribe Bar was visible and plain permalinks were being used [95720]</li>\n<li>Fix &#8211; Prevent <code>url_to_postid</code> from running when on the main events page to avoid query conflicts [94328]</li>\n<li>Fix &#8211; Prevent 404s and malformed URLs that would sometimes arise when navigating to a past-events view from the &#8220;All&#8221;-events view on a single recurring event [43925]</li>\n<li>Fix &#8211; Make the <code>[tribe_events]</code> shortcode&#8217;s output scroll to top when using the List View to match the non-shortcode List View  [81509]</li>\n<li>Fix &#8211; Ensure that default venue and address values are used throughout various venue-creation forms [63915]</li>\n<li>Tweak &#8211; Honor the return types for <code>tribe_has_next_event</code> and <code>tribe_has_previous_event</code> when the global query is null</li>\n<li>Language &#8211; 28 new strings added, 290 updated, 29 fuzzied, and 7 obsoleted</li>\n</ul>\n<h4>[4.6.14.1] 2018-04-18</h4>\n<ul>\n<li>Fix &#8211; Fixed fatal error that would sometimes arise when The Events Calendar was set to display on the front page</li>\n</ul>\n<h4>[4.6.14] 2018-04-18</h4>\n<ul>\n<li>Fix &#8211; Updated the &#8220;front page&#8221; logic to store the value in the DB instead of &#8220;mocking&#8221; the view via JS [100832]</li>\n<li>Fix &#8211; Fixed the generation of PHP warnings on retrieval of posts if the &#8220;Include events in main blog loop&#8221; option is checked (thanks to Colin Carmichael for reporting this problem) [97667]</li>\n<li>Fix &#8211; Made the <code>tribe-ea-record</code> custom post type (used to store Event Aggregator record information) private [99106]</li>\n<li>Fix &#8211; Expanded the size of the time zone input in the admin to allow for better visibility for long names [100363]</li>\n<li>Fix &#8211; If the main events page is set to be the site&#8217;s front page, ensure it shows as &#8220;selected&#8221; in the Customizer&#8217;s front page option [100832]</li>\n<li>Fix &#8211; Fixed an issue where failed Event Aggregator scheduled imports would re-attempt the import too soon [102489]</li>\n<li>Fix &#8211; Ensure the Tribe Bar displays all the available ranges of dates and times [100646]</li>\n<li>Fix &#8211; Hid the filters in the Tribe Bar if a unique view is enabled [75114]</li>\n<li>Fix &#8211; Fixed some imported-event handling so that events with no time and that aren&#8217;t all-day events do not display on the front-end [93979]</li>\n<li>Fix &#8211; Changed the HTTP status codes of empty event, venue, organizer, category, and tag archives from 404 to 200 and return empty arrays to stick with WP REST API standard [102283]</li>\n<li>Fix &#8211; Better &#8220;guessing&#8221; on column mapping during the import of CSV file (thanks to April in our Help Desk for flagging this problem!) [96162]</li>\n<li>Fix &#8211; Add new <code>tribe_events_linked_post_type_meta_key</code> filter, required to be set for each custom linked post type, to output custom linked post types in their drag-and-drop order (thanks @natureslens for highlighting the issue) [100733]</li>\n<li>Tweak &#8211; Added the <code>tribe_aggregator_find_matching_organizer</code> and <code>tribe_aggregator_find_matching_venue</code> filters in Events Aggregator to allow the definition of custom Venue and Organizer match criteria [97292]</li>\n<li>Tweak &#8211; Display the retry time for a failed Event Aggregator scheduled import in the Scheduled tab [102489]</li>\n<li>Tweak &#8211; Add new filter, <code>tribe_events_import_event_duplicate_matches</code>, to determine if an event is part of the duplicates matches [77956]</li>\n<li>Tweak &#8211; Ensure &#8220;secondary&#8221; maps, e.g. in the sidebar, have the same full-width behavior as &#8220;main&#8221; maps [74052]</li>\n<li>Tweak &#8211; Restore some missing header navigation elements [99742]</li>\n<li>Tweak &#8211; Add notice if an import is missing required columns [67886]</li>\n<li>Tweak &#8211; Save time zone and time zone abbreviation fields (if provided) even if date was not changed when saving event through API [102705]</li>\n</ul>\n<h4>[4.6.13] 2018-03-28</h4>\n<ul>\n<li>Feature &#8211; Added facilities allowing users to trash or permanently delete expired events [98826]</li>\n<li>Fix &#8211; Corrected the behavior of the previous/next event links rendered on single event pages (props to @jeremyfelt for fixing this) [101757]</li>\n<li>Fix &#8211; Save order of organizers as displayed in the admin (thanks to JobInfo and others for report) [79126]</li>\n<li>Tweak &#8211; Added Gutenberg compatibility for the Gutenberg Extension plugin</li>\n<li>Tweak &#8211; Added new filter <code>tribe_tickets_venue_action_links_edit_url</code> to modify the venue edit link for the sales and attendee reports [93923]</li>\n<li>Tweak &#8211; Altered day view to start at 00:00:00 and not 00:00:01 [99641]</li>\n</ul>\n<h4>[4.6.12] 2018-03-08</h4>\n<ul>\n<li>Fix &#8211; Resolved an oversight resulting in notice-level errors when the <code>tribe_event_is_on_date()</code> function was called incorrectly (props to @sharewisdom for pointing this out) [99117]</li>\n<li>Fix &#8211; Resolved errors within the admin environment when the &#8220;ticketed&#8221; view of events is generated [99266]</li>\n<li>Fix &#8211; Improved compatibility with WordPress SEO in relation to the default mobile events view [68716]</li>\n<li>Fix &#8211; Resolved Javascript errors in month view which were triggered under some conditions by the presence of password-protected events [99089]</li>\n<li>Fix &#8211; Improved logic responsible for identifying which events are expired (in the past) by using timezone-aware comparisons [91168]</li>\n<li>Fix &#8211; Corrected the export of upcoming events from single organizer pages (added to support changes in Events Calendar PRO) [70727]</li>\n<li>Tweak &#8211; Added safety checks around our use of the global $wp_query object (thanks @archetypalsxe for highlighting this issue!) [100199]</li>\n<li>Tweak &#8211; Renamed &#8216;Use Javascript to control date filtering&#8217; option to &#8216;Enable live refresh&#8217; and improved the associated helper text [98022]</li>\n<li>Tweak &#8211; Added caching to reduce the number of HTTP requests being made in relation to Event Aggregator within the admin environment [99486]</li>\n<li>Tweak &#8211; Improved performance by reducing the number of queries that run in single event pages (in relation to <code>tribe_get_prev_event_link()</code> and <code>tribe_get_next_event_link()</code> specifically) [94587]</li>\n<li>Tweak &#8211; Added pagination to single organizer and venue pages [97772]</li>\n<li>Tweak &#8211; Improved compatibility with the Twenty Seventeen theme (ensuring the calendar is full-width if set to be the site&#8217;s homepage) [97977]</li>\n<li>Language &#8211; 3 new strings added, 161 updated, 1 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[4.6.11.1] 2018-02-16</h4>\n<ul>\n<li>Fix &#8211; The render of the venue and organizer templates (thanks to Antonio and others for reporting this in our forums) [99550]</li>\n<li>Fix &#8211; Make sure events on calendar are not affected by DST changes [99537]</li>\n</ul>\n<h4>[4.6.11] 2018-02-14</h4>\n<ul>\n<li>Fix &#8211; Ensure parity of CSS styles between the default Month View and the embedded Month Views generated by Events Calendar PRO&#8217;s [tribe_events] shortcode (thanks @copoloff for reporting this bug!) [92329]</li>\n<li>Fix &#8211; If <code>tribe_ical_feed_calname</code>  is empty the property <code>X-WR-CALNAME</code> is not added to the .ics file [46620]</li>\n<li>Fix &#8211; Stopped modifications of the main query if is in a single post to allow custom variables don&#8217;t affect the page loading when using shortcode (our thanks to Joseph Reckley and others for highlighting this problem) [91787]</li>\n<li>Tweak &#8211; Fixed a handful of small CSS bugs in the mobile views of the Twenty Sixteen, Twenty Fifteen, and Twenty Fourteen themes [95693]</li>\n<li>Tweak &#8211; Added new hooks (<code>tribe_events_ical_before</code>, <code>tribe_events_ical_events_list_args</code> and <code>tribe_events_ical_events_list_query</code>) to allow further customization of the iCal feed [86227]</li>\n<li>Tweak &#8211; Added safeguards to reduce conflicts when lodash and underscore are used on the same site [92205]</li>\n<li>Language &#8211; 0 new strings added, 41 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.10.1] 2018-01-26</h4>\n<ul>\n<li>Fix &#8211; Make sure rewrite rule for <code>/events</code> is not hardcoded and is based on dynamic option field (thanks to @earnjam and others for flagging this problem) [98463]</li>\n</ul>\n<h4>[4.6.10] 2018-01-23</h4>\n<ul>\n<li>Fix &#8211; Allow The Events Calendar REST API to be disabled using the <code>tribe_events_rest_api_enabled</code> filter [97209]</li>\n<li>Fix &#8211; Remove the errant <code>div.tribe-events-single-section</code> on the single event view when there is no venue [97615]</li>\n<li>Fix &#8211; Make sure the date for past events is set to the current date not the end of the day of the current date [71936]</li>\n<li>Fix &#8211; Use <code>featured_color_scheme_custom</code> if present as mechanism to overwrite the default color scheme for highlight color [96821]</li>\n<li>Fix &#8211; Make sure the date for past events is set to the current date not the end of the day of the current date [71936]</li>\n<li>Tweak &#8211; Trigger an event <code>map-created.tribe</code> when a map is created to allow flexibility on customization [91984]</li>\n<li>Tweak &#8211; Add a link to the knowledge base about &#8216;Setting Up Your Google Maps API Key&#8217; [89761]</li>\n<li>Tweak &#8211; Add <code>the_title</code> filter to events called by <code>tribe_events_template_data</code> [38237]</li>\n<li>Tweak &#8211; Made the &#8220;events&#8221; and &#8220;event&#8221; slugs translatable by WPML and other multilingual plugins [95026]</li>\n<li>Tweak &#8211; Introduced the <code>tribe_events_query_force_local_tz</code> filter to allow for forcing non-UTC event start and end times in Tribe__Events__Query [92948]</li>\n<li>Tweak &#8211; Prevent empty or otherwise-invalid values for various date-format options in the Display settings [94725]</li>\n<li>Tweak &#8211; Brought day number headers in the Month View into compliance with WCAG 2.0 accessibility standards when using the &#8220;Tribe Events&#8221; stylesheet [68411]</li>\n<li>Tweak &#8211; Improved the alignment of the event cost on the single-event view (props to @canberraclimbersassociation for reporting this bug) [97208]</li>\n<li>Tweak &#8211; Added some more context to the labeling of the &#8220;Number of events per page&#8221; option (thanks to Todd H. for highlighting this label) [73659]</li>\n<li>Tweak &#8211; Improve performance on Event Admin List Count by removing JOIN and use cached results [63567]</li>\n<li>Tweak &#8211; Made the &#8220;/page/&#8221; component of some views&#8217; URL string translatable [40976]</li>\n<li>Tweak &#8211; Button &#8220;Merge Duplicates&#8221; is always visible from now on [75208]</li>\n<li>Tweak &#8211; Allow queries to explicitly include or exclude events that are nominally hidden from event listings [91254]</li>\n</ul>\n<h4>[4.6.9] 2018-01-10</h4>\n<ul>\n<li>Feature &#8211; Add new utility functions tribe_is_events_home and tribe_is_events_front_page similar to native WP is_home and is_front_page [42195]</li>\n<li>Fix &#8211; Avoid issues when importing multiple organizers that specify images [96354]</li>\n<li>Fix &#8211; Make sure latitude and longitude information from iCal feeds is used if available [96363]</li>\n<li>Fix &#8211; Fixed an issue that prevented EA from importing images attached to Facebook events [96393]</li>\n<li>Fix &#8211; Remove the duplicate filter call that was running twice for <code>tribe_rest_venue_data</code> [96090]</li>\n<li>Tweak &#8211; Added new <code>tribe_aggregator_import_event_image</code>, <code>tribe_aggregator_import_venue_image</code> and <code>tribe_aggregator_import_organizer_image</code> filter so that users can control whether, during EA imports, images should be attached to post or not [96393]</li>\n<li>Tweak &#8211; Made it possible to translate the iCal feed&#8217;s description field (props @gafderks) [96677]</li>\n<li>Tweak &#8211; Improved escaping of map IDs (props LucaPipolo) [96772]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up organizers by slug instead of ID at the path <code>organizers/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>organizers/{ID}</code> [96088]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up venues by slug instead of ID at the path <code>venues/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>venues/{ID}</code> [96088]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API responses for organizer and venue data [96088]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API parameters allowed to use when inserting or updating an organizer or event [96088]</li>\n<li>Tweak &#8211; Added action: <code>tribe_events_venue_save</code> [96069]</li>\n<li>Tweak &#8211; Added action: <code>tribe_events_organizer_save</code> [96069]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_rest_venue_prepare_postarr</code> [96069]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_rest_organizer_prepare_postarr</code> [96069]</li>\n<li>Tweak &#8211; Old <code>tribe_rest_venue_data</code> filter was passing the venue and the event two the second parameter because of the duplication. Now it has the second parameter as $venue, third parameter as $event if event ID was provided [96090]</li>\n<li>Language &#8211; 5 new strings added, 30 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.8] 2017-12-18</h4>\n<ul>\n<li>Fix &#8211; Preserve filter bar checkbox selections when changing views [66749]</li>\n<li>Fix &#8211; Fix radio filters so they are only included as values when switching views when checked [72954]</li>\n<li>Fix &#8211; Ensure the correct properties are set for list widget queries, to avoid problems when running alongside Events Calendar PRO (props @KZeni) [94105]</li>\n<li>Fix &#8211; Fixed some layout issues with the &#8220;Buy Now&#8221; button and stock labels on mobile list views [81115]</li>\n<li>Fix &#8211; Fixed issue where left- or right-aligned images at the bottom of event descriptions would overlap event meta on single-event pages [71134]</li>\n<li>Fix &#8211; Fixed issue where Google Maps Link would display in some situations even when there is no address information for which to generate a link. [94909]</li>\n<li>Fix &#8211; Corrected reference to a Select2 asset (our thanks to @pyxis630 for flagging this problem and props to @andrasguseo for the fix) [95348]</li>\n<li>Fix &#8211; Ensure that when start and end dates are passed to the REST API, all events within the date range are correctly retrieved (thanks @braffenberg and others for highlighting this issue!) [90005]</li>\n<li>Tweak &#8211; Added Google Maps API key to all Google Maps URLs when the key is available, allowing maps to load more reliably on some hosting environments (props to @sfdfortnight, @thor, and many others for reporting this!) [62910]</li>\n<li>Tweak &#8211; Adjusted CSS to improve the display of venue URLs/phone numbers (especially when Events Calendar PRO is also active) (our thanks to Mathew on the forums for flagging this issue) [69127]</li>\n<li>Tweak &#8211; Added new REST API endpoint that allows looking up events by slug instead of ID at the path <code>events/by-slug/{slug}/</code>, it has the same functionality as the endpoint <code>events/{ID}</code> [92825]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API responses for event data [92825]</li>\n<li>Tweak &#8211; Added <code>slug</code> to the REST API parameters allowed to use when inserting or updating an event [92825]</li>\n<li>Tweak &#8211; Added new <code>tribe_events_rest_use_inclusive_start_end_dates</code> filter so that users can make the REST API return events from a more literal date range [90005]</li>\n<li>Language &#8211; 3 new strings added, 68 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.7] 2017-12-07</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where EA imports might not correctly create venues for iCalendar imports (thanks @starweb and others for highlighting this issue) [94323]</li>\n<li>Fix &#8211; Fixed an issue where Month View wouldn&#8217;t render correctly in X Theme with the &#8220;Events template&#8221; option set to &#8220;Default Page Template&#8221; [92554]</li>\n<li>Fix &#8211; Fixed a WPML incompatibility issue where language could be switched to the wrong one (thanks @dgwatkins) [94732]</li>\n<li>Tweak &#8211; Added the <code>tribe_events_x_theme_force_full_content()</code> filter to let users disable X Theme compatibility code [92554]</li>\n<li>Language &#8211; 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.6] 2017-11-21</h4>\n<ul>\n<li>Feature &#8211; Added Template class which adds a few layers of filtering to any template file included</li>\n<li>Tweak &#8211; Added clear warnings and errors to prevent and limit the import of iCalendar sources missing required fields [93600]</li>\n<li>Tweak &#8211; Included <code>tribe_callback_return</code> for static returns for Hooks</li>\n<li>Tweak &#8211; Improved Aggregator notices including error data on the responses [87326]</li>\n<li>Language &#8211; 4 new strings added, 79 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.5] 2017-11-16</h4>\n<ul>\n<li>Fix &#8211; Improved legacy URL redirect logic to prevent unwanted redirects (our thanks to wesleyanhq and Adam Schwartz for highlighting this issue) [86942]</li>\n<li>Fix &#8211; Modified tribe_get_template_part() to remove potential for multiple templates to be rendered in a single call [46630]</li>\n<li>Fix &#8211; Fixed an issue where Event Aggregator scheduled imports might remain stuck in pending status [90501, 92614, 91754]</li>\n<li>Fix &#8211; Removed code which was automatically populating various address fields with default values when creating a new venue from within the event editor [44732]</li>\n<li>Fix &#8211; Resolved some issues with the &#8220;Show Map&#8221; and &#8220;Show Map Link&#8221; options in CSV files not being reliably respected on import (props @joappf and many others for highlighting this issue) [82784]</li>\n<li>Fix &#8211; Added opportunities to override edit linked post links [89015]</li>\n<li>Fix &#8211; Fixed a bug where only some parts of event featured images were clickable in List Views (thanks @mattemkadia for highlighting this issue) [81392]</li>\n<li>Fix &#8211; Fixed the broken &#8216;Learn more&#8217; URL received after an unsuccessful &#8220;Other URL&#8221; import preview [92890]</li>\n<li>Fix &#8211; Fixed issue in list view navigation with backwards previous/next classes (thanks @secondtoughest) [36230]</li>\n<li>Fix &#8211; Fixed an issue where venues and organizers would not be correctly assigned to events in CSV imports with import statuses other than &#8220;Publish&#8221; [79680]</li>\n<li>Tweak &#8211; Remove net import scheduled notes for on demand imports [79079]</li>\n<li>Tweak &#8211; Allow for non-Latin characters to be used as the Events URL slug and the Single Event URL slug (thanks @daviddweb for originally reporting this) [61880]</li>\n<li>Tweak &#8211; Remove net import scheduled notes for on demand imports [79079]</li>\n<li>Tweak &#8211; Fixed some layout issues that would emerge with &#8220;Events URL Slug&#8221; option when &#8220;Plain&#8221; permalinks were enabled [92314]</li>\n<li>Tweak &#8211; Tweaked some language in Event Aggregator&#8217;s metabox on individual edit-event screens to reduce confusion around the impact of the Update Authority on CSV imports [77957]</li>\n<li>Tweak &#8211; Fix PHP 7.1 compatibility with Event Aggregator (props @BJP NEALE) [90002]</li>\n<li>Tweak &#8211; Added new filter: <code>tribe_events_force_filtered_ical_link</code>. This makes the &#8220;Export Events&#8221; URL more easily modifiable (thanks to @tdudley07 for highlighting this issue) [43908]</li>\n<li>Tweak &#8211; Made the &#8220;End of Day Cutoff&#8221; option better accommodate 24-hour and other time formats (thanks @festivalgeneral for bringing this issue to our attention!) [78621]</li>\n<li>Tweak &#8211; Made the options presented by the timezone selector filterable (via the newly added <code>tribe_events_timezone_choice</code> hook &#8211; our thanks to National University&#8217;s Marketing Department for this idea) [92909]</li>\n<li>Tweak &#8211; Improved integration with Twenty Seventeen &#8211; main events page now uses full height header when set to front page (thanks @uncovery for pointing this out) [89767]</li>\n<li>Tweak &#8211; Ensured REST API taxonomy endpoints are only registered in WordPress versions 4.7 and higher (thanks @dnaber-de for reporting this) [93227]</li>\n<li>Language &#8211; 1 new strings added, 132 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.6.4] 2017-11-09</h4>\n<ul>\n<li>Tweak &#8211; Timepicker is now part of Tribe Common, it was removed from The Events Calendar</li>\n<li>Tweak &#8211; Required changes to make the plugin compatible with version 4.6 of Event Tickets</li>\n<li>Language &#8211; 10 new strings added, 167 updated, 0 fuzzied, and 2 obsoleted</li>\n</ul>\n<h4>[4.6.3] 2017-11-02</h4>\n<ul>\n<li>Fix &#8211; Prevent JS error when adding a Pro widget in the WP Customizer screen [72127]</li>\n<li>Fix &#8211; Fixed issue where the value of an event&#8217;s &#8220;Show Google Maps Link&#8221; option would not properly affect the displaying of the link on List View (props: @etechnologie) [75547]</li>\n<li>Fix &#8211; Added some more specification to our jquery-ui-datepicker CSS to limit conflicts with other plugins and themes [90577]</li>\n<li>Fix &#8211; Improve shortcode pagination/view change url so it is reusable (props: @der.chef and others) [70021]</li>\n<li>Fix &#8211; Ensure the <code>tribe_json_ld_{type}_object</code> filter is available to make modifications of event, venue and organizer JSON LD data possible (thanks to Mathew for flagging this problem) [89801]</li>\n<li>Fix &#8211; Improved JSON LD output for events by outputting the correct UTC offset where required (our thanks to Nina and many others for flagging this issue) [78233]</li>\n<li>Tweak &#8211; Fixed some display issues for the event schedule details (props @mia-caro)</li>\n<li>Tweak &#8211; Improved the clarity of and amount of context for some linked post labels to make translation of those labels a little easier and more nuanced (props @hnacc and others) [88589]</li>\n<li>Tweak &#8211; Changed the order in which the list view &#8220;next events&#8221; link is assembled for better translatability (with thanks to @alelouya for highlighting this problem) [72097]</li>\n<li>Tweak &#8211; Adjusted linked posts selector HTML to improve compatibility with Batcache [92049]</li>\n<li>Tweak &#8211; Improved datepicker handling so an end date on or later than the start date can always be selected [89825]</li>\n<li>Language &#8211; 0 new strings added, 7 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.6.2] 2017-10-18</h4>\n<ul>\n<li>Fix &#8211; Restored functionality to the &#8220;currency position&#8221; options in Events Settings, and in the per-event cost settings (props @schola and many others!) [89918]</li>\n<li>Fix &#8211; Fixed issue in Month view with multi-month events not appearing on subsequent months (thanks @shinno.kei &amp; @schittly for helping isolate this) [89747]</li>\n<li>Fix &#8211; Made some changes to prevent Month View caching from breaking WPML support when in Month View (props: @mpike and many others!) [82286]</li>\n<li>Fix &#8211; Fixed start/end times being displayed in incorrect timezone in structured data (thanks @mtncreative &amp; @esosa) [42125]</li>\n<li>Fix &#8211; Fixed an issue that would cause a 404 error if the selected default view was not enabled (thanks @pruneau) [45612]</li>\n<li>Fix &#8211; Improved translatability by adding missing textdomains for a number of strings (props @pedro-mendonca) [91071]</li>\n<li>Fix &#8211; Removed unneeded escaping to ensure the organizer link displays as expected (pros @f4w-pwharton) [91074]</li>\n<li>Tweak &#8211; Improvements to the readme.txt file surrounding plugin requirements (thanks @ramiy) [90285]</li>\n<li>Tweak &#8211; Improve site identification in multisite installations using Event Aggregator to avoid throttling issues [90489]</li>\n<li>Tweak &#8211; Avoid notice level errors when a non-existent category archive is requested (our thanks to Charles Simmons for highlighting this) [90697]</li>\n<li>Tweak &#8211; Added a new filter <code>tribe_events_ical_single_event_links</code> to make customizing the iCal and gCal export links on single-event views easier [90705]</li>\n</ul>\n<h4>[4.6.1] 2017-10-04</h4>\n<ul>\n<li>Fix &#8211; Fixed &#8220;Next Events&#8221; and &#8220;Previous Events&#8221; navigation links in list views, which would sometimes make a category-filtered list view lose its category filter as a user navigated through pages of future or past events (props @forumhelpdesk and @atomicdust for reporting this!) [72013]</li>\n<li>Fix &#8211; Fixed some layout issues with the Tribe Bar datepicker that would arise when using a Twenty Sixteen or Twenty Fifteen child them (thanks to @stefanrueegger for reporting this) [46471]</li>\n<li>Fix &#8211; Prevented modification of event titles within the loop when using TRIBE_MODIFY_GLOBAL_TITLE [89273]</li>\n<li>Fix &#8211; Fixed issue when exporting all-day multi-day events via iCal where the end date was one day early (Thank you @fairmont for reporting this!) [87775]</li>\n<li>Fix &#8211; Fixed issues with the jQuery Timepicker vendor script conflicting with other plugins&#8217; similar scripts (props: @hcny et al.) [74644]</li>\n<li>Fix &#8211; Fixed an issue that would prevent Event Aggregator scheduled imports from running [88395]</li>\n<li>Fix &#8211; Fixed the &#8220;Start Time&#8221; and &#8220;End Time&#8221; timepicker fields in the event-creation screen to make it impossible to have an end date/time that comes before the start date/time [72686]</li>\n<li>Tweak &#8211; Remove unnecessary parameters from some remove_action calls in the plugin (thanks to @JPry on GitHub for submitting this fix!) [88867]</li>\n<li>Tweak &#8211; Adjusted the EA cron start time so that it never gets created in the past [88965]</li>\n<li>Tweak &#8211; Improved options format in the Event Aggregator settings [88970]</li>\n<li>Tweak &#8211; Added a filter to CSV importer for altering the delimiter, escaping, and enclosing characters [70570]</li>\n<li>Tweak &#8211; Adjusted the <code>tribe_update_venue()</code> template tag so it no longer creates some unnecessary meta fields involving post_title, post_content, etc. (thanks @oheinrich for bringing this to our attention) [66968]</li>\n<li>Tweak &#8211; Improved the performance of The Events Calendar REST API tweaking some queries [89743]</li>\n<li>Tweak &#8211; Add support for a <code>found_posts</code> argument in <code>tribe_get_events</code>, <code>tribe_get_venues</code> and <code>tribe_get_organizers</code> functions to return the number of posts found matching the current query arguments [89743]</li>\n<li>Deprecated &#8211; Deprecated the <code>tribe-events-bar-date-search-default-value</code> filter; use <code>tribe_events_bar_date_search_default_value</code> instead [67482]</li>\n<li>Language &#8211; Improvements to aid translatability of text throughout plugin (props: @ramiy) [88982]</li>\n<li>Language &#8211; 7 new strings added, 180 updated, 4 fuzzied, and 3 obsoleted</li>\n</ul>\n<h4>[4.6] 2017-09-25</h4>\n<ul>\n<li>Feature &#8211; Added full CRUD REST support for Events, Organizers, Venues, Event Categories, and Tags</li>\n<li>Tweak &#8211; Updated Bootstrap Datepicker to v1.7.0</li>\n<li>Tweak &#8211; Added latitude/longitude to REST responses when available on venues</li>\n<li>Tweak &#8211; Added JSON-LD data to REST responses when available</li>\n<li>Tweak &#8211; Replaced deprecated first parameter of <code>tribe_get_organizers()</code> with a parameter that, when specified with a truthy value, returns only organizers with upcoming events attached to them</li>\n<li>Tweak &#8211; Added linked post filters: <code>tribe_{$this-&gt;post_type}_has_events_excluded_post_stati</code>, <code>tribe_events_tribe_organizer_create</code>, <code>tribe_events_tribe_organizer_update</code>, <code>tribe_event_venue_duplicate_post_fields</code>, <code>tribe_event_organizer_duplicate_custom_fields</code></li>\n<li>Tweak &#8211; Added action: <code>tribe_events_organizer_created</code></li>\n<li>Tweak &#8211; Added REST filters: <code>tribe_rest_organizer_default_only_with_upcoming</code>, <code>tribe_rest_venue_default_only_with_upcoming</code>, <code>tribe_events_rest_term_allow_delete</code></li>\n<li>Tweak &#8211; Added duplicate-detection filters: <code>tribe_duplicate_post_strategies</code>, <code>tribe_duplicate_post_strategy</code>, <code>tribe_duplicate_post_{$strategy}_strategy</code></li>\n<li>Language &#8211; 152 new strings added, 217 updated, 6 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.5.13] 2017-09-20</h4>\n<ul>\n<li>Feature &#8211; Add link to the featured image in the Events List widget. New filter introduced to control this: <code>tribe_events_list_widget_featured_image_link</code> (props to @cabadaj007 for the feature request) [84807]</li>\n<li>Feature &#8211; Remove &#8216;France, Metropolitan&#8217; option from country list to prevent issues with Google Maps API (thanks @varesanodotfr for pointing this out) [78023]</li>\n<li>Feature &#8211; Ignored Events will restore previous status instead of setting to &#8216;publish&#8217; [82213]</li>\n<li>Fix &#8211; Patched jQuery Resize vendor library to avoid JavaScript conflicts (props to @britner for the original report) [71994]</li>\n<li>Fix &#8211; Fixed a typo in the Event List widget options [71081]</li>\n<li>Fix &#8211; Addressed some PHP notices that would sometimes emerge in tag-filtered post lists in the wp-admin (thanks to @wfsec28 and others in the forums for reporting this!) [45274]</li>\n<li>Fix &#8211; When &#8220;Full Styles&#8221; or &#8220;Tribe Events Styles&#8221; are used, prevent duplicate featured images from showing up in the Twenty Seventeen theme (props to @want2what and others in the forums for reporting this) [80955]</li>\n<li>Fix &#8211; Fixed the issue that would prevent the start date and date range parameters from being taken into account when using &#8216;Other URL&#8217; source in Event Aggregator</li>\n<li>Fix &#8211; Aggregator will no longer update comments while inactive [78890]</li>\n<li>Fix &#8211; Avoid issues when REST API archive request parameters are not in the original order (thanks @Nslaver for reporting this and providing a fix) [88748]</li>\n<li>Tweak &#8211; Aggregator prevents duplicated records with the same params from being created [68833]</li>\n<li>Tweak &#8211; Aggregator will now allow for some minor shifts in schedule execution time to help distribute requests to EA Service [86628]</li>\n<li>Tweak &#8211; Improve text in the Event Aggregator settings [77452]</li>\n<li>Tweak &#8211; Add actions before and after posts are inserted or updated by Event Aggregator to allow custom functions to kick in (<code>tribe_aggregator_before_insert_posts</code> and <code>tribe_aggregator_after_insert_posts</code>) [87530]</li>\n<li>Tweak &#8211; Allow users to import CSV with numerically-named categories by using a flag (currently <code>{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}n</code>) (thanks @Shamsi for reporting) [78340]</li>\n<li>Tweak &#8211; Allow date range and events count limits to be set on each type of import (except for &#8216;Other URL&#8217;) in Event Aggregator [79975]</li>\n</ul>\n<h4>[4.5.12.3] 2017-09-19</h4>\n<ul>\n<li>Fix &#8211; Display events on Month View correctly for WordPress version 4.8.2 and up (props @realcrozetva for reporting this) [88952]</li>\n</ul>\n<h4>[4.5.12.2] 2017-09-08</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where manually running Scheduled Imports would always result in a failed import [87321]</li>\n</ul>\n<h4>[4.5.12.1] 2017-09-07</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where events imported via Event Aggregator from an iCal-like source would be duplicated in place of being updated [87654]</li>\n</ul>\n<h4>[4.5.12] 2017-09-06</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where, with certain date formats chosen in the Events display settings, the &#8220;Next Month&#8221; link navigation wasn&#8217;t working (props to @tttammi and others for reporting this issue!) [86937]</li>\n<li>Fix &#8211; Fixed a typo in REST API Swagger documentation that mentioned &#8220;organizer&#8221; when it should have stated &#8220;venue&#8221;.</li>\n<li>Fix &#8211; Fixed issues with Event Aggregator queueing system where events might be duplicated or incorrectly updated [79975]</li>\n<li>Fix &#8211; Prevent notice when the Aggregator Record title is an array [82149]</li>\n<li>Fix &#8211; Allows Aggregator Google Map settings to extend the Global Setting by default (props to queerio for reporting this!) [67639]</li>\n<li>Fix &#8211; Prevent Warnings when throwing WordPress admin notices from Aggregator daily usage limit (props to cigarplanner for reporting this!) [83187]</li>\n<li>Fix &#8211; Resolved problem where Aggregator wouldn&#8217;t allow you to remove filtering terms for Records [76949]</li>\n<li>Fix &#8211; Allow any datepicker format to be used on Aggregator filtering Events (props to matthewseymour for reporting this!) [77819]</li>\n<li>Fix &#8211; Added check to see if log directory is readable before listing logs within it (thank you @rodrigochallengeday-org and @richmondmom for reporting this) [86091]</li>\n<li>Tweak &#8211; Datatables Head and Foot checkboxes will not select all items, only the current page [77395]</li>\n<li>Tweak &#8211; Included tooltip for Aggregator &#8220;Hide &amp; Ignore&#8221; button for events [67890]</li>\n<li>Tweak &#8211; Added all the Aggregator Origins to the Admin Bar [68693]</li>\n<li>Tweak &#8211; Added filters: <code>tribe_get_state_options</code></li>\n<li>Tweak &#8211; Added template tags: <code>maybe_format_from_datepicker()</code></li>\n<li>Tweak &#8211; Added the <code>tribe_rest_single_event_data</code> filter to the single event REST API endpoint to allow filtering the returned data (thanks @mwender) [88748]</li>\n<li>Language &#8211; 2 new strings added, 90 updated, 0 fuzzied, and 1 obsoleted</li>\n</ul>\n<h4>[4.5.11] 2017-08-24</h4>\n<ul>\n<li>Fix &#8211; Avoid Event Aggregator previews or scheduled imports being marked as failures [84259]</li>\n<li>Fix &#8211; Fixed start and end date limit parsing for events archive in the REST API code [78375]</li>\n<li>Fix &#8211; Fixed issue with <code>tribe_events_get_the_excerpt()</code> returning a read more link that sometimes pointed to the current page [70473]</li>\n<li>Fix &#8211; Fixed Post ID not being sent to the_title filter for Organizers and Venues (props Anna L.) [85206]</li>\n<li>Fix &#8211; Fixed issue where Month View tooltips would often go off-screen in some smaller viewport sizes [65136]</li>\n<li>Fix &#8211; Fixed an issue that would sometimes render Event Aggregator options invalid even with a valid license [78469]</li>\n<li>Fix &#8211; Fixed an issue where the mobile.php template file would often fail to include an event&#8217;s featured image [74291]</li>\n<li>Fix &#8211; Resolved issue where invalid linked post IDs prevent proper updates on linked posts (props to Mathew L. and a few others for highlighting this issue) [71802]</li>\n<li>Fix &#8211; Do not hijack the blog when the main events page is configured to appear on the site&#8217;s homepage (our thanks to Jason and others for flagging this problem) [72094]</li>\n<li>Fix &#8211; Remove extra trailing double-quotes at the end of the timepicker data-format attributes [85603]</li>\n<li>Fix &#8211; Fixed an issues where Event Aggregator scheduled imports could not run other than manually [81639]</li>\n<li>Tweak &#8211; Prevent stray commas from showing up for some event venues in the List View [72289]</li>\n<li>Tweak &#8211; Prevent stray commas from showing up for some event venues in the Day View [85429]</li>\n<li>Tweak &#8211; Modify certain event queries to widen the window of opportunity for query caching (props @garretjohnson) [84841]</li>\n<li>Tweak &#8211; Improve Event Aggregator message regarding Facebook token expiration [70376]</li>\n<li>Tweak &#8211; Support importing from URLs (Event Aggregator) where the protocol hasn&#8217;t been specified by defaulting to HTTP [76466]</li>\n<li>Tweak &#8211; Removed WP API adjustments [85996]</li>\n<li>Tweak &#8211; Added filter: <code>tribe_aggregator_meta_source</code> to filter the Event Aggregator import source</li>\n<li>Tweak &#8211; Added filter: <code>tribe_events_linked_post_meta_values_{$current_linked_post_meta_key}</code> for filtering the array of values retrieved for a specific linked post meta field</li>\n<li>Tweak &#8211; Updated views: <code>src/views/day/single-event.php</code> and <code>src/views/list/single-event.php</code></li>\n<li>Compatibility &#8211; Minimum supported version of WordPress is now 4.5</li>\n<li>Language &#8211; Improvements to various strings to improve ease of translation (props to @ramiy)</li>\n<li>Language &#8211; 5 new strings added, 56 updated, 1 fuzzied, and 3 obsoleted [the-events-calendar]</li>\n</ul>\n<h4>[4.5.10.1] 2017-08-16</h4>\n<ul>\n<li>Fix &#8211; Updates common library to resolve a range of issues preventing frontend assets from loading and breaking parts of our user interface [85017]</li>\n</ul>\n<h4>[4.5.10] 2017-08-09</h4>\n<ul>\n<li>Fix &#8211; Avoid duplicate events when importing from some iCal, Google Calendar and Facebook feeds in Event Aggregator (our thanks to Jason Sears, controlyours and many other users for highlighting these issues) [67038]</li>\n<li>Fix &#8211; Fixed bug that caused scheduled imports to get stuck in a perpetual state of failure when receiving error messages from the Event Aggregator service (our thanks to Antonio Jose and others for flagging this problem) [83767]</li>\n<li>Fix &#8211; Resolved issue where errors from the Event Aggregator service were not properly logging/visible on the History tab [83767]</li>\n<li>Tweak &#8211; Made linked post fields&#8217; auto-save features more stringently check for empty values to prevent the plugin from trying to &#8220;save&#8221; empty values (our thanks to Jean-Marie for highlighting this problem) [80282]</li>\n<li>Tweak &#8211; Moved the organizer e-mail address field label a bit to better accommodate Community Events [80426]</li>\n<li>Tweak &#8211; Added filter to tribe_get_display_end_date()&#8217;s return value [77730]</li>\n<li>Tweak &#8211; Avoid notice-level errors while processing queues within Event Aggregator (our thanks to David Sharpe and others for reporting this) [84020]</li>\n<li>Tweak &#8211; Improve compatibility and avoid Javascript errors when running alongside Twenty Seventeen [70853]</li>\n<li>Compatibility &#8211; Minimum supported version of WordPress is now 4.4</li>\n<li>Language &#8211; 1 new strings added, 119 updated, 0 fuzzied, and 0 obsoleted</li>\n</ul>\n<h4>[4.5.9] 2017-07-26</h4>\n<ul>\n<li>Fix &#8211; Send Aggregator callback URL with correct Scheme [83364]</li>\n<li>Fix &#8211; Scheduled Aggregator cron for inserting will re-enqueue to complete scheduled imports [83382]</li>\n<li>Fix &#8211; Avoid overwriting Venues and Organizers when importing FB events with similarly named Venues and Organizers [75370]</li>\n<li>Fix &#8211; Improve handling of large and/or slow Google Calendar and iCal feeds [79975]</li>\n<li>Tweak &#8211; Added period &#8220;.&#8221; separator to datepicker formats. [65282]</li>\n<li>Tweak &#8211; Added tribe_events_month_get_events_in_month filter to allow overriding of events used in month templates. [83317]</li>\n</ul>\n<h4>[4.5.8.1] 2017-07-21</h4>\n<ul>\n<li>Fix &#8211; Fixed an issue where failed EA Imports would hang for a long time before failing [83344]</li>\n</ul>\n<h4>[4.5.8] 2017-07-13</h4>\n<ul>\n<li>Fix &#8211; Remove permalink logic for recurring events (Events Calendar PRO will implement instead) [74153]</li>\n<li>Fix &#8211; Avoid type error when setting up one-time imports for Facebook URLs (our thanks to @J for flagging this!) [78664]</li>\n<li>Fix &#8211; Add a safety check in isOrganizer() function (our thanks to Kevin for flagging this!) [81645]</li>\n<li>Fix &#8211; Avoid EA Client hanging when no events are found while attempting an import from a Facebook source [82713]</li>\n<li>Fix &#8211; Improve compatibility of The Events Calendar when operating with WPML from within a subdirectory (props: @dgwatkins) [81998]</li>\n</ul>\n<h4>[4.5.7] 2017-06-28</h4>\n<ul>\n<li>Fix &#8211; Restore support for translated events category slugs when WPML is active [73478]</li>\n<li>Fix &#8211; Improve handling of shortcodes within event view excerpts (props: @awbauer) [81226]</li>\n<li>Fix &#8211; Improve compatibility with WPML in relation to event permalinks specifically (props: @dgwatkins) [81224]</li>\n<li>Fix &#8211; Improved handling of Venue fields that allows for better form validation in Community Events [76297]</li>\n<li>Tweak &#8211; Better detection and reporting of communication failures with the Event Aggregator server</li>\n<li>Tweak &#8211; Textual corrections (with thanks to @garrett-eclipse for highlighting many of these) [77196]</li>\n<li>Tweak &#8211; New filter added (&#8220;tribe_events_linked_posts_dropdown_enable_creation&#8221;) to facilitate more control over linked posts [80487]</li>\n<li>Tweak &#8211; Improve performance of theme compatibility code [71974]</li>\n<li>Tweak &#8211; Don&#8217;t show Event Aggregator system status in Help tab if there&#8217;s no Event Aggregator license in place [68506]</li>\n</ul>\n<h4>[4.5.6] 2017-06-22</h4>\n<ul>\n<li>Tweak &#8211; Improved how Cost field looks and it&#8217;s consistency across views [71092 &amp; 71094]</li>\n<li>Fix &#8211; Resolved issue where the Meta Chunker attempted to inappropriately chunk meta for post post_types [80857]</li>\n<li>Tweak &#8211; Added actions: <code>tribe_events_inside_cost</code></li>\n<li>Tweak &#8211; Changed views: <code>day/single-event</code>, <code>day/single-featured</code>, <code>list/single-event</code>, <code>list/single-featured</code></li>\n<li>Language &#8211; 1 new strings added, 15 updated, 1 fuzzied, and 1 obsoleted [the-events-calendar]</li>\n<li>Language &#8211; 0 new strings added, 0 updated, 1 fuzzied, and 0 obsoleted [tribe-common]</li>\n</ul>\n<h4>[4.5.5] 2017-06-14</h4>\n<ul>\n<li>Fix &#8211; Removed extra double quotes in organizer link output [71133]</li>\n<li>Fix &#8211; Make the list and day view styles match more closely [63599]</li>\n<li>Fix &#8211; Better sanitization on CSV imports (thanks to Valentinos Chouris from NCC Group for reporting this) [80311]</li>\n<li>Fix &#8211; Prevent tabs from being incorrectly escaped in iCal output (props: KZeni) [80452]</li>\n<li>Fix &#8211; Fixed inconsistent font styling of Tribe Bar form labels. [27252]</li>\n<li>Tweak &#8211; Removed unused Javascript (jQuery UI Dialog) to help avoid warnings (our thanks to @gama6889 for flagging this) [80766]</li>\n<li>Tweak &#8211; Added new filter hooks &#8216;tribe_events_register_event_type_args&#8217; and &#8216;tribe_events_register_event_cat_type_args&#8217; [80658]</li>\n</ul>\n<h4>[4.5.4] 2017-06-06</h4>\n<ul>\n<li>Tweak &#8211; Minor tweaks to the CSS for linked post types (Organizer/Venues)</li>\n<li>Fix &#8211; Prevent drag and drop icon showing when singular linked post type is been displayed</li>\n<li>Fix &#8211; Resolved issue where scheduled imports sometimes failed to execute [79587]</li>\n<li>Fix &#8211; Better sanitization of data (Props to Valentinos Chouris for reporting this) [80310]</li>\n<li>Language &#8211; 2 new strings added, 156 updated, 0 fuzzied, and 4 obsoleted [the-events-calendar]</li>\n<li>Language &#8211; 4 new strings added, 20 updated, 1 fuzzied, and 0 obsoleted [tribe-common]</li>\n</ul>\n<h4>[4.5.3] 2017-06-01</h4>\n<ul>\n<li>Fix &#8211; Made it easier to translate the update confirmation message (our thanks to safu9 for highlighting this) [79729]</li>\n<li>Fix &#8211; Fixed compatibility issue with WPML which caused organizers and venues to disappear on translated events [67581]</li>\n<li>Fix — Fixed bug where venues and organizers would be duplicated when their associated event is previewed. [64088]</li>\n<li>Tweak &#8211; Other fixes to the plugin verbiage (with thanks to @garrett-eclipse and others)</li>\n</ul>\n<h4>[4.5.2.1] 2017-05-19</h4>\n<ul>\n<li>Fix &#8211; Prevent fatal errors occuring in PHP 5.5 and earlier [79208]</li>\n</ul>\n<h4>[4.5.2] 2017-05-17</h4>\n<ul>\n<li>Fix &#8211; Correct REST API reference URL (our thanks to Lindsey for flagging this) [78658]</li>\n<li>Fix &#8211; Improve Event Aggregator integration to avoid situations where imports continually restart but do not complete [77988]</li>\n<li>Tweak &#8211; Make the inclusion or exclusion of the year (within the event schedule string) filterable [78070]</li>\n<li>Tweak &#8211; Adjustments to help avoid false positive security alerts being generated in relation to our customizer integration [78355]</li>\n</ul>\n<h4>[4.5.1] 2017-05-04</h4>\n<ul>\n<li>Fix &#8211; Prevented errors on EA import screen that happened in exotic circumstance. Thanks @kathryn for reporting this! [75787]</li>\n<li>Fix &#8211; Made EA preserve custom dates after reimporting a Facebook Event when option is set. [75787]</li>\n<li>Fix &#8211; Enhance month view caching to minimize impact of JSON-LD generation [74656]</li>\n<li>Tweak &#8211; Styling/layout improvements within the Event Aggregator screen [77895]</li>\n</ul>\n<h4>[4.5.0.2] 2017-05-01</h4>\n<ul>\n<li>Fix &#8211; Ensure compatibility with WordPress version 4.4 and earlier</li>\n</ul>\n<h4>[4.5.0.1] 2017-05-01</h4>\n<ul>\n<li>Fix &#8211; Resolving issue where some premium plugins were falsely claiming they were out of date</li>\n</ul>\n<h4>[4.5] 2017-05-01</h4>\n<ul>\n<li>Feature &#8211; Event Aggregator now allows users to import from other sites with The Events Calendar [68139]</li>\n<li>Feature &#8211; Include a Events REST API endpoint for read operations [70711]</li>\n<li>Feature &#8211; Include granular Scheduling for Events Aggregator</li>\n<li>Tweak &#8211; Update Authority for modified fields now will include Organizer, Venues and Taxonomy changes [71152]</li>\n<li>Tweak &#8211; Clean up direct calls to get events and use wrapper <code>tribe_get_events()</code> which has a hook for customizing</li>\n<li>Tweak &#8211; Remove including Event Tickets for backwards compatibility as a vendor library [71908]</li>\n<li>Tweak &#8211; Create a global ID to increase consistency on all of the imported items with Event Aggregator [75218]</li>\n<li>Fix &#8211; Prevent Aggregator to run on Empty Queues thus generating fatals (props to @Donald for the report here) [75377]</li>\n<li>Fix &#8211; Categories and Tags are no longer cleared when importing with Event Aggregator (thank you @Nicolas for the report) [74264]</li>\n<li>Fix &#8211; Increase consistency on Column Mapping for CSV imports [76476]</li>\n<li>Tweak &#8211; Added filters for REST API: <code>tribe_events_rest_url_prefix</code>, <code>tribe_rest_url</code>, <code>tribe_events_rest_use_builtin</code>, <code>tribe_rest_events_archive_data</code>, <code>tribe_rest_event_max_per_page</code>, <code>tribe_rest_event_data</code>, <code>tribe_rest_venue_data</code>, <code>tribe_rest_organizer_data</code>, <code>tribe_rest_event_categories_data</code>, <code>tribe_rest_event_tags_data</code>, <code>tribe_rest_event_taxonomy_term_data</code>, <code>tribe_rest_event_featured_image</code>, <code>tribe_events_rest_api_enabled</code></li>\n<li>Tweak &#8211; Added filters for REST API Documentation: <code>tribe_rest_swagger_cost_details_documentation</code>, <code>tribe_rest_swagger_date_details_documentation</code>, <code>tribe_rest_swagger_image_details_documentation</code>, <code>tribe_rest_swagger_image_size_documentation</code>, <code>tribe_rest_swagger_term_documentation</code>, <code>tribe_rest_swagger_event_documentation</code>, <code>tribe_rest_swagger_organizer_documentation</code>, <code>tribe_rest_swagger_venue_documentation</code>, <code>tribe_rest_swagger_documentation</code></li>\n<li>Tweak &#8211; Added filters for Modified fields tracking: <code>tribe_tracker_post_types</code>, <code>tribe_tracker_excluded_meta_keys</code>, <code>tribe_tracker_enabled</code>, <code>tribe_tracker_enabled_for_terms</code>, <code>tribe_tracker_taxonomies</code></li>\n<li>Tweak &#8211; Added filters for Event Aggregator: <code>tribe_aggregator_localized_data</code>, <code>tribe_aggregator_service_messages</code>, <code>tribe_aggregator_url_import_range_options</code>, <code>tribe_aggregator_url_import_range_cap</code>, <code>tribe_aggregator_url_import_range_start</code>, <code>tribe_aggregator_url_import_range_end</code></li>\n<li>Tweak &#8211; Removed filters for Event Aggregator: <code>tribe_aggregator_track_modified_fields</code></li>\n<li>Tweak &#8211; Added actions for Initialization: <code>tribe_events_bound_implementations</code></li>\n<li>Tweak &#8211; Removed methods for <code>Tribe__Events__Main</code>: <code>track_event_post_field_changes</code>, <code>maybe_load_tickets_framework</code></li>\n<li>Tweak &#8211; Removed methods for <code>Tribe__Events__Aggregator__Service</code>: <code>has_service_message</code></li>\n</ul>\n<h4>[4.4.5] 2017-03-23</h4>\n<ul>\n<li>Fix &#8211; Local changes to events should be preserved in accordance with the Event Import Authority setting (thanks to @bryan for reporting this one) [72876]</li>\n<li>Fix &#8211; Correct the value for days of the week abbreviation (thanks @mmmmartin03 for the report) [75379]</li>\n<li>Tweak &#8211; Enable the month view cache by default on new installations [74867]</li>\n<li>Tweak &#8211; External links to Google maps changed from http to https (nice find by @bjf2000 &#8211; reported via the .org support page) [74930]</li>\n<li>Tweak &#8211; Links to WordPress.org changed from http to https (ultimately this is also credited to @bjf2000&#8217;s find. Thanks!) [72273]</li>\n</ul>\n<h4>[4.4.4] 2017-03-08</h4>\n<ul>\n<li>Fix &#8211; Avoid unnecessarily removing a callback from an action while inside the same action (improves PolyLang compatibility &#8211; props @Chouby) [73122]</li>\n<li>Fix &#8211; Resolving issue where sites that overrode the wp-admin path would fail to successfully perform a Facebook OAuth with Event Aggregator [74687]</li>\n<li>Tweak &#8211; Improve template loading for easier customization by developers and better support of the template hierarchy (props @QWp6t) [72842]</li>\n</ul>\n<h4>[4.4.3] 2017-02-22</h4>\n<ul>\n<li>Fix &#8211; Resolved issue where iCal exports on month view were exporting more events than intended (thanks to @s2ldesign for reporting in our forums) [72133]</li>\n<li>Fix &#8211; Resolved meta width issue for maps when Pro is active (gracias a @ANTONIO JOSE por el reporte del error)  [69844, 72272]</li>\n<li>Fix &#8211; Resolved issue where featured images were not being imported via Event Aggregator Facebook imports (cheers to @Cody for the initial bug report) [72764]</li>\n<li>Fix &#8211; Resolved issue where translated &#8216;all&#8217; slugs were not respected (thank you @Marianne for your report in the forums) [71996]</li>\n<li>Tweak &#8211; Translation improvements and fixes (@Katja &#8211; thanks! ) [70068]</li>\n<li>Tweak &#8211; Allow &#8220;-1&#8221; when specifying the &#8220;Month view events per day&#8221; setting [70497]</li>\n</ul>\n<h4>[4.4.2] 2017-02-09</h4>\n<ul>\n<li>Fix &#8211; Ensure the global and source-specific Google Map settings for imports are respected [67228]</li>\n<li>Fix &#8211; Prevent PHP 5.2 Strict mode from throwing notices due to usage of <code>is_a</code> [72812]</li>\n<li>Fix &#8211; Ensure the events list widget&#8217;s show/hide if there are upcoming events setting is respected [72965]</li>\n<li>Tweak &#8211; Add filters for template tag functions related to dates: <code>tribe_get_start_time</code>, <code>tribe_get_end_time</code>, <code>tribe_get_start_date</code> and <code>tribe_get_end_date</code> [67759]</li>\n</ul>\n<h4>[4.4.1.1] 2017-01-26</h4>\n<ul>\n<li>Fix &#8211; Resolved fatal caused when rendering themes that override tribe styles</li>\n</ul>\n<h4>[4.4.1] 2017-01-26</h4>\n<ul>\n<li>Fix &#8211; Resolve the Fatals related to undefined methods and Memory exhaustion [71958, 71912]</li>\n<li>Fix &#8211; iCal export for Single events working again [71916]</li>\n<li>Tweak &#8211; Changes the Search label to prevent duplicate words (props @oheinrich) [72149]</li>\n<li>Tweak &#8211; Add theme version to <code>tribe-event.css</code> (props @berler) [71973]</li>\n<li>Fix &#8211; Resolve JavaScript error when jQuery was been de-registered [71369]</li>\n<li>Fix &#8211; Prevent Fatals when Importing Images on Event Aggregator [70576]</li>\n<li>Fix &#8211; Prevent Third Party notes to be escaped, anchor link working again [71872]</li>\n<li>Fix &#8211; Google Maps now are using HTTPS instead of HTTP (props @cliffordp)</li>\n<li>Fix &#8211; Prevent Fatals on Event Aggregator Cron, due to Activity logging failure [71904]</li>\n<li>Fix &#8211; Elminate some cases of problem with Facebook manual import on Event Aggregator [69137]</li>\n<li>Fix &#8211; WPML integration smaller incompatibilities [70520, 70522]</li>\n</ul>\n<h4>[4.4.0.1] 2017-01-09</h4>\n<ul>\n<li>Fix &#8211; Adds safety check to ensure a smooth activation process when earlier versions of Tribe Common are active</li>\n</ul>\n<h4>[4.4] 2017-01-09</h4>\n<ul>\n<li>Feature &#8211; Add dynamic helper text to single event editor to display the events date and time [66484]</li>\n<li>Feature &#8211; Add support for featured events [65898]</li>\n<li>Feature &#8211; Add support for placing the main events archive on the site homepage [38757]</li>\n<li>Feature &#8211; Add support for the theme customizer [67489]</li>\n<li>Feature &#8211; Make it possible to adjust map pins via the theme customizer [65889]</li>\n<li>Feature &#8211; Support for Event Aggregator in a multisite network context added [61427]</li>\n<li>Fix &#8211; Add a link to The Events Calendar Help page in the Network Administration screen of multisite installations [68665]</li>\n<li>Fix &#8211; Multisite license editing and displaying consistency [68662]</li>\n<li>Tweak &#8211; Adjusted styles and added actions for featured events in the List Widget [65923]</li>\n<li>Tweak &#8211; Organizers and Venues are now with a better and cleaner interface [68430]</li>\n<li>Tweak &#8211; Eliminate duplicate meta data for organizer posts [25084]</li>\n<li>Tweak &#8211; Improved the start/end date user interface [66486, 66487, 66550]</li>\n<li>Tweak &#8211; iCal export now includes all events &#8211; up to a reasonable limit &#8211; rather than just those in the current view [65037]</li>\n<li>Tweak &#8211; Adjustments made to the default week view color scheme [69756]</li>\n<li>Tweak &#8211; Add AJAX and improve consistency of the venue and organizer UI [38129]</li>\n</ul>\n<h4>[4.3.5] 2016-12-20</h4>\n<ul>\n<li>Tweak &#8211; Updated the template override instructions in a number of templates [68229]</li>\n<li>Tweak &#8211; Improve behavior of tribe_get_events_title() in respect of single events [46313]</li>\n<li>Tweak &#8211; Event Aggregator will only load on the Administration, prevent bigger loads for Front-End users [70812]</li>\n<li>Tweak &#8211; Allow better filtering for Organizers and Venue Meta fields (Props: @Chouby from Polylang) [70894]</li>\n<li>Fix &#8211; Prevent JavaScript Notices related to Bumpdown [69886]</li>\n<li>Fix &#8211; Assets URL on Windows Servers are fully operational again [68377]</li>\n<li>Fix &#8211; JavaScript and CSS files will respect HTTPS on all pages [69561]</li>\n<li>Fix &#8211; Fixed comment count and visibility issues due to Event Aggregator records [68297]</li>\n<li>Fix &#8211; Fixed PHP notices and warnings raised when importing .ics files [69960]</li>\n<li>Fix &#8211; Only show link to Venues if Pro is active in List View [69887]</li>\n<li>Fix &#8211; Fixed and issue that would make Event Aggregator importing notices remain stuck in the Import screen [70614]</li>\n<li>Fix &#8211; Avoid error screen when saving licenses on multisite installations [68599]</li>\n<li>Fix &#8211; Fix calendar view links in WPML language switcher [67134]</li>\n</ul>\n<h4>[4.3.4.2] 2016-12-13</h4>\n<ul>\n<li>Fix &#8211; Correct an oversight leading to breakages of the /all/ events archive for Events Calendar PRO users [70662]</li>\n</ul>\n<h4>[4.3.4.1] 2016-12-09</h4>\n<ul>\n<li>Fix &#8211; Updates Tribe Common to remove some stray characters that were impacting page layouts (props: @Aetles) [70536]</li>\n</ul>\n<h4>[4.3.4] 2016-12-08</h4>\n<ul>\n<li>Tweak &#8211; Tribe Common now is loaded only once across our plugin suite, improves performance in some cases [65755]</li>\n<li>Fix &#8211; Featured Images for Event Aggregator imports are working as expected again. [69465]</li>\n<li>Fix &#8211; Google Calendar and iCalendar files are now updating their respective events [68684]</li>\n<li>Fix &#8211; On demand Event Aggregator records will update events correctly [69542]</li>\n</ul>\n<h4>[4.3.3] 2016-11-16</h4>\n<ul>\n<li>Feature &#8211; Added Tribe Extension class and loader, to make small addons easier to build [68188]</li>\n<li>Fix &#8211; Ordering on Month view is working as expected again [69123]</li>\n<li>Fix &#8211; Enable ampersand character in mobile month view titles (thanks @kate for the report of this) [45409]</li>\n<li>Fix &#8211; Prevent notices for Event Aggregator License checking [67981]</li>\n<li>Fix &#8211; Mismatched text domains are resolved, important for translations (props to @Hans) [68462]</li>\n<li>Fix &#8211; Sticky on Month View is working as expected again [68902]</li>\n<li>Fix &#8211; Prevent HTTPS websites from pointing to Assets in HTTP [68372]</li>\n<li>Fix &#8211; On <code>WP_Query</code> we will no-longer overwrite custom <code>post__not_in</code> params [42143]</li>\n</ul>\n<h4>[4.3.2] 2016-11-02</h4>\n<ul>\n<li>Fix &#8211; Fixes an issue where the text in the Location search field was URL encoded when using the back or forward button for navigation. [61742]</li>\n<li>Fix &#8211; Aggregator Errors will not show more than once daily as comments (Thanks @Jacob for your report on the forums) [68094]</li>\n<li>Fix &#8211; Event Aggregator ICS default configuration now are been Selected Correctly [67885]</li>\n<li>Fix &#8211; Shortcode Month view now will display tooltips correctly [68094]</li>\n<li>Fix &#8211; Avoid loading the select2 JavaScript library twice when Advanced Custom Fields is activated (props to @ryan for the initial report [43605]</li>\n<li>Fix &#8211; Avoid errors and notices on calendar page when X theme and WPML plugins are active (thanks @ingrid for reporting this one) [64400]</li>\n</ul>\n<h4>[4.3.1.1] 2016-10-20</h4>\n<ul>\n<li>Fix &#8211; Corrected a packaging issue from the 4.3.1 release [67936]</li>\n</ul>\n<h4>[4.3.1] 2016-10-20</h4>\n<ul>\n<li>Tweak &#8211; Implement the pruning of Event Aggregator history records after 7 days, filterable by tribe_aggregator_record_retention [68283]</li>\n<li>Tweak &#8211; Event Aggregator will now verify that the license key has uses remaining before creating a history record [68286]</li>\n<li>Tweak &#8211; Improve <code>tribe_create_event</code> documentation (Props to Keith) [44871]</li>\n<li>Fix &#8211; Resolved an issue where scheduled Event Aggregator imports marked as &#8220;On Demand&#8221; were being run by cron [68284]</li>\n<li>Fix &#8211; Resolved a bug where empty meta fields were being inserted into Event Aggregator record post meta [68290]</li>\n<li>Fix &#8211; Resolved a bug where Venue and Organizers urls were been generated incorrectly (Thanks @Matt) [68168]</li>\n<li>Fix &#8211; Pagination links on Month view are updating correctly [67977]</li>\n<li>Fix &#8211; Resolved the support for translated event category archive slug that could lead to broken links on the front-end while using WPML (Props to Wilco in the support Forums) [62018]</li>\n<li>Fix &#8211; Resolved a bug where searching for past events in the List view would always yield no results (Thanks for the report @Davide) [61863]</li>\n<li>Fix &#8211; Resolved an issue where long file names would break plugin updates on some Windows installations (pros to @Alan [62552]</li>\n<li>Fix &#8211; Resolved an issue where the <code>/all</code> link on recurring events on non English websites could be broken (reported by @lumiest &#8211; thanks!) [68062]</li>\n<li>Fix &#8211; Pagination links on Month view are updating correctly [67977]</li>\n</ul>\n<h4>[4.3.0.1] 2016-10-14</h4>\n<ul>\n<li>Fix &#8211; Preventing legacy Facebook events from being duplicated</li>\n</ul>\n<h4>[4.3] 2016-10-13</h4>\n<ul>\n<li>Feature &#8211; Added Event Aggregator to enable service-based event imports from iCal feeds, Facebook, and Meetup</li>\n<li>Feature &#8211; Revamped the CSV import screens to work within the new Event Aggregator pages</li>\n<li>Tweak &#8211; Adjusted some view logic to support the new Event Views shortcode in Pro [44800]</li>\n<li>Tweak &#8211; Added a button to copy the system infomation on the help tab [43709]</li>\n<li>Tweak &#8211; Added an option for users to opt into automatic system infomation so our support system can grab the system information found on the help tab automatically [31645]</li>\n<li>Tweak &#8211; Use an earlier hook for iCal feed generation (props @jlambe) [64141]</li>\n<li>Tweak &#8211; Revise and simplify integration with Event Tickets attendee screen [61992]</li>\n<li>Tweak &#8211; Added context to a set of strings to make translation easier (props @pedro-mendonca) [64586]</li>\n<li>Tweak &#8211; Deprecated various disused functions and classes relating to the Meta Factory [39905]</li>\n<li>Fix &#8211; Cease using GLOB_BRACE for including deprecated files due to limited server support [63172]</li>\n<li>Fix &#8211; Avoid problems that can occur when hooking and unhooking actions (props @Chouby) [63474]</li>\n<li>Fix &#8211; Resolves an issue where we were duplicating a core WordPress hook but with a different set of parameters (props @Chouby) [66455]</li>\n<li>Fix &#8211; Correct the datetime formatting issues within the iCal feed (props @henryk) [65968]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Main::initOptions()</code> has been deprecated with no replacement</li>\n<li>Deprecated &#8211; <code>Tribe__Events__Main::set_meta_factory_global()</code> has been deprecated in favor of using the <code>Tribe__Events__Meta_Factory</code> class</li>\n<li>Deprecated &#8211; The <code>setup_meta()</code> method in both the <code>Tribe__Events__Template__Single_Event</code> and <code>Tribe__Events__Template_Factory</code> classes has been deprecated</li>\n<li>Deprecated &#8211; The <code>the_title()</code>, <code>event_date()</code>, <code>event_category()</code>, <code>event_tag()</code>, <code>event_website()</code>, <code>event_origin()</code>, <code>organizer_name()</code>, <code>organizer_email()</code>, <code>venue_name()</code>, <code>venue_address()</code>, and <code>venue_map()</code> methods have been deprecated in the <code>Tribe__Events__Advanced_Functions__Register_Meta</code> class</li>\n<li>Deprecated &#8211; The <code>register()</code>, <code>check_exists()</code>, and <code>get_args()</code> methods have been deprecated in the <code>Tribe__Events__Meta_Factory</code> class</li>\n</ul>\n<h4>[4.2.7] 2016-09-15</h4>\n<ul>\n<li>Tweak &#8211; Additional support for plugin extensions</li>\n</ul>\n<h4>[4.2.6] 2016-08-31</h4>\n<ul>\n<li>Add &#8211; tribe_is_event_past() conditional to detect if event end time is past current time (Reported by @Jonathan in our support forums &#8211; thanks Jonathan.)</li>\n</ul>\n<h4>[4.2.5] 2016-08-17</h4>\n<ul>\n<li>Fix &#8211; Fixed inconsistent template filtering logic for single event template [62525]</li>\n<li>Tweak &#8211; Restored preview for published events [64874]</li>\n</ul>\n<h4>[4.2.4] 2016-08-03</h4>\n<ul>\n<li>Tweak &#8211; Changed &#8220;Event Add-Ons&#8221; to load faster [64286]</li>\n<li>Fix &#8211; Fixed default venue setting [64628]</li>\n<li>Fix &#8211; Fixed default venue state and province settings [64629]</li>\n</ul>\n<h4>[4.2.3] 2016-07-20</h4>\n<ul>\n<li>Fix &#8211; In month view, be sure to unhook JSON-LD output when calling unhook function</li>\n<li>Fix &#8211; Incorrect JSON-LD event start and end times (thank you @jjbte for reporting on .org forums)</li>\n<li>Fix &#8211; Show Google Map and Link checkbox so they show when editing an event (Reported originally by Michael of @NailedIT in the .org forum)</li>\n<li>Fix &#8211; Use Community Events Venue Edit Link when on Community Events Forms instead of Admin (also as a result of the report abve from @NailedIT. Thanks again.)</li>\n</ul>\n<h4>[4.2.2] 2016-07-06</h4>\n<ul>\n<li>Fix &#8211; Small CSS Issue on Welcome Page</li>\n<li>Fix &#8211; Month view on mobile device width doesn&#8217;t have links to prev/next months</li>\n<li>Fix &#8211; Reimport of updated CSV removes featured image (Bug #46149)</li>\n<li>Fix &#8211; Fixed the issue that would make multiple organizers details disappear when trying to submit invalid event data using Community</li>\n<li>Fix &#8211; Add a check to avoid being unable to switch view when Filter Bar plugin is active and at least one field is set to auto-complete mode</li>\n<li>Fix &#8211; Only add the events custom post type to the tag archive queries and not custom queries with tags [45635]</li>\n<li>Fix &#8211; When using the filter tribe_events_excerpt_allow_shortcode shortcodes will be maybe be processed in event excerpts in the list views [42289]</li>\n</ul>\n<h4>[4.2.1.1] 2016-06-28</h4>\n<ul>\n<li>Fix &#8211; Ensure translations load as expected with all supported versions of WordPress (thanks to @JacobALund for originally reporting this on .org forums)</li>\n</ul>\n<h4>[4.2.1] 2016-06-22</h4>\n<ul>\n<li>Tweak &#8211; Adjust the caching rules for Month View for faster loading</li>\n<li>Fix &#8211; Replace a bad return type to avoid unnecessary notices in the error log</li>\n<li>Fix &#8211; Add missing styles for correctly hide screen reader text</li>\n<li>Fix &#8211; Fixes <code>tribe_get_event_link()</code> which wasn&#8217;t working when passing second parameter as `true&#8217;</li>\n<li>Tweak &#8211; Reduce the ginormous font size of Month View titles in skeleton styles</li>\n<li>Fix &#8211; Add styling to adjust List View description to full width</li>\n<li>Fix &#8211; Miscellaneous tweaks to improve the Month and Day views</li>\n<li>Fix &#8211; Fix a shorthand array that was causing errors in PHP 5.2 and 5.3 when importing events</li>\n</ul>\n<h4>[4.2] 2016-06-08</h4>\n<ul>\n<li>Feature &#8211; Added Google Maps API key field in the Settings tab to avoid map timeouts and errors on larger sites (Thanks to Yan for reporting this!)</li>\n<li>Feature &#8211; Added support for featured image, multiple organizers, excerpt and more custom fields in the .csv file import function for events (Thank you to Graphic Designer for posting on UserVoice!)</li>\n<li>Feature &#8211; Added support for featured image, description, map details and more custom fields in the .csv file import function for venues</li>\n<li>Feature &#8211; Added support for featured image and description in the .csv file import function for organizers (Thank you to Rebecca for posting on UserVoice!)</li>\n<li>Feature &#8211; Added an oEmbed template for events</li>\n<li>Feature &#8211; Improve performance of a query used to determine if there are free/uncosted events (Thank you @fabianmarz for the pull request!)</li>\n<li>Feature &#8211; Added support for attaching custom post types to events</li>\n<li>Tweak &#8211; Improved filtering of the <code>tribe_event_featured_image()</code> function (Cheers to @fabianmarz!)</li>\n<li>Tweak &#8211; Add an encoding class for the CSV importer to prevent non utf8 characters from preventing imports (Thanks to screenrage for the report!)</li>\n<li>Tweak &#8211; Improved our JSON-LD output to ensure consistency (Props to @garrettjohnson and Lars!)</li>\n<li>Tweak &#8211; Language files in the <code>wp-content/languages/plugins</code> path will be loaded before attempting to load internal language files (Thank you to user aafhhl for bringing this to our attention!)</li>\n<li>Tweak &#8211; Switch to HTTPS for the &#8220;Powered by The Events Calendar&#8221; link (Thank you Cynthia for reporting this!)</li>\n<li>Tweak &#8211; Switch to using HTTPS by default for interactions with Google Maps API</li>\n<li>Tweak &#8211; Improved filterability of calendar excerpts by introducing the new <code>tribe_events_get_the_excerpt</code> filter hook</li>\n<li>Tweak &#8211; Improved filtering of organizer details when importing by CSV (Props to @Geir for bringing this up!)</li>\n<li>Tweak &#8211; Adjustments for single event view in Twenty Fifteen theme</li>\n<li>Tweak &#8211; Improved performance of query used to test for events without any cost</li>\n<li>Tweak &#8211; Added missing semicolon to a laquo (Props to mwender on GitHub for the fix!)</li>\n<li>Tweak &#8211; Improve the &#8220;stickiness&#8221; of CSV import column mappings (Thank you @jamesgol!)</li>\n<li>Tweak &#8211; Consistency of JSON-LD markup improved (Cheers to @garrettjohnson for the help!)</li>\n<li>Tweak &#8211; Avoid notice-level errors when working with WP CLI on a site where The Events Calendar is also active (Thanks to @sun)</li>\n<li>Tweak &#8211; Corrected the spelling of timezone in the CSV Importer&#8217;s event field</li>\n<li>Tweak &#8211; Updated venue and organizer templates to use the new architecture for attaching custom post types to events</li>\n<li>Tweak &#8211; Move plugin CSS to PostCSS</li>\n<li>Tweak &#8211; Category default view is now set to <code>default</code> in place of hardcoding the current default view in the category base rewrite rule [31907]</li>\n<li>Deprecated &#8211; <code>Tribe__Events__PUE__Checker</code>, <code>Tribe__Events__PUE__Plugin_Info</code>, and <code>Tribe__Events__PUE__Utility</code> classes are deprecated and are replaced by <code>Tribe__PUE__Checker</code>, <code>Tribe__PUE__Plugin_Info</code>, and <code>Tribe__PUE__Utility</code> classes</li>\n<li>Fixed &#8211; Changed the use of <code>have_posts()</code> in the maybe iCal links for the main views that could cause an infinite loop</li>\n<li>Accessibility &#8211; Focus styles added for search fields</li>\n<li>Accessibility &#8211; Add ARIA labels for Month/Day/List sub nav</li>\n<li>Accessibility &#8211; Add ARIA label for events footer sub nav heading</li>\n</ul>\n<h4>[4.1.4] 2016-05-19</h4>\n<ul>\n<li>Fix &#8211; Improve accuracy of list view pagination after switching from month view</li>\n<li>Tweak &#8211; Give the multi-organizer form &#8216;sticky&#8217; properties so values persist even if the submission is initially rejected</li>\n<li>Tweak &#8211; Resolved minor CSS issues in the welcome page</li>\n</ul>\n<h4>[4.1.3] 2016-04-28</h4>\n<ul>\n<li>Fix &#8211; Month View single days are now ordered as follows: sticky events, ongoing multi-day events, all day events, then start time. In other words, all events should be ordered as you&#8217;d expect when viewing events in Month View.</li>\n<li>Fix &#8211; Updated the compatibility of CSV importer with WordPress 4.5 due to a change in the <code>post_status</code> filter. This will help prevent some of the errors you may have seen when importing events using a CSV file.</li>\n<li>Tweak &#8211; Added new event names for AJAX success to the List, Month, and Day views to help The Events Calendar&#8217;s compatibility with our other premium plugins.</li>\n</ul>\n<h4>[4.1.2] 2016-04-11</h4>\n<ul>\n<li>Tweak &#8211; Removed an unneeded hook that attempted to add a query argument to event tag links</li>\n<li>Fix &#8211; Resolved an issue where events marked as &#8220;sticky&#8221; would not display as such in Month View</li>\n<li>Fix &#8211; Dashes, hyphens, or whatever you like to call them in the events archive slug no longer breaks the URL</li>\n<li>Fix &#8211; The notice that pops up when a conflicting &#8220;events&#8221; page exists can now be dismissed</li>\n</ul>\n<h4>[4.1.1.1] 2016-04-07</h4>\n<ul>\n<li>Security &#8211; Tightened up security with post type link filtering (props to Nadal Soler for reporting this issue!)</li>\n<li>Security &#8211; Tightened up security around tribe bar submissions (props to Paul Mynarsky for reporting this issue!)</li>\n</ul>\n<h4>[4.1.1] 2016-03-30</h4>\n<ul>\n<li>Fix &#8211; Resolved bug where array notices were output on single event pages when venues were not set (props to zaxiscreative for reporting this issue!)</li>\n<li>Fix &#8211; Resolved issue where the Month View in mobile sizes retained the long day-of-week names when the abbreviations should have been used (props to Lucy for the bug report!)</li>\n<li>Fix &#8211; Fixed bug where a &#8220;0&#8221; was added to the default Venue name when creating a new event</li>\n<li>Fix &#8211; Fixed notice that caused Ajax requests to fail (props to cgrymala on WP.org for reporting this!)</li>\n<li>Fix &#8211; Removed quotes from around TZID-specified timezones in iCal feeds which causes problems with some parsers (props to factory44 for reporting the issue that lead to this fix)</li>\n<li>Fix &#8211; Resolved various capitalization issues with German translations (props to oheinrich in our forums for pointing out this issue!)</li>\n</ul>\n<h4>[4.1.0.1] 2016-03-17</h4>\n<ul>\n<li>Fix &#8211; Resolved multiple issues with the German <code>de_DE</code> language file that caused a number of site-breaking issues</li>\n</ul>\n<h4>[4.1] 2016-03-15</h4>\n<ul>\n<li>Feature &#8211; Added a tribe_get_venue_website_url() function for fetching Venue website URLs (props to fervorcreative in our forums for this request!)</li>\n<li>Performance &#8211; Lazy-load venue and organizer selector data</li>\n<li>Tweak &#8211; Allow iCal filenames to be filtered via a new filter: tribe_events_ical_feed_filename</li>\n<li>Tweak &#8211; Added a hook to allow single day queries in month view to be filtered: tribe_events_month_daily_events_query_args</li>\n<li>Tweak &#8211; Improved the logic around rebuilding known date ranges</li>\n<li>Tweak &#8211; Always show the &#8220;Merge Duplicates&#8221; button for venues and organizers in the Events General Settings page</li>\n<li>Tweak &#8211; Allow the &#8220;same slug&#8221; notice to be dismissed and fix some text in that message</li>\n<li>Tweak &#8211; Ignore alpha/beta/rc suffixes on version numbers when checking template versions</li>\n<li>Tweak &#8211; Add a filter for month view daily events query: tribe_events_month_daily_events_query_args</li>\n<li>Tweak &#8211; Added a more flexible cost range parsing function</li>\n<li>Tweak &#8211; Obfuscate license keys Events &gt; Help &gt; System Information</li>\n<li>Fix &#8211; Fixed a fatal that sometimes occurred when refreshing the import CSV page</li>\n<li>Fix &#8211; Fixed issue where some characters were not escaped appropriately for month and year formats</li>\n<li>Fix &#8211; Added missing tribe-loading@2x.gif</li>\n<li>Fix &#8211; Fixed a warning produced by passing a DateTime() object into start_date or end_date args of tribe_get_events (props to iamhexcoder for the pull request!)</li>\n<li>Fix &#8211; Fixed bug where events in month view were not always sorted in chronological order</li>\n<li>Fix &#8211; Fixed the System Info URL in Events &gt; Help</li>\n<li>Fix &#8211; Resolved issue where the default country would be &#8220;Array&#8221; if no default country is set</li>\n<li>Fix &#8211; Fixed bug where ajaxurl was sometimes undefined</li>\n</ul>\n<h4>[4.0.7] 2016-03-02</h4>\n<ul>\n<li>Fix &#8211; Resolve display issues on templates with Jetpack and a few themes</li>\n<li>Fix &#8211; Mobile breakpoints on month view working with custom breakpoints</li>\n<li>Fix &#8211; Reordering Venue and Organizer metadata no longer breaks titles</li>\n<li>Fix &#8211; Prevented notices from happening when using <code>the_title</code> filter</li>\n<li>Fix &#8211; iCal links now will respect categories on the first page</li>\n<li>Fix &#8211; Prevent third-party bugs with SEO plugins when inserting events programmatically</li>\n<li>Fix &#8211; Organizer information is showing up again correctly</li>\n<li>Fix &#8211; Modified the add-on license validation method to better explain what is happening</li>\n<li>Fix &#8211; Description on mobile views now have the correct class attribute on HTML</li>\n<li>Fix &#8211; Added missing semicolon on the list navigation for &#8220;&amp;laquo&#8221;</li>\n</ul>\n<h4>[4.0.6] 2016-02-17</h4>\n<ul>\n<li>Tweak &#8211; Adjust injection of event data into the_content from priority 10 to 9 for better 3rd-party plugin compatibility</li>\n<li>Tweak &#8211; Change mobile month view selector to load event details below the calendar for better theme compatibility</li>\n<li>Tweak &#8211; Better handling of edge cases on the post_excerpt for List View</li>\n<li>Tweak &#8211; Removal of generic CSS classes like <code>.updated</code> and <code>.published</code></li>\n<li>Fix &#8211; Prevent Notices from appearing when using <code>tribe_get_organizer()</code></li>\n<li>Fix &#8211; Make HTML Single Event Pages valid</li>\n<li>Fix &#8211; Numeric named categories URLs are now fully working</li>\n<li>Fix &#8211; Event Title now Accepts HTML on Tooltips</li>\n<li>Fix &#8211; Licenses Tab now will work with <code>DISALLOW_FILE_MODS</code> (Props to Sun for spotting and fixing this)</li>\n</ul>\n<h4>[4.0.5] 2016-01-15</h4>\n<ul>\n<li>Security &#8211; Security fix with Venues and Organizers (props to grantdayjames for reporting this!)</li>\n</ul>\n<h4>[4.0.4] 2015-12-23</h4>\n<ul>\n<li>Tweak &#8211; Including the latest embedded Event Tickets release for backward compatibility</li>\n</ul>\n<h4>[4.0.3] 2015-12-22</h4>\n<ul>\n<li>Tweak &#8211; Adjust single-event.php template to allow the &#8220;Time&#8221; title and content to be filterable (Props to Sitecrafting for highlighting this issue!)</li>\n<li>Fix &#8211; Resolved issue with an overly escaped Event Category edit URL that prevented editing categories (Thanks to Ian for the first report of this issue!)</li>\n<li>Fix &#8211; Fixed issue where clicking on columns on the Events listed in the Admin Dashboard were ALWAYS sorted by Event start/end date before sorting by the column selected (Cheers to Corrado for bringing this to our attention!)</li>\n</ul>\n<h4>[4.0.2] 2015-12-16</h4>\n<ul>\n<li>Tweak &#8211; Adding better support for non-numeric cost values on events (Props to Mirja for highlighting this!)</li>\n<li>Tweak &#8211; Avoid notice level errors when advanced events list widget settings are saved (Thank you Johan for reporting the issue!)</li>\n<li>Tweak &#8211; Improve messaging in the same-slug warning message (Thanks to Simon for bringing this to our attention!)</li>\n<li>Tweak &#8211; Hook to Event Tickets to inject event dates into ticket emails</li>\n<li>Tweak &#8211; Adding better support for default venues (Props to Karly for noting this!)</li>\n<li>Tweak &#8211; Improve handling of internationalized slugs (Cheers to Oliver for the help!)</li>\n<li>Fix &#8211; Ensure the past events list displays the correct events when accessed via ajax (Thank you Jesse for highlighting this!)</li>\n<li>Fix &#8211; Support ordering by venue/organizer within event queries (Thank you Doug for bringing this to our attention!)</li>\n<li>Fix &#8211; Fixed issue where events with the same date/time would sometimes be excluded from single-event navigation (Cheers to JeremyEnglert for the tip!)</li>\n<li>Fix &#8211; Resolved issue where events set with the explicit cost of 0 were not showing as &#8220;Free&#8221; (Thank you terrizsolo for reporting this!)</li>\n<li>Fix &#8211; Fixed bug where the datepicker in Twenty Sixteen was really ugly</li>\n<li>Fix &#8211; Fixed bug where using Quick Edit on events caused the table columns in the event list to become jumbled on save (Props to A K for the report!)</li>\n<li>Fix &#8211; Resolved bug where category links sometimes included event category 1 (Thank you Anthony for the original report of this problem!)</li>\n<li>Fix &#8211; Fixed a settings page URL (Props to Kristy for the heads up!)</li>\n</ul>\n<h4>[4.0.1] 2015-12-10</h4>\n<ul>\n<li>Tweak &#8211; Add a warning message for major updates</li>\n<li>Tweak &#8211; For SEO reasons, use an h1 for the title rather than an h2 (props to wpexplorer for this fix)</li>\n<li>Tweak &#8211; Target the calendar view grid in JS using a simpler selector</li>\n<li>Fix &#8211; Resolved WP 4.4 related fatal on the Nav Menu page that prevented the admin footer from rendering/enqueuing JS</li>\n<li>Fix &#8211; Resolved bug where visiting /events/upcoming could sometimes result in an infinite redirect loop</li>\n<li>Fix &#8211; Removed <code>wp_trim_excerpt</code> and use only it&#8217;s powers, fixing the excerpt problem</li>\n<li>Fix &#8211; Fixed bug where the mobile calendar view did not display the date for the date being viewed</li>\n<li>Fix &#8211; Fixed bug where the admin toolbar&#8217;s Events &gt; Import &gt; CSV did not link to the CSV importer page</li>\n<li>Fix &#8211; Fixed issue where the events list in the admin dashboard were not ordered in an intuitive manner</li>\n<li>Fix &#8211; Resolved bug where sorting by event category or tag resulted in an error</li>\n<li>Fix &#8211; Fixed bug where full event content text was displayed where excerpts should have been displayed</li>\n<li>Fix &#8211; Resolved issue where events imported via CSV were excluded from single event navigation</li>\n<li>Fix &#8211; Fixed bug where /events/list would sometimes 404 on a new install</li>\n<li>Fix &#8211; Resolved bug where multiday all-day events displayed the end date as one day later than it should be when the End of Day Cut-off was set to something other than 12am</li>\n<li>Fix &#8211; Timezone handling fixed within generated iCal feeds</li>\n</ul>\n<h4>[4.0] 2015-12-02</h4>\n<ul>\n<li>Security &#8211; A TON of escaping was added to our codebase thanks to the efforts of the always-helpful Andy Fragen (@afragen)</li>\n<li>Feature &#8211; Moved the Ticket framework code into its own plugin (event-tickets)</li>\n<li>Feature &#8211; The event cost now supports more international formats with the addition of the tribe_events_cost_separators filter (Thank you remokrol for bringing this to our attention!)</li>\n<li>Feature &#8211; Added support for the twentysixteen theme</li>\n<li>Feature &#8211; Created a new Add-Ons tab in Settings so that TEC add-ons can have a consolidated settings tab</li>\n<li>Feature &#8211; Improve the date formats UI by providing example output for each selected format</li>\n<li>Tweak &#8211; Restructured TEC&#8217;s core settings code for reusability with other standalone plugins like Event Tickets</li>\n<li>Tweak &#8211; Deprecate old JS event names in favor of a new JS event naming standard. Example: deprecated tribe_ev_runAjax in favor of run-ajax.tribe</li>\n<li>Tweak &#8211; Consolidated import pages for TEC and add-ons</li>\n<li>Tweak &#8211; When suggesting a UTF-8 compatibility CSV formatting tool, point to one that still exists</li>\n<li>Tweak &#8211; Added the ability to filter attendees CSV items via tribe_events_tickets_attendees_csv_items (Props to @bostondv on GitHub for this patch!)</li>\n<li>Tweak &#8211; Updated all excerpt output to use tribe_events_get_the_excerpt() to ensure a consistent display of excerpt content (Cheers to Joseph to pointing this out!)</li>\n<li>Tweak &#8211; Add support for wp_get_document_title in response to the WordPress 4.4 deprecation of wp_title</li>\n<li>Tweak &#8211; Check post creation permissions before letting users create venues and organizers from the event meta box</li>\n<li>Tweak &#8211; Only display data separators between fields that have data when rendering organizers (Thank you Bud for highlighting this issue!)</li>\n<li>Tweak &#8211; When a user cannot create organizers, prevent the auto-selection of organizers when editing an event</li>\n<li>Tweak &#8211; Remove microformat CSS classes from templates and replace with namespaced content-relevant CSS classes</li>\n<li>Tweak &#8211; Changed the &#8220;updated&#8221; CSS class to &#8220;tribe-updated&#8221; so that it is properly namespaced (Thank you vijayrajesh!)</li>\n<li>Tweak &#8211; The Plugin Update Checker will now auto-save valid plugin keys (Thanks to Denon for originally bringing this up!)</li>\n<li>Tweak &#8211; Cleaned up the output of JSON-LD data. Filterable via the new tribe_google_data_markup_json filter</li>\n<li>Tweak &#8211; Drop the use of the generic CSS class &#8220;placeholder&#8221; in favor of &#8220;tribe-event-placeholder&#8221; (Thanks to Marc on the forums!)</li>\n<li>Tweak &#8211; Adjusted the CSS padding on Admin Menu items for Events</li>\n<li>Tweak &#8211; Various codesniffer fixes</li>\n<li>Tweak &#8211; tribe_get_venue_link() no longer echoes if you ask it to return an <a> element</a></li>\n<li>Tweak &#8211; Error messages for empty Venue names</li>\n<li>Tweak &#8211; Improve our responsiveness for the widget mini calendar, allowing smaller sidebars.</li>\n<li>Tweak &#8211; No longer retrieve empty costs when fetching all costs for all events</li>\n<li>Tweak &#8211; Change the priority of bootstrapping the-events-calendar to ensure it occurs before any of the TEC addons in the event some addons are upgraded to v4.0 later than TEC</li>\n<li>Tweak &#8211; Adjust the logic used for adding a noindex/follow tag to event views</li>\n<li>Tweak &#8211; No longer hiding default address fields when default venues are selected when Pro is active</li>\n<li>Fix &#8211; Resolved issue where the iCal feed did not provide an appropriately formatted timezone in some cases (Cheers to Matt for the report!)</li>\n<li>Fix &#8211; Added support for translating some previously untranslatable strings (Props to tititou36, media325, and Stef!)</li>\n<li>Fix &#8211; Prevented duplicate CSS IDs on the mini calendars (Cheers to Corrado for the help!)</li>\n<li>Fix &#8211; Fixed bug causing tribe_get_single_ical_link() and tribe_get_ical_link() to use the same URL when it shouldn&#8217;t (Props to Ben Byrne @drywall on Twitter for the heads up!)</li>\n<li>Fix &#8211; Fixed issue where the &#8220;Add another organizer&#8221; text wasn&#8217;t using the correct singular label (Thank you MIKE for the report!)</li>\n<li>Fix &#8211; Various CSS fixes for twenty(ten-fifteen)</li>\n<li>Fix &#8211; Improved our handling of <code>get_current_screen()</code> across the plugin, avoiding notices and warnings (Thank you Mike for the help!)</li>\n<li>Fix &#8211; Fixed bug where accessing object properties on a non object errored out when saving event meta (props to @dalethedeveloper on GitHub for this fix!)</li>\n<li>Fix &#8211; Fixed bug where organizer ID meta attached sometimes included a blank record. That blank record is no longer returned in tribe_get_organizer_ids()</li>\n<li>Fix &#8211; Fixed error message returned when tabbing away from a blank event name meta box so that it properly indicates that an event name is required (Our thanks to @tapan29bd for this fix!)</li>\n<li>Fix &#8211; Resolved issue where Timezone event start/end date property name strings were malformed which guaranteed a a call to get_post_meta for Timezone date strings</li>\n<li>Fix &#8211; Fixed CSS issue where the month view calendar could sometimes extend beyond the edge of the page when Skeleton Styles were enabled</li>\n<li>Fix &#8211; Fixed a problem where iCal data was generated with incorrect dates in the case of some all days events (thanks to Matt for highlighting this)</li>\n<li>Fix &#8211; Resolved a problem causing the previous month view to appear when it should not</li>\n<li>Fix &#8211; Fixed issue in mobile month view where date was missing from heading</li>\n<li>Fix &#8211; Resolved issue that caused /events/ to 404 if it was visited on a new install before hitting &#8220;Save&#8221; on the Events &gt; Settings &gt; Display page</li>\n<li>Deprecated &#8211; The Tribe__Events__Main::defaultValueReplaceEnabled() method is being deprecated in favor of tribe_get_option(&#8216;defaultValueReplace&#8217;). Schedules for removal in v4.5</li>\n<li>Deprecated &#8211; The tribe_event_link() has been deprecated in favor of tribe_get_event_link(). Scheduled for removal in 5.0</li>\n<li>Deprecated &#8211; The third parameter of tribe_get_organizer_link() (the $echo parameter) has been deprecated and is scheduled for removal in 5.0</li>\n<li>Deprecated &#8211; Tribe__Events__Abstract_Deactivation in favor of Tribe__Abstract_Deactivation</li>\n<li>Deprecated &#8211; Tribe__Events__Admin__Helpers in favor of Tribe__Admin__Helpers</li>\n<li>Deprecated &#8211; Tribe__Events__App_Shop in favor of Tribe__App_Shop</li>\n<li>Deprecated &#8211; Tribe__Events__Autoloader in favor of Tribe__Autoloader</li>\n<li>Deprecated &#8211; Tribe__Events__Cache in favor of Tribe__Cache</li>\n<li>Deprecated &#8211; Tribe__Events__Cache_Listener in favor of Tribe__Cache_Listener</li>\n<li>Deprecated &#8211; Tribe__Events__Changelog_Reader in favor of Tribe__Changelog_Reader</li>\n<li>Deprecated &#8211; Tribe__Events__Credits in favor of Tribe__Credits</li>\n<li>Deprecated &#8211; Tribe__Events__Date_Utils in favor of Tribe__Date_Utils</li>\n<li>Deprecated &#8211; Tribe__Events__Field in favor of Tribe__Field</li>\n<li>Deprecated &#8211; Tribe__Events__Settings in favor of Tribe__Settings</li>\n<li>Deprecated &#8211; Tribe__Events__Settings_Tab in favor of Tribe__Settings_Tab</li>\n<li>Deprecated &#8211; Tribe__Events__Support in favor of Tribe__Support</li>\n<li>Deprecated &#8211; Tribe__Events__Template_Part_Cache in favor of Tribe__Template_Part_Cache</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Attendees_Table in favor of Tribe__Tickets__Attendees_Table in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Metabox in favor of Tribe__Tickets__Metabox in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Ticket_Object in favor of Tribe__Tickets__Ticket_Object in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Tickets in favor of Tribe__Tickets__Tickets in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Tickets__Tickets_Pro in favor of Tribe__Tickets__Tickets_Handler in the event-tickets plugin</li>\n<li>Deprecated &#8211; Tribe__Events__Validate in favor of Tribe__Validate</li>\n<li>Deprecated &#8211; Tribe__Events__View_Helpers in favor of Tribe__View_Helpers</li>\n<li>Deprecated &#8211; Tribe__Events__Main::OPTIONNAME in favor of Tribe__Main::OPTIONNAME</li>\n<li>Deprecated &#8211; Tribe__Events__Main::OPTIONNAMENETWORK in favor of Tribe__Main::OPTIONNAMENETWORK</li>\n<li>Deprecated &#8211; Tribe__Events__Main::addHelpAdminMenuItem() in favor of Tribe__Settings_Manager::add_help_admin_menu_item()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::addNetworkOptionsPage() in favor of Tribe__Settings_Manager::add_network_options_page()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::array_insert_after_key() in favor of Tribe__Main::array_insert_after_key()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::array_insert_before_key() in favor of Tribe__Main::array_insert_before_key()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::debug() in favor of Tribe__Debug::debug()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::defaultValueReplaceEnabled() in favor of tribe_get_option( &#8216;defaultValueReplace&#8217; )</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doHelpTab() in favor of Tribe__Settings_Manager::do_help_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doNetworkSettingTab() in favor of Tribe__Settings_Manager::do_network_settings_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::doSettingTabs() in favor of Tribe__Settings_Manager::do_setting_tabs()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::do_licenses_tab() in favor of Tribe__Settings_Manager::do_licenses_tab()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNetworkOption() in favor of Tribe__Settings_Manager::get_network_option()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNetworkOptions() in favor of Tribe__Settings_Manager::get_network_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getNotices() in favor of Tribe__Notices::get()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getOption() in favor of Tribe__Settings_Manager::get_option()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::getOptions() in favor of Tribe__Settings_Manager::get_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::have_addons() in favor of Tribe__Settings_Manager::have_addons()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::isNotice() in favor of Tribe__Notices::is_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginDir in favor of Tribe__Events__Main::plugin_dir</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginName in favor of Tribe__Events__Main::plugin_name</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginPath in favor of Tribe__Events__Main::plugin_path</li>\n<li>Deprecated &#8211; Tribe__Events__Main::pluginUrl in favor of Tribe__Events__Main::plugin_url</li>\n<li>Deprecated &#8211; Tribe__Events__Main::removeNotice() in favor of Tribe__Notices::remove_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::renderDebug() in favor of Tribe__Debug::render()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::saveAllTabsHidden() in favor of Tribe__Settings_Manager::save_all_tabs_hidden()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::setNetworkOptions() in favor of Tribe__Settings_Manager::set_network_options()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::setNotice() in favor of Tribe__Notices::set_notice()</li>\n<li>Deprecated &#8211; Tribe__Events__Main::truncate() in favor of tribe_events_get_the_excerpt()</li>\n<li>Deprecated &#8211; tribe_event_beginning_of_day() in favor of tribe_beginning_of_day()</li>\n<li>Deprecated &#8211; tribe_event_end_of_day() in favor of tribe_end_of_day()</li>\n<li>Deprecated &#8211; tribe_event_format_date() in favor of tribe_format_date()</li>\n<li>Deprecated &#8211; tribe_events_the_notices() in favor of tribe_the_notices()</li>\n</ul>\n<h4>3.x and previous</h4>\n<p>For release notes from the 3.x and older lifecycles, see our <a href=\"https://theeventscalendar.com/category/products/release-notes/\" rel=\"nofollow ugc\">full historical release notes</a>.</p>\n\";s:11:\"screenshots\";s:2015:\"<ol><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2755131\" alt=\"Month View with hover\"></a><p>Month View with hover</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2755131\" alt=\"Mobile Views\"></a><p>Mobile Views</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2755131\" alt=\"Single event\"></a><p>Single event</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2755131\" alt=\"List View\"></a><p>List View</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2755131\" alt=\"Event Editor\"></a><p>Event Editor</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2755131\" alt=\"Events admin listing\"></a><p>Events admin listing</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2755131\" alt=\"General Settings\"></a><p>General Settings</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2755131\" alt=\"Display Settings\"></a><p>Display Settings</p></li><li><a href=\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2755131\"><img src=\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2755131\" alt=\"CSV Importer\"></a><p>CSV Importer</p></li></ol>\";s:7:\"reviews\";s:16470:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Odd Behavior in Photo View</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/blukid/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6dd3cdf95c0e9c9a96cff3a4dae5d810?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6dd3cdf95c0e9c9a96cff3a4dae5d810?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/blukid/\" class=\"reviewer-name\">blukid</a> on <span class=\"review-date\">September 12, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Experienced odd behavior in \'Photo View\' where the full month text was displaying along with the abbreviation in events which ended at midnight. Event Cal Pro support provided a quick fix via editing of the date-time.php file.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Top plugin to have, easy to use and reliable</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rcstudios/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a0a8a6309273de2dddc267dd9303ca8b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a0a8a6309273de2dddc267dd9303ca8b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rcstudios/\" class=\"reviewer-name\">RCStudios</a> on <span class=\"review-date\">September 10, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">This plugin is one of the best solutions for building calendars for your web site. Not just that, but essential features like events RSVP, ticket sales,  and WooCommerce seamless integration helps us build better solutions for our clients helping them make nice revenues online.<br /><br />The technical support is top of the line, they are very knowledgeable, reliable and innovative. <br /><br />Rockon!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Superb events &#039;engine&#039; for your website</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/davidthreefour/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0f1e14f503f0fa5ff65b26e2c1d1cac8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0f1e14f503f0fa5ff65b26e2c1d1cac8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/davidthreefour/\" class=\"reviewer-name\">ArnoldBocklin <small>(davidthreefour)</small></a> on <span class=\"review-date\">September 6, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">The Events Calendar (TEC) – right out of the box – is a great way to add an events \'engine\' to your website. Already super-powerful, the additional components make TEC suite of apps a must if you have multiple events to share via your website. Additionally, support provided either directly from their highly responsive team or the free knowledgebase is second to none. Highly recommended.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Can´t show events in start date order</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/attefall/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3bbb9e7c1953f3cf12c6a3372032a357?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3bbb9e7c1953f3cf12c6a3372032a357?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/attefall/\" class=\"reviewer-name\">attefall</a> on <span class=\"review-date\">September 3, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">...so useless when only showing events by published date - and not the start of of the events. :-( </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great Plugin!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ceef454/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a60f6e4edeefec0aefb21a13b7c4831e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a60f6e4edeefec0aefb21a13b7c4831e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ceef454/\" class=\"reviewer-name\">ceef454</a> on <span class=\"review-date\">September 1, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">This thing does what it says and has the added benefit of a 365 calendar that updates locally to subscribers.   Very happy with it!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Essential Plugin, Excellent Support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ln-cwm/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7fd7b6ecc9e457801104656d31cdf260?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7fd7b6ecc9e457801104656d31cdf260?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ln-cwm/\" class=\"reviewer-name\">LN-CWM</a> on <span class=\"review-date\">August 31, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">We\'ve been using this plugin since 2015. It does the job very well indeed, with new features added from time-to-time based on user input. The support is excellent. There was a period where they had a policy of not giving any styling advice, but that now thankfully seems to have changed.  Highly recommended!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works very well, but really ugly</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/karo0683/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7c213430b1dedfef73e1644a93b4b110?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7c213430b1dedfef73e1644a93b4b110?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/karo0683/\" class=\"reviewer-name\">karo0683</a> on <span class=\"review-date\">August 30, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Works very well, but really ugly. You have to go into the code to customize or add lots of plugins. And it\'s ABSOLUTELY NOT intuitive.<br />On the other hand, support is great. Thanks to Tristan for his help.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">There\'s a real lack of options for easy customization and making the calendar and events fun.<br />Why hasn\'t the development team been working on this all this time?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent, quick support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/nikkiklock/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/91ff62cc8f583b44352e1dae2d8c2f15?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/91ff62cc8f583b44352e1dae2d8c2f15?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/nikkiklock/\" class=\"reviewer-name\">nikkiklock</a> on <span class=\"review-date\">August 29, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">The Events Calendar\'s support team is unlike any other tech support I\'ve ever experienced in 17 years of managing my business\'s website. I recently really appreciated having one main person to shepherd me through a particularly difficult problem to solve over several weeks, rather than getting a new person with every response. Challenges with compatibility on a huge site like ours is inevitable, and though I manage our site, I\'m not a dev, so their patience and clarity of instructions every step of the way were great. Highly recommend this plugin!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Stellar Support</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/denovoweb/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/81ed05ae968ff754eb3df329407e157c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/81ed05ae968ff754eb3df329407e157c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/denovoweb/\" class=\"reviewer-name\">denovoweb</a> on <span class=\"review-date\">August 28, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">We had a complex issue that we were butting our heads up against, the Events Calendar team went not only dug in deep, helped us get a temporary fix in place and they developed a way to deal with our pantheon CDN issue. <br />They kept us in the loop the entire time and created a permanent fix. I\'ve dealt with a lot of plugin support that would have totally passed the buck and Events Calendar Team went ABOVE AND BEYOND.  <br />Thank you! </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good solid plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/devaraj227/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/4c7ca9a7fbbc2ea6cbbdfdba1aeb3553?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/4c7ca9a7fbbc2ea6cbbdfdba1aeb3553?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/devaraj227/\" class=\"reviewer-name\">devaraj227</a> on <span class=\"review-date\">August 28, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Good, useful plugin that gives me more options and decent support with the paid-for version. Recommended.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:13:\"download_link\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.2.zip\";s:11:\"screenshots\";a:9:{i:1;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2755131\";s:7:\"caption\";s:21:\"Month View with hover\";}i:2;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2755131\";s:7:\"caption\";s:12:\"Mobile Views\";}i:3;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2755131\";s:7:\"caption\";s:12:\"Single event\";}i:4;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2755131\";s:7:\"caption\";s:9:\"List View\";}i:5;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2755131\";s:7:\"caption\";s:12:\"Event Editor\";}i:6;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2755131\";s:7:\"caption\";s:20:\"Events admin listing\";}i:7;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2755131\";s:7:\"caption\";s:16:\"General Settings\";}i:8;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2755131\";s:7:\"caption\";s:16:\"Display Settings\";}i:9;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2755131\";s:7:\"caption\";s:12:\"CSV Importer\";}}s:4:\"tags\";a:5:{s:8:\"calendar\";s:8:\"calendar\";s:5:\"event\";s:5:\"Event\";s:6:\"events\";s:6:\"events\";s:9:\"organizer\";s:9:\"organizer\";s:8:\"schedule\";s:8:\"schedule\";}s:8:\"versions\";a:302:{s:3:\"1.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.zip\";s:5:\"1.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.1.zip\";s:5:\"1.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.2.zip\";s:5:\"1.5.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.3.zip\";s:5:\"1.5.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.4.zip\";s:5:\"1.5.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.5.zip\";s:5:\"1.5.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.6.zip\";s:3:\"1.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.zip\";s:5:\"1.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.1.zip\";s:5:\"1.6.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.2.zip\";s:5:\"1.6.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.3.zip\";s:5:\"1.6.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.4.zip\";s:5:\"1.6.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.5.zip\";s:3:\"2.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.zip\";s:5:\"2.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.1.zip\";s:6:\"2.0.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.10.zip\";s:6:\"2.0.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.11.zip\";s:5:\"2.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.2.zip\";s:5:\"2.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.3.zip\";s:5:\"2.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.4.zip\";s:5:\"2.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.5.zip\";s:5:\"2.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.6.zip\";s:5:\"2.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.7.zip\";s:5:\"2.0.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.8.zip\";s:5:\"2.0.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.9.zip\";s:3:\"3.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.zip\";s:5:\"3.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.1.zip\";s:5:\"3.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.2.zip\";s:5:\"3.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.3.zip\";s:3:\"3.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.1.zip\";s:4:\"3.10\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.zip\";s:6:\"3.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.1.zip\";s:4:\"3.11\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.zip\";s:6:\"3.11.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.1.zip\";s:6:\"3.11.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.2.zip\";s:4:\"3.12\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.zip\";s:6:\"3.12.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.1.zip\";s:6:\"3.12.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.2.zip\";s:6:\"3.12.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.3.zip\";s:6:\"3.12.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.4.zip\";s:6:\"3.12.5\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.5.zip\";s:6:\"3.12.6\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.6.zip\";s:3:\"3.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.2.zip\";s:3:\"3.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.zip\";s:5:\"3.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.1.zip\";s:3:\"3.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.zip\";s:5:\"3.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.1.zip\";s:3:\"3.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.zip\";s:5:\"3.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.1.zip\";s:3:\"3.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.zip\";s:5:\"3.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.1.zip\";s:3:\"3.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.7.zip\";s:3:\"3.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.zip\";s:5:\"3.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.1.zip\";s:3:\"3.9\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.zip\";s:5:\"3.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.1.zip\";s:5:\"3.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.2.zip\";s:5:\"3.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.3.zip\";s:3:\"4.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.zip\";s:5:\"4.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.1.zip\";s:5:\"4.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.2.zip\";s:5:\"4.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.3.zip\";s:5:\"4.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.4.zip\";s:5:\"4.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.5.zip\";s:5:\"4.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.6.zip\";s:5:\"4.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.7.zip\";s:3:\"4.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.zip\";s:7:\"4.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.0.1.zip\";s:5:\"4.1.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.zip\";s:7:\"4.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.1.zip\";s:5:\"4.1.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.2.zip\";s:5:\"4.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.3.zip\";s:5:\"4.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.4.zip\";s:3:\"4.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.zip\";s:5:\"4.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.zip\";s:7:\"4.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.1.zip\";s:5:\"4.2.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.2.zip\";s:5:\"4.2.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.3.zip\";s:5:\"4.2.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.4.zip\";s:5:\"4.2.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.5.zip\";s:5:\"4.2.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.6.zip\";s:5:\"4.2.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.7.zip\";s:3:\"4.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.zip\";s:7:\"4.3.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.0.2.zip\";s:5:\"4.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.zip\";s:7:\"4.3.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.2.zip\";s:7:\"4.3.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.2.1.zip\";s:7:\"4.3.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.3.1.zip\";s:7:\"4.3.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.1.zip\";s:7:\"4.3.4.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.3.zip\";s:7:\"4.3.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.5.1.zip\";s:3:\"4.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.zip\";s:7:\"4.4.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.0.2.zip\";s:5:\"4.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.zip\";s:7:\"4.4.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.2.zip\";s:7:\"4.4.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.2.1.zip\";s:7:\"4.4.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.3.1.zip\";s:7:\"4.4.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.4.1.zip\";s:7:\"4.4.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.5.1.zip\";s:3:\"4.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.zip\";s:7:\"4.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.1.zip\";s:7:\"4.5.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.3.zip\";s:7:\"4.5.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.1.1.zip\";s:6:\"4.5.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.zip\";s:8:\"4.5.10.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.2.zip\";s:8:\"4.5.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.11.1.zip\";s:6:\"4.5.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.zip\";s:8:\"4.5.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.1.zip\";s:8:\"4.5.12.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.2.zip\";s:8:\"4.5.12.4\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.4.zip\";s:8:\"4.5.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.13.1.zip\";s:5:\"4.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.zip\";s:7:\"4.5.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.2.zip\";s:7:\"4.5.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.3.1.zip\";s:7:\"4.5.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.4.1.zip\";s:7:\"4.5.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.5.1.zip\";s:7:\"4.5.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.6.1.zip\";s:7:\"4.5.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.7.1.zip\";s:5:\"4.5.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.zip\";s:7:\"4.5.8.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.2.zip\";s:7:\"4.5.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.9.1.zip\";s:7:\"4.6.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.0.1.zip\";s:7:\"4.6.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.1.1.zip\";s:6:\"4.6.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.zip\";s:8:\"4.6.10.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.2.zip\";s:6:\"4.6.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.zip\";s:8:\"4.6.11.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.2.zip\";s:8:\"4.6.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.12.1.zip\";s:8:\"4.6.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.13.1.zip\";s:6:\"4.6.14\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.zip\";s:8:\"4.6.14.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.2.zip\";s:8:\"4.6.15.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.15.1.zip\";s:8:\"4.6.16.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.16.1.zip\";s:8:\"4.6.17.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.17.1.zip\";s:8:\"4.6.18.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.18.1.zip\";s:8:\"4.6.19.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.19.1.zip\";s:7:\"4.6.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.2.1.zip\";s:6:\"4.6.20\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.zip\";s:8:\"4.6.20.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.2.zip\";s:8:\"4.6.21.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.21.1.zip\";s:6:\"4.6.22\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.zip\";s:8:\"4.6.22.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.2.zip\";s:8:\"4.6.23.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.23.1.zip\";s:6:\"4.6.24\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.zip\";s:8:\"4.6.24.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.2.zip\";s:8:\"4.6.25.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.25.1.zip\";s:6:\"4.6.26\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.zip\";s:8:\"4.6.26.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.2.zip\";s:7:\"4.6.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.3.1.zip\";s:7:\"4.6.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.4.1.zip\";s:7:\"4.6.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.5.1.zip\";s:7:\"4.6.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.6.1.zip\";s:7:\"4.6.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.7.1.zip\";s:7:\"4.6.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.8.1.zip\";s:7:\"4.6.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.9.1.zip\";s:3:\"4.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.zip\";s:7:\"4.7.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.0.2.zip\";s:7:\"4.7.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.1.1.zip\";s:7:\"4.7.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.2.1.zip\";s:7:\"4.7.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.3.1.zip\";s:7:\"4.7.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.4.1.zip\";s:3:\"4.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.zip\";s:7:\"4.8.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.0.2.zip\";s:7:\"4.8.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.1.1.zip\";s:7:\"4.8.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.2.1.zip\";s:7:\"4.9.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.1.zip\";s:7:\"4.9.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.2.zip\";s:7:\"4.9.0.4\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.4.zip\";s:5:\"4.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.1.zip\";s:7:\"4.9.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.1.2.zip\";s:8:\"4.9.10.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.10.1.zip\";s:8:\"4.9.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.11.1.zip\";s:8:\"4.9.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.12.1.zip\";s:8:\"4.9.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.13.1.zip\";s:8:\"4.9.14.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.14.1.zip\";s:7:\"4.9.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.2.1.zip\";s:5:\"4.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.zip\";s:7:\"4.9.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.1.zip\";s:7:\"4.9.3.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.3.zip\";s:7:\"4.9.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.4.1.zip\";s:7:\"4.9.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.5.1.zip\";s:7:\"4.9.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.6.1.zip\";s:7:\"4.9.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.7.1.zip\";s:7:\"4.9.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.8.1.zip\";s:7:\"4.9.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.9.1.zip\";s:5:\"5.0.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.zip\";s:7:\"5.0.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.1.zip\";s:7:\"5.0.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.3.zip\";s:7:\"5.0.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.1.1.zip\";s:7:\"5.0.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.1.2.zip\";s:5:\"5.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.zip\";s:7:\"5.0.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.2.zip\";s:7:\"5.0.2.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.3.zip\";s:5:\"5.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.zip\";s:7:\"5.0.3.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.2.zip\";s:7:\"5.0.3.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.3.zip\";s:7:\"5.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.0.1.zip\";s:7:\"5.1.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.0.2.zip\";s:7:\"5.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.1.1.zip\";s:7:\"5.1.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.1.2.zip\";s:7:\"5.1.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.2.1.zip\";s:7:\"5.1.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.2.2.zip\";s:5:\"5.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.3.zip\";s:7:\"5.1.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.3.1.zip\";s:5:\"5.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.4.zip\";s:7:\"5.1.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.4.1.zip\";s:5:\"5.1.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.5.zip\";s:7:\"5.1.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.5.1.zip\";s:5:\"5.1.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.6.zip\";s:7:\"5.1.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.6.1.zip\";s:6:\"5.10.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.0.zip\";s:6:\"5.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.1.zip\";s:6:\"5.11.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.11.0.zip\";s:6:\"5.12.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.0.zip\";s:6:\"5.12.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.1.zip\";s:6:\"5.12.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.2.zip\";s:6:\"5.12.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.3.zip\";s:6:\"5.12.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.4.zip\";s:6:\"5.13.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.13.0.zip\";s:6:\"5.14.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.zip\";s:8:\"5.14.0.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.1.zip\";s:8:\"5.14.0.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.2.zip\";s:8:\"5.14.0.3\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.3.zip\";s:8:\"5.14.0.4\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.4.zip\";s:6:\"5.14.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.1.zip\";s:6:\"5.14.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.2.zip\";s:8:\"5.14.2.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.2.1.zip\";s:6:\"5.15.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.15.0.zip\";s:8:\"5.15.0.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.15.0.1.zip\";s:6:\"5.16.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.0.zip\";s:6:\"5.16.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.1.zip\";s:8:\"5.16.1.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.1.1.zip\";s:6:\"5.16.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.2.zip\";s:8:\"5.16.2.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.2.1.zip\";s:6:\"5.16.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.3.zip\";s:8:\"5.16.3.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.3.1.zip\";s:6:\"5.16.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.4.zip\";s:8:\"5.16.4.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.4.1.zip\";s:5:\"5.2.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.0.zip\";s:7:\"5.2.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.0.1.zip\";s:5:\"5.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.zip\";s:7:\"5.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.1.zip\";s:7:\"5.2.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.2.zip\";s:5:\"5.3.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.0.zip\";s:7:\"5.3.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.0.1.zip\";s:5:\"5.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.zip\";s:7:\"5.3.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.1.zip\";s:7:\"5.3.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.2.zip\";s:5:\"5.3.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.zip\";s:7:\"5.3.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.1.zip\";s:7:\"5.3.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.2.zip\";s:5:\"5.4.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.zip\";s:7:\"5.4.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.1.zip\";s:7:\"5.4.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.2.zip\";s:7:\"5.4.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.3.zip\";s:5:\"5.5.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.zip\";s:7:\"5.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.1.zip\";s:7:\"5.5.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.2.zip\";s:5:\"5.6.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.6.0.zip\";s:5:\"5.7.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.7.0.zip\";s:5:\"5.7.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.7.1.zip\";s:5:\"5.8.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.0.zip\";s:5:\"5.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.1.zip\";s:5:\"5.8.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.2.zip\";s:5:\"5.9.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.0.zip\";s:5:\"5.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.1.zip\";s:5:\"5.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.2.zip\";s:5:\"6.0.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.0.zip\";s:7:\"6.0.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.0.1.zip\";s:5:\"6.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.1.zip\";s:7:\"6.0.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.1.1.zip\";s:6:\"6.0.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.10.zip\";s:6:\"6.0.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.11.zip\";s:6:\"6.0.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.12.zip\";s:6:\"6.0.13\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.13.zip\";s:8:\"6.0.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.13.1.zip\";s:5:\"6.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.2.zip\";s:5:\"6.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.3.zip\";s:7:\"6.0.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.3.1.zip\";s:5:\"6.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.4.zip\";s:5:\"6.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.5.zip\";s:5:\"6.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.6.zip\";s:7:\"6.0.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.6.1.zip\";s:7:\"6.0.6.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.6.2.zip\";s:5:\"6.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.7.zip\";s:7:\"6.0.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.7.1.zip\";s:5:\"6.0.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.8.zip\";s:5:\"6.0.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.9.zip\";s:5:\"6.1.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.0.zip\";s:7:\"6.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.0.1.zip\";s:7:\"6.1.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.0.2.zip\";s:5:\"6.1.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.1.zip\";s:5:\"6.1.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.2.zip\";s:7:\"6.1.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.2.1.zip\";s:7:\"6.1.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.2.2.zip\";s:5:\"6.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.3.zip\";s:5:\"6.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.4.zip\";s:5:\"6.2.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.0.zip\";s:7:\"6.2.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.0.1.zip\";s:5:\"6.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.1.zip\";s:5:\"6.2.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.2.zip\";s:5:\"trunk\";s:62:\"https://downloads.wordpress.org/plugin/the-events-calendar.zip\";}s:11:\"donate_link\";s:18:\"https://evnt.is/29\";s:7:\"banners\";a:2:{s:3:\"low\";s:74:\"https://ps.w.org/the-events-calendar/assets/banner-772x250.png?rev=2257622\";s:4:\"high\";s:75:\"https://ps.w.org/the-events-calendar/assets/banner-1544x500.png?rev=2257622\";}}s:13:\"wordpress-seo\";a:26:{s:4:\"name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:4:\"21.2\";s:6:\"author\";s:43:\"<a href=\"https://yoa.st/1uk\">Team Yoast</a>\";s:14:\"author_profile\";s:37:\"https://profiles.wordpress.org/yoast/\";s:12:\"contributors\";a:3:{s:5:\"yoast\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/yoast/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/67377a634e25eb10de4bb771001d01bf?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Yoast\";}s:11:\"joostdevalk\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/joostdevalk/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7e0897cfeb791c3b254899d7d314b87f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Joost de Valk\";}s:7:\"tdevalk\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/tdevalk/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9a51d2acc1c6e0e3cf4d20e1f025027d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"tdevalk\";}}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:5:\"7.2.5\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:96;s:7:\"ratings\";a:5:{i:5;i:25860;i:4;i:626;i:3;i:192;i:2;i:131;i:1;i:791;}s:11:\"num_ratings\";i:27600;s:15:\"support_threads\";i:334;s:24:\"support_threads_resolved\";i:302;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:21:\"2023-09-19 8:04am GMT\";s:5:\"added\";s:10:\"2010-10-11\";s:8:\"homepage\";s:18:\"https://yoa.st/1uj\";s:8:\"sections\";a:6:{s:12:\"installation\";s:1039:\"<p>Starting with Yoast SEO consists of just two steps: installing and setting up the plugin. Yoast SEO is designed to work with your site’s specific needs, so don’t forget to go through the Yoast SEO first-time configuration as explained in the ‘after activation’ step!</p>\n<h3>INSTALL YOAST SEO FROM WITHIN WORDPRESS</h3>\n<ol>\n<li>Visit the plugins page within your dashboard and select ‘Add New’;</li>\n<li>Search for ‘Yoast SEO’;</li>\n<li>Activate Yoast SEO from your Plugins page;</li>\n<li>Go to ‘after activation’ below.</li>\n</ol>\n<h3>INSTALL YOAST SEO MANUALLY</h3>\n<ol>\n<li>Upload the ‘wordpress-seo’ folder to the /wp-content/plugins/ directory;</li>\n<li>Activate the Yoast SEO plugin through the ‘Plugins’ menu in WordPress;</li>\n<li>Go to ‘after activation’ below.</li>\n</ol>\n<h3>AFTER ACTIVATION</h3>\n<ol>\n<li>You should see (a notice to start) the Yoast SEO first-time configuration;</li>\n<li>Go through this configuration and set up the plugin for your site;</li>\n<li>You’re done!</li>\n</ol>\n\";s:3:\"faq\";s:6119:\"\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20xml{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20sitemaps{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20in{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20yoast{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20seo{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20plugin{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20work{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow do the XML Sitemaps in the Yoast SEO plugin work?\n</h4>\n<p>\n<p>Having an XML sitemap can be beneficial for SEO, as Google can retrieve essential pages of a website very fast, even if the internal linking of a site isn’t flawless.<br />\nThe sitemap index and individual sitemaps are updated automatically as you add or remove content and will include the post types you want search engines to index. Post Types marked as noindex will not appear in the sitemap. <a href=\"https://yoa.st/3qt\" rel=\"nofollow ugc\">Learn more about XML Sitemaps</a>.</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20add{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20website{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20google{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20search{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20console{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow can I add my website to Google Search Console?\n</h4>\n<p>\n<p>It is straightforward to add your website to Google Search Console.<br />\n1. Create a Google Search Console account and login into your account.<br />\n2. Click ‘Add a property’ under the search drop-down.<br />\n3. Enter your website URL in the box and click ‘Continue’.<br />\n4. Click the arrow next to ‘HTML tag’ to expand the option.<br />\n5. Copy the meta tag.<br />\n6. Log in to your WordPress website.<br />\n7. Click on ‘SEO’ in the dashboard.<br />\n8. Click on ‘General’.<br />\n9. Click on the ‘Webmaster Tools’ tab.<br />\n10. Paste the code in the Google field and click ‘Save Changes’.<br />\n11. Go back to Google Search Console and click ‘Verify’.</p>\n<p>If you want more details steps, please visit <a href=\"https://yoa.st/3qu\" rel=\"nofollow ugc\">our article on our help center</a>.</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20implement{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20yoast{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20seo{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20breadcrumbs{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow do I implement Yoast SEO breadcrumbs?\n</h4>\n<p>\n<p>The steps below are a temporary solution as manual edits made to theme files may be overwritten with future theme updates. Please contact the theme developer for a permanent solution. We’ve written an article about the <a href=\"https://yoa.st/3qv\" rel=\"nofollow ugc\">importance of breadcrumbs for SEO</a>.</p>\n<p>To implement the <a href=\"https://yoa.st/3qw\" rel=\"nofollow ugc\">breadcrumbs</a> function in Yoast SEO, you will have to edit your theme. We recommend that prior to any editing of the theme files, a backup is taken. Your host provider can help you take a backup.<br />\nCopy the following code into your theme where you want the breadcrumbs to be. If you are not sure, you will need to experiment with placement:</p>\n<pre><code>&lt;?php\nif ( function_exists( \'yoast_breadcrumb\' ) ) {\n    yoast_breadcrumb( \'&lt;p id=\"breadcrumbs\"&gt;\',\'&lt;/p&gt;\' );\n}\n?&gt;\n</code></pre>\n<p>Common places where you could place your breadcrumbs are inside your <code>single.php</code> and/or <code>page.php</code> file just above the page’s title. Another option that makes it really easy in some themes is by just pasting the code in <code>header.php</code> at the very end.</p>\n<p>In most non-WooTheme themes, this code snippet should not be added to your <code>functions.php</code> file.<br />\nAlternatively, you can manually add the breadcrumb shortcode to individual posts or pages: <code>[wpseo_breadcrumb]</code></p>\n<p>If you need more details or a step by step guide, read our <a href=\"https://yoa.st/3qx\" rel=\"nofollow ugc\">Implementation guide for Yoast SEO breadcrumbs</a>.</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20noindex{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20urls{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow do I noindex URLS?\n</h4>\n<p>\n<p>Yoast SEO provides multiple options for setting a URL or group of URLs to noindex. <a href=\"https://yoa.st/3qy/\" rel=\"nofollow ugc\">Read more about how to do this in this guide</a>.</p>\n</p>\n<dt id=\'google{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20shows{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20wrong{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20description{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}2C{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20fix{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20this{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nGoogle shows the wrong description, how do I fix this?\n</h4>\n<p>\n<p>If you’ve crafted nice meta descriptions for your blog posts, nothing is more annoying than Google showing another description for your site completely in the search result snippet.</p>\n<p>Possible causes could be:<br />\n1. wrong description in code<br />\n2. Google cache is outdated<br />\n3. Search term manipulation<br />\n4. Google ignored the meta description</p>\n<p>You can <a href=\"https://yoa.st/3qz\" rel=\"nofollow ugc\">read more here on how to solve the issue with the wrong description</a>.</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20often{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20is{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20yoast{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20seo{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20updated{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow often is Yoast SEO updated?\n</h4>\n<p>\n<p>Yoast SEO is updated every two weeks. If you want to know why, please read <a href=\"https://yoa.st/3q-\" rel=\"nofollow ugc\">this post on why we release every two weeks</a>!</p>\n</p>\n<dt id=\'how{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20get{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20support{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nHow do I get support?\n</h4>\n<p>\n<p>As our free plugin is used by millions of people worldwide, we cannot offer you all one on one support. If you have trouble with the Yoast SEO for WordPress plugin, you can get help on the support forums here at <a href=\"https://wordpress.org/support/plugin/wordpress-seo/\" rel=\"ugc\">wordpress.org</a> or by checking out our help center at <a href=\"https://yoa.st/3r1\" rel=\"nofollow ugc\">yoast.com/help/</a>.</p>\n<p>The plugins you buy at Yoast are called ‘premium plugins’ (even if Premium isn’t in its name) and include a complete year of free updates and premium support. This means you can contact our support team if you have any questions about that plugin.</p>\n<p><a href=\"https://yoa.st/3r2\" rel=\"nofollow ugc\">Read more on how to get support</a></p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20happens{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20data{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20if{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20enable{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20usage{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20tracking{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat happens to my data if I enable usage tracking?\n</h4>\n<p>\n<p><a href=\"https://yoa.st/4w7\" rel=\"nofollow ugc\">This page on yoast.com explains what data we collect to improve Yoast SEO</a>. We only collect data when you explicitly opt in. Read more about how we handle your data in <a href=\"https://yoa.st/4w8\" rel=\"nofollow ugc\">our Privacy Policy</a>.</p>\n</p>\n<dt id=\'i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20have{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20a{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20different{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20question{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20than{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20listed{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20here\'>\nI have a different question than listed here\n</h4>\n<p>\n<p>Your question has most likely been answered on our help center: <a href=\"https://yoa.st/1va\" rel=\"nofollow ugc\">yoast.com/help/</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:2425:\"<h4>21.2</h4>\n<p>Release date: 2023-09-19</p>\n<p>Yoast SEO 21.2 is out today! In this release, we&#8217;ve improved the naming of several features and enhanced the sidebar in the block editor, making it easier to use. Find out more about what&#8217;s new in Yoast SEO 21.2 in <a href=\"https://yoa.st/release-19-9-23\" rel=\"nofollow ugc\">our release post</a>!</p>\n<h4>Enhancements</h4>\n<ul>\n<li>Renames Google preview to Search appearance in the metabox and sidebar.</li>\n</ul>\n<h4>Bugfixes</h4>\n<ul>\n<li>Fixes a bug where, even if <code>Show author archives without posts in search results</code> is enabled, the archive page would have a <code>noindex</code> in the <code>robots</code> metatag.</li>\n<li>Fixes a bug where notices about incorrect calls to <code>wpdb::prepare</code> would be thrown on Yoast SEO Premium activation.</li>\n<li>Fixes a bug where pagination meta tags would be wrong when using Query Loop Block with custom query variables.</li>\n<li>Fixes a bug where the redirect notification would mention &#8220;posts&#8221; when a tag was deleted or trashed.</li>\n<li>Fixing a bug where adding special characters like &#8220;»&#8221; as a title separator would break the RSS feed.</li>\n</ul>\n<h4>Other</h4>\n<ul>\n<li>Sets the minimum supported WordPress version to 6.2.</li>\n</ul>\n<h4>21.1</h4>\n<p>Release date: 2023-09-05</p>\n<p>Here&#8217;s Yoast SEO 21.1! After the AI release, we&#8217;re back with an update filled with fixes and enhancements to improve your SEO work. Check it out! Find out more about what&#8217;s new in Yoast SEO 21.1 in <a href=\"https://yoa.st/release-5-9-23\" rel=\"nofollow ugc\">our release post</a>!</p>\n<h4>Bugfixes</h4>\n<ul>\n<li>Fixes a bug where an error could occur when an indexable was outdated. Props to @jaimearroyonavia.</li>\n<li>Fixes a bug where the cleanup routine would throw an error when on multisites.</li>\n<li>Fixes a bug where the notification for a new content type in the notification center would not be dismissed when installing Elementor and reviewing the new content types.</li>\n</ul>\n<h4>Other</h4>\n<ul>\n<li>Adds an attribute to the link &#8220;See who contributed to&#8221; to open in a new browser tab, located in the General tab. Props to @nathanwritescode-uk.</li>\n</ul>\n<h4>Earlier versions</h4>\n<p>For the changelog of earlier versions, please refer to <a href=\"https://yoa.st/yoast-seo-changelog\" rel=\"nofollow ugc\">the changelog on yoast.com</a>.</p>\n\";s:11:\"description\";s:21831:\"<p>Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.</p>\n<h3>YOAST SEO: THE #1 WORDPRESS SEO PLUGIN</h3>\n<p>Supercharge your website&#8217;s visibility and attract organic traffic with Yoast SEO, the WordPress SEO plugin trusted by millions worldwide.</p>\n<p>With those millions of users, we&#8217;ve definitely helped someone like you! Users of our plugin range from owners of small-town bakeries and local physical stores to some of the world&#8217;s largest and most influential organizations. And we&#8217;ve done this since 2008!</p>\n<p>Yoast SEO Free provides the essentials to kickstart your SEO, and the <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a> plugin and its extensions unlock extra tools and functionality to take your SEO to the next level.</p>\n<h3>SEO FOR EVERYONE, MADE BY SEO EXPERTS</h3>\n<p>SEO is the most consistent and cost-effective website traffic source, but it can be a challenging and complex maze. Luckily, you don&#8217;t have to do this alone. We&#8217;re here to help!</p>\n<p>Yoast&#8217;s mission is <strong>SEO for everyone</strong>. Whether you&#8217;re a beginner or a seasoned expert, Yoast SEO equips you with all the essentials to navigate the complexities of SEO, turning those challenges into opportunities for growth and success.</p>\n<h3>STAY ON TOP OF SEO WITH NEW FEATURES</h3>\n<p>Creating engaging and optimized SEO titles and meta descriptions has never been easier, faster, and more precise! With our latest feature, the AI title &amp; meta description generator, you&#8217;ll certainly save time. The feature is currently in beta and is available for <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a> users.</p>\n<h3>WHY YOAST SEO?</h3>\n<p>Are you agonizing over the intricate details of search engine optimization? Are you losing sleep trying to crack the code of SEO algorithms? Is the ever-evolving landscape of SEO leaving you overwhelmed and behind the curve?</p>\n<p>These are the common struggles website owners face when trying to master the art of SEO and gain that coveted top spot in search results.</p>\n<p>With Yoast SEO, you can overcome these challenges and unlock extraordinary gains:</p>\n<ul>\n<li>\n<p>Beat the competition: Leave your rivals in the dust with our powerful SEO tools. Outperform industry competitors and enjoy the traffic and recognition you deserve.</p>\n</li>\n<li>\n<p>Streamline your SEO strategy: Bid farewell to the complexities of SEO. Yoast SEO handles the technical aspects, such as canonical URLs and meta tags, automating essential optimizations behind the scenes. Unleash your focus on creating captivating content that connects with your audience.</p>\n</li>\n<li>\n<p>Climb those rankings: Take advantage of advanced features like XML sitemaps, title and meta description templating, and Schema.org structured data integration. Empower search engines to fully understand and appreciate your website, helping you reach the top of search results.</p>\n</li>\n<li>\n<p>Optimize content mastery: Yoast SEO offers comprehensive analysis tools that help elevate your content&#8217;s SEO and readability. Get powerful insights and actionable recommendations to craft extraordinary content that resonates with readers and search engines.  But there&#8217;s more! Yoast SEO Premium has unique generative AI features to help write awesome titles and meta descriptions.</p>\n</li>\n<li>\n<p>Elevate user experience: Yoast SEO paves the way for an exceptional website experience. Engage your audience with intuitive site breadcrumbs, fast loading times, and great content!</p>\n</li>\n</ul>\n<h3>LET&#8217;S GO OVER KEY FEATURES IN YOAST SEO</h3>\n<p>Yoast SEO helps you do WordPress SEO in many ways. Let&#8217;s take a look!</p>\n<h4>QUICK AND EASY SETUP TO GET YOU STARTED</h4>\n<p>Setting up your Yoast SEO plugin is smooth, hassle-free, and doesn&#8217;t require any advanced knowledge! Our step-by-step first-time configuration walks you through the essentials, helping you get your SEO up and running quickly.</p>\n<p>You&#8217;ll be prompted to fill in key details about your site during the setup. This enables Yoast SEO to translate all this information into structured data, which helps search engines better understand your content and website!</p>\n<p>Are you already using another SEO plugin? No worries! Transitioning from other plugins to Yoast SEO is a breeze. We&#8217;ve designed it to be seamless, ensuring you don&#8217;t lose critical data.</p>\n<p>Connecting your site to vital webmaster tools like Google&#8217;s Search Console usually requires technical know-how. But with Yoast SEO, that&#8217;s a thing of the past. Our integration simplifies the process, making it something you can do in less than 5 minutes. Of course, we&#8217;ll guide you along the way!</p>\n<h4>TAKING CARE OF YOUR TECHNICAL SEO NEEDS</h4>\n<p>Although technical optimization is a big part of SEO, it&#8217;s not easy.\\<br />\nYoast understands that only some people who work on SEO are experts or have the time to dive into the technical aspects of a website. That&#8217;s why Yoast SEO handles much of the technical optimization, freeing up your time to work on other parts of your website, like writing awesome content that attracts visitors.</p>\n<ul>\n<li>\n<p>Get automated technical SEO improvements, like optimized meta tags, right out of the box.</p>\n</li>\n<li>\n<p>Add canonical URLs to tell search engines which content they should show when you have pages with similar content.</p>\n</li>\n<li>\n<p>Get advanced XML sitemaps, making it effortless for search engines to understand your site structure and index your web pages effectively.</p>\n</li>\n<li>\n<p>Elevate your brand presence with customizable titles and meta description templating, ensuring consistent and compelling search result snippets that drive click-through rates.</p>\n</li>\n<li>\n<p>Get best-in-class Schema.org structured data integration, significantly increasing your chances of getting visually rich search results that attract more users.</p>\n</li>\n<li>\n<p>Take complete control over your site&#8217;s breadcrumbs, allowing visitors and search engines to navigate your website seamlessly.</p>\n</li>\n<li>\n<p>Significantly improves your website&#8217;s loading times, courtesy of Yoast SEO&#8217;s innovative data management techniques tailored for WordPress.</p>\n</li>\n<li>\n<p>[Advanced] Yoast SEO comes with a wide range of crawl settings that optimize how search engines crawl your site and reduce its carbon footprint. This lowers your site&#8217;s environmental impact and contributes to a sustainable web.</p>\n</li>\n</ul>\n<h4>WRITE AWESOME CONTENT THAT USERS AND SEARCH ENGINES LOVE</h4>\n<p>Unlock the full potential of your content with Yoast SEO&#8217;s state-of-the-art content analysis. Crafting compelling content becomes easier with Yoast SEO&#8217;s suite of features designed to help you increase your website&#8217;s content performance.</p>\n<ul>\n<li>\n<p>Leverage detailed SEO analysis that guides you toward creating SEO-friendly content, allowing you to target the right keywords and boost your visibility in search results.</p>\n</li>\n<li>\n<p>Drive engagement and enhance readability with the integrated readability analysis. Ensure your content is clear, concise, and effortlessly readable by humans and search engines alike.</p>\n</li>\n<li>\n<p>To effectively cater to a global audience, benefit from Yoast SEO&#8217;s full language support for English, German, French, Dutch, Spanish, Italian, Russian, Indonesian, Polish, Portuguese, Arabic, Swedish, Hebrew, Hungarian, Turkish, Czech, Norwegian, Slovak, and Greek.</p>\n</li>\n<li>\n<p>Preview your content as it will appear in search results directly within Yoast SEO, even on mobile devices. This helps you to fine-tune your meta titles and descriptions to maximize click-through rates.</p>\n</li>\n<li>\n<p>Enable your HowTo content to be displayed in search results by using the innovative Schema structured data blocks for the WordPress block editor</p>\n</li>\n<li>\n<p>A dedicated breadcrumbs block ensures your users always know their location within your website.</p>\n</li>\n<li>\n<p>Embrace inclusivity in your content creation process with the inclusive language analysis. This optional feature analyzes your text and provides suggestions to make your content more inclusive and considerate of different audiences. By using inclusive language, you can create a welcoming environment and ensure your content resonates with diverse groups of people.</p>\n</li>\n<li>\n<p>Seamlessly do keyword research right within the plugin with the Semrush integration. Find out what related keywords people are searching for, so you can optimize your content to reach more audiences.</p>\n</li>\n<li>\n<p>Track your rankings in Yoast SEO with the Wincher integration. Yoast SEO and Wincher show how your content and keywords rank in Google. So that you immediately know if your optimizations are paying off or if you need to take more action!</p>\n</li>\n<li>\n<p>Are you using Elementor to build your website? No worries because Yoast SEO integrates with Elementor. Take advantage of all Yoast SEO&#8217;s benefits within your favorite website builder!</p>\n</li>\n<li>\n<p>Yoast SEO Premium even has advanced AI features, helping you write titles and meta descriptions at the touch of a button thanks to generative AI. We don&#8217;t use a credit system for this, so this artificial intelligence tool is free to use once you have Yoast SEO Premium.</p>\n</li>\n</ul>\n<h4>KEEP YOUR SITE IN SHAPE FOR SEO</h4>\n<p>Yoast SEO empowers you to keep your website in perfect shape, regardless of your role or expertise:</p>\n<ul>\n<li>\n<p>Fine-tune your website&#8217;s engine, allowing you to focus on creating engaging and valuable content. With Yoast SEO, technical optimization becomes effortless, allowing you to prioritize what truly matters.</p>\n</li>\n<li>\n<p>Structure your website easily using Yoast SEO&#8217;s cornerstone content features, enabling search engines to understand and index your most important pages effectively.</p>\n</li>\n<li>\n<p>Translate valuable content into structured data where applicable, allowing search engines to fully comprehend your website&#8217;s meaning and context.</p>\n</li>\n<li>\n<p>Streamline collaboration and empower your team with SEO roles, granting specific access to colleagues and stakeholders. Efficiently manage your SEO strategy and ensure everyone is aligned toward achieving optimal results.</p>\n</li>\n<li>\n<p>Yoast SEO includes a powerful front-end SEO inspector that allows you to preview and fine-tune the SEO settings directly on your website&#8217;s front end. With this intuitive tool, you can easily optimize elements such as meta titles, meta descriptions, URL slugs, robots meta tags, and structured data by seeing their appearance in real-time.</p>\n</li>\n<li>\n<p>Yoast SEO has a regular 2-week update cycle, ensuring you always stay up-to-date with the latest development and updates from search engines.</p>\n</li>\n</ul>\n<h4>POWERFUL INTEGRATION WITH OTHER TOOLS</h4>\n<p>Yoast SEO seamlessly integrates with various themes, plugins, and tools to enhance the user experience and improve your WordPress SEO workflow.</p>\n<ul>\n<li>\n<p>Leverage Yoast SEO&#8217;s optimized compatibility with the <a href=\"https://wordpress.org/support/article/wordpress-editor/\" rel=\"ugc\">WordPress block editor</a> (or &#8216;Gutenberg&#8217; editor) for a seamless content creation experience.</p>\n</li>\n<li>\n<p>Take your storytelling to the next level with <a href=\"https://wordpress.org/plugins/web-stories/{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}5C\" rel=\"ugc\">Google&#8217;s Web Stories</a> plugin, allowing you to create captivating and interactive <a href=\"https://amp.dev/about/stories/\" rel=\"nofollow ugc\">web stories</a>.</p>\n</li>\n<li>\n<p>Utilize the full potential of the <a href=\"https://wordpress.org/plugins/advanced-custom-fields/\" rel=\"ugc\">Advanced Custom Fields</a> plugin when combined with the <a href=\"https://wordpress.org/plugins/acf-content-analysis-for-yoast-seo/\" rel=\"ugc\">ACF Content Analysis for Yoast SEO</a> plugin, enriching your content with structured data while reaping the benefits of Yoast SEO&#8217;s powerful analysis.</p>\n</li>\n<li>\n<p>Seamlessly integrate Yoast SEO with the <a href=\"https://wordpress.org/plugins/elementor/\" rel=\"ugc\">Elementor</a> website builder, empowering you to optimize your stunning designs effectively.</p>\n</li>\n<li>\n<p>Elevate your site search quality with <a href=\"https://wordpress.org/plugins/wp-search-with-algolia/\" rel=\"ugc\">Algolia</a> integration, ensuring users can effortlessly find the content they want.</p>\n</li>\n<li>\n<p>Utilize the <a href=\"https://wordproof.com/\" rel=\"nofollow ugc\">WordProof</a> plugin, which adds timestamps to your content, proving ownership and establishing credibility.</p>\n</li>\n<li>\n<p>Combine Yoast SEO with Semrush, a leading SEO tool. Access comprehensive keyword data directly within Yoast SEO, empowering you to supercharge your SEO strategy with data-driven insights.</p>\n</li>\n<li>\n<p>Connect your Yoast SEO plugin with Wincher, a powerful SEO tracking tool. Monitor your keyword rankings, and track your website&#8217;s visibility in search results. Stay on top of your SEO performance and make data-driven decisions to improve your website&#8217;s ranking.</p>\n</li>\n</ul>\n<p>Choose Yoast SEO for unparalleled compatibility with your preferred tools and seamless integration into your existing WordPress setup.</p>\n<h4>TRUST THE EXPERTS</h4>\n<p>Yoast is powered by expert developers, testers, software architects, and SEO consultants. They work constantly to stay at the cutting edge of WordPress SEO and to improve the plugin with every release.</p>\n<h4>WE&#8217;LL ONBOARD YOU AND HELP YOU DO SEO</h4>\n<p>You may wonder, &#8220;What do I do after installing the plugin?&#8221; It&#8217;s a common question, and we understand that the world of SEO can seem daunting at first glance.</p>\n<p>That&#8217;s why we don&#8217;t leave you to figure things out alone at Yoast. We&#8217;re here to help you succeed with your SEO goals because empowering our users is at the core of our philosophy!</p>\n<p>Onboarding experience: After you install the plugin and run the first-time setup wizard, we offer an intuitive onboarding experience that guides you through the essential settings and features. This ensures you&#8217;re making the most out of your new plugin, step by step.</p>\n<p>Webinars: Want to learn how to get started with SEO and interact with experts from Yoast? Our regular webinars provide live and interactive learning experiences. They cover various topics and are designed to help you get started with SEO, no matter your skill level.</p>\n<p>Courses in Yoast SEO academy: If you&#8217;re looking for a structured learning path, our Yoast SEO academy offers a variety of online courses, both free and paid. You can follow the courses at your own pace and learn when you want. These lessons cover everything from the basics of WordPress to advanced SEO techniques, catering to beginners and experienced users.</p>\n<p>Blogs section: Our regularly updated blog is a treasure trove of information, filled with practical tips, insights, and guides on how to improve your SEO. Whether you&#8217;re looking for a quick fix or an in-depth analysis, our blog covers you.</p>\n<p>Newsletter: Stay in the loop with our newsletter. It&#8217;s more than just news; it&#8217;s a timely update on important changes and trends in the SEO world. We sift through the noise to bring you what matters, so you can take informed action when it counts. We&#8217;ll also provide you with tips and guides on how to improve your SEO.</p>\n<p>When you choose Yoast SEO, you&#8217;re never alone in your journey. We&#8217;re with you every step of the way, providing the resources and support you need to take your online presence to new heights.</p>\n<h4>EXPAND YOUR SEO KNOWLEDGE WITH ONLINE COURSES</h4>\n<p>With <a href=\"https://yoa.st/3ri\" rel=\"nofollow ugc\">Yoast SEO academy</a>, learning SEO becomes accessible and engaging. Whether you&#8217;re starting fresh or looking to sharpen your skills, our free courses provide a solid foundation in WordPress and SEO.</p>\n<p>Investing in <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a> gives you FULL access to all courses, from SEO copywriting, ecommerce SEO, and technical SEO to Local SEO. These courses equip you with more advanced knowledge, skills, and tips to help your website grow and succeed. Get two great products for a single price and become a master of SEO with Yoast SEO Premium and the Yoast SEO academy!</p>\n<h3>SERIOUS ABOUT GETTING HIGHER RANKINGS AND MORE TRAFFIC?</h3>\n<p>Not only do you get many additional benefits by upgrading to <a href=\"https://yoa.st/1v8\" rel=\"nofollow ugc\">Yoast SEO Premium</a>, but you&#8217;ll also get 24/7 personalized support that takes away your worry.</p>\n<ul>\n<li>\n<p>Optimize your content and diversify your keywords using synonyms and related keyphrases in Yoast SEO Premium. Expand your reach and deliver more natural, engaging content to your audience. You can optimize up to 5 keyphrases with the Premium version.</p>\n</li>\n<li>\n<p>Optimizes your articles for different word forms, singular and plural variations, different verb forms, synonyms, and related keyphrases, thanks to the semantic understanding technology in Yoast SEO Premium.</p>\n</li>\n<li>\n<p>Seamlessly handle URL changes or page deletions with Yoast SEO Premium&#8217;s redirect manager. Automatically create redirects to prevent &#8220;404: page not found&#8221; errors and retain valuable traffic and backlinks.</p>\n</li>\n<li>\n<p>Get internal linking suggestions in real-time. Yoast SEO Premium enhances your article&#8217;s depth and authority by recommending related posts to link to.</p>\n</li>\n<li>\n<p>Gain precise control over your page&#8217;s appearance on social networks like Facebook and Twitter with Social Previews in Yoast SEO Premium. Customize your social presence and entice users to engage with your content effectively.</p>\n</li>\n<li>\n<p>Simplify your SEO workflows and get guidance to work on time-consuming SEO tasks, like finding unlinked content, with the Yoast SEO workouts.</p>\n</li>\n<li>\n<p>Get actionable feedback on using intricate vocabulary to enhance your writing and make it accessible to a broader audience. (Note: This feature is currently available in English and beta.)</p>\n</li>\n<li>\n<p>Take advantage of the IndexNow integration, which instantly pings search engines like Microsoft Bing every time you publish or update content to ensure timely indexing.</p>\n</li>\n<li>\n<p>Easily create optimized SEO titles and meta descriptions at the touch of a button, thanks to generative AI. Crafting optimized and engaging SEO titles and meta descriptions has never been faster and easier. We don&#8217;t use a credit system for this, so this artificial intelligence tool is free to use once you have Yoast SEO Premium.</p>\n</li>\n<li>\n<p>Get 24/7 personalized e-mail support, so no matter when a question or issue arises, you&#8217;re never left in the dark. Whether it&#8217;s a technical hurdle or simply a need for guidance, our dedicated support team is always available to assist.</p>\n</li>\n</ul>\n<h3>EXTEND YOUR WORDPRESS SEO</h3>\n<p>Take your WordPress SEO to new heights with these powerful Yoast SEO add-ons:</p>\n<ul>\n<li>\n<p><a href=\"https://yoa.st/1uu\" rel=\"nofollow ugc\">Yoast Local SEO</a>: Optimize your website for a local audience, drive foot traffic to your local stores, and establish a strong presence in the local search results.</p>\n</li>\n<li>\n<p><a href=\"https://yoa.st/1uw\" rel=\"nofollow ugc\">Yoast Video SEO</a>: Improves the loading speed of your video and ensures that Google fully understands the content of your videos. This helps you rank your videos higher in video search results.</p>\n</li>\n<li>\n<p><a href=\"https://yoa.st/1uv\" rel=\"nofollow ugc\">Yoast News SEO</a>: Amplify your visibility and performance in Google News, allowing your news website to reach a broader audience.</p>\n</li>\n<li>\n<p><a href=\"https://yoa.st/3rh\" rel=\"nofollow ugc\">Yoast WooCommerce SEO</a>: Enhance your online shop&#8217;s discoverability with extra tools and functionality designed specifically for online shops, helping you drive more targeted traffic and dominate the search results for your products.</p>\n</li>\n</ul>\n<h3>BUG REPORTS</h3>\n<p>Did you come across a bug while using Yoast SEO? We welcome your bug reports! To provide comprehensive details and track the progress of resolutions, please report bugs in the WordPress SEO <a href=\"https://github.com/Yoast/wordpress-seo\" rel=\"nofollow ugc\">repository on GitHub</a>. Please note that GitHub is not a support forum, but an efficient platform for addressing and resolving issues efficiently.</p>\n<h3>THERE&#8217;S MORE TO LEARN ABOUT SEO</h3>\n<p>For a comprehensive resource on search engine optimization and Yoast SEO, explore our <a href=\"https://yoast.com/{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}5C\" rel=\"nofollow ugc\">official website</a>, which is rich with insights and inspiration. Seek resolutions and guidance in our extensively curated help center, designed to empower you with the knowledge required to optimize your website effectively.</p>\n<p>Take your SEO skills to new heights with &#8220;<a href=\"https://yoa.st/1v6\" rel=\"nofollow ugc\">WordPress SEO &#8211; The Definitive Guide</a>&#8221; by Yoast &#8211; a must-read for WordPress enthusiasts. Discover more exceptional plugins and solutions by Team Yoast, tailored to enhance your digital presence and achieve unparalleled success.</p>\n<p>Stay updated with the latest developments and analyses by following Yoast on Facebook, Instagram, and Twitter. Begin your journey to extraordinary SEO results with Yoast SEO today!</p>\n\";s:11:\"screenshots\";s:2478:\"<ol><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2853382\" alt=\"The modern interface makes Yoast SEO easy to work with.\"></a><p>The modern interface makes Yoast SEO easy to work with.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2853382\" alt=\"Easily manage how your posts and pages appear in SERPs.\"></a><p>Easily manage how your posts and pages appear in SERPs.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2853382\" alt=\"Yoast SEO Premium has extra crawl optimization options.\"></a><p>Yoast SEO Premium has extra crawl optimization options.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2853382\" alt=\"Yoast SEO integrates with tools like Semrush and Wincher.\"></a><p>Yoast SEO integrates with tools like Semrush and Wincher.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2853382\" alt=\"The famous SEO and readability analyses in Yoast SEO.\"></a><p>The famous SEO and readability analyses in Yoast SEO.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2853382\" alt=\"See what your post looks like in Google.\"></a><p>See what your post looks like in Google.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-7.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-7.png?rev=2853382\" alt=\"The First-time configuration helps you get started quickly.\"></a><p>The First-time configuration helps you get started quickly.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-8.png?rev=2853382\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-8.png?rev=2853382\" alt=\"The inclusive language analysis in Yoast SEO.\"></a><p>The inclusive language analysis in Yoast SEO.</p></li><li><a href=\"https://ps.w.org/wordpress-seo/assets/screenshot-9.png?rev=2956588\"><img src=\"https://ps.w.org/wordpress-seo/assets/screenshot-9.png?rev=2956588\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:15925:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/thomasceniceros/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/47d362b1c74a62075cdfede5c42261be?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/47d362b1c74a62075cdfede5c42261be?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/thomasceniceros/\" class=\"reviewer-name\">thomasceniceros</a> on <span class=\"review-date\">September 19, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Amazing plugin</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Yoast went WOKE</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/jlong1961/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8c3383c8fe10ecf7c750467f533bbce5?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8c3383c8fe10ecf7c750467f533bbce5?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/jlong1961/\" class=\"reviewer-name\">jlong1961</a> on <span class=\"review-date\">September 14, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">So Yoast wants us to run the \"Inclusive Language Analyzer\" on our sites to remove offensive terms such as man, male, woman, and female.  Oh, the horror of the word \"man\".    What kind of garbage is this?   I will be removing this plugin from my sites.  Did they hire they the CEO of Anheuser-Busch to manage the company???  Have these groomers not learned from that?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">I think it&#039;s the right decision to return to Yoast</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/dhaif/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ff1c5b06e39d4c6063abca938ad1bfdd?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ff1c5b06e39d4c6063abca938ad1bfdd?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/dhaif/\" class=\"reviewer-name\">dhaif</a> on <span class=\"review-date\">September 11, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I\'ve been utilizing the Yoast SEO plugin for several months and I\'m extremely pleased with the outcomes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">It\'s user-friendly, packed with features, and effectively optimizes my website. Although I briefly tried a different SEO plugin, I observed a decline in both my traffic and ranking. Consequently, I made the decision to return to Yoast SEO, and I\'m delighted that I did.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Decent Free SEO Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/solidindividual42/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/dacf92ee164d1d087c85498dd3b4d232?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/dacf92ee164d1d087c85498dd3b4d232?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/solidindividual42/\" class=\"reviewer-name\">solidindividual42</a> on <span class=\"review-date\">August 31, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I like the Yoast plugin, and prefer it to the other popular free plugins. But I\'m knocking 2 stars off for the awful passive voice detection. It is by no means the end of the world that the plugin struggles with A LOT of false positives for passive voice. It\'s just disappointing and annoying.<br />I\'m begging you Yoast, go talk to the people at Grammarly or something. Just because the word \"are\" is in a sentence doesn\'t automatically make it passive.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Unable to disable schema output</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/web39/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/85c988776f49d5ac8d1eb91f707ca095?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/85c988776f49d5ac8d1eb91f707ca095?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/web39/\" class=\"reviewer-name\">Roman Moiseenko <small>(web39)</small></a> on <span class=\"review-date\">August 30, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">It is not possible to disable schema output.<br />None of the suggested methods works and they can\'t make a button to disable it.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Ought to be sued</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/urbaknight/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/16f5e136e249b30df8449e8ecb8305f5?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/16f5e136e249b30df8449e8ecb8305f5?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/urbaknight/\" class=\"reviewer-name\">urbaknight</a> on <span class=\"review-date\">August 26, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Back in 2022, there was an Google update and I thought my site was filtered and my traffic dropped drastically, along with drop in sales by more than 50{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}. The following months, I tried everything to recover from it, only to now find out that it was Yoast plugin that ACTUALLY APPLIED NOINDEX tag to my pages where more than 1000 products were hidden from the google search engine. This made me lose more than $4K sales each month since then. <br /><br />HOW CAN YOU CHANGE USER\'S SEO SETTINGS JUST BY INSTALLING YOUR PLUGIN?!<br /><br />Is this a method to force people to subscribe to your premium package?<br /><br />I am sure a lot of people encountered the same issue. Whoever made the decision to implement this, it is going to bite you back for sure for your negligence.  </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Best SEO Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/anonymized-21067829/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/743d270345d7948282c03f925a46a6bf?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/743d270345d7948282c03f925a46a6bf?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/anonymized-21067829/\" class=\"reviewer-name\">Anonymous User 21067829 <small>(anonymized_21067829)</small></a> on <span class=\"review-date\">August 21, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Best plugin and easy to configure.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">After removing the plugin, garbage remains in meta.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/damir_sh/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/3de00b67fe962e54fa773010fa33e871?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/3de00b67fe962e54fa773010fa33e871?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/damir_sh/\" class=\"reviewer-name\">damir_sh</a> on <span class=\"review-date\">August 18, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">After removing the plugin, garbage remains in meta.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Super helpful!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/mimi0508/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/4bd4efdd5a33183e0b1c899cd30487d2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/4bd4efdd5a33183e0b1c899cd30487d2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/mimi0508/\" class=\"reviewer-name\">mimi0508</a> on <span class=\"review-date\">August 15, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Super helpful for all the SEO-related work!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">WP-Login disable</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/elmo2000/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/05b3a55afbea9f15f3e82d074fafb1cf?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/05b3a55afbea9f15f3e82d074fafb1cf?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/elmo2000/\" class=\"reviewer-name\">elmo2000</a> on <span class=\"review-date\">August 14, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">After a long search i came to the conclusion that Yoast Seo Premium disabled my /wp-admin page (Page not found after log in) .. When disable thsi plug in , everything works fine...  @devolpteam  any update available?</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.2.zip\";s:11:\"screenshots\";a:9:{i:1;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2853382\";s:7:\"caption\";s:55:\"The modern interface makes Yoast SEO easy to work with.\";}i:2;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2853382\";s:7:\"caption\";s:55:\"Easily manage how your posts and pages appear in SERPs.\";}i:3;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2853382\";s:7:\"caption\";s:55:\"Yoast SEO Premium has extra crawl optimization options.\";}i:4;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2853382\";s:7:\"caption\";s:57:\"Yoast SEO integrates with tools like Semrush and Wincher.\";}i:5;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2853382\";s:7:\"caption\";s:53:\"The famous SEO and readability analyses in Yoast SEO.\";}i:6;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2853382\";s:7:\"caption\";s:40:\"See what your post looks like in Google.\";}i:7;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-7.png?rev=2853382\";s:7:\"caption\";s:59:\"The First-time configuration helps you get started quickly.\";}i:8;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-8.png?rev=2853382\";s:7:\"caption\";s:45:\"The inclusive language analysis in Yoast SEO.\";}i:9;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-9.png?rev=2956588\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:16:\"content-analysis\";s:16:\"Content analysis\";s:11:\"readability\";s:11:\"Readability\";s:6:\"schema\";s:6:\"schema\";s:3:\"seo\";s:3:\"seo\";s:11:\"xml-sitemap\";s:11:\"xml sitemap\";}s:8:\"versions\";a:50:{s:4:\"18.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.0.zip\";s:4:\"18.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.1.zip\";s:4:\"18.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.2.zip\";s:4:\"18.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.3.zip\";s:4:\"18.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.4.zip\";s:6:\"18.4.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.4.1.zip\";s:4:\"18.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.5.zip\";s:6:\"18.5.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.5.1.zip\";s:4:\"18.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.6.zip\";s:4:\"18.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.7.zip\";s:4:\"18.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.8.zip\";s:4:\"18.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.9.zip\";s:4:\"19.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.0.zip\";s:4:\"19.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.1.zip\";s:5:\"19.10\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.10.zip\";s:5:\"19.11\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.11.zip\";s:5:\"19.12\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.12.zip\";s:5:\"19.13\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.13.zip\";s:5:\"19.14\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.14.zip\";s:4:\"19.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.2.zip\";s:4:\"19.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.3.zip\";s:4:\"19.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.4.zip\";s:4:\"19.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.5.zip\";s:6:\"19.5.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.5.1.zip\";s:4:\"19.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.6.zip\";s:6:\"19.6.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.6.1.zip\";s:4:\"19.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.7.zip\";s:6:\"19.7.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.7.1.zip\";s:6:\"19.7.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.7.2.zip\";s:4:\"19.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.8.zip\";s:4:\"19.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.9.zip\";s:4:\"20.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.0.zip\";s:4:\"20.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.1.zip\";s:5:\"20.10\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.10.zip\";s:5:\"20.11\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.11.zip\";s:5:\"20.12\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.12.zip\";s:5:\"20.13\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.13.zip\";s:4:\"20.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.2.zip\";s:6:\"20.2.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.2.1.zip\";s:4:\"20.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.3.zip\";s:4:\"20.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.4.zip\";s:4:\"20.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.5.zip\";s:4:\"20.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.6.zip\";s:4:\"20.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.7.zip\";s:4:\"20.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.8.zip\";s:4:\"20.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.9.zip\";s:4:\"21.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.0.zip\";s:4:\"21.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.1.zip\";s:4:\"21.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.2.zip\";s:5:\"trunk\";s:56:\"https://downloads.wordpress.org/plugin/wordpress-seo.zip\";}s:11:\"donate_link\";s:18:\"https://yoa.st/1up\";s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";s:4:\"high\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";}}s:6:\"leadin\";a:26:{s:4:\"name\";s:70:\"HubSpot &#8211; CRM, Email Marketing, Live Chat, Forms &amp; Analytics\";s:4:\"slug\";s:6:\"leadin\";s:7:\"version\";s:6:\"10.2.5\";s:6:\"author\";s:59:\"<a href=\"http://hubspot.com/products/wordpress\">HubSpot</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/hubspotdev/\";s:12:\"contributors\";a:2:{s:10:\"hubspotdev\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/hubspotdev/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/b0fc5d064b5de562cd2c4da8f2949488?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"HubSpot\";}s:6:\"leadin\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/leadin/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/e01bb710319d405b425ca83629d9df92?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Leadin\";}}s:8:\"requires\";s:3:\"5.4\";s:6:\"tested\";s:5:\"6.2.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:88;s:7:\"ratings\";a:5:{i:5;i:155;i:4;i:13;i:3;i:5;i:2;i:8;i:1;i:18;}s:11:\"num_ratings\";i:199;s:15:\"support_threads\";i:10;s:24:\"support_threads_resolved\";i:8;s:15:\"active_installs\";i:300000;s:12:\"last_updated\";s:21:\"2023-09-12 9:37am GMT\";s:5:\"added\";s:10:\"2014-03-12\";s:8:\"homepage\";s:45:\"http://www.hubspot.com/integrations/wordpress\";s:8:\"sections\";a:6:{s:11:\"description\";s:13487:\"<p><em>HubSpot is a CRM platform with all the tools and integrations you need for marketing, sales, and customer service. Each product in the platform is powerful alone, but the real magic happens when you use them together. See for yourself in the free HubSpot WordPress plugin.</em></p>\n<p>Build a relationship with your audience and grow your business with <a href=\"https://www.hubspot.com/products/wordpress?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">HubSpot</a>. HubSpot&#8217;s all-in-one WordPress plugin allows you to manage contacts (CRM), create the best email marketing campaigns, engage visitors with live chat and chatbots, add beautiful forms to pages, and more.</p>\n<p>Use HubSpot to:</p>\n<ul>\n<li>💬 Connect with visitors on your site in real-time using live chat and chatbots.</li>\n<li>📋 Capture leads with ease — build custom forms or link existing forms from your website in minutes.</li>\n<li>📧 Nurture your leads by sending newsletters &amp; automating email marketing campaigns.</li>\n<li>📈 Track the health of your business with easy-to-understand analytics dashboards.</li>\n<li>🚀 See a unified timeline of a contact’s page views, past conversations, and more in the smart  WordPress CRM plugin.</li>\n</ul>\n<p>Ready to get started? Click download in the top right corner of the page.</p>\n<h3>CRM &amp; Contact Management Platform</h3>\n<p>Your CRM in the HubSpot WordPress plugin is your company&#8217;s command center. It&#8217;s the place where you can track every single customer interaction and get a 360-degree view of your customers. You can even use it to manage or automate marketing, sales, and service processes.]</p>\n<p>With HubSpot CRM, you don&#8217;t need to jump from tool to tool to keep track of everything. Instead, you can store all of your data in one place.</p>\n<p>HubSpot’s free WordPress CRM gives you ultimate visibility into customer interactions across every team in your organization. That means that everyone will be on the same page—from marketing to sales to customer service—and able to help your customers more effectively.</p>\n<p>Best of all, if you’re planning on growing your business (or you already are), HubSpot has the tools to grow with you.</p>\n<p>Features of our top WordPress CRM that you&#8217;ll love, suited specifically for your business needs:</p>\n<p>✅ Lead generation &amp; lead management on your WordPress website<br />\n✅ Pipeline management<br />\n✅ WordPress email marketing<br />\n✅ WordPress reporting dashboard<br />\n✅ Contact management<br />\n✅ Prospect tracking</p>\n<p>Streamline your entire business with the free CRM solution that has something for everyone. Try the HubSpot CRM plugin today.</p>\n<h3><a href=\"https://www.hubspot.com/products/wordpress/email-marketing\" rel=\"nofollow ugc\">Email Newsletter &amp; Marketing Automation Software</a></h3>\n<p>Would you like to enhance your WordPress email marketing campaigns or build the best email newsletter templates? 🤔</p>\n<p>Maybe you&#8217;d like to explore different automation features, build professional emails in minutes, and send them to your entire contact database with ease.</p>\n<p>Try the HubSpot WordPress email marketing plugin today. Customers love our free email marketing software for features like:</p>\n<p>🤩 <strong>20+ pre-designed free email templates to match your campaign goals. (Choose from free newsletter templates, eBooks, welcome emails, and more!)</strong></p>\n<blockquote>\n<p>All you have to do is add your content and press send!</p>\n</blockquote>\n<p>⚒️ <strong>Drag and drop WordPress newsletter builder.</strong></p>\n<blockquote>\n<p>Build beautiful newsletter templates with the HubSpot WordPress plugin. Create custom newsletter templates effortlessly with a drag-and-drop builder.</p>\n<p>Test out newsletters before you send them, schedule publications for the best time to convert, optimize for mobile devices, and save your own email designs to use again later.</p>\n<p>Send newsletters to targeted contact lists all within the free WordPress newsletter plugin tool..</p>\n<p>Adjust typography, designs, colors, and more to create email campaigns your subscribers will love!</p>\n</blockquote>\n<p>🤖 <strong>Email automation software, email tracking, and A/B testing tools.</strong></p>\n<blockquote>\n<p>Send automated emails anytime someone fills out a form or engages with your live chat &amp; chatbots. You can send messages immediately or use email scheduling to send messages later.</p>\n<p>Setup an A/B test of your newsletter while designing it. Test out different email calls to action and optimize your newsletters with the best performing versions.</p>\n</blockquote>\n<p>Email is one of the most effective ways to stay connected to your audience. With email tracking, all of your emails are logged in your database. You can measure email engagement with reports for delivery rates, open rates, and click-through rates — and use that information to improve campaigns.</p>\n<h3><a href=\"https://www.hubspot.com/products/wordpress/live-chat\" rel=\"nofollow ugc\">Live Chat &amp; Chatbots</a></h3>\n<p>Make your website a 24-hour marketing machine on autopilot with the HubSpot WordPress live chat plugin.</p>\n<p>Live website chat inside the HubSpot WordPress plugin streamlines the customer experience, making it easier than ever for you to engage with website visitors leads, convert them into customers, and provide them with the support they need.</p>\n<p>HubSpot’s free WordPress live chat solution software offers:</p>\n<p>😀 Custom styling to match your website<br />\n🤖 A variety of chatbot options including:</p>\n<ul>\n<li>✅ Concierge chatbot</li>\n<li>✅ Qualify leads chatbot</li>\n<li>✅ Meetings chatbot</li>\n<li>✅ Tickets chatbot</li>\n<li>✅ Knowledge base &amp; support chatbot</li>\n<li>✅ Offline chatbot</li>\n</ul>\n<p>📲 Real-time live messaging on the go via HubSpot’s mobile app<br />\n👨‍💻 A Slack integration to receive and respond to live chat notifications<br />\n🕐 24/7 live chat support on autopilot</p>\n<p>Our free live chat plugin feature helps you turn website visitors into customers by providing insightful, real-time support.</p>\n<h3><a href=\"https://www.hubspot.com/products/wordpress/forms\" rel=\"nofollow ugc\">Forms &amp; Popups</a></h3>\n<p>Want to know the easiest way to learn more about your visitors?</p>\n<p><em>Ask them directly.</em></p>\n<p>The problem is that forms can come in so many different shapes and sizes that it&#8217;s hard to know where to start. That&#8217;s why HubSpot has options for you.</p>\n<p>​​HubSpot&#8217;s form builder and popup plugin give you the power to create or edit forms in just a few clicks.</p>\n<p>First, get familiar with our different form types:</p>\n<p>✅ Embedded<br />\n✅ Standalone page<br />\n✅ Pop-up box<br />\n✅ Dropdown banner<br />\n✅ Slide in left/right box</p>\n<p>Then, when you&#8217;re ready to go, pick a custom template:</p>\n<p>✅ Contact us<br />\n✅ Newsletter sign up form template<br />\n✅ Support template<br />\n✅ eBook download template<br />\n✅ Event registration template<br />\n✅ More coming soon</p>\n<p>Choose from a variety of settings, color schemes, and fonts — or start from scratch. HubSpot comes with an intuitive form and popup builder that simplifies the process, no matter what type of form you have in mind.</p>\n<p>Rather stick with your existing forms and popup plugin? That’s fine too! HubSpot integrates with most WordPress form builders, form creators, and popup builders out-of-the-box so you don’t have to worry about a thing.</p>\n<h3><a href=\"https://www.hubspot.com/products/wordpress/live-chat\" rel=\"nofollow ugc\">Live Chat &amp; Chatbots</a></h3>\n<p>Make your website a 24-hour marketing machine on autopilot.</p>\n<p>Live web chat inside the HubSpot WordPress plugin streamlines the customer experience, making it easier than ever for you to engage with leads, convert them into customers, and provide them with the support they need.</p>\n<p>HubSpot’s WordPress live chat software offers:</p>\n<p>😀 Custom styling to match your website<br />\n🤖 A variety of bot options including:</p>\n<ul>\n<li>✅ Concierge bot</li>\n<li>✅ Qualify leads bot</li>\n<li>✅ Meetings bot</li>\n<li>✅ Tickets bot</li>\n<li>✅ Knowledge base &amp; support bot</li>\n<li>✅ Offline bot</li>\n</ul>\n<p>📲 Real-time messaging on the go via HubSpot’s mobile app<br />\n👨‍💻 A Slack integration to receive and respond to chat notifications<br />\n🕐 24/7 live support on autopilot</p>\n<p>Our free live chat feature helps you turn website visitors into customers by providing insightful, real-time support.</p>\n<h3><a href=\"https://www.hubspot.com/products/wordpress/analytics\" rel=\"nofollow ugc\">Analytics</a></h3>\n<p>Customers are browsing your website, but what are they actually looking at?</p>\n<p>The HubSpot WordPress plugin gives you a straightforward, visual answer.</p>\n<p>With built-in marketing analytics (email analytics, web traffic analytics, WordPress analytics), it&#8217;s easy to understand which marketing actions are driving the most results… and which ones you need to fix. Quickly see how your forms, popup forms, live chat &amp; chatbots, email marketing, and sales follow-ups are helping grow your business.</p>\n<p>👩‍💻 <strong>Get a complete picture of who&#8217;s on your site.</strong></p>\n<p>What pages are being looked at? Who is visiting the pages? How long do they stay on-site? What parts of the site do they spend the most time on? With our plugin, you&#8217;ll be able to see everything about your visitor behavior in one place—and learn how to convert them into customers!</p>\n<p>📈 <strong>Get detailed reports across marketing channels.</strong></p>\n<p>Create detailed reports on performance of various assets, from blog posts and landing pages to email campaigns and more. Arrange these views in dashboards in your plugin, so you can easily see the performance of your website and make data-driven decisions.</p>\n<h3>Seamless Integrations</h3>\n<p>Ready to get started? Now you can easily integrate HubSpot with over <a href=\"https://ecosystem.hubspot.com/marketplace/apps?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">1030 integrations</a> including:</p>\n<p>💻 <strong>Social Media Software, Analytics, &amp; Advertising Software Integrations</strong></p>\n<p>✅ Adroll<br />\n✅ Facebook Ads<br />\n✅ Facebook Messenger<br />\n✅ Google Ads<br />\n✅ Hotjar<br />\n✅ Instagram<br />\n✅ Linkedin Ads<br />\n✅ Twitter<br />\n✅ YouTube</p>\n<p>📲 <strong>Communications &amp; Design Integrations</strong></p>\n<p>✅ Canva<br />\n✅ HelloSign<br />\n✅ Slack<br />\n✅ Vidyard<br />\n✅ Integromat<br />\n✅ Zoom</p>\n<p>🖥️ <strong>CRM, Email Marketing, &amp; Marketing Automation Integrations</strong></p>\n<p>✅ Active Campaign<br />\n✅ Campaign Monitor<br />\n✅ Constant Contact<br />\n✅ Drip<br />\n✅ Gmail<br />\n✅ Hustle<br />\n✅ Mailchimp<br />\n✅ Ontraport<br />\n✅ Outlook<br />\n✅ Salesforce<br />\n✅ Sendinblue<br />\n✅ WP Fusion<br />\n✅ Zoho<br />\n✅ Neverbounce<br />\n✅ Email Delivery Optimization by Seventh Sense</p>\n<p>💵 <strong>E-commerce (Online Store), Recurring Payment, &amp; Payment Processing Integrations</strong></p>\n<p>✅ BigCommerce<br />\n✅ Shopify<br />\n✅ Stripe<br />\n✅ WooCommerce</p>\n<p>📆 <strong>Events &amp; Meeting Scheduling Software Integrations</strong></p>\n<p>✅ Calendly<br />\n✅ Eventbrite<br />\n✅ The Events Calendar</p>\n<p>📋 <strong>Forms, Landing Page Builders, &amp; CRO Integrations</strong></p>\n<p>✅ Elementor<br />\n✅ Formidable Forms<br />\n✅ Forminator<br />\n✅ Gravity Forms<br />\n✅ Instapage<br />\n✅ JotForm<br />\n✅ Kali Forms<br />\n✅ MailOptIn<br />\n✅ Ninja Forms<br />\n✅ OptInMonster<br />\n✅ Sumo<br />\n✅ Survey Monkey<br />\n✅ Typeform<br />\n✅ Unbounce<br />\n✅ WPForms</p>\n<p>💬 <strong>Live Chat &amp; Customer Support Software Integrations</strong></p>\n<p>✅ Drift<br />\n✅ Front<br />\n✅ Help Scout<br />\n✅ Intercom<br />\n✅ LiveChat<br />\n✅ Pure Chat<br />\n✅ Zendesk<br />\n✅ Sakari SMS<br />\n✅ Treble.ai</p>\n<p>🔋 <strong>Productivity &amp; Project Management Software Integrations</strong></p>\n<p>✅ Asana<br />\n✅ Jira</p>\n<h3>What are people saying about the HubSpot plugin?</h3>\n<blockquote>\n<p>“HubSpot was a big factor in helping us scale WP Buffs to $1M in revenue. Their plugin and sales CRM made our sales process so much more professional and kept us fully organized as we grew from 1 salesperson to 4. Plus, the reporting dashboards allow me to know where our sales game is strong and where we can still improve with just a few clicks. Needless to say, I&#8217;m all in on HubSpot.” – <strong>Joe Howard, Founder &amp; CEO, WP Buffs</strong></p>\n<p>“HubSpot educates marketers beyond just the anonymous web analytics they get from Google Analytics. Instead, it digs down to individual users.” – <strong>Michael Shoup, Founder / CEO, 12South Marketing</strong></p>\n<p>“HubSpot dramatically cuts down the time I spend on marketing. We used to spend tons of time generating very few inbound leads, but those numbers have gone through the roof with minimal effort.” – <strong>Brian Ruhlmann, Director of Sales &amp; Marketing, AdmitHub</strong></p>\n</blockquote>\n\";s:12:\"installation\";s:1227:\"<h4>Search</h4>\n<p>The easiest way to install this plugin is to use the WordPress Admin interface.</p>\n<ul>\n<li>Go to your admin dashboard</li>\n<li>Find the &#8220;Plugins&#8221; menu</li>\n<li>Click on &#8220;Add New&#8221;</li>\n<li>Search for &#8220;HubSpot&#8221;</li>\n<li>Click &#8220;Install Now&#8221;</li>\n<li>Go to your &#8220;Plugins&#8221; menu</li>\n<li>Click &#8220;Activate&#8221; on the HubSpot &#8211; CRM, Email Marketing, Live Chat, Forms &amp; Analytics plugin</li>\n<li>Log in or sign up for a HubSpot account</li>\n</ul>\n<p>Your WordPress site and HubSpot account will be connected and you&#8217;re ready to get started with HubSpot &#8211; CRM, Email Marketing, Live Chat, Forms &amp; Analytics.</p>\n<h4>Upload</h4>\n<ol>\n<li>Upload the &#8216;leadin&#8217; folder to the &#8216;/wp-content/plugins/&#8217; directory</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress</li>\n</ol>\n<p>Having trouble? Check out our <a href=\"https://knowledge.hubspot.com/articles/kcs_article/integrations/how-can-i-install-the-hubspot-tracking-code-for-wordpress?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">help documentation</a></p>\n\";s:3:\"faq\";s:6722:\"\n<dt id=\'requirements\'>\nRequirements\n</h4>\n<p>\n<ul>\n<li>Your website or blog must be using WordPress.org version 3.7 or higher on your server. We recommend the latest version.</li>\n<li>The plugin cannot be installed on WordPress.com sites, as they do not allow you to add plugins or Javascript.</li>\n<li>The wp_footer function must be included in your WordPress theme’s footer file (footer.php).</li>\n<li>This function is required for our Javascript snippet to be installed on every page of your site.</li>\n<li>You must be a WordPress admin to be able to install plugins for your site. If you are not the admin, you can forward these instructions to the person who manages your WordPress install.</li>\n</ul>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20does{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20plugin{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat does the plugin do?\n</h4>\n<p>\n<p>HubSpot&#8217;s WordPress plugin allows you to use HubSpot email marketing, CRM, forms, popups, analytics, and live chat on your WordPress website. This plugin gives you all the tools you need to grow your business and delight your contacts and customers.</p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20is{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat is HubSpot?\n</h4>\n<p>\n<p><a href=\"https://hubspot.com/?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">HubSpot</a> is an all-in-one CRM platform that provides a marketing, sales, and customer service products to help you grow your business.</p>\n</p>\n<dt id=\'who{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20should{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20use{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWho should use HubSpot?\n</h4>\n<p>\n<p>HubSpot is perfect for agencies, business owners (including small businesses and e-commerce companies), bloggers, designers, or anyone with a WordPress website that wants to use a seamless CRM plugin with built-in marketing tools. 135,000+ companies in 100+ countries already use HubSpot to grow their businesses.</p>\n</p>\n<dt id=\'are{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20coding{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20skills{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20needed{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20use{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20the{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20wordpress{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20plugin{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nAre coding skills needed to use the HubSpot WordPress plugin?\n</h4>\n<p>\n<p>Not at all! HubSpot’s WordPress plugin is easy to download and starts working seamlessly with your WordPress site right away. You can take advantage of our CRM, live chat, email marketing, forms, and much more without the need to code.</p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20is{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20available{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20for{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20free{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20with{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat is available for free with HubSpot?\n</h4>\n<p>\n<p>With HubSpot’s WordPress plugin, you can use the free CRM software for email marketing, contact management, live chat, customer service, content creation, content management, and more. HubSpot’s full suite of free tools is perfect for small businesses looking to grow and streamline their tech stack.  is free to use with forms, contact management, email marketing, and more.</p>\n<p>HubSpot also has paid tiers available for those who want more advanced functionality like blogging, landing pages, search engine optimization (SEO), team email, retargeting, lead scoring, bots, email scheduling, NPS surveys, calls-to-action (CTAs), knowledge base, and more. If you&#8217;d like a complete view of the features offered in HubSpot&#8217;s free and paid tiers, view our <a href=\"https://hubspot.com/pricing?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">pricing page</a>.</p>\n<p>Our CRM for WordPress is powered by HubSpot’s <a href=\"https://www.hubspot.com/products/crm\" rel=\"nofollow ugc\">free CRM</a>.</p>\n</p>\n<dt id=\'do{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20need{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20install{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20a{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20wordpress{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20smtp{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20plugin{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20to{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20use{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}27s{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20email{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20feature{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nDo I need to install a WordPress SMTP plugin to use HubSpot&#8217;s email feature?\n</h4>\n<p>\n<p>No, there’s no need to install an additional mail SMTP plugin.</p>\n<p>Unlike other WordPress form plugins and email plugins that send messages using a PHP mail function, HubSpot is a stand-alone email marketing software. You can <a href=\"https://knowledge.hubspot.com/email-notifications/how-can-i-find-my-email-servers-imap-and-smtp-information\" rel=\"nofollow ugc\">define your IMAP and SMTP</a> from your existing mail service (Gmail, Outlook, Yahoo) and stop worrying about email deliverability from within WordPress.</p>\n</p>\n<dt id=\'what{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20types{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20of{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20forms{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20and{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20popups{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20can{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20i{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20build{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20with{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nWhat types of forms and popups can I build with HubSpot?\n</h4>\n<p>\n<p>Here are some examples of the types of forms and popups you can create with HubSpot:</p>\n<ul>\n<li>advanced forms</li>\n<li>announcement popup</li>\n<li>appointment form</li>\n<li>banner bar</li>\n<li>calculator form</li>\n<li>conditional form</li>\n<li>conditional logic form</li>\n<li>contact button form</li>\n<li>contact form popup</li>\n<li>contact forms</li>\n<li>coupon popup</li>\n<li>custom form</li>\n<li>custom forms</li>\n<li>custom popup</li>\n<li>custom popups</li>\n<li>donation form</li>\n<li>email form</li>\n<li>email forms</li>\n<li>email submit form</li>\n<li>event form</li>\n<li>exit intent popup forms</li>\n<li>exit popup</li>\n<li>feedback form</li>\n<li>file upload form</li>\n<li>floating bar popup</li>\n<li>inline signup form</li>\n<li>lightbox popup</li>\n<li>mobile popup</li>\n<li>multi page form</li>\n<li>newsletter form</li>\n<li>newsletter popup</li>\n<li>order form</li>\n<li>payment form</li>\n<li>pdf form</li>\n<li>popup form</li>\n<li>quiz form</li>\n<li>quote form</li>\n<li>quote request form</li>\n<li>registration popup</li>\n<li>scroll trigger popup</li>\n<li>signature form</li>\n<li>signup form</li>\n<li>slide-in popup</li>\n<li>slide-in scroll popup</li>\n<li>star rating form</li>\n<li>sticky bar</li>\n<li>sticky popup</li>\n<li>subscription form</li>\n<li>survey form</li>\n<li>survey popup</li>\n<li>targeted popup</li>\n<li>time on site popup</li>\n<li>upload form</li>\n<li>user registration form</li>\n<li>web contact form</li>\n<li>web form</li>\n<li>welcome mat popup</li>\n<li>woocommerce popup</li>\n</ul>\n<p>Rather use your existing form tool? HubSpot integrates with most WordPress form builders and popup builders.</p>\n</p>\n<dt id=\'does{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20hubspot{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20support{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20e-commerce{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20stores{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}3F\'>\nDoes HubSpot support e-commerce stores?\n</h4>\n<p>\n<p>The HubSpot WordPress plugin is great for many types of businesses including ecommerce. For WooCommerce shop owners, consider the <a href=\"https://wordpress.org/plugins/makewebbetter-hubspot-for-woocommerce/\" rel=\"ugc\">HubSpot for WooCommerce plugin</a> for even added functionality in your shop.</p>\n</p>\n<dt id=\'my{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20question{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20is{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20not{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}20listed.\'>\nMy question is not listed.\n</h4>\n<p>\n<p>Please visit the <a href=\"https://community.hubspot.com/?utm_source=wordpress-plugin-listing&amp;utm_campaign=wordpress&amp;utm_medium=marketplaces\" rel=\"nofollow ugc\">HubSpot Community</a> for more detailed documentation and support. Thank you!</p>\n</p>\n\n\";s:9:\"changelog\";s:362:\"<p><a href=\"https://plugins.svn.wordpress.org/leadin/trunk/changelog.txt\" rel=\"nofollow ugc\">Full changelog here</a><br />\n&#8211; Current version: 10.2.5<br />\n&#8211; Version release date: 2023-09-07</p>\n<h4>10.2.3 (2023-08-23)</h4>\n<ul>\n<li>Sets device id in embedder options</li>\n</ul>\n<h4>10.2.0 (2023-08-09)</h4>\n<ul>\n<li>Live chat app embedder</li>\n</ul>\n\";s:11:\"screenshots\";s:2397:\"<ol><li><a href=\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=2965762\" alt=\"Measure impact with reports.\"></a><p>Measure impact with reports.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=2965762\" alt=\"Organize, track, and nurture your leads in your free HubSpot CRM.\"></a><p>Organize, track, and nurture your leads in your free HubSpot CRM.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=2965762\" alt=\"Your website forms will automatically sync with your HubSpot CRM.\"></a><p>Your website forms will automatically sync with your HubSpot CRM.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=2965762\" alt=\"Nurture and convert leads with lists and email.\"></a><p>Nurture and convert leads with lists and email.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=2965762\" alt=\"Send contacts a beautiful, effective and personalized email.\"></a><p>Send contacts a beautiful, effective and personalized email.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=2965762\" alt=\"Add live chat to your website and easily engage &amp; help your site visitors.\"></a><p>Add live chat to your website and easily engage &amp; help your site visitors.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=2965762\" alt=\"Add 24/7 chatbots to your website to help automate lead capture and support.\"></a><p>Add 24/7 chatbots to your website to help automate lead capture and support.</p></li><li><a href=\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=2965762\"><img src=\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=2965762\" alt=\"Create beautiful forms and popups on your website in minutes using the intuitive drag and drop builder.\"></a><p>Create beautiful forms and popups on your website in minutes using the intuitive drag and drop builder.</p></li></ol>\";s:7:\"reviews\";s:17413:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">EXCELENTE</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/dechomai/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/5ea3528b9918477a0020cc22f2ca286f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/5ea3528b9918477a0020cc22f2ca286f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/dechomai/\" class=\"reviewer-name\">dechomai</a> on <span class=\"review-date\">August 31, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Este plugin es ESPECTACULAR, tengo que RECONOCER que todavia no lo domino pero lo que me ofrece de manera gratuita es EXCEPCIONAL. Gracias y Felicitaciones</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Execlente experiencia, muy util a mis fines!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/linneoventas/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/473e33c6bc84e4b7bea01ff633211687?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/473e33c6bc84e4b7bea01ff633211687?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/linneoventas/\" class=\"reviewer-name\">linneoventas</a> on <span class=\"review-date\">August 23, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Execlente experiencia, muy util a mis fines!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very poor experience</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/freddredirl/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f9415f6ba167f30d0fd23502020fd07b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f9415f6ba167f30d0fd23502020fd07b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/freddredirl/\" class=\"reviewer-name\">freddredirl</a> on <span class=\"review-date\">August 9, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I dont think I have ever given a 1 poor review before - but this deserves one. Very glitchy onboarding experience bringing you round in circles, try again and poor explanations of errors/causes. Surprising for such a well known CRM.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Super useful</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rmartins1978/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/5e57cb79c50931c37d9f6ac1d459612a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/5e57cb79c50931c37d9f6ac1d459612a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rmartins1978/\" class=\"reviewer-name\">Rui Martins <small>(rmartins1978)</small></a> on <span class=\"review-date\">June 25, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Use this in all of my websites. Allows me to manage communication with prospects and then follow them up until they become customers.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The Pros and Cons of Hubspot</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/marbs/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/274f7cd4d4a88ff782d5e20cbac82d4a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/274f7cd4d4a88ff782d5e20cbac82d4a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/marbs/\" class=\"reviewer-name\">marbs</a> on <span class=\"review-date\">May 17, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I recently integrated the Hubspot WordPress plugin into my website with high hopes of streamlining my marketing efforts. While the plugin offers some useful features, there are a few drawbacks that significantly impact both mobile website performance and user experience.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>First and foremost, I noticed a significant decline in mobile website performance after implementing the Hubspot plugin. According to Google PageSpeed Insights, my website\'s performance score plummeted <strong>from 64</strong> to <strong>39</strong> <em>(unable to add links to screenshot to compliment my review)</em>. This decline is quite concerning, as a slow-loading website can have a detrimental effect on user engagement and search engine rankings. It is essential to consider this performance impact before deciding to use the Hubspot plugin, especially if website speed is a priority for your business.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I encountered a frustrating issue with the plugin\'s login functionality. Whenever I close my browser, all data associated with Hubspot, including my login information, is automatically deleted for security reasons. Consequently, I find myself having to log in manually to the Hubspot dashboard every time I access it. This inconvenience disrupts my workflow and wastes precious time that could be better spent on other tasks. This issue seems to be a significant flaw in Hubspot\'s design and should be addressed promptly.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Despite these setbacks, it\'s worth noting that the Hubspot WordPress plugin does offer some valuable features for marketers. It allows for seamless integration of Hubspot\'s CRM and marketing tools, enabling easy lead capture, email marketing, and contact management. The plugin also provides analytics and reporting functionalities, giving users insights into their marketing performance but the downside is, when you option for an upgrade it gets pricey.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The Hubspot WordPress plugin presents a mixed bag of pros and cons. While it offers useful marketing features and analytics capabilities, it comes with notable downsides. The decline in mobile website performance according to Google PageSpeed Insights is concerning, and the persistent login issue is a significant inconvenience. If you decide to use the Hubspot plugin, it is crucial to be aware of these limitations and consider the trade-offs carefully. Hopefully, the Hubspot team will address these issues promptly to improve the overall user experience.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Good UI and Integration in WP is easy</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/msstaxes/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0ae18aea8316d157995dbb6121173432?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0ae18aea8316d157995dbb6121173432?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/msstaxes/\" class=\"reviewer-name\">msstaxes</a> on <span class=\"review-date\">April 4, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>UI is good, we have more control on customisation of forms, live chat etc. I recommend it.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Does not work- waste of time</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/teresa789/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/5d9ee226da8b846b06354ea82e10dc16?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/5d9ee226da8b846b06354ea82e10dc16?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/teresa789/\" class=\"reviewer-name\">teresa789</a> on <span class=\"review-date\">March 24, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I have installed the plugin on 4 different site and none of them work, I have it on one site no other plugins so no conflict there and it still will not connect. I can not find any information or help on what to do. What a waste of a day, researching and still can not get it to work, I also set up an account on hubspot and could not even get the email section to connect, it should not be this hard. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Reliable but needs work</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/pagecode/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/26b20ff1025d2019012f5e9793183e9d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/26b20ff1025d2019012f5e9793183e9d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/pagecode/\" class=\"reviewer-name\">Pagecode <small>(pagecode)</small></a> on <span class=\"review-date\">March 16, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Its great but it needs work with the connection sometimes bugging out</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works but kills your performance</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/karel0017/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/faab764af226d81afde958b425fbdbeb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/faab764af226d81afde958b425fbdbeb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/karel0017/\" class=\"reviewer-name\">karel0017</a> on <span class=\"review-date\">March 12, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>We used this plugin for a while, only to track some pages. No forms, no CTA. We had to uninstall it because it was responsible for a huge drop in our performance. We went from 99 to 67 in lighthouse! After disabling, our performance was back to normal. This is unacceptable, especially, for a plugin that is supposed to be in the SEO domain...</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">life is now easy</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ahsandeveloper/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a1852014e857381888bd5238d7888580?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a1852014e857381888bd5238d7888580?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ahsandeveloper/\" class=\"reviewer-name\">ahsandeveloper</a> on <span class=\"review-date\">March 12, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>This makes my life easy.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:13:\"download_link\";s:49:\"https://downloads.wordpress.org/plugin/leadin.zip\";s:11:\"screenshots\";a:8:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=2965762\";s:7:\"caption\";s:28:\"Measure impact with reports.\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=2965762\";s:7:\"caption\";s:65:\"Organize, track, and nurture your leads in your free HubSpot CRM.\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=2965762\";s:7:\"caption\";s:65:\"Your website forms will automatically sync with your HubSpot CRM.\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=2965762\";s:7:\"caption\";s:47:\"Nurture and convert leads with lists and email.\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=2965762\";s:7:\"caption\";s:60:\"Send contacts a beautiful, effective and personalized email.\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=2965762\";s:7:\"caption\";s:78:\"Add live chat to your website and easily engage &amp; help your site visitors.\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=2965762\";s:7:\"caption\";s:76:\"Add 24/7 chatbots to your website to help automate lead capture and support.\";}i:8;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=2965762\";s:7:\"caption\";s:103:\"Create beautiful forms and popups on your website in minutes using the intuitive drag and drop builder.\";}}s:4:\"tags\";a:5:{s:9:\"analytics\";s:9:\"analytics\";s:3:\"crm\";s:3:\"crm\";s:5:\"forms\";s:5:\"forms\";s:9:\"live-chat\";s:9:\"live chat\";s:9:\"marketing\";s:9:\"marketing\";}s:8:\"versions\";a:15:{s:7:\"10.0.18\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.0.18.zip\";s:7:\"10.0.21\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.0.21.zip\";s:7:\"10.0.24\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.0.24.zip\";s:6:\"10.0.7\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.0.7.zip\";s:7:\"10.1.13\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.13.zip\";s:7:\"10.1.16\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.16.zip\";s:7:\"10.1.23\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.23.zip\";s:7:\"10.1.27\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.27.zip\";s:7:\"10.1.29\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.29.zip\";s:6:\"10.1.6\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.1.6.zip\";s:6:\"10.2.0\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.2.0.zip\";s:6:\"10.2.2\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.2.2.zip\";s:6:\"10.2.4\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.2.4.zip\";s:5:\"9.2.0\";s:55:\"https://downloads.wordpress.org/plugin/leadin.9.2.0.zip\";s:6:\"9.2.26\";s:56:\"https://downloads.wordpress.org/plugin/leadin.9.2.26.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://ps.w.org/leadin/assets/banner-772x250.png?rev=2965762\";s:4:\"high\";s:62:\"https://ps.w.org/leadin/assets/banner-1544x500.png?rev=2965762\";}}s:7:\"bbpress\";a:26:{s:4:\"name\";s:7:\"bbPress\";s:4:\"slug\";s:7:\"bbpress\";s:7:\"version\";s:5:\"2.6.9\";s:6:\"author\";s:58:\"<a href=\"https://bbpress.org\">The bbPress Contributors</a>\";s:14:\"author_profile\";s:47:\"https://profiles.wordpress.org/johnjamesjacoby/\";s:12:\"contributors\";a:5:{s:4:\"matt\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/matt/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/767fc9c115a1b989744c755db47feb60?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Matt Mullenweg\";}s:15:\"johnjamesjacoby\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/johnjamesjacoby/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/7a2644fb53ae2f7bfd7143b504af396c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"John James Jacoby\";}s:6:\"jmdodd\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/jmdodd/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6a7c997edea340616bcc6d0fe03f65dd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Jennifer M. Dodd\";}s:6:\"netweb\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/netweb/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/97e1620b501da675315ba7cfb740e80f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Stephen Edgar\";}s:14:\"sergeybiryukov\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/sergeybiryukov/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/750b7b0fcd855389264c2b1294d61bd6?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Sergey Biryukov\";}}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:6:\"5.6.20\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:78;s:7:\"ratings\";a:5:{i:5;i:192;i:4;i:40;i:3;i:24;i:2;i:20;i:1;i:51;}s:11:\"num_ratings\";i:327;s:15:\"support_threads\";i:1;s:24:\"support_threads_resolved\";i:0;s:15:\"active_installs\";i:200000;s:12:\"last_updated\";s:21:\"2021-11-29 3:31pm GMT\";s:5:\"added\";s:10:\"2010-01-13\";s:8:\"homepage\";s:19:\"https://bbpress.org\";s:8:\"sections\";a:5:{s:11:\"description\";s:291:\"<p>Are you looking for a timeless, elegant, and streamlined discussion board? bbPress is easy to integrate, easy to use, and is built to scale with your growing community.</p>\n<p>bbPress is intentionally simple yet infinitely powerful forum software, built by contributors to WordPress.</p>\n\";s:12:\"installation\";s:1835:\"<h4>From your WordPress dashboard</h4>\n<ol>\n<li>Visit &#8216;Plugins &gt; Add New&#8217;</li>\n<li>Search for &#8216;bbPress&#8217;</li>\n<li>Activate bbPress from your Plugins page. (You will be greeted with a Welcome page.)</li>\n</ol>\n<h4>From WordPress.org</h4>\n<ol>\n<li>Download bbPress.</li>\n<li>Upload the &#8216;bbpress&#8217; directory to your &#8216;/wp-content/plugins/&#8217; directory, using your favorite method (ftp, sftp, scp, etc&#8230;)</li>\n<li>Activate bbPress from your Plugins page. (You will be greeted with a Welcome page.)</li>\n</ol>\n<h4>Once Activated</h4>\n<ol>\n<li>Visit &#8216;Forums &gt; Add New&#8217; and create some forums. (You can always delete these later.)</li>\n<li>If you have pretty permalinks enabled, visit example.com/forums/, or if you do not have pretty permalinks enabled, visit example.com?post_type=forum</li>\n<li>Visit &#8216;Settings &gt; Forums&#8217; and configure the settings to best match the needs of your community.</li>\n<li>Visit &#8216;Tools &gt; Forums &gt; Import Forums&#8217; if you have an existing forum to convert to bbPress.</li>\n</ol>\n<h4>Once Configured</h4>\n<ul>\n<li>bbPress comes with a robust theme-compatibility API that does its best to make bbPress look and feel right with just-about any WordPress theme. You may need to adjust some styling on your own to make everything look pristine.</li>\n<li>You may want to customize the register/activation/sign-in/lost-password flows, to better suit your site. bbPress comes with a bevy of shortcodes to make this possible, listed here: https://codex.bbpress.org/shortcodes/</li>\n<li>bbPress also comes with built-in support for Akismet and BuddyPress, two very popular and very powerful WordPress plugins. If you&#8217;re using either, visit your Forum Settings page and ensure that integration appears correct.</li>\n</ul>\n\";s:9:\"changelog\";s:104:\"<p>Check out the <a href=\"https://codex.bbpress.org/releases/\" rel=\"nofollow ugc\">releases page</a></p>\n\";s:11:\"screenshots\";s:1543:\"<ol><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\" alt=\"Forums - Admin Interface\"></a><p>Forums - Admin Interface</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\" alt=\"Topics - Admin Interface\"></a><p>Topics - Admin Interface</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\" alt=\"Replies - Admin Interface\"></a><p>Replies - Admin Interface</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\" alt=\"Settings - Admin Interface\"></a><p>Settings - Admin Interface</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\" alt=\"Settings 2 - Admin Interface\"></a><p>Settings 2 - Admin Interface</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\" alt=\"Themes - Admin Interface\"></a><p>Themes - Admin Interface</p></li><li><a href=\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\"><img src=\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\" alt=\"Single Forum - Default Theme\"></a><p>Single Forum - Default Theme</p></li></ol>\";s:7:\"reviews\";s:17849:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Does Not Work in Latest WordPress versions (blank page)</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/jmstacey/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8636a492ab325037a209c64f117770fa?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8636a492ab325037a209c64f117770fa?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/jmstacey/\" class=\"reviewer-name\"> <small>(jmstacey)</small></a> on <span class=\"review-date\">August 14, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Blank white page on latest WordPress version 6.3. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Old fashioned &amp; buggy</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/thommycgn/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c6521cbbf21ed1c6ad0e61ace47aeda1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c6521cbbf21ed1c6ad0e61ace47aeda1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/thommycgn/\" class=\"reviewer-name\">thommycgn</a> on <span class=\"review-date\">April 19, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>bbpress is very old fashioned and a bit cumbersome and buggy. The search does not work with the latest wordpress version, you always end up on an archive page with wrong display. The error is not caused by the theme or another plugin, have tried many things. With some themes only a blank page comes up.<br />Also the url structure is not really nice (/forums/forum/..). bbPress urgently needs an overhaul! I spent 2 days with bbPress, before I finally switched to another plugin, because it was not possible to get bbPress to run without errors. There are better free forums for wordpress that look much more modern (Asharos forum worked right away, without problems).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Blank page on twenty twenty three</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/2fr3/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e98745ce55ac5104ced08ba2d46f469d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e98745ce55ac5104ced08ba2d46f469d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/2fr3/\" class=\"reviewer-name\">2FR3</a> on <span class=\"review-date\">March 27, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>See title, good job !</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not good</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/farzandezamiin/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6e4097d8ceb44f76cef014b96bd0b81e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6e4097d8ceb44f76cef014b96bd0b81e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/farzandezamiin/\" class=\"reviewer-name\">ابوالقاسم کریمی <small>(farzandezamiin)</small></a> on <span class=\"review-date\">March 2, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Not good</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Attempt to modify property &quot;classes&quot; on null</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/filout/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6c21a095a47f2b57e69d30f2c75597d8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6c21a095a47f2b57e69d30f2c75597d8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/filout/\" class=\"reviewer-name\">filout</a> on <span class=\"review-date\">February 14, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Hello everyone,</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>our provider made a php update from v7.4 to v8.1 (because EOL for php v7.4) the days and after this our homepage wasn\'t reachable with the error message in the topic.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Via FTP i deactivated all installed plugins until the error came back and i found out, that this error comes from bbPress.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We have installed:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>php v8.1</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>WordPress v6.1.1</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>bbPress v2.6.9</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>bbp style pack v5.3.5</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>bbPress Toolkit v1.0.12</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>theme Origamiez v1.3.5</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>If you need further information please let me know.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Regards</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Filout</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not really fun to work with</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/cutu234/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a77c9110b8b015d7884f60de3f5a10d4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a77c9110b8b015d7884f60de3f5a10d4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/cutu234/\" class=\"reviewer-name\">cutu234</a> on <span class=\"review-date\">January 23, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I really wanted to like this plugin, I really did. I mean, it\'s by the guys that made WordPress. So, what could possibly go wrong? Well, let\'s start with the layout. While I do appreciate simple and clean designs, it can get TOO simple. The forum page looks like a Typo3 layout from the nineties. Now to the more annoying part: There is no registration or lost password form on the login page. Seriously? So, I added both pages and activated the sidebar <strong>just for the bbpress widget</strong>! This gives me an acceptable registration page. But wait! If I fill in the wrong credentials (or simply nothing), I\'ll get redirected to the WordPress login page. WHAT? I know that I can install a plugin for this feature. But I simple don\'t want an additional plugin for such a basic thing.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">No longer worthwhile</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/webstpro/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/57f97bfae6b106b06fc6dfc2d3e7714f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/57f97bfae6b106b06fc6dfc2d3e7714f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/webstpro/\" class=\"reviewer-name\">webstpro</a> on <span class=\"review-date\">December 15, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Very primitive. No documentation. For example, there is a search box but no way to put a label on it. I tried to add a topic to a forum but there was no submit button. Basically, it has not been updated in a year and it shows.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Worthless</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ebonweaver/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c8cbc9cdbe05480d0bee8937d8b5b55c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c8cbc9cdbe05480d0bee8937d8b5b55c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ebonweaver/\" class=\"reviewer-name\">ebonweaver</a> on <span class=\"review-date\">June 27, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">I\'m shocked how unusable this is.  Configuration is not simple and not documented.  Appearance is primitive at best, not even basic.  But in the end it\'s totally worthless as all the basic access functionality is missing or does not work.  No registration page/ link on login page.  No documentation on setting this up.  blogs all point to manually making a registration page using shortcodes??  But the codes don\'t work, so the plugin is just useless.  From here I tried Asgaros and while simple, it actually works in full out of the box with easy configuration all in one place (not 3 like bbpress).  Sure if you want a nice registration form you need another plugin, but that was already the case for Wordpress anyway.</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great Forum plugin of Wordpress</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/deepblue5/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/26557041113062c2805aa7dcd65c850e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/26557041113062c2805aa7dcd65c850e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/deepblue5/\" class=\"reviewer-name\">DeepBlue <small>(deepblue5)</small></a> on <span class=\"review-date\">February 22, 2022</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">Works great\nsimple and fast\nand easy to get a nice design with free pluggin bbp style pack</div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Wrecks your roles; impossible to clean up after - AVOID THIS PLUGIN</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ourroots/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9d9375220fce4a42e0252e5aa6988dd8?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9d9375220fce4a42e0252e5aa6988dd8?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ourroots/\" class=\"reviewer-name\">ourroots</a> on <span class=\"review-date\">August 24, 2021</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\">We wanted to try BBPress but we discovered quickly that it caused way too many problems with roles &amp; permissions for the site. So we removed it. But it turns out that for at least 8 years bbPress has known the roles can\'t be removed cleanly and they just shrug and say \"not important.\" So, I recommend you NOT INSTALL THIS PLUGIN. It will leave ugly traces behind itself like a nasty WordPress slug and you\'ll waste hours googling it and trying to fix it to no avail. It\'s old, it\'s ugly, and it\'s a mess.</div>\n</div>\n\";}s:13:\"download_link\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.9.zip\";s:11:\"screenshots\";a:7:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\";s:7:\"caption\";s:24:\"Forums - Admin Interface\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\";s:7:\"caption\";s:24:\"Topics - Admin Interface\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\";s:7:\"caption\";s:25:\"Replies - Admin Interface\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\";s:7:\"caption\";s:26:\"Settings - Admin Interface\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\";s:7:\"caption\";s:28:\"Settings 2 - Admin Interface\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\";s:7:\"caption\";s:24:\"Themes - Admin Interface\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\";s:7:\"caption\";s:28:\"Single Forum - Default Theme\";}}s:4:\"tags\";a:4:{s:10:\"discussion\";s:10:\"discussion\";s:5:\"forum\";s:5:\"forum\";s:6:\"forums\";s:6:\"forums\";s:7:\"support\";s:7:\"support\";}s:8:\"versions\";a:65:{s:3:\"2.0\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.0.zip\";s:10:\"2.0-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-1.zip\";s:11:\"2.0-beta-2b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-2b.zip\";s:10:\"2.0-beta-3\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3.zip\";s:11:\"2.0-beta-3b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3b.zip\";s:8:\"2.0-rc-2\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-2.zip\";s:8:\"2.0-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-3.zip\";s:8:\"2.0-rc-4\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-4.zip\";s:8:\"2.0-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-5.zip\";s:5:\"2.0.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.1.zip\";s:5:\"2.0.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.2.zip\";s:5:\"2.0.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.3.zip\";s:3:\"2.1\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.1.zip\";s:10:\"2.1-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.1-beta-1.zip\";s:7:\"2.1-rc1\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc1.zip\";s:7:\"2.1-rc2\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc2.zip\";s:7:\"2.1-rc3\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc3.zip\";s:7:\"2.1-rc4\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc4.zip\";s:5:\"2.1.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.1.zip\";s:5:\"2.1.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.2.zip\";s:5:\"2.1.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.3.zip\";s:3:\"2.2\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.2.zip\";s:5:\"2.2.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.1.zip\";s:5:\"2.2.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.2.zip\";s:5:\"2.2.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.3.zip\";s:5:\"2.2.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.4.zip\";s:3:\"2.3\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.3.zip\";s:9:\"2.3-beta1\";s:60:\"https://downloads.wordpress.org/plugin/bbpress.2.3-beta1.zip\";s:5:\"2.3.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.1.zip\";s:5:\"2.3.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.2.zip\";s:3:\"2.4\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.4.zip\";s:5:\"2.4.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.4.1.zip\";s:3:\"2.5\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.5.zip\";s:5:\"2.5.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.1.zip\";s:6:\"2.5.10\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.10.zip\";s:6:\"2.5.11\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.11.zip\";s:6:\"2.5.12\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.12.zip\";s:6:\"2.5.13\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.13.zip\";s:6:\"2.5.14\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:5:\"2.5.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.2.zip\";s:5:\"2.5.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.3.zip\";s:5:\"2.5.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.4.zip\";s:5:\"2.5.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.5.zip\";s:5:\"2.5.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";s:5:\"2.5.7\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.7.zip\";s:5:\"2.5.8\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.8.zip\";s:5:\"2.5.9\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.9.zip\";s:10:\"2.6-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-1.zip\";s:10:\"2.6-beta-2\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-2.zip\";s:8:\"2.6-rc-1\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-1.zip\";s:8:\"2.6-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-3.zip\";s:8:\"2.6-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-5.zip\";s:8:\"2.6-rc-6\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-6.zip\";s:8:\"2.6-rc-7\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-7.zip\";s:5:\"2.6.0\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.0.zip\";s:5:\"2.6.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.1.zip\";s:5:\"2.6.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.2.zip\";s:5:\"2.6.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.3.zip\";s:5:\"2.6.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.4.zip\";s:5:\"2.6.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.5.zip\";s:5:\"2.6.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.6.zip\";s:5:\"2.6.7\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.7.zip\";s:5:\"2.6.8\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.8.zip\";s:5:\"2.6.9\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.9.zip\";s:5:\"trunk\";s:50:\"https://downloads.wordpress.org/plugin/bbpress.zip\";}s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://ps.w.org/bbpress/assets/banner-772x250.png?rev=478663\";s:4:\"high\";s:62:\"https://ps.w.org/bbpress/assets/banner-1544x500.png?rev=567403\";}}s:14:\"contact-form-7\";a:26:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:7:\"version\";s:3:\"5.8\";s:6:\"author\";s:62:\"<a href=\"https://ideasilo.wordpress.com/\">Takayuki Miyoshi</a>\";s:14:\"author_profile\";s:44:\"https://profiles.wordpress.org/takayukister/\";s:12:\"contributors\";a:1:{s:12:\"takayukister\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/takayukister/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/bb7bc21850c77e9eb16b44102f4a539d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Takayuki Miyoshi\";}}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:80;s:7:\"ratings\";a:5:{i:5;i:1401;i:4;i:141;i:3;i:70;i:2;i:61;i:1;i:376;}s:11:\"num_ratings\";i:2049;s:15:\"support_threads\";i:292;s:24:\"support_threads_resolved\";i:94;s:15:\"active_installs\";i:5000000;s:12:\"last_updated\";s:21:\"2023-08-06 8:25am GMT\";s:5:\"added\";s:10:\"2007-08-02\";s:8:\"homepage\";s:25:\"https://contactform7.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:3077:\"<p>Contact Form 7 can manage multiple contact forms, plus you can customize the form and the mail contents flexibly with simple markup. The form supports Ajax-powered submitting, CAPTCHA, Akismet spam filtering and so on.</p>\n<h4>Docs and support</h4>\n<p>You can find <a href=\"https://contactform7.com/docs/\" rel=\"nofollow ugc\">docs</a>, <a href=\"https://contactform7.com/faq/\" rel=\"nofollow ugc\">FAQ</a> and more detailed information about Contact Form 7 on <a href=\"https://contactform7.com/\" rel=\"nofollow ugc\">contactform7.com</a>. When you cannot find the answer to your question on the FAQ or in any of the documentation, check the <a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"ugc\">support forum</a> on WordPress.org. If you cannot locate any topics that pertain to your particular issue, post a new topic for it.</p>\n<h4>Contact Form 7 needs your support</h4>\n<p>It is hard to continue development and support for this free plugin without contributions from users like you. If you enjoy using Contact Form 7 and find it useful, please consider <a href=\"https://contactform7.com/donate/\" rel=\"nofollow ugc\">making a donation</a>. Your donation will help encourage and support the plugin&#8217;s continued development and better user support.</p>\n<h4>Privacy notices</h4>\n<p>With the default configuration, this plugin, in itself, does not:</p>\n<ul>\n<li>track users by stealth;</li>\n<li>write any user personal data to the database;</li>\n<li>send any data to external servers;</li>\n<li>use cookies.</li>\n</ul>\n<p>If you activate certain features in this plugin, the contact form submitter&#8217;s personal data, including their IP address, may be sent to the service provider. Thus, confirming the provider&#8217;s privacy policy is recommended. These features include:</p>\n<ul>\n<li>reCAPTCHA (<a href=\"https://policies.google.com/?hl=en\" rel=\"nofollow ugc\">Google</a>)</li>\n<li>Akismet (<a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">Automattic</a>)</li>\n<li>Constant Contact (<a href=\"https://www.endurance.com/privacy\" rel=\"nofollow ugc\">Endurance International Group</a>)</li>\n<li><a href=\"https://www.brevo.com/legal/privacypolicy/\" rel=\"nofollow ugc\">Brevo (formerly Sendinblue)</a></li>\n<li><a href=\"https://stripe.com/privacy\" rel=\"nofollow ugc\">Stripe</a></li>\n</ul>\n<h4>Recommended plugins</h4>\n<p>The following plugins are recommended for Contact Form 7 users:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/flamingo/\" rel=\"ugc\">Flamingo</a> by Takayuki Miyoshi &#8211; With Flamingo, you can save submitted messages via contact forms in the database.</li>\n<li><a href=\"https://wordpress.org/plugins/bogo/\" rel=\"ugc\">Bogo</a> by Takayuki Miyoshi &#8211; Bogo is a straight-forward multilingual plugin that does not cause headaches.</li>\n</ul>\n<h4>Translations</h4>\n<p>You can <a href=\"https://contactform7.com/translating-contact-form-7/\" rel=\"nofollow ugc\">translate Contact Form 7</a> on <a href=\"https://translate.wordpress.org/projects/wp-plugins/contact-form-7\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n\";s:12:\"installation\";s:458:\"<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the <strong>Plugins</strong> screen (<strong>Plugins &gt; Installed Plugins</strong>).</li>\n</ol>\n<p>You will find <strong>Contact</strong> menu in your WordPress admin screen.</p>\n<p>For basic usage, have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow ugc\">plugin&#8217;s website</a>.</p>\n\";s:3:\"faq\";s:449:\"<p>Do you have questions or issues with Contact Form 7? Use these support channels appropriately.</p>\n<ol>\n<li><a href=\"https://contactform7.com/docs/\" rel=\"nofollow ugc\">Docs</a></li>\n<li><a href=\"https://contactform7.com/faq/\" rel=\"nofollow ugc\">FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"ugc\">Support forum</a></li>\n</ol>\n<p><a href=\"https://contactform7.com/support/\" rel=\"nofollow ugc\">Support</a></p>\n\";s:9:\"changelog\";s:1492:\"<p>For more information, see <a href=\"https://contactform7.com/category/releases/\" rel=\"nofollow ugc\">Releases</a>.</p>\n<h4>5.8</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-58/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-58/</a></p>\n<h4>5.7.7</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-577/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-577/</a></p>\n<h4>5.7.6</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-576/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-576/</a></p>\n<h4>5.7.5.1</h4>\n<ul>\n<li>Fixes an old PHP compatibility issue.</li>\n</ul>\n<h4>5.7.5</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-575/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-575/</a></p>\n<h4>5.7.4</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-574/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-574/</a></p>\n<h4>5.7.3</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-573/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-573/</a></p>\n<h4>5.7.2</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-572/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-572/</a></p>\n<h4>5.7.1</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-571/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-571/</a></p>\n<h4>5.7</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-57/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-57/</a></p>\n\";s:11:\"screenshots\";s:225:\"<ol><li><a href=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\"><img src=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\" alt=\"screenshot-1.png\"></a><p>screenshot-1.png</p></li></ol>\";s:7:\"reviews\";s:16704:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">If webste performance matters - Avoid like the plague</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/oneexception/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/784081f536206880194ba875742791db?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/784081f536206880194ba875742791db?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/oneexception/\" class=\"reviewer-name\">oneexception</a> on <span class=\"review-date\">September 20, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">This plugin will destroy your website performance and score<br />I cant believe there hasnt been a fix released for \'Refill\' and \'Schema\' in all this time. The headaches this s*** has caused ARRGGHH!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">It doesn&#039;t work with reCaptcha.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/danwilliamsbooks/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/2cb6822bca86a63b43d01ece1d916161?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/2cb6822bca86a63b43d01ece1d916161?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/danwilliamsbooks/\" class=\"reviewer-name\">danwilliamsbooks</a> on <span class=\"review-date\">September 8, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">It does not appear to work. It seems easy to configure with a lot of options. However, it generates javascript errors and does not enable my users to contact me even though my email server is working fine. It appears not to play with reCaptcha which I don\'t want to live without.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">error configuration and no actual solution for why</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/crankywebdev/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/39f031dab4da81f789e0162ced1e28be?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/39f031dab4da81f789e0162ced1e28be?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/crankywebdev/\" class=\"reviewer-name\">crankywebdev</a> on <span class=\"review-date\">August 26, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">For about 10 years in the 2010s I used this plugin as an IT professional building dozens of wordpress-based sites. It was always frustrating trying to fix the errors because the documentation sucked.<br /><br />Fast forward and I haven\'t been in the IT industry for over 7 years and it still sucks. AYFKM?!<br /><br />If the form error is going to say: [your-subject]  \"There is a possible empty field.\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">[your-subject]  is a valid replacement value.<br /><br />There\'s a serious problem with the quality of this plugin.<br /><br />100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} Why wordpress has always had major issues. It should come with basic functionality like contact form but instead relies on 3rd party plugins to fill the void. Are we going to have to wait another couple decades for a CMS that actually comes with baked-in basic functionality instead of relying on 3rd party crapware?<br /></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Essential Plugin but unwanted recapcha</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/knguyen2011/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/10d21a4318f306753a030ff189867909?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/10d21a4318f306753a030ff189867909?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/knguyen2011/\" class=\"reviewer-name\">knguyen2011</a> on <span class=\"review-date\">August 22, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">This is good plugin but it loads capcha 3 everywhere and no way to disable it. No option to disable it.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Facing some issues</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/cgartistamit/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ffa0d63ce3fe5ee40bd3868733affe00?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ffa0d63ce3fe5ee40bd3868733affe00?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/cgartistamit/\" class=\"reviewer-name\">cgartist.amit</a> on <span class=\"review-date\">August 18, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">I am using this form from 5-6 years this is just awesome. But a client wants to make checkbox looks like toggle type selectable buttons.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">I created a module via CF7, I wants to make some changes like padding, color, etc to make checkbox looks like a button. Or anything else to achieve this. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p class=\"\">using css</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:code -->\n<pre class=\"wp-block-code\"><code>.togglebuttons .wpcf7-list-item {<br />margin: 0 10px 0 0;<br />display: inline-block;<br />}<br />.togglebuttons &gt; span input {<br />opacity: 0;<br />position: absolute;<br />}\n\n.togglebuttons &gt; span .wpcf7-list-item-label {<br />cursor: pointer;<br />display: block;<br />color: #ffffff;<br />border-radius: 15px;<br />background: #f44571;<br />padding: 5px 15px;<br />background: #4054b2;<br />box-shadow: 0 0px 0px rgba(0,0,0,.2);<br />border: 0px solid #e0e0e0;<br />}\n\n.togglebuttons &gt; span input:checked + .wpcf7-list-item-label {<br />background: #4054b2;<br />border: 0px solid #0193c2;<br />color: #ffffff;<br />font-weight: bold;<br />}</code></pre>\n<!-- /wp:code --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">poor service</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ratemybodypart/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/aedaa96cadca7e7d2ec92f39376ee26e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/aedaa96cadca7e7d2ec92f39376ee26e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ratemybodypart/\" class=\"reviewer-name\">ratemybodypart</a> on <span class=\"review-date\">August 18, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Been in contact with them but got no reply. i like the Plugin but the customer service is abyssmal. looking at the stats, 97 out of 325 cases resolved. thats p*ss poor effort</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Do not waste time even testing it ... won&#039;t work</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/asif_rn/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/aa1dd66c5f9c9bf526fa89cb9f2edb8f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/aa1dd66c5f9c9bf526fa89cb9f2edb8f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/asif_rn/\" class=\"reviewer-name\">Asif <small>(asif_rn)</small></a> on <span class=\"review-date\">August 9, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Unnecessarily complex and does not in most cases. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">ReCaptcha</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/micro-design/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c0286ff497e63efc84dcea796975e8b4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c0286ff497e63efc84dcea796975e8b4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/micro-design/\" class=\"reviewer-name\">Martin Tonev <small>(micro-design)</small></a> on <span class=\"review-date\">August 3, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p class=\"\">Unbelivable stupid ReCaptch integration, why you require to use only Invisible Recaptcha ??? <br /><br />I want to use the checkbox because with the invisible all messages are SPAM no matter what I write!!!!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great plugin!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/katarinawp90/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f68d8f4282aacc918aa3ec34a83b1d4b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f68d8f4282aacc918aa3ec34a83b1d4b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/katarinawp90/\" class=\"reviewer-name\">Katarina <small>(katarinawp90)</small></a> on <span class=\"review-date\">June 28, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Working excellent with Elementor, Flamingo and Honeypot.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Contact Form 7 does not meet expectations</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/sherlockclubcom/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/b21ab40b20c8f6842a38b9f07f45205b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/b21ab40b20c8f6842a38b9f07f45205b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/sherlockclubcom/\" class=\"reviewer-name\">sherlockclubcom</a> on <span class=\"review-date\">June 19, 2023</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Contact Form 7 does not meet expectations</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.zip\";s:11:\"screenshots\";a:1:{i:1;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\";s:7:\"caption\";s:16:\"screenshot-1.png\";}}s:4:\"tags\";a:5:{s:7:\"contact\";s:7:\"contact\";s:12:\"contact-form\";s:12:\"contact form\";s:5:\"email\";s:5:\"email\";s:8:\"feedback\";s:8:\"feedback\";s:4:\"form\";s:4:\"form\";}s:8:\"versions\";a:174:{s:3:\"1.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.1.zip\";s:4:\"1.10\";s:62:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.zip\";s:8:\"1.10.0.1\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.0.1.zip\";s:6:\"1.10.1\";s:64:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.1.zip\";s:3:\"1.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.2.zip\";s:3:\"1.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.zip\";s:5:\"1.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.1.zip\";s:5:\"1.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.2.zip\";s:3:\"1.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.zip\";s:5:\"1.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.1.zip\";s:5:\"1.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.2.zip\";s:5:\"1.4.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.3.zip\";s:5:\"1.4.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.4.zip\";s:3:\"1.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.5.zip\";s:3:\"1.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.6.zip\";s:5:\"1.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.6.1.zip\";s:3:\"1.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.zip\";s:5:\"1.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.1.zip\";s:5:\"1.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.2.zip\";s:5:\"1.7.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.4.zip\";s:5:\"1.7.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.5.zip\";s:5:\"1.7.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.6.zip\";s:7:\"1.7.6.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.6.1.zip\";s:5:\"1.7.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.7.zip\";s:7:\"1.7.7.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.7.1.zip\";s:5:\"1.7.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.8.zip\";s:3:\"1.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.zip\";s:7:\"1.8.0.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.1.zip\";s:7:\"1.8.0.2\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.2.zip\";s:7:\"1.8.0.3\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.3.zip\";s:7:\"1.8.0.4\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.4.zip\";s:5:\"1.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.1.zip\";s:7:\"1.8.1.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.1.1.zip\";s:3:\"1.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.zip\";s:5:\"1.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.1.zip\";s:5:\"1.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.zip\";s:7:\"1.9.2.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.1.zip\";s:7:\"1.9.2.2\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.2.zip\";s:5:\"1.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.3.zip\";s:5:\"1.9.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.4.zip\";s:5:\"1.9.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.5.zip\";s:7:\"1.9.5.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.5.1.zip\";s:3:\"2.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.zip\";s:8:\"2.0-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0-beta.zip\";s:5:\"2.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.1.zip\";s:5:\"2.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.2.zip\";s:5:\"2.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.3.zip\";s:5:\"2.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.4.zip\";s:5:\"2.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.5.zip\";s:5:\"2.0.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.6.zip\";s:5:\"2.0.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.7.zip\";s:3:\"2.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.zip\";s:5:\"2.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.1.zip\";s:5:\"2.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.2.zip\";s:3:\"2.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.2.zip\";s:5:\"2.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.2.1.zip\";s:3:\"2.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.3.zip\";s:5:\"2.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.3.1.zip\";s:3:\"2.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.zip\";s:5:\"2.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.1.zip\";s:5:\"2.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.2.zip\";s:5:\"2.4.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.3.zip\";s:5:\"2.4.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.4.zip\";s:5:\"2.4.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.5.zip\";s:5:\"2.4.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.6.zip\";s:3:\"3.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.zip\";s:8:\"3.0-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0-beta.zip\";s:5:\"3.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.1.zip\";s:5:\"3.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.2.zip\";s:7:\"3.0.2.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.2.1.zip\";s:3:\"3.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.zip\";s:5:\"3.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.1.zip\";s:5:\"3.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.2.zip\";s:3:\"3.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.2.zip\";s:5:\"3.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.2.1.zip\";s:3:\"3.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.zip\";s:5:\"3.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.1.zip\";s:5:\"3.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.2.zip\";s:5:\"3.3.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.3.zip\";s:3:\"3.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.zip\";s:5:\"3.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.1.zip\";s:5:\"3.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.2.zip\";s:3:\"3.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.zip\";s:5:\"3.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.1.zip\";s:5:\"3.5.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.2.zip\";s:5:\"3.5.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.3.zip\";s:5:\"3.5.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.4.zip\";s:3:\"3.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.6.zip\";s:3:\"3.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.zip\";s:5:\"3.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.1.zip\";s:5:\"3.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.2.zip\";s:3:\"3.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.8.zip\";s:5:\"3.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.8.1.zip\";s:3:\"3.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.zip\";s:8:\"3.9-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9-beta.zip\";s:5:\"3.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.1.zip\";s:5:\"3.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.2.zip\";s:5:\"3.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.3.zip\";s:3:\"4.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.zip\";s:5:\"4.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.1.zip\";s:5:\"4.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.2.zip\";s:5:\"4.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.3.zip\";s:3:\"4.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.zip\";s:8:\"4.1-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1-beta.zip\";s:5:\"4.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.1.zip\";s:5:\"4.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.2.zip\";s:3:\"4.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.zip\";s:8:\"4.2-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2-beta.zip\";s:5:\"4.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.1.zip\";s:5:\"4.2.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.2.zip\";s:3:\"4.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.zip\";s:5:\"4.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.1.zip\";s:3:\"4.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.zip\";s:5:\"4.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.1.zip\";s:5:\"4.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.2.zip\";s:3:\"4.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.5.zip\";s:5:\"4.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.5.1.zip\";s:3:\"4.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.zip\";s:5:\"4.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.1.zip\";s:3:\"4.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.7.zip\";s:3:\"4.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.8.zip\";s:5:\"4.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.8.1.zip\";s:3:\"4.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.zip\";s:5:\"4.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.1.zip\";s:5:\"4.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.2.zip\";s:3:\"5.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.zip\";s:5:\"5.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.1.zip\";s:5:\"5.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.2.zip\";s:5:\"5.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.3.zip\";s:5:\"5.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.4.zip\";s:5:\"5.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.5.zip\";s:3:\"5.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.zip\";s:5:\"5.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.1.zip\";s:5:\"5.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.2.zip\";s:5:\"5.1.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.3.zip\";s:5:\"5.1.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.4.zip\";s:5:\"5.1.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.5.zip\";s:5:\"5.1.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.6.zip\";s:5:\"5.1.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.7.zip\";s:5:\"5.1.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.8.zip\";s:5:\"5.1.9\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.9.zip\";s:3:\"5.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.zip\";s:5:\"5.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.1.zip\";s:5:\"5.2.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.2.zip\";s:3:\"5.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.zip\";s:5:\"5.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.1.zip\";s:5:\"5.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.2.zip\";s:3:\"5.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.zip\";s:5:\"5.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.1.zip\";s:5:\"5.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.2.zip\";s:3:\"5.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.zip\";s:5:\"5.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.1.zip\";s:5:\"5.5.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.2.zip\";s:5:\"5.5.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.3.zip\";s:5:\"5.5.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.4.zip\";s:5:\"5.5.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.5.zip\";s:5:\"5.5.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.6.zip\";s:7:\"5.5.6.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.6.1.zip\";s:3:\"5.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.zip\";s:5:\"5.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.1.zip\";s:5:\"5.6.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.2.zip\";s:5:\"5.6.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.3.zip\";s:5:\"5.6.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.4.zip\";s:3:\"5.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.zip\";s:5:\"5.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.1.zip\";s:5:\"5.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.2.zip\";s:5:\"5.7.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.3.zip\";s:5:\"5.7.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.4.zip\";s:5:\"5.7.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.5.zip\";s:7:\"5.7.5.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.5.1.zip\";s:5:\"5.7.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.6.zip\";s:5:\"5.7.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.7.zip\";s:3:\"5.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.zip\";s:5:\"trunk\";s:57:\"https://downloads.wordpress.org/plugin/contact-form-7.zip\";}s:11:\"donate_link\";s:32:\"https://contactform7.com/donate/\";s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";s:4:\"high\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";}}}","no");
INSERT INTO wp_options VALUES("1375","_site_transient_avada_addons_json","{\"418947\":{\"post_title\":\"Custom Search Element\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2021\\/04\\/custom_search_880_660.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2021\\/04\\/imgpsh_fullsize_anim.jpeg\",\"plugin_name\":\"Custom Search Element\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/custom-search-element-for-avada-builder\\/31213422?ref=ThemeFusion\",\"new\":false,\"date\":1618918239},\"416560\":{\"post_title\":\"Custom Field Element\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/08\\/custom_fields_element.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/08\\/custom_fields_element.jpg\",\"plugin_name\":\"Custom Field Element\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/custom-field-element-for-fusion-builder\\/22247344?ref=ThemeFusion\",\"new\":false,\"date\":1533635113},\"416071\":{\"post_title\":\"Elegant Elements\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/elegant_elements.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/elegant_elements.jpg\",\"plugin_name\":\"Elegant Elements\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/elegant-elements-for-fusion-builder\\/21113424?ref=ThemeFusion\",\"new\":false,\"date\":1513943064},\"415029\":{\"post_title\":\"Custom Post Types and Taxonomies\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/35815191-ee7402b4-0a65-11e8-8c17-78079117d5b4.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/35815191-ee7402b4-0a65-11e8-8c17-78079117d5b4.jpg\",\"plugin_name\":\"Fusion Builder Custom Post Types and Taxonomies\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/custom-post-types-and-taxonomies-for-fusion-builder\\/15572585?ref=ThemeFusion\",\"new\":false,\"date\":1479378733},\"415031\":{\"post_title\":\"Elegant Tabs\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/elegant_tabs.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/11\\/elegant_tabs.jpg\",\"plugin_name\":\"Elegant Tabs for Fusion Builder\",\"description\":\"\",\"url\":\"https:\\/\\/codecanyon.net\\/item\\/elegant-tabs-for-fusion-builder\\/18795917?ref=ThemeFusion\",\"new\":false,\"date\":1479292408},\"415041\":{\"post_title\":\"Coming Soon\",\"thumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/10\\/coming_soon.jpg\",\"retinaThumbnail\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/10\\/coming_soon.jpg\",\"plugin_name\":null,\"description\":\"\",\"url\":\"https:\\/\\/themeforest.net\\/item\\/avada-responsive-multipurpose-theme\\/2833226?ref=ThemeFusion\",\"new\":false,\"date\":1475330672}}","no");
INSERT INTO wp_options VALUES("1377","fusion_core_version","5.10.1","yes");
INSERT INTO wp_options VALUES("1378","widget_ad_125_125-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1379","widget_fusion_author-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1380","widget_contact_info-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1381","widget_pyre_tabs-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1382","widget_recent_works-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1383","widget_tweets-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1384","widget_flickr-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1385","widget_social_links-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1386","widget_facebook-like-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1387","widget_menu-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1388","widget_avada-vertical-menu-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1389","widget_form-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1390","fusion_core_flush_permalinks","1","yes");
INSERT INTO wp_options VALUES("1399","fusion_builder_version","3.10.1","yes");
INSERT INTO wp_options VALUES("1408","fusion_form_cleanup_datetime","1697876348","yes");
INSERT INTO wp_options VALUES("1419","leadin_activation_time","1695261767","yes");
INSERT INTO wp_options VALUES("1420","fusion_demo_history","a:1:{s:10:\"psychology\";a:11:{s:24:\"fusion_tb_layout_default\";b:0;s:5:\"terms\";a:8:{i:0;a:2:{s:7:\"term_id\";i:2;s:8:\"taxonomy\";s:8:\"category\";}i:1;a:2:{s:7:\"term_id\";i:3;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:2;a:2:{s:7:\"term_id\";i:4;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:3;a:2:{s:7:\"term_id\";i:5;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:4;a:2:{s:7:\"term_id\";i:6;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:5;a:2:{s:7:\"term_id\";i:7;s:8:\"taxonomy\";s:16:\"element_category\";}i:6;a:2:{s:7:\"term_id\";i:8;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:7;a:2:{s:7:\"term_id\";i:9;s:8:\"taxonomy\";s:8:\"nav_menu\";}}s:13:\"theme_options\";b:0;s:7:\"widgets\";a:30:{i:0;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1378\";s:11:\"option_name\";s:24:\"widget_ad_125_125-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:1;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"108\";s:11:\"option_name\";s:15:\"widget_archives\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:2;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1388\";s:11:\"option_name\";s:33:\"widget_avada-vertical-menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:3;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"103\";s:11:\"option_name\";s:12:\"widget_block\";s:12:\"option_value\";s:890:\"a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:4;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"107\";s:11:\"option_name\";s:15:\"widget_calendar\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:5;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"76\";s:11:\"option_name\";s:17:\"widget_categories\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:6;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1380\";s:11:\"option_name\";s:26:\"widget_contact_info-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:7;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"119\";s:11:\"option_name\";s:18:\"widget_custom_html\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:8;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1386\";s:11:\"option_name\";s:27:\"widget_facebook-like-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:9;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1384\";s:11:\"option_name\";s:20:\"widget_flickr-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:10;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1389\";s:11:\"option_name\";s:18:\"widget_form-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:11;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1379\";s:11:\"option_name\";s:27:\"widget_fusion_author-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:12;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"109\";s:11:\"option_name\";s:18:\"widget_media_audio\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:13;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"111\";s:11:\"option_name\";s:20:\"widget_media_gallery\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:14;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"110\";s:11:\"option_name\";s:18:\"widget_media_image\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:15;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"112\";s:11:\"option_name\";s:18:\"widget_media_video\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:16;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1387\";s:11:\"option_name\";s:18:\"widget_menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:17;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"113\";s:11:\"option_name\";s:11:\"widget_meta\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:18;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"118\";s:11:\"option_name\";s:15:\"widget_nav_menu\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:19;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"106\";s:11:\"option_name\";s:12:\"widget_pages\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:20;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1381\";s:11:\"option_name\";s:23:\"widget_pyre_tabs-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:21;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1382\";s:11:\"option_name\";s:26:\"widget_recent_works-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:22;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"116\";s:11:\"option_name\";s:22:\"widget_recent-comments\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:23;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"115\";s:11:\"option_name\";s:19:\"widget_recent-posts\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:24;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"78\";s:11:\"option_name\";s:10:\"widget_rss\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:25;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"114\";s:11:\"option_name\";s:13:\"widget_search\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:26;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1385\";s:11:\"option_name\";s:26:\"widget_social_links-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:27;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"117\";s:11:\"option_name\";s:16:\"widget_tag_cloud\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:28;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"77\";s:11:\"option_name\";s:11:\"widget_text\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:29;O:8:\"stdClass\":4:{s:9:\"option_id\";s:4:\"1383\";s:11:\"option_name\";s:20:\"widget_tweets-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}}s:16:\"sidebars_widgets\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:21:\"avada-footer-widget-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:13:\"array_version\";i:3;}s:12:\"sbg_sidebars\";b:0;s:8:\"blogname\";s:33:\"Building Bridges Behavior Therapy\";s:13:\"page_on_front\";s:1:\"0\";s:13:\"show_on_front\";s:5:\"posts\";s:18:\"nav_menu_locations\";a:0:{}s:12:\"general_data\";s:8:\"imported\";}}","no");
INSERT INTO wp_options VALUES("1421","fusion_import_data","a:17:{s:4:\"post\";a:1:{i:0;s:10:\"psychology\";}s:4:\"page\";a:1:{i:0;s:10:\"psychology\";}s:15:\"avada_portfolio\";a:0:{}s:9:\"avada_faq\";a:0:{}s:12:\"avada_layout\";a:1:{i:0;s:10:\"psychology\";}s:12:\"fusion_icons\";a:1:{i:0;s:10:\"psychology\";}s:10:\"attachment\";a:1:{i:0;s:10:\"psychology\";}s:7:\"product\";a:0:{}s:5:\"event\";a:0:{}s:5:\"forum\";a:0:{}s:7:\"sliders\";a:1:{i:0;s:10:\"psychology\";}s:7:\"widgets\";a:1:{i:0;s:10:\"psychology\";}s:13:\"theme_options\";a:1:{i:0;s:10:\"psychology\";}s:11:\"convertplug\";a:0:{}s:12:\"general_data\";a:1:{i:0;s:10:\"psychology\";}s:3:\"all\";a:1:{i:0;s:10:\"psychology\";}s:11:\"fusion_form\";a:1:{i:0;s:10:\"psychology\";}}","no");
INSERT INTO wp_options VALUES("1422","fusion_tb_layout_default","{\\\"conditions\\\":[],\\\"template_terms\\\":{\\\"footer\\\":\\\"712\\\",\\\"header\\\":\\\"1338\\\"}}","yes");
INSERT INTO wp_options VALUES("1423","wp_calendar_block_has_published_posts","1","yes");
INSERT INTO wp_options VALUES("1424","category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1425","fusion_tb_category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1426","portfolio_category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1427","portfolio_skills_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1428","faq_category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1429","slide-page_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1430","element_category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1431","template_category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1433","fusion_options","a:1033:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"wide\";s:10:\"site_width\";s:6:\"1300px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:0:\"\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:4:\"60px\";s:6:\"bottom\";s:4:\"60px\";}s:13:\"page_template\";s:10:\"site_width\";s:16:\"hundredp_padding\";s:4:\"30px\";s:13:\"sidebar_width\";s:3:\"24{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:14:\"sidebar_gutter\";s:2:\"6{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:17:\"sidebar_2_1_width\";s:3:\"20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:17:\"sidebar_2_2_width\";s:3:\"20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:19:\"dual_sidebar_gutter\";s:2:\"4{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1000\";s:23:\"side_header_break_point\";s:3:\"800\";s:19:\"content_break_point\";s:3:\"800\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:16:\"visibility_small\";s:3:\"700\";s:17:\"visibility_medium\";s:4:\"1177\";s:22:\"typography_sensitivity\";s:4:\"0.00\";s:17:\"typography_factor\";s:4:\"1.50\";s:13:\"color_palette\";a:9:{s:6:\"color1\";a:2:{s:5:\"label\";s:7:\"Color 1\";s:5:\"color\";s:7:\"#ffffff\";}s:6:\"color2\";a:2:{s:5:\"label\";s:7:\"Color 2\";s:5:\"color\";s:7:\"#fbf7f3\";}s:6:\"color3\";a:2:{s:5:\"label\";s:7:\"Color 3\";s:5:\"color\";s:7:\"#f2f3f5\";}s:6:\"color4\";a:2:{s:5:\"label\";s:7:\"Color 4\";s:5:\"color\";s:7:\"#e2e2e2\";}s:6:\"color5\";a:2:{s:5:\"label\";s:7:\"Color 5\";s:5:\"color\";s:7:\"#a66d3f\";}s:6:\"color6\";a:2:{s:5:\"label\";s:7:\"Color 6\";s:5:\"color\";s:7:\"#4a4e57\";}s:6:\"color7\";a:2:{s:5:\"label\";s:7:\"Color 7\";s:5:\"color\";s:7:\"#004c4c\";}s:6:\"color8\";a:2:{s:5:\"label\";s:7:\"Color 8\";s:5:\"color\";s:7:\"#212934\";}s:8:\"custom10\";a:2:{s:5:\"label\";s:9:\"Custom 10\";s:5:\"color\";s:20:\"rgba(166,109,63,0.8)\";}}s:13:\"primary_color\";s:17:\"var(--awb-color7)\";s:15:\"header_position\";s:3:\"top\";s:13:\"header_layout\";s:2:\"v3\";s:15:\"slider_position\";s:5:\"below\";s:19:\"header_left_content\";s:12:\"social_links\";s:20:\"header_right_content\";s:10:\"navigation\";s:17:\"header_v4_content\";s:18:\"tagline_and_search\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:39:\"info@buildingbridgesbehaviortherapy.com\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"1\";s:16:\"header_bg_repeat\";s:9:\"no-repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"header_bg_color\";s:17:\"var(--awb-color1)\";s:23:\"archive_header_bg_color\";s:17:\"var(--awb-color1)\";s:19:\"header_border_color\";s:19:\"rgba(226,226,226,0)\";s:19:\"header_top_bg_color\";s:17:\"var(--awb-color7)\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 44{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:13:\"header_sticky\";s:1:\"1\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"0\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:20:\"header_sticky_shadow\";s:1:\"1\";s:22:\"header_sticky_bg_color\";s:17:\"var(--awb-color1)\";s:24:\"header_sticky_menu_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 69{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:25:\"header_sticky_nav_padding\";s:2:\"35\";s:27:\"header_sticky_nav_font_size\";s:4:\"14px\";s:10:\"nav_height\";s:2:\"84\";s:20:\"menu_highlight_style\";s:3:\"bar\";s:25:\"menu_highlight_background\";s:17:\"var(--awb-color5)\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"3\";s:11:\"nav_padding\";s:2:\"48\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:15:\"megamenu_shadow\";s:1:\"1\";s:28:\"main_menu_sub_menu_animation\";s:4:\"fade\";s:29:\"dropdown_menu_top_border_size\";s:1:\"3\";s:19:\"dropdown_menu_width\";s:3:\"200\";s:34:\"mainmenu_dropdown_vertical_padding\";s:2:\"12\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"0\";s:31:\"menu_display_dropdown_indicator\";s:4:\"none\";s:20:\"main_nav_search_icon\";s:1:\"1\";s:22:\"main_nav_search_layout\";s:7:\"overlay\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"2px\";s:17:\"menu_sub_bg_color\";s:17:\"var(--awb-color2)\";s:19:\"menu_bg_hover_color\";s:17:\"var(--awb-color2)\";s:18:\"menu_sub_sep_color\";s:19:\"rgba(226,226,226,0)\";s:17:\"menu_h45_bg_color\";s:17:\"var(--awb-color1)\";s:14:\"nav_typography\";a:8:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"14px\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:15:\"menu_text_align\";s:6:\"center\";s:22:\"menu_hover_first_color\";s:17:\"var(--awb-color5)\";s:14:\"menu_sub_color\";s:17:\"var(--awb-color7)\";s:22:\"nav_dropdown_font_size\";s:4:\"14px\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"32\";s:22:\"flyout_menu_icon_color\";s:17:\"var(--awb-color8)\";s:28:\"flyout_menu_icon_hover_color\";s:17:\"var(--awb-color5)\";s:28:\"flyout_menu_background_color\";s:98:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc( var(--awb-color1-a) - 4{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:24:\"flyout_menu_item_padding\";s:2:\"32\";s:23:\"topmenu_dropwdown_width\";s:3:\"200\";s:29:\"header_top_first_border_color\";s:113:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 89{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),calc( var(--awb-color4-a) - 94{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:23:\"header_top_sub_bg_color\";s:17:\"var(--awb-color1)\";s:30:\"header_top_menu_bg_hover_color\";s:17:\"var(--awb-color3)\";s:29:\"header_top_menu_sub_sep_color\";s:17:\"var(--awb-color4)\";s:14:\"snav_font_size\";s:4:\"12px\";s:11:\"sec_menu_lh\";s:4:\"48px\";s:10:\"snav_color\";s:17:\"var(--awb-color1)\";s:25:\"header_top_menu_sub_color\";s:17:\"var(--awb-color6)\";s:31:\"header_top_menu_sub_hover_color\";s:17:\"var(--awb-color5)\";s:18:\"mobile_menu_design\";s:7:\"classic\";s:28:\"mobile_menu_icons_top_margin\";s:1:\"2\";s:22:\"mobile_menu_nav_height\";s:2:\"42\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:18:\"mobile_menu_search\";s:1:\"1\";s:29:\"mobile_menu_submenu_indicator\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:17:\"var(--awb-color1)\";s:30:\"mobile_archive_header_bg_color\";s:17:\"var(--awb-color1)\";s:28:\"mobile_menu_background_color\";s:17:\"var(--awb-color2)\";s:23:\"mobile_menu_hover_color\";s:17:\"var(--awb-color5)\";s:24:\"mobile_menu_border_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"mobile_menu_toggle_color\";s:17:\"var(--awb-color7)\";s:22:\"mobile_menu_typography\";a:9:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"42px\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:28:\"mobile_menu_font_hover_color\";s:17:\"var(--awb-color1)\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:14:\"megamenu_width\";s:10:\"site_width\";s:18:\"megamenu_max_width\";s:4:\"1200\";s:31:\"megamenu_interior_content_width\";s:14:\"viewport_width\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"7\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"14\";s:15:\"menu_icon_color\";s:17:\"var(--awb-color7)\";s:21:\"menu_icon_hover_color\";s:17:\"var(--awb-color5)\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"14px\";}s:14:\"logo_alignment\";s:4:\"left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"31px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:17:\"var(--awb-color5)\";s:16:\"logo_custom_link\";s:0:\"\";s:4:\"logo\";a:5:{s:3:\"url\";s:87:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2023/09/BBBT-logo.png\";s:2:\"id\";s:4:\"1963\";s:6:\"height\";s:2:\"60\";s:5:\"width\";s:3:\"313\";s:9:\"thumbnail\";s:94:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2023/09/BBBT-logo-150x60.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:87:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2023/09/BBBT-logo.png\";s:2:\"id\";s:4:\"1963\";s:6:\"height\";s:2:\"60\";s:5:\"width\";s:3:\"313\";s:9:\"thumbnail\";s:94:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2023/09/BBBT-logo-150x60.png\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:87:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2023/09/BBBT-logo.png\";s:2:\"id\";s:4:\"1963\";s:6:\"height\";s:2:\"60\";s:5:\"width\";s:3:\"313\";s:9:\"thumbnail\";s:94:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2023/09/BBBT-logo-150x60.png\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:8:\"fav_icon\";a:5:{s:3:\"url\";s:100:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2020/10/logo-psychology-mark2x.png\";s:2:\"id\";s:3:\"736\";s:6:\"height\";s:2:\"76\";s:5:\"width\";s:2:\"74\";s:9:\"thumbnail\";s:100:\"https://www.buildingbridgesbehaviortherapy.com/wp-content/uploads/2020/10/logo-psychology-mark2x.png\";}s:20:\"fav_icon_apple_touch\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"fav_icon_android\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:13:\"fav_icon_edge\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:4:\"hide\";s:17:\"page_title_bar_bs\";s:11:\"breadcrumbs\";s:19:\"page_title_bar_text\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:5:\"300px\";s:24:\"page_title_mobile_height\";s:5:\"240px\";s:19:\"page_title_bg_color\";s:17:\"var(--awb-color3)\";s:23:\"page_title_border_color\";s:19:\"rgba(226,226,226,0)\";s:20:\"page_title_font_size\";s:4:\"54px\";s:22:\"page_title_line_height\";s:0:\"\";s:16:\"page_title_color\";s:17:\"var(--awb-color8)\";s:30:\"page_title_subheader_font_size\";s:4:\"18px\";s:26:\"page_title_subheader_color\";s:17:\"var(--awb-color6)\";s:20:\"page_title_alignment\";s:6:\"center\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"14px\";s:22:\"breadcrumbs_text_color\";s:17:\"var(--awb-color6)\";s:28:\"breadcrumbs_text_hover_color\";s:17:\"var(--awb-color5)\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:20:\"breadcrumb_show_leaf\";s:1:\"1\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:19:\"slidingbar_position\";s:3:\"top\";s:16:\"slidingbar_width\";s:5:\"300px\";s:17:\"slidingbar_sticky\";s:1:\"1\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:27:\"slidingbar_column_alignment\";s:7:\"stacked\";s:26:\"slidingbar_content_padding\";a:4:{s:3:\"top\";s:4:\"60px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"60px\";s:4:\"left\";s:4:\"30px\";}s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:6:\"circle\";s:19:\"slidingbar_bg_color\";s:17:\"var(--awb-color8)\";s:24:\"slidingbar_divider_color\";s:17:\"var(--awb-color6)\";s:28:\"slidingbar_toggle_icon_color\";s:17:\"var(--awb-color1)\";s:20:\"slidingbar_font_size\";s:4:\"14px\";s:25:\"slidingbar_headings_color\";s:17:\"var(--awb-color1)\";s:21:\"slidingbar_text_color\";s:99:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc( var(--awb-color1-a) - 40{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:21:\"slidingbar_link_color\";s:99:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc( var(--awb-color1-a) - 14{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:27:\"slidingbar_link_color_hover\";s:17:\"var(--awb-color1)\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"4\";s:29:\"footer_widgets_center_content\";s:1:\"0\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"0\";s:11:\"footer_text\";s:217:\"Copyright 2012 - 2020 | <a href=\"https://bit.ly/2YJkGCr\">Avada Website Builder</a> by <a href=\"https://theme-fusion.com\">ThemeFusion</a> | All Rights Reserved | Powered by <a href=\"https://wordpress.org\">WordPress</a>\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"0\";s:17:\"footerw_bg_repeat\";s:9:\"no-repeat\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:4:\"60px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"64px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:17:\"var(--awb-color7)\";s:18:\"footer_border_size\";s:1:\"0\";s:19:\"footer_border_color\";s:17:\"var(--awb-color4)\";s:19:\"footer_divider_line\";s:1:\"0\";s:24:\"footer_divider_line_size\";s:1:\"1\";s:25:\"footer_divider_line_style\";s:4:\"none\";s:20:\"footer_divider_color\";s:17:\"var(--awb-color6)\";s:22:\"footer_widgets_padding\";s:4:\"16px\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"20px\";}s:18:\"copyright_bg_color\";s:17:\"var(--awb-color7)\";s:21:\"copyright_border_size\";s:1:\"0\";s:22:\"copyright_border_color\";s:17:\"var(--awb-color6)\";s:26:\"footer_headings_typography\";a:9:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color1)\";}s:17:\"footer_text_color\";s:17:\"var(--awb-color1)\";s:17:\"footer_link_color\";s:99:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc( var(--awb-color1-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:23:\"footer_link_color_hover\";s:17:\"var(--awb-color1)\";s:20:\"copyright_text_color\";s:17:\"var(--awb-color1)\";s:20:\"copyright_link_color\";s:99:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc( var(--awb-color1-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:26:\"copyright_link_color_hover\";s:17:\"var(--awb-color1)\";s:19:\"copyright_font_size\";s:4:\"13px\";s:24:\"responsive_sidebar_order\";s:25:\"content,sidebar,sidebar-2\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:3:\"0px\";s:16:\"sidebar_bg_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"18px\";s:21:\"sidebar_heading_color\";s:17:\"var(--awb-color8)\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:13:\"posts_sidebar\";s:4:\"None\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"0\";s:21:\"blog_sidebar_position\";s:5:\"Right\";s:20:\"blog_archive_sidebar\";s:4:\"None\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:8:\"bg_color\";s:17:\"var(--awb-color4)\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:16:\"content_bg_color\";s:17:\"var(--awb-color1)\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:9:\"no-repeat\";s:15:\"typography_sets\";a:5:{s:11:\"typography1\";a:8:{s:5:\"label\";s:8:\"Headings\";s:11:\"font-family\";s:18:\"Cormorant Garamond\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"600\";s:9:\"font-size\";s:4:\"64px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography2\";a:8:{s:5:\"label\";s:11:\"Subheadings\";s:11:\"font-family\";s:9:\"Noto Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:3:\"1.8\";s:14:\"letter-spacing\";s:3:\"3px\";s:14:\"text-transform\";s:9:\"uppercase\";}s:11:\"typography3\";a:8:{s:5:\"label\";s:4:\"Lead\";s:11:\"font-family\";s:9:\"Noto Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography4\";a:8:{s:5:\"label\";s:4:\"Body\";s:11:\"font-family\";s:9:\"Noto Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"19px\";s:11:\"line-height\";s:1:\"2\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography5\";a:8:{s:5:\"label\";s:5:\"Small\";s:11:\"font-family\";s:9:\"Noto Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"1.72\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"body_typography\";a:8:{s:11:\"font-family\";s:34:\"var(--awb-typography4-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography4)\";s:9:\"font-size\";s:32:\"var(--awb-typography4-font-size)\";s:11:\"line-height\";s:34:\"var(--awb-typography4-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography4-letter-spacing)\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:10:\"link_color\";s:17:\"var(--awb-color7)\";s:16:\"link_hover_color\";s:17:\"var(--awb-color7)\";s:15:\"link_decoration\";s:1:\"0\";s:25:\"link_decoration_exclusion\";a:4:{i:0;s:7:\"buttons\";i:1;s:5:\"menus\";i:2;s:4:\"tocs\";i:3;s:11:\"tabstoggles\";}s:20:\"link_decoration_line\";s:4:\"none\";s:21:\"link_decoration_style\";s:5:\"solid\";s:25:\"link_decoration_thickness\";s:3:\"1px\";s:26:\"link_decoration_line_hover\";s:4:\"none\";s:27:\"link_decoration_style_hover\";s:5:\"solid\";s:31:\"link_decoration_thickness_hover\";s:3:\"1px\";s:13:\"h1_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:32:\"var(--awb-typography1-font-size)\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"0.67em\";s:13:\"margin-bottom\";s:6:\"0.67em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:13:\"h2_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"1.1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:13:\"h3_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"32px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:13:\"h4_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"28px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"1.33em\";s:13:\"margin-bottom\";s:6:\"1.33em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:13:\"h5_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"26px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"1.67em\";s:13:\"margin-bottom\";s:6:\"1.67em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:13:\"h6_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"2.33em\";s:13:\"margin-bottom\";s:6:\"2.33em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:21:\"post_title_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"32px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:29:\"post_titles_extras_typography\";a:9:{s:11:\"font-family\";s:9:\"Noto Sans\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:1:{i:0;s:0:\"\";}s:5:\"woff2\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:4:\"woff\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"ttf\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"eot\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"svg\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:14:\"adobe_fonts_id\";s:0:\"\";s:19:\"blog_page_title_bar\";s:15:\"bar_and_content\";s:24:\"blog_show_page_title_bar\";s:15:\"bar_and_content\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:5:\"large\";s:19:\"blog_archive_layout\";s:4:\"grid\";s:20:\"blog_pagination_type\";s:10:\"pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:99:\"hsla(var(--awb-color3-h),var(--awb-color3-s),var(--awb-color3-l),calc( var(--awb-color3-a) - 30{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:38:\"blog_load_more_posts_button_text_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 69{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:42:\"blog_load_more_posts_hover_button_bg_color\";s:99:\"hsla(var(--awb-color3-h),var(--awb-color3-s),var(--awb-color3-l),calc( var(--awb-color3-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:44:\"blog_load_more_posts_hover_button_text_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 69{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:25:\"blog_archive_grid_columns\";s:1:\"2\";s:32:\"blog_archive_grid_column_spacing\";s:2:\"80\";s:18:\"blog_equal_heights\";s:1:\"1\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"40px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:4:\"25px\";}s:21:\"blog_layout_alignment\";s:0:\"\";s:14:\"content_length\";s:4:\"hide\";s:19:\"excerpt_length_blog\";s:2:\"10\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:15:\"dates_box_color\";s:17:\"var(--awb-color3)\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"0\";s:22:\"featured_images_single\";s:1:\"1\";s:11:\"blog_pn_nav\";s:1:\"1\";s:15:\"blog_post_title\";s:5:\"below\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:18:\"social_sharing_box\";s:1:\"1\";s:11:\"author_info\";s:1:\"1\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"1\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"1\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"0\";s:14:\"post_meta_read\";s:1:\"0\";s:14:\"post_meta_tags\";s:1:\"0\";s:14:\"meta_font_size\";s:4:\"13px\";s:11:\"date_format\";s:0:\"\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"1\";s:32:\"portfolio_archive_column_spacing\";s:2:\"20\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:2:\"10\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:2:\"10\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:10:\"pagination\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:99:\"hsla(var(--awb-color3-h),var(--awb-color3-s),var(--awb-color3-l),calc( var(--awb-color3-a) - 30{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:51:\"portfolio_archive_load_more_posts_button_text_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 69{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:55:\"portfolio_archive_load_more_posts_hover_button_bg_color\";s:99:\"hsla(var(--awb-color3-h),var(--awb-color3-s),var(--awb-color3-l),calc( var(--awb-color3-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:57:\"portfolio_archive_load_more_posts_hover_button_text_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 69{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:14:\"portfolio_slug\";s:15:\"portfolio-items\";s:24:\"portfolio_meta_font_size\";s:4:\"13px\";s:16:\"portfolio_pn_nav\";s:1:\"1\";s:19:\"portfolio_width_100\";s:1:\"0\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:25:\"show_first_featured_image\";s:1:\"0\";s:28:\"portfolio_project_desc_title\";s:1:\"1\";s:25:\"portfolio_project_details\";s:1:\"1\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"1\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:18:\"portfolio_comments\";s:1:\"0\";s:18:\"social_media_icons\";a:6:{s:25:\"fusionredux_repeater_data\";a:4:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:4:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:9:\"instagram\";i:3;s:9:\"pinterest\";}s:9:\"icon_mark\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:3:\"url\";a:4:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";}s:12:\"custom_title\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:13:\"custom_source\";a:4:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:3;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:17:\"var(--awb-color1)\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:17:\"var(--awb-color1)\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"1\";s:29:\"footer_social_links_font_size\";s:4:\"16px\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:17:\"var(--awb-color7)\";s:25:\"footer_social_links_boxed\";s:1:\"0\";s:29:\"footer_social_links_box_color\";s:17:\"var(--awb-color1)\";s:32:\"footer_social_links_boxed_radius\";s:3:\"4px\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:39:\"Share This Story, Choose Your Platform!\";s:30:\"sharing_box_tagline_text_color\";s:17:\"var(--awb-color8)\";s:15:\"social_bg_color\";s:17:\"var(--awb-color3)\";s:22:\"social_sharing_padding\";a:4:{s:3:\"top\";s:6:\"1.25em\";s:5:\"right\";s:6:\"1.25em\";s:6:\"bottom\";s:6:\"1.25em\";s:4:\"left\";s:6:\"1.25em\";}s:14:\"social_sharing\";a:10:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:6:\"reddit\";i:3;s:8:\"linkedin\";i:4;s:8:\"whatsapp\";i:5;s:6:\"tumblr\";i:6;s:9:\"pinterest\";i:7;s:2:\"vk\";i:8;s:4:\"xing\";i:9;s:5:\"email\";}s:30:\"sharing_social_links_font_size\";s:4:\"16px\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:99:\"hsla(var(--awb-color6-h),var(--awb-color6-s),var(--awb-color6-l),calc( var(--awb-color6-a) - 40{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:26:\"sharing_social_links_boxed\";s:1:\"0\";s:30:\"sharing_social_links_box_color\";s:98:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) + 2{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"4px\";s:34:\"sharing_social_links_boxed_padding\";s:3:\"8px\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"0\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"30px\";s:6:\"height\";s:4:\"30px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:6:\"height\";s:5:\"400px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:17:\"var(--awb-color8)\";s:16:\"es_caption_color\";s:17:\"var(--awb-color6)\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-white\";s:13:\"lightbox_path\";s:8:\"vertical\";s:24:\"lightbox_animation_speed\";s:6:\"normal\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:3:\"0.9\";s:14:\"lightbox_title\";s:1:\"1\";s:13:\"lightbox_desc\";s:1:\"1\";s:15:\"lightbox_social\";s:1:\"1\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:17:\"form_input_height\";s:4:\"50px\";s:14:\"form_text_size\";s:4:\"16px\";s:13:\"form_bg_color\";s:17:\"var(--awb-color1)\";s:15:\"form_text_color\";s:99:\"hsla(var(--awb-color6-h),var(--awb-color6-s),var(--awb-color6-l),calc( var(--awb-color6-a) - 40{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:17:\"form_border_width\";a:4:{s:3:\"top\";s:3:\"1px\";s:5:\"right\";s:3:\"1px\";s:6:\"bottom\";s:3:\"1px\";s:4:\"left\";s:3:\"1px\";}s:17:\"form_border_color\";s:17:\"var(--awb-color4)\";s:23:\"form_focus_border_color\";s:17:\"var(--awb-color5)\";s:18:\"form_border_radius\";s:1:\"6\";s:19:\"form_views_counting\";s:3:\"all\";s:17:\"recaptcha_version\";s:2:\"v3\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:15:\"recaptcha_score\";s:3:\"0.5\";s:24:\"recaptcha_badge_position\";s:6:\"inline\";s:20:\"recaptcha_login_form\";s:1:\"0\";s:11:\"hubspot_api\";s:3:\"off\";s:11:\"hubspot_key\";s:0:\"\";s:13:\"mailchimp_api\";s:3:\"off\";s:13:\"mailchimp_key\";s:0:\"\";s:13:\"email_address\";s:0:\"\";s:24:\"contact_comment_position\";s:5:\"below\";s:29:\"contact_form_privacy_checkbox\";s:1:\"0\";s:26:\"contact_form_privacy_label\";s:152:\"By checking this box, you confirm that you have read and are agreeing to our terms of use regarding the storage of the data submitted through this form.\";s:8:\"gmap_api\";s:0:\"\";s:13:\"gmap_api_type\";s:2:\"js\";s:18:\"gmap_embed_address\";s:0:\"\";s:19:\"gmap_embed_map_type\";s:7:\"roadmap\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:17:\"var(--awb-color5)\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"map_infobox_text_color\";s:17:\"var(--awb-color1)\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:21:\"search_filter_results\";s:1:\"0\";s:14:\"search_content\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";}s:27:\"search_limit_to_post_titles\";s:1:\"0\";s:18:\"search_form_design\";s:5:\"clean\";s:11:\"live_search\";s:1:\"0\";s:26:\"live_search_min_char_count\";s:1:\"4\";s:28:\"live_search_results_per_page\";s:3:\"100\";s:26:\"live_search_results_height\";s:3:\"250\";s:34:\"live_search_display_featured_image\";s:1:\"1\";s:29:\"live_search_display_post_type\";s:1:\"1\";s:13:\"search_layout\";s:4:\"grid\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_pagination_type\";s:10:\"pagination\";s:19:\"search_grid_columns\";s:1:\"3\";s:26:\"search_grid_column_spacing\";s:2:\"40\";s:21:\"search_content_length\";s:7:\"excerpt\";s:21:\"search_excerpt_length\";s:2:\"10\";s:25:\"search_strip_html_excerpt\";s:1:\"1\";s:22:\"search_featured_images\";s:1:\"1\";s:11:\"search_meta\";a:5:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:9:\"read_more\";}s:26:\"search_new_search_position\";s:3:\"top\";s:18:\"gfonts_load_method\";s:5:\"local\";s:14:\"privacy_embeds\";s:1:\"0\";s:14:\"privacy_expiry\";s:2:\"30\";s:19:\"privacy_embed_types\";a:8:{i:0;s:7:\"youtube\";i:1;s:5:\"vimeo\";i:2;s:10:\"soundcloud\";i:3;s:8:\"facebook\";i:4;s:6:\"flickr\";i:5;s:7:\"twitter\";i:6;s:5:\"gmaps\";i:7;s:8:\"tracking\";}s:22:\"privacy_embed_defaults\";a:0:{}s:16:\"privacy_bg_color\";s:113:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 89{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),calc( var(--awb-color4-a) - 90{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:13:\"privacy_color\";s:113:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 89{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),calc( var(--awb-color4-a) - 70{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:11:\"privacy_bar\";s:1:\"0\";s:19:\"privacy_bar_padding\";a:4:{s:3:\"top\";s:4:\"15px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"15px\";s:4:\"left\";s:4:\"30px\";}s:20:\"privacy_bar_bg_color\";s:17:\"var(--awb-color6)\";s:21:\"privacy_bar_font_size\";s:4:\"13px\";s:17:\"privacy_bar_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),var(--awb-color4-l),calc( var(--awb-color4-a) - 40{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:22:\"privacy_bar_link_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 14{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:28:\"privacy_bar_link_hover_color\";s:17:\"var(--awb-color5)\";s:16:\"privacy_bar_text\";s:51:\"This website uses cookies and third party services.\";s:23:\"privacy_bar_button_text\";s:2:\"OK\";s:23:\"privacy_bar_button_save\";s:1:\"0\";s:16:\"privacy_bar_more\";s:1:\"0\";s:21:\"privacy_bar_more_text\";s:8:\"Settings\";s:23:\"privacy_bar_update_text\";s:15:\"Update Settings\";s:30:\"privacy_bar_headings_font_size\";s:4:\"13px\";s:26:\"privacy_bar_headings_color\";s:98:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 2{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:19:\"privacy_bar_content\";a:4:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"type\";a:1:{i:0;s:0:\"\";}s:5:\"title\";a:1:{i:0;s:0:\"\";}s:11:\"description\";a:1:{i:0;s:0:\"\";}}s:18:\"privacy_bar_reject\";s:1:\"0\";s:23:\"privacy_bar_reject_text\";s:6:\"Reject\";s:16:\"sidenav_behavior\";s:5:\"hover\";s:18:\"side_nav_font_size\";s:4:\"16px\";s:10:\"post_views\";s:9:\"page_load\";s:19:\"post_views_counting\";s:3:\"all\";s:26:\"featured_image_placeholder\";s:1:\"1\";s:12:\"excerpt_base\";s:5:\"words\";s:16:\"disable_excerpts\";s:1:\"1\";s:24:\"excerpt_read_more_symbol\";s:5:\"[...]\";s:14:\"link_read_more\";s:1:\"0\";s:12:\"avatar_shape\";s:6:\"circle\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"0\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:14:\"totop_position\";s:13:\"left_floating\";s:19:\"totop_border_radius\";s:1:\"6\";s:22:\"totop_scroll_down_only\";s:1:\"1\";s:16:\"custom_scrollbar\";s:1:\"0\";s:20:\"scrollbar_background\";s:17:\"var(--awb-color3)\";s:16:\"scrollbar_handle\";s:17:\"var(--awb-color5)\";s:8:\"faq_slug\";s:9:\"faq-items\";s:13:\"cloning_posts\";s:1:\"1\";s:20:\"related_posts_layout\";s:17:\"title_on_rollover\";s:20:\"number_related_posts\";s:1:\"4\";s:21:\"related_posts_columns\";s:1:\"4\";s:28:\"related_posts_column_spacing\";s:2:\"48\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"0\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"1\";s:19:\"related_posts_swipe\";s:1:\"0\";s:25:\"related_posts_swipe_items\";s:1:\"0\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:4:\"fade\";s:24:\"image_rollover_icon_size\";s:4:\"15px\";s:20:\"image_rollover_icons\";s:2:\"no\";s:20:\"title_image_rollover\";s:1:\"1\";s:19:\"cats_image_rollover\";s:1:\"1\";s:26:\"icon_circle_image_rollover\";s:1:\"1\";s:24:\"image_gradient_top_color\";s:99:\"hsla(var(--awb-color7-h),var(--awb-color7-s),var(--awb-color7-l),calc( var(--awb-color7-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:27:\"image_gradient_bottom_color\";s:17:\"var(--awb-color7)\";s:25:\"image_rollover_text_color\";s:17:\"var(--awb-color1)\";s:25:\"image_rollover_icon_color\";s:17:\"var(--awb-color1)\";s:17:\"pagination_sizing\";s:12:\"width_height\";s:23:\"pagination_width_height\";s:2:\"30\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:23:\"pagination_border_width\";s:1:\"1\";s:24:\"pagination_border_radius\";s:1:\"0\";s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"13px\";s:16:\"pagination_range\";s:1:\"1\";s:26:\"pagination_start_end_range\";s:1:\"0\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:19:\"rgba(255,255,255,0)\";s:25:\"grid_separator_style_type\";s:4:\"none\";s:20:\"grid_separator_color\";s:17:\"var(--awb-color4)\";s:18:\"masonry_grid_ratio\";s:3:\"1.5\";s:20:\"masonry_width_double\";s:4:\"2000\";s:23:\"enable_language_updates\";s:1:\"1\";s:19:\"dependencies_status\";s:1:\"1\";s:27:\"disable_code_block_encoding\";s:1:\"1\";s:16:\"disable_megamenu\";s:1:\"0\";s:19:\"status_widget_areas\";s:1:\"1\";s:19:\"status_avada_studio\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"0\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"1\";s:12:\"status_vimeo\";s:1:\"1\";s:11:\"status_gmap\";s:1:\"1\";s:12:\"status_totop\";s:7:\"desktop\";s:18:\"status_fontawesome\";a:3:{i:0;s:3:\"fab\";i:1;s:3:\"far\";i:2;s:3:\"fas\";}s:28:\"fontawesome_v4_compatibility\";s:1:\"0\";s:22:\"status_fontawesome_pro\";s:1:\"0\";s:14:\"status_outline\";s:1:\"0\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:24:\"disable_rich_snippet_faq\";s:1:\"1\";s:34:\"enable_block_editor_backend_styles\";s:1:\"0\";s:17:\"load_block_styles\";s:3:\"off\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:529:\"<script>\r\nlet cls = 0;\r\n\r\nnew PerformanceObserver((entryList) => {\r\n  for (const entry of entryList.getEntries()) {\r\n    if (!entry.hadRecentInput) {\r\n      cls += entry.value;\r\n      console.log(\'Current CLS value:\', cls, entry);\r\n    }\r\n  }\r\n}).observe({type: \'layout-shift\', buffered: true});\r\n\r\nnew PerformanceObserver((entryList) => {\r\n  for (const entry of entryList.getEntries()) {\r\n    console.log(\'LCP candidate:\', entry.startTime, entry);\r\n  }\r\n}).observe({type: \'largest-contentful-paint\', buffered: true});\r\n</script>\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"0\";s:19:\"status_fusion_forms\";s:1:\"1\";s:21:\"status_awb_Off_Canvas\";s:1:\"1\";s:23:\"status_fusion_portfolio\";s:1:\"1\";s:18:\"status_fusion_faqs\";s:1:\"1\";s:16:\"maintenance_mode\";s:0:\"\";s:24:\"maintenance_redirect_url\";s:0:\"\";s:20:\"maintenance_template\";s:1:\"0\";s:22:\"maintenance_user_roles\";a:0:{}s:19:\"maintenance_exclude\";s:0:\"\";s:22:\"maintenance_page_title\";s:0:\"\";s:23:\"maintenance_robots_meta\";s:7:\"noindex\";s:10:\"svg_upload\";s:8:\"disabled\";s:15:\"pw_jpeg_quality\";s:2:\"82\";s:27:\"wp_big_image_size_threshold\";s:4:\"2560\";s:9:\"lazy_load\";s:5:\"avada\";s:17:\"lazy_load_iframes\";s:4:\"none\";s:17:\"font_face_display\";s:8:\"swap-all\";s:13:\"preload_fonts\";s:3:\"all\";s:22:\"preload_fonts_variants\";a:2:{i:0;s:3:\"400\";i:1;s:3:\"600\";}s:21:\"preload_fonts_subsets\";a:1:{i:0;s:5:\"latin\";}s:15:\"emojis_disabled\";s:8:\"disabled\";s:23:\"jquery_migrate_disabled\";s:8:\"disabled\";s:12:\"defer_jquery\";s:1:\"0\";s:12:\"defer_styles\";s:1:\"0\";s:11:\"gzip_status\";s:1:\"0\";s:12:\"video_facade\";s:3:\"off\";s:18:\"clear_object_cache\";s:1:\"0\";s:16:\"css_cache_method\";s:4:\"file\";s:30:\"css_combine_third_party_assets\";s:1:\"1\";s:19:\"media_queries_async\";s:1:\"0\";s:12:\"critical_css\";s:1:\"0\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:13:\"info_bg_color\";s:17:\"var(--awb-color1)\";s:17:\"info_accent_color\";s:17:\"var(--awb-color7)\";s:15:\"danger_bg_color\";s:109:\"hsla(calc(var(--awb-color7-h) + 170),var(--awb-color7-s),var(--awb-color7-l),calc(var(--awb-color7-a) - 90{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}))\";s:19:\"danger_accent_color\";s:97:\"hsla(calc(var(--awb-color7-h) + 170),var(--awb-color7-s),var(--awb-color7-l),var(--awb-color7-a))\";s:16:\"success_bg_color\";s:108:\"hsla(calc(var(--awb-color7-h) - 30),var(--awb-color7-s),var(--awb-color7-l),calc(var(--awb-color7-a) - 90{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}))\";s:20:\"success_accent_color\";s:96:\"hsla(calc(var(--awb-color7-h) - 30),var(--awb-color7-s),var(--awb-color7-l),var(--awb-color7-a))\";s:16:\"warning_bg_color\";s:99:\"hsla(var(--awb-color7-h),var(--awb-color7-s),var(--awb-color7-l),calc( var(--awb-color7-a) - 90{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:20:\"warning_accent_color\";s:17:\"var(--awb-color7)\";s:20:\"alert_box_text_align\";s:6:\"center\";s:24:\"alert_box_text_transform\";s:6:\"normal\";s:21:\"alert_box_dismissable\";s:3:\"yes\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:1:\"1\";s:16:\"animation_offset\";s:13:\"top-into-view\";s:21:\"status_css_animations\";s:7:\"desktop\";s:15:\"audio_max_width\";s:4:\"100{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:22:\"audio_background_color\";s:17:\"var(--awb-color8)\";s:23:\"audio_progressbar_color\";s:17:\"var(--awb-color1)\";s:27:\"audio_controls_color_scheme\";s:5:\"light\";s:17:\"audio_border_size\";s:1:\"0\";s:18:\"audio_border_color\";s:17:\"var(--awb-color1)\";s:19:\"audio_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:17:\"blog_grid_columns\";s:1:\"3\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:44:\"blog_element_load_more_posts_button_bg_color\";s:99:\"hsla(var(--awb-color3-h),var(--awb-color3-s),var(--awb-color3-l),calc( var(--awb-color3-a) - 30{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:46:\"blog_element_load_more_posts_button_text_color\";s:17:\"var(--awb-color8)\";s:50:\"blog_element_load_more_posts_hover_button_bg_color\";s:17:\"var(--awb-color3)\";s:52:\"blog_element_load_more_posts_hover_button_text_color\";s:17:\"var(--awb-color8)\";s:14:\"button_padding\";a:4:{s:3:\"top\";s:4:\"13px\";s:5:\"right\";s:4:\"29px\";s:6:\"bottom\";s:4:\"13px\";s:4:\"left\";s:4:\"29px\";}s:11:\"button_span\";s:2:\"no\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"17px\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}s:25:\"button_gradient_top_color\";s:17:\"var(--awb-color5)\";s:28:\"button_gradient_bottom_color\";s:17:\"var(--awb-color5)\";s:31:\"button_gradient_top_color_hover\";s:17:\"var(--awb-color7)\";s:34:\"button_gradient_bottom_color_hover\";s:17:\"var(--awb-color7)\";s:21:\"button_gradient_start\";s:1:\"0\";s:19:\"button_gradient_end\";s:3:\"100\";s:20:\"button_gradient_type\";s:6:\"linear\";s:21:\"button_gradient_angle\";s:3:\"180\";s:23:\"button_radial_direction\";s:13:\"center center\";s:19:\"button_accent_color\";s:17:\"var(--awb-color1)\";s:25:\"button_accent_hover_color\";s:17:\"var(--awb-color1)\";s:18:\"button_bevel_color\";s:17:\"var(--awb-color7)\";s:24:\"button_bevel_color_hover\";s:17:\"var(--awb-color7)\";s:19:\"button_border_width\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:20:\"button_border_radius\";a:4:{s:8:\"top_left\";s:3:\"5px\";s:9:\"top_right\";s:3:\"5px\";s:12:\"bottom_right\";s:3:\"5px\";s:11:\"bottom_left\";s:3:\"5px\";}s:19:\"button_border_color\";s:17:\"var(--awb-color1)\";s:25:\"button_border_hover_color\";s:17:\"var(--awb-color1)\";s:14:\"button_presets\";s:1:\"1\";s:18:\"carousel_nav_color\";s:99:\"hsla(var(--awb-color6-h),var(--awb-color6-s),var(--awb-color6-l),calc( var(--awb-color6-a) - 30{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:20:\"carousel_hover_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc( var(--awb-color8-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"chart_legend_position\";s:3:\"top\";s:19:\"chart_show_tooltips\";s:3:\"yes\";s:14:\"chart_bg_color\";s:19:\"rgba(255,255,255,0)\";s:21:\"chart_axis_text_color\";s:17:\"var(--awb-color8)\";s:20:\"chart_gridline_color\";s:97:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc(var(--awb-color8-a) - 90{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}))\";s:21:\"checklist_icons_color\";s:17:\"var(--awb-color1)\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:17:\"var(--awb-color5)\";s:20:\"checklist_text_color\";s:17:\"var(--awb-color7)\";s:19:\"checklist_item_size\";s:4:\"16px\";s:22:\"checklist_item_padding\";a:4:{s:3:\"top\";s:6:\"0.35em\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:6:\"0.35em\";s:4:\"left\";s:1:\"0\";}s:17:\"checklist_divider\";s:2:\"no\";s:23:\"checklist_divider_color\";s:0:\"\";s:25:\"checklist_odd_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:26:\"checklist_even_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:11:\"col_spacing\";s:2:\"5{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:16:\"col_width_medium\";s:18:\"inherit_from_large\";s:15:\"col_width_small\";s:3:\"1_1\";s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:4:\"30px\";}s:19:\"full_width_bg_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"full_width_gradient_start_color\";s:19:\"rgba(255,255,255,0)\";s:29:\"full_width_gradient_end_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"full_width_border_sizes\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"full_width_border_color\";s:17:\"var(--awb-color4)\";s:29:\"container_scroll_nav_bg_color\";s:113:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 89{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),calc( var(--awb-color4-a) - 80{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ))\";s:33:\"container_scroll_nav_bullet_color\";s:17:\"var(--awb-color4)\";s:35:\"container_hundred_percent_animation\";s:4:\"fade\";s:44:\"container_hundred_percent_scroll_sensitivity\";s:3:\"450\";s:41:\"container_hundred_percent_animation_speed\";s:3:\"800\";s:41:\"container_hundred_percent_dots_navigation\";s:1:\"1\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:24:\"container_legacy_support\";s:1:\"0\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:2:\"24\";s:23:\"content_box_title_color\";s:17:\"var(--awb-color8)\";s:22:\"content_box_body_color\";s:17:\"var(--awb-color8)\";s:21:\"content_box_icon_size\";s:2:\"20\";s:22:\"content_box_icon_color\";s:17:\"var(--awb-color1)\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:25:\"content_box_icon_bg_color\";s:17:\"var(--awb-color7)\";s:38:\"content_box_icon_bg_inner_border_color\";s:17:\"var(--awb-color8)\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"1\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:17:\"var(--awb-color4)\";s:21:\"content_box_link_type\";s:4:\"text\";s:23:\"content_box_button_span\";s:2:\"no\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:0:\"\";s:6:\"bottom\";s:0:\"\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:16:\"countdown_layout\";s:7:\"floated\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:24:\"countdown_label_position\";s:9:\"text_flow\";s:26:\"countdown_background_color\";s:17:\"var(--awb-color5)\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:29:\"countdown_counter_box_spacing\";s:4:\"10px\";s:27:\"countdown_counter_box_color\";s:17:\"var(--awb-color7)\";s:25:\"countdown_counter_padding\";a:4:{s:3:\"top\";s:5:\"0.6em\";s:5:\"right\";s:5:\"1.1em\";s:6:\"bottom\";s:5:\"0.6em\";s:4:\"left\";s:5:\"1.1em\";}s:29:\"countdown_counter_border_size\";s:1:\"0\";s:30:\"countdown_counter_border_color\";s:17:\"var(--awb-color7)\";s:31:\"countdown_counter_border_radius\";s:3:\"4px\";s:27:\"countdown_counter_font_size\";s:4:\"18px\";s:28:\"countdown_counter_text_color\";s:17:\"var(--awb-color1)\";s:25:\"countdown_label_font_size\";s:4:\"18px\";s:21:\"countdown_label_color\";s:17:\"var(--awb-color1)\";s:27:\"countdown_heading_font_size\";s:4:\"18px\";s:28:\"countdown_heading_text_color\";s:17:\"var(--awb-color1)\";s:30:\"countdown_subheading_font_size\";s:4:\"14px\";s:31:\"countdown_subheading_text_color\";s:17:\"var(--awb-color1)\";s:25:\"countdown_link_text_color\";s:17:\"var(--awb-color1)\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:17:\"var(--awb-color5)\";s:22:\"counter_box_title_size\";s:2:\"50\";s:21:\"counter_box_icon_size\";s:2:\"50\";s:22:\"counter_box_body_color\";s:17:\"var(--awb-color8)\";s:21:\"counter_box_body_size\";s:2:\"14\";s:24:\"counter_box_border_color\";s:17:\"var(--awb-color3)\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:17:\"var(--awb-color5)\";s:22:\"counter_unfilled_color\";s:17:\"var(--awb-color2)\";s:13:\"dropcap_color\";s:17:\"var(--awb-color5)\";s:18:\"dropcap_text_color\";s:17:\"var(--awb-color1)\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:17:\"var(--awb-color3)\";s:30:\"faq_accordian_background_color\";s:17:\"var(--awb-color1)\";s:25:\"faq_accordian_hover_color\";s:17:\"var(--awb-color2)\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:27:\"faq_accordion_divider_color\";s:17:\"var(--awb-color4)\";s:33:\"faq_accordion_divider_hover_color\";s:17:\"var(--awb-color4)\";s:30:\"faq_accordion_title_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:23:\"faq_accordion_icon_size\";s:2:\"16\";s:24:\"faq_accordian_icon_color\";s:17:\"var(--awb-color1)\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:17:\"var(--awb-color7)\";s:32:\"faq_accordion_content_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography4-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography4)\";s:9:\"font-size\";s:32:\"var(--awb-typography4-font-size)\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color7)\";}s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:26:\"faq_accordian_active_color\";s:17:\"var(--awb-color4)\";s:33:\"faq_accordian_active_accent_color\";s:0:\"\";s:22:\"flip_boxes_flip_effect\";s:7:\"classic\";s:25:\"flip_boxes_flip_direction\";s:5:\"right\";s:24:\"flip_boxes_flip_duration\";s:3:\"0.8\";s:24:\"flip_boxes_equal_heights\";s:2:\"no\";s:19:\"flip_boxes_front_bg\";s:17:\"var(--awb-color7)\";s:24:\"flip_boxes_front_heading\";s:17:\"var(--awb-color2)\";s:21:\"flip_boxes_front_text\";s:17:\"var(--awb-color3)\";s:18:\"flip_boxes_back_bg\";s:17:\"var(--awb-color5)\";s:23:\"flip_boxes_back_heading\";s:17:\"var(--awb-color1)\";s:20:\"flip_boxes_back_text\";s:97:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 20{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}))\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"6px\";s:13:\"gallery_limit\";s:1:\"0\";s:23:\"gallery_pagination_type\";s:6:\"button\";s:29:\"gallery_load_more_button_text\";s:9:\"Load More\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:19:\"gallery_border_size\";s:1:\"0\";s:20:\"gallery_border_color\";s:17:\"var(--awb-color3)\";s:21:\"gallery_border_radius\";s:3:\"0px\";s:19:\"google_map_api_type\";s:2:\"js\";s:9:\"icon_size\";s:2:\"32\";s:10:\"icon_color\";s:17:\"var(--awb-color1)\";s:16:\"icon_color_hover\";s:17:\"var(--awb-color1)\";s:11:\"icon_circle\";s:3:\"yes\";s:17:\"icon_circle_color\";s:17:\"var(--awb-color6)\";s:23:\"icon_circle_color_hover\";s:17:\"var(--awb-color5)\";s:16:\"icon_border_size\";s:1:\"1\";s:17:\"icon_border_color\";s:17:\"var(--awb-color6)\";s:23:\"icon_border_color_hover\";s:17:\"var(--awb-color5)\";s:18:\"icon_border_radius\";a:4:{s:8:\"top_left\";s:3:\"50{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:9:\"top_right\";s:3:\"50{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:12:\"bottom_right\";s:3:\"50{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";s:11:\"bottom_left\";s:3:\"50{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098}\";}s:15:\"icon_hover_type\";s:4:\"fade\";s:17:\"before_after_type\";s:12:\"before_after\";s:22:\"before_after_font_size\";s:2:\"14\";s:25:\"before_after_accent_color\";s:17:\"var(--awb-color1)\";s:28:\"before_after_label_placement\";s:14:\"image-centered\";s:24:\"before_after_handle_type\";s:7:\"default\";s:25:\"before_after_handle_color\";s:17:\"var(--awb-color1)\";s:22:\"before_after_handle_bg\";s:19:\"rgba(255,255,255,0)\";s:19:\"before_after_offset\";s:2:\"50\";s:24:\"before_after_orientation\";s:10:\"horizontal\";s:28:\"before_after_handle_movement\";s:10:\"drag_click\";s:28:\"before_after_transition_time\";s:3:\"0.5\";s:24:\"before_after_border_size\";s:1:\"0\";s:25:\"before_after_border_color\";s:17:\"var(--awb-color3)\";s:26:\"before_after_border_radius\";s:3:\"0px\";s:21:\"imageframe_style_type\";s:4:\"none\";s:15:\"imageframe_blur\";s:1:\"3\";s:20:\"imgframe_style_color\";s:99:\"hsla(var(--awb-color4-h),var(--awb-color4-s),calc( var(--awb-color4-l) - 89{78e47bcb034f15781792ffca1cb5ce2368674514edccfb203585f1c5729e4098} ),var(--awb-color4-a))\";s:22:\"imageframe_border_size\";s:1:\"0\";s:21:\"imgframe_border_