<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\FormatDates;
use App\Scopes\LatestScope;

class DataSheet extends Model
{
    use FormatDates;

    /**
     *
     * Boot the model.
     *
     */
    public static function boot()
    {
        parent::boot();

        // deleted questions relationship
        static::deleted(function ($record) {
            SheetQuestion::where("data_sheet_id", $record->id)->delete();
        });

        // add global scope
        static::addGlobalScope(new LatestScope());
    }

    public function tasks(){
        return $this->hasMany('App\SheetQuestion', 'data_sheet_id');
    }
}
