<?php

namespace App\Http\Controllers\PortalController;

use App\Services\UserService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class UserController extends Controller
{
    // user list page
    public function userFilterList($type = "all"){
        return view("portal.users.index", compact("type"));
    }

    // get user list ajax datatable
    public function userFilterListRequest(UserService $userService, $type){
        return $userService->userFilterListAjax($type);
    }

    // add new user page
    public function addNewUser(){
        return view("portal.users.addUser");
    }

    // add new user request
    public function addNewUserRequest(Request $request, UserService $userService){
        return $userService->addNewUserRequest($request);
    }

    // edit user page
    public function editUser($id, UserService $userService){
        return $userService->editUserPage($id);
    }

    // update user request
    public function updateUserRequest(Request $request, UserService $userService){
        return $userService->updateUserRequest($request);
    }

    // view user page
    public function viewUser($id, UserService $userService){
        return $userService->viewUserPage($id);
    }

    // delete user
    public function deleteUser($id, UserService $userService){
        return $userService->deleteUser($id);
    }

    // assign client to staff
    public function assignClientToStaffRequest(Request $request, UserService $userService){
        return $userService->assignClientToStaffRequest($request);
    }

    // remove client from staff
    public function removeClientFromStaff($id, UserService $userService){
        return $userService->removeClientFromStaff($id);
    }
}
