<?php


namespace App\Services;


use Carbon\Carbon;

class HelperServices
{
    // return json response
    static function returnJsonResponse($responseCode, $msg, $data = [], $errors = [], $statusCode = 200){
        $response = [
            'response_code' => $responseCode,
            'message'=> $msg,
            'data' => $data,
            'errors' => $errors,
        ];

        return response()->json($response, $statusCode);
    }

    // validation error format
    static function validationErrorFormat($errors){
        $errorArray = array();
        foreach(json_decode(json_encode($errors)) as $key=>$error){
            $errorArray[$key] =  $error[0];
        }
        return $errorArray;
    }

    // date & time format apply
    static function dateTimeFormat($date, $format = "M d, Y h:i a"){
        return Carbon::parse($date)->format($format);
    }

    // make directory
    static function makeDir($dirpath, $mode=0644){
        return is_dir($dirpath) || mkdir($dirpath, $mode, true);
    }

    // remove folders & files inside of directory
    static function recursiveRemoveDirectory($directory){
        if(!is_dir($directory)){
            return true;
        }
        foreach(glob("{$directory}/*") as $file){
            if(is_dir($file)) {
                self::recursiveRemoveDirectory($file);
            } else {
                unlink($file);
            }
        }
        rmdir($directory);
    }
}
