<?php


namespace App\Traits;

use Carbon\Carbon;

trait FormatDates
{
    protected $newDateFormat = 'M d, Y';

    public function initialVal()
    {
        return $this->newDateFormat = env("DATE_FORMAT");
    }

    public function getCreatedAtAttribute($date)
    {
        return Carbon::parse($date)->format($this->initialVal());
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::parse($date)->diffForHumans();
    }
}
