<?php

namespace App;

use App\Services\HelperServices;
use App\Traits\FormatDates;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use Notifiable, FormatDates, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     *
    protected $fillable = [
        'name', 'email', 'password',
    ]; */

    protected $guarded = [];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token', 'login_from',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     *
     * Boot the model.
     *
     */
    public static function boot()
    {
        parent::boot();

        // remove folder on delete user
        static::deleted(function ($user) {
            $uploadingPath = public_path('/storage/user-data/user-'.$user->id);
            HelperServices::recursiveRemoveDirectory($uploadingPath);
        });
    }

    // check user thumbnail
    public function getThumbnailAttribute($value){
        if($value != ""){
            return asset('storage/user-data/user-'.$this->id.'/'.$value);
        } else {
            return asset('images/profile.png');
        }
    }

    // client listing
    public function staffClients(){
        return $this->belongsToMany('App\User', "staff_pivot_clients", "staff_id", "client_id")->withPivot("id")->withTimestamps();
    }
}
