@extends('layouts.app')

@section('title', 'Edit Sheet Task')

@section('headSource')

@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Edit Sheet Task</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Data Sheets</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">View Data Sheets</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit Sheet Task</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-list-alt"></i> Task detail</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                            <form id="sheetTaskEditForm" method="post">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Title (required)</label>
                                            <textarea class="form-control" name="title" required>{{$record->title}}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Progress Note (required)</label>
                                            <textarea id="progressNote" class="form-control" name="progress_note" required>{{$record->progress_note}}</textarea>
                                        </div>
                                        <div class="mb-3">
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon Doe" style="cursor: pointer;" data-tag="##ClientFullName##">##ClientFullName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Jhon" style="cursor: pointer;" data-tag="##ClientFirstName##">##ClientFirstName##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="He/She" style="cursor: pointer;" data-tag="##ClientGenderNoun##">##ClientGenderNoun##</span>
                                            <span class="badge badge-secondary insertTag" data-toggle="tooltip" title="Selected Answer" style="cursor: pointer;" data-tag="##AnswerPrompt##">##AnswerPrompt##</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control form-control-lg" name="status">
                                                <option value="1" {{($record->status == 1)? "selected": ""}}>Active</option>
                                                <option value="0" {{($record->status == 0)? "selected": ""}}>Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <button type="submit" class="btn btn-primary">Update Task</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-lg-4">
                            <form id="taskAnswerForm" method="post">
                                <label>Answer (required)</label>
                                <div class="input-group">
                                    <input name="answer" type="text" class="form-control" required>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="submit">Add</button>
                                    </div>
                                </div>
                            </form>
                            <div class="basic-list-group mt-4">
                                <ul class="list-group">
                                    @foreach($record->answers as $answer)
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            {{$answer->answer}} <a href="{{route('portal.deleteAnswerInTask', ["id" => $answer->pivot->id])}}" class="deletedBtn badge badge-primary badge-pill"><i class="fa fa-times"></i></a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

@endsection

@section('footerSource')

<script>
    $(document).ready(function () {
        // insert tag in progress note
        $(".insertTag").click(function (e) {
            let tag = $(this).data("tag");
            let noteTxt = $("#progressNote").val();
            let upDateNoteTxt = noteTxt+' '+tag+' ';
            $("#progressNote").val(upDateNoteTxt);
        });

        // tooltip
        $('[data-toggle="tooltip"]').tooltip();

        // edit sheet task form submit
        $("#sheetTaskEditForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&id={{$record->id}}";
            axios.put('{{route("portal.updateSheetTaskRequest")}}', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });

        // add answer form submit
        $("#taskAnswerForm").submit(function (e) {
            e.preventDefault();
            let data = $(this).serialize()+"&id={{$record->id}}";
            axios.post('{{route("portal.addAnswerInTaskRequest")}}', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
@endsection
