@extends('layouts.app')

@section('title', 'Edit User')

@section('headSource')
<!-- Daterange picker -->
<link href="{!! asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.css') !!}" rel="stylesheet">
@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Edit User</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Users</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit User</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
            <div class="card mb-3">
                <div class="card-header">
                    <h3><i class="fa fa-user"></i> User details</h3>
                </div>
                <div class="card-body">
                    <form id="userEditForm" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="{{$user->id}}">
                        <div class="row">
                            <div class="col-lg-9 col-xl-9">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Full name (required)</label>
                                            <input class="form-control" name="name" type="text" value="{{$user->name}}" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Valid Email (required)</label>
                                            <input class="form-control" name="email" type="email" value="{{$user->email}}" required />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Username (required)</label>
                                            <input class="form-control" name="username" type="text" value="{{$user->username}}" required />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Password (leave empty not to change)</label>
                                            <input class="form-control" name="password" type="password" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Date Of Birth</label>
                                            <input class="form-control" name="date_of_birth" type="text" value="{{$user->date_of_birth}}" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Gender</label>
                                            <select class="form-control form-control-lg" name="gender">
                                                <option value="Male" {{($user->gender == 'Male')? "selected": ""}}>Male</option>
                                                <option value="Female" {{($user->gender == 'Female')? "selected": ""}}>Female</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <input class="form-control" name="address" type="text" value="{{$user->address}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <input class="form-control" name="phone_number" type="text" value="{{$user->phone_number}}" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Emergency Phone Number</label>
                                            <input class="form-control" name="emergency_contact" type="text" value="{{$user->emergency_contact}}" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="form-control form-control-lg" name="status">
                                                <option value="1" {{($user->status == 1)? "selected": ""}}>Active</option>
                                                <option value="0" {{($user->status == 0)? "selected": ""}}>Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        @if($user->role == "Staff")
                                            <div class="form-group">
                                                <label>Employee Id (required)</label>
                                                <input class="form-control" name="employee_id" type="text" value="{{$user->employee_id}}" required/>
                                            </div>
                                        @endif
                                        @if($user->role == "Client")
                                            <div class="form-group">
                                                <label>DDD Id (required)</label>
                                                <input class="form-control" name="ddd_id" type="text" value="{{$user->ddd_id}}" required />
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-xl-3 border-left">
                                {{--<strong>Login with</strong>: {{$user->login_from}}
                                <br>
                                <br>--}}
                                <strong>Role</strong>: {{$user->role}}
                                <div class="mb-5"></div>
                                <div id="avatar_image">
                                    <img id="thumbnailImg" alt="image" style="max-width:100px; height:auto;" src="{!! $user->thumbnail !!}" />
                                </div>
                                <div class="m-b-10"></div>
                                <div class="form-group">
                                    <label>Profile Image</label>
                                    <input type="file" name="thumbnail" class="form-control previewInput" data-target="#thumbnailImg">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- end card-body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

@endsection

@section('footerSource')
<!-- Daterangepicker -->
<!-- momment js is must -->
<script src="{!! asset('admin-assets/vendor/moment/moment.min.js') !!}"></script>
<script src="{!! asset('admin-assets/vendor/bootstrap-daterangepicker/daterangepicker.js') !!}"></script>
<script>
    $(document).ready(function () {
        // date picker
        $('input[name="date_of_birth"]').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true
        });

        // edit user form submit
        $("#userEditForm").submit(function (e) {
            e.preventDefault();
            let data = new FormData($(this)[0]);
            axios.post('{{route("portal.updateUserRequest")}}', data)
                .then(function (response) {
                    if(response.data.response_code == 1){
                        successMsg(response.data.message);
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                    } else {
                        errorMsg(response.data.message);
                    }
                })
                .catch(function (error) {

                });
        });
    });
</script>
@endsection
