@extends('layouts.app')

@section('title', ucfirst($type).' User Listing')

@section('headSource')
<!-- Datatable -->
<link rel="stylesheet" href="{!! asset('admin-assets/vendor/datatables/css/jquery.dataTables.min.css') !!}">
@endsection

@section('content')

    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>{{ucfirst($type)}} User Listing</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Users</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ucfirst($type)}}</a></li>
            </ol>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ucfirst($type)}} Users</h4>
                    <span class="pull-right"><a href="{{route("portal.addNewUserPage")}}" class="btn btn-primary btn-sm"><i class="fa fa-user-plus" aria-hidden="true"></i> Add new user</a></span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Id</th>
                                    <th>Sr</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footerSource')
    <!-- Datatable -->
    <script src="{!! asset('admin-assets/vendor/datatables/js/jquery.dataTables.min.js') !!}"></script>
    <script>
        $(document).ready(function () {
            var table = $('#datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{!! route('portal.userFilterListDatatable', ["type" => $type]) !!}',
                columns: [
                    {
                        "className":      'details-control',
                        "orderable":      false,
                        "searchable":     false,
                        "data":           null,
                        "defaultContent": ''
                    },
                    { data: 'id', name: 'id', 'visible': false},
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false,searchable: false},
                    { data: 'name', name: 'name' },
                    { data: 'email', name: 'email' },
                    { data: 'role', name: 'role' },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'action', name: 'action', orderable: false},
                ],
                "order": [[1, 'desc']],
            });

            // Add event listener for opening and closing details
            $('#datatable tbody').on('click', 'td.details-control', function () {
                var tr = $(this).closest('tr');
                var row = table.row( tr );

                if ( row.child.isShown() ) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                }
                else {
                    // Open this row
                    row.child( childRowFormat(row.data()) ).show();
                    tr.addClass('shown');
                }
            });
        });

        function childRowFormat( data ) {
            let employeeIdCss = (data.role != "Staff")? 'style="display: none"': '';
            let dddIdCss = (data.role != "Client")? 'style="display: none"': '';
            let status = (data.status == 1)? '<span class="badge light badge-success">Active</span>': '<span class="badge light badge-warning">Inactive</span>';
            return `<table class="table table-bordered">
                        <tr>
                            <td>Date of bith:</td>
                            <td>`+data.date_of_birth+`</td>
                        </tr>
                        <tr>
                            <td>Gender:</td>
                            <td>`+data.gender+`</td>
                        </tr>
                        <tr>
                            <td>Address:</td>
                            <td>`+data.address+`</td>
                        </tr>
                        <tr>
                            <td>Phone:</td>
                            <td>`+data.phone_number+`</td>
                        </tr>
                        <tr>
                            <td>Emergency Contact:</td>
                            <td>`+data.emergency_contact+`</td>
                        </tr>
                        <tr `+employeeIdCss+`>
                            <td>Employee Id:</td>
                            <td>`+data.employee_id+`</td>
                        </tr>
                        <tr `+dddIdCss+`>
                            <td>DDD Id:</td>
                            <td>`+data.ddd_id+`</td>
                        </tr>
                        <tr>
                            <td>Status:</td>
                            <td>`+status+`</td>
                        </tr>
                        <tr>
                            <td>Image:</td>
                            <td><img src="`+data.thumbnail+`" alt="`+data.name+`" style="height: 100px"> </td>
                        </tr>
                    </table>`;
        }
    </script>
@endsection
