<?php


namespace App\Services;


use App\Scopes\LatestScope;
use App\TaskReport;

class TaskReportService
{
    // Datatable filter task history of user
    public function userTaskHistoryAjaxList($userId){
        $data = TaskReport::with('client', 'sheet')->where(["staff_id" => $userId])->withoutGlobalScope(new LatestScope());

        return $this->returnDatatableResponse($data);
    }

    private function returnDatatableResponse($data){
        return datatables()->of($data)
            ->addColumn('action', function($row){
                $btn = '<div class="d-flex">';
                $btn .=  '<a href="'.route("portal.viewTaskReportPage", ["id" => $row->id]).'" class="btn btn-success shadow sharp mr-1"><i class="fa fa-eye"></i> View</a>';
                $btn .= '</div>';
                return $btn;
            })
            ->editColumn('created_at', function ($row){
                return $row->created_at_date;
            })
            ->rawColumns(['action'])
            ->addIndexColumn()
            ->make(true);
    }

    // get task report detail
    public function viewTaskReportPage($reportId){
        $data = TaskReport::find($reportId);
        if(!$data){
            abort(404);
        }
        $data = $data->load('client', 'sheet', 'staff', 'reportData.question', 'reportData.answer');

        return view('portal.taskReports.viewTaskReport', compact("data"));
    }

    // get client listing of staff member api
    public function getSheetReports($request, $userId){
        $page = ($request->get('page'))? $request->get('page') : '1';
        $taskReports = TaskReport::with('client', 'sheet')->where(["staff_id" => $userId])->paginate(env('API_PER_PAGE_LIMIT'));
        $reportData = [];
        foreach($taskReports as $report){
            $reportData[] = $this->sheetReportObj($report);
        }

        $returnData = HelperServices::returnPaginationArr($taskReports, $reportData);
        $returnData = HelperServices::arrayLoopGenModified($returnData);
        return HelperServices::returnJsonResponse(1, 'Success', $returnData);
    }

    // sheet report obj
    private function sheetReportObj($record){
        $returnObj = [
            "id" => $record->id,    // report id
            "sheet_id" => $record->data_sheet_id,
            "sheet_name" => $record->sheet->name,
            "client_id" => $record->client_id,
            "client_name" => $record->client->name,
            "created_at" => $record->created_at->format("Y-m-d H:i:s"),
        ];
        return $returnObj;
    }
}
