<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateQuestionAnserPivotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('question_answers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('sheet_question_id')->unsigned();
            $table->foreign('sheet_question_id')
                ->references('id')->on('sheet_questions')->onDelete('cascade');
            $table->bigInteger('sheet_answer_id')->unsigned();
            $table->foreign('sheet_answer_id')
                ->references('id')->on('sheet_answers')->onDelete('cascade');
            $table->boolean('delete_answer')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('question_answers');
    }
}
